/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.extras;

import com.formdev.flatlaf.FlatIconColors;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.GrayFilter;
import com.formdev.flatlaf.util.UIScale;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RGBImageFilter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;

public class FlatSVGIcon
implements Icon {
    private static final SVGUniverse svgUniverse = new SVGUniverse();
    private final String name;
    private final ClassLoader classLoader;
    private SVGDiagram diagram;
    private boolean dark;
    private static Boolean darkLaf;

    public FlatSVGIcon(String name) {
        this(name, null);
    }

    public FlatSVGIcon(String name, ClassLoader classLoader) {
        this.name = name;
        this.classLoader = classLoader;
    }

    private void update() {
        if (this.dark == FlatSVGIcon.isDarkLaf() && this.diagram != null) {
            return;
        }
        this.dark = FlatSVGIcon.isDarkLaf();
        URL url = this.getIconURL(this.name, this.dark);
        if (url == null & this.dark) {
            url = this.getIconURL(this.name, false);
        }
        try {
            this.diagram = svgUniverse.getDiagram(url.toURI());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
    }

    private URL getIconURL(String name, boolean dark) {
        if (dark) {
            int dotIndex = name.lastIndexOf(46);
            name = name.substring(0, dotIndex) + "_dark" + name.substring(dotIndex);
        }
        ClassLoader cl = this.classLoader != null ? this.classLoader : FlatSVGIcon.class.getClassLoader();
        return cl.getResource(name);
    }

    public boolean hasFound() {
        this.update();
        return this.diagram != null;
    }

    @Override
    public int getIconWidth() {
        this.update();
        return (int)UIScale.scale((float)(this.diagram != null ? this.diagram.getWidth() : 16.0f));
    }

    @Override
    public int getIconHeight() {
        this.update();
        return (int)UIScale.scale((float)(this.diagram != null ? this.diagram.getHeight() : 16.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.update();
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null && !clipBounds.intersects(new Rectangle(x, y, this.getIconWidth(), this.getIconHeight()))) {
            return;
        }
        RGBImageFilter grayFilter = null;
        if (c != null && !c.isEnabled()) {
            Object grayFilterObj = UIManager.get("Component.grayFilter");
            grayFilter = grayFilterObj instanceof RGBImageFilter ? (RGBImageFilter)grayFilterObj : GrayFilter.createDisabledIconFilter((boolean)this.dark);
        }
        GraphicsFilter g2 = new GraphicsFilter((Graphics2D)g.create(), ColorFilter.getInstance(), grayFilter);
        try {
            FlatUIUtils.setRenderingHints((Graphics2D)((Object)g2));
            ((Graphics2D)((Object)g2)).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.paintSvg((Graphics2D)((Object)g2), x, y);
        }
        finally {
            ((Graphics)((Object)g2)).dispose();
        }
    }

    private void paintSvg(Graphics2D g, int x, int y) {
        if (this.diagram == null) {
            this.paintSvgError(g, x, y);
            return;
        }
        g.translate(x, y);
        g.clipRect(0, 0, this.getIconWidth(), this.getIconHeight());
        UIScale.scaleGraphics((Graphics2D)g);
        this.diagram.setIgnoringClipHeuristic(true);
        try {
            this.diagram.render(g);
        }
        catch (SVGException ex) {
            this.paintSvgError(g, 0, 0);
        }
    }

    private void paintSvgError(Graphics2D g, int x, int y) {
        g.setColor(Color.red);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
    }

    private static boolean isDarkLaf() {
        if (darkLaf == null) {
            FlatSVGIcon.lafChanged();
            UIManager.addPropertyChangeListener(e -> FlatSVGIcon.lafChanged());
        }
        return darkLaf;
    }

    private static void lafChanged() {
        darkLaf = FlatLaf.isLafDark();
    }

    private static class GraphicsFilter
    extends Graphics2DProxy {
        private final ColorFilter colorFilter;
        private final RGBImageFilter grayFilter;

        public GraphicsFilter(Graphics2D delegate, ColorFilter colorFilter, RGBImageFilter grayFilter) {
            super(delegate);
            this.colorFilter = colorFilter;
            this.grayFilter = grayFilter;
        }

        public void setColor(Color c) {
            super.setColor(this.filterColor(c));
        }

        public void setPaint(Paint paint) {
            if (paint instanceof Color) {
                paint = this.filterColor((Color)paint);
            }
            super.setPaint(paint);
        }

        private Color filterColor(Color color) {
            if (this.colorFilter != null) {
                color = this.colorFilter.filter(color);
            }
            if (this.grayFilter != null) {
                int oldRGB = color.getRGB();
                int newRGB = this.grayFilter.filterRGB(0, 0, oldRGB);
                color = newRGB != oldRGB ? new Color(newRGB, true) : color;
            }
            return color;
        }
    }

    public static class ColorFilter {
        private static ColorFilter instance;
        private final Map<Integer, String> rgb2keyMap = new HashMap<Integer, String>();
        private final Map<Color, Color> color2colorMap = new HashMap<Color, Color>();

        public static ColorFilter getInstance() {
            if (instance == null) {
                instance = new ColorFilter();
            }
            return instance;
        }

        public ColorFilter() {
            for (FlatIconColors c : FlatIconColors.values()) {
                this.rgb2keyMap.put(c.rgb, c.key);
            }
        }

        public void addAll(Map<Color, Color> from2toMap) {
            this.color2colorMap.putAll(from2toMap);
        }

        public void add(Color from, Color to) {
            this.color2colorMap.put(from, to);
        }

        public void remove(Color from) {
            this.color2colorMap.remove(from);
        }

        public Color filter(Color color) {
            Color newColor = this.color2colorMap.get(color);
            if (newColor != null) {
                return newColor;
            }
            String colorKey = this.rgb2keyMap.get(color.getRGB() & 0xFFFFFF);
            if (colorKey == null) {
                return color;
            }
            newColor = UIManager.getColor(colorKey);
            if (newColor == null) {
                return color;
            }
            return newColor.getAlpha() != color.getAlpha() ? new Color(newColor.getRGB() & 0xFFFFFF | color.getRGB() & 0xFF000000) : newColor;
        }
    }
}

