/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.ParserResult;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EXADriver
implements Driver {
    private static final String DRIVER_NAME = "EXASolution JDBC Driver";
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 64;
    public static final int MAX_CONNECTION_POOL_SIZE = 8192;
    public static int connectionPoolSize = 64;
    private static Map versionInfo = null;
    private DebugLog debug = null;
    private static EXADriver registeredDriver;

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Exasol JDBC driver, version " + EXADriver.getEXADriverMajorVersion() + "." + EXADriver.getEXADriverMinorVersion() + "." + EXADriver.getEXADriverVersionInc());
        System.out.println("Build for JRE 6 or higher");
    }

    public static void debugError(String string, Throwable throwable, DebugLog debugLog) {
        String string2 = "JDBC Exception - " + string;
        if (null == debugLog || null == throwable) {
            return;
        }
        if (null != string) {
            debugLog.log(string2);
        }
        if (null != throwable) {
            StackTraceElement[] stackTraceElementArray;
            StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
            if (null != stackTraceElementArray2 && stackTraceElementArray2.length > 0) {
                debugLog.log(throwable.getClass() + ": " + throwable.getMessage());
                stackTraceElementArray = stackTraceElementArray2;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    debugLog.log("    at " + stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')');
                }
            }
            for (stackTraceElementArray = throwable.getCause(); null != stackTraceElementArray; stackTraceElementArray = stackTraceElementArray.getCause()) {
                StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray.getStackTrace();
                if (null == stackTraceElementArray3 || stackTraceElementArray3.length <= 0) continue;
                debugLog.log("Caused by:");
                debugLog.log(stackTraceElementArray.getClass() + ": " + stackTraceElementArray.getMessage());
                for (StackTraceElement stackTraceElement : stackTraceElementArray3) {
                    debugLog.log("    at " + stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')');
                }
            }
        }
    }

    @Override
    public boolean acceptsURL(String string) {
        return string.startsWith("jdbc:exa:") || string.startsWith("jdbc:exa-debug:") || string.startsWith("exa:") || string.startsWith("exa-debug:") || string.startsWith("jdbc:exa-slave:") || string.startsWith("jdbc:exa-slave-debug:") || string.startsWith("exa-slave:") || string.startsWith("exa-slave-debug:");
    }

    public static void register() throws SQLException {
        if (EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        EXADriver eXADriver = new EXADriver();
        DriverManager.registerDriver(eXADriver);
        registeredDriver = eXADriver;
    }

    public static void deregister() throws SQLException {
        if (!EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using EXADriver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Vector<ClusterNode> vector = null;
        if (null == string) {
            throw new SQLException(Translator.Driver_URL_can_t_be_null());
        }
        if (0 == string.length()) {
            throw new SQLException(Translator.Driver_URL_can_t_be_an_empty_string());
        }
        EXAConnection eXAConnection = null;
        try {
            ParserResult parserResult = this.parseURL8(string);
            if (parserResult != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(parserResult.params.getProperty("connectionPoolSize"));
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n > 8192 || n < 0) {
                    throw new SQLException("Connection pool size can be between 1 and 8192");
                }
                if (n != 0) {
                    if (connectionPoolSize != 64 && n != connectionPoolSize) {
                        throw new SQLException("Connection pool size can be changed only one time in the driver.");
                    }
                    connectionPoolSize = n;
                }
                if ("1".equals(parserResult.params.getProperty("TestConnectionStringOnly"))) {
                    parserResult = this.expandDNSPool(parserResult);
                }
                vector = new Vector<ClusterNode>();
                for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
                    if (!((ClusterNode)parserResult.clusterNodes.get(i)).isValid()) continue;
                    vector.add((ClusterNode)parserResult.clusterNodes.get(i));
                }
                if (vector.size() < 1) {
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts(), "HY000");
                }
                if (properties != null) {
                    parserResult.params.putAll((Map<?, ?>)properties);
                }
                if ("1".equals(parserResult.params.getProperty("debug"))) {
                    this.openLog(parserResult.params.getProperty("logdir"));
                }
                String string2 = parserResult.params.getProperty("user");
                String string3 = parserResult.params.getProperty("password");
                this.log("Java Version  : " + System.getProperty("java.version"));
                this.log("Driver Version: " + EXADriver.getVersionInfo());
                this.log("Connection Url: " + string);
                for (int i = 0; i < vector.size(); ++i) {
                    if (0 == ((ClusterNode)vector.get(i)).GetPort()) {
                        ((ClusterNode)vector.get(i)).SetPort(8563);
                    }
                    this.log("Server:Port: " + ((ClusterNode)vector.get(i)).GetHostAndPort());
                }
                this.log("Username...: " + string2);
                if (string3 != null && string3 != "") {
                    this.log("Password...: *****");
                }
                if (vector.size() < 1) {
                    this.log(Translator.Error_in_connection_string_no_valid_hosts());
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts());
                }
                eXAConnection = new EXAConnection(vector, string2, string3, this.debug, parserResult.params);
            }
            return eXAConnection;
        }
        catch (SQLException sQLException) {
            this.log(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMajorVersion() {
        return EXADriver.getEXADriverMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return EXADriver.getEXADriverMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return EXAConnection.getDefaultProperties();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private void openLog(String string) {
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.debug = new DebugLog(string, "utf8");
        }
        catch (IOException iOException) {
            System.err.println("Cannot create logfile in " + string);
            this.debug = null;
        }
    }

    protected static int getEXADriverMajorVersion() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_MAJOR")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    protected static int getEXADriverMinorVersion() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_MINOR")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    protected static int getEXADriverVersionInc() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_INC_jdbc")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    protected static String getEXADriverName() {
        return DRIVER_NAME;
    }

    public static String getCompilationInfo() {
        try {
            Class<?> clazz = Class.forName("com.exasol.jdbc.EXADriver");
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/exasol/jdbc/timestamp");
            StringBuffer stringBuffer = new StringBuffer();
            int n = inputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            Pattern pattern = Pattern.compile("Revision:");
            String[] stringArray = pattern.split(stringBuffer.toString());
            if (stringArray.length > 1) {
                return stringArray[1].trim();
            }
            return Translator.No_info_available();
        }
        catch (Exception exception) {
            return Translator.No_info_available();
        }
    }

    private String GetNextWord(InputStream inputStream) throws IOException {
        String string = "";
        try {
            int n = inputStream.read();
            while (n != 44 && n != 58 && n != -1) {
                string = string + (char)n;
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string.equals("")) {
            return string;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParserResult parseURL8(String string) throws SQLException {
        Object object;
        Object object2;
        String[] stringArray = TextUtil.split(";", string);
        String[] stringArray2 = TextUtil.split(":", stringArray[0]);
        if (stringArray2 == null) {
            return null;
        }
        if (0 != stringArray2[0].compareToIgnoreCase("jdbc")) {
            return null;
        }
        if (!("exa".equals(stringArray2[1]) || "exa-debug".equals(stringArray2[1]) || "exa-slave".equals(stringArray2[1]) || "exa-slave-debug".equals(stringArray2[1]))) {
            return null;
        }
        ParserResult parserResult = new ParserResult();
        parserResult.params.setProperty("url", string);
        if (System.getProperty("com.exasol.jdbc.debug") != null && System.getProperty("com.exasol.jdbc.debug").equalsIgnoreCase("true") || "exa-debug".equals(stringArray2[1]) || "exa-slave-debug".equals(stringArray2[1])) {
            parserResult.params.setProperty("debug", "1");
        }
        if ("exa-slave".equals(stringArray2[1]) || "exa-slave-debug".equals(stringArray2[1])) {
            parserResult.params.setProperty("slave", "1");
        }
        if (stringArray2.length < 3) {
            throw new SQLException(Translator.Error_reading_the_hosts_form_cluster_string());
        }
        String string2 = "";
        if (stringArray2[2].startsWith("//")) {
            void var9_14;
            void var9_12;
            object2 = stringArray2[2].toCharArray();
            char[] cArray = new char[((Object)object2).length - 2];
            int n = 2;
            while (var9_12 < ((Object)object2).length) {
                cArray[var9_12 - 2] = (char)object2[var9_12];
                ++var9_12;
            }
            stringArray2[2] = new String(cArray);
            String string3 = "";
            for (int i = 2; i < stringArray2.length; ++i) {
                String string4 = (String)var9_14 + stringArray2[i];
            }
            try {
                File file = new File((String)var9_14);
                file.canRead();
                FileInputStream fileInputStream = new FileInputStream(file);
            }
            catch (IOException iOException) {
                void var9_17;
                if (1 != stringArray2[2].length()) throw new SQLException(Translator.Error_reading_cluster_string_form_the_file() + (String)var9_14 + ". " + iOException.toString());
                String string5 = "";
                stringArray2[2] = stringArray2[2] + ":";
                for (int i = 2; i < stringArray2.length; ++i) {
                    String string6 = (String)var9_17 + stringArray2[i];
                }
                try {
                    File file = new File((String)var9_17);
                    file.canRead();
                    FileInputStream fileInputStream = new FileInputStream(file);
                }
                catch (IOException iOException2) {
                    throw new SQLException(Translator.Error_reading_cluster_string_form_the_file() + (String)var9_17 + ". " + iOException2.toString());
                }
            }
        } else {
            object2 = "";
            for (int i = 2; i < stringArray2.length; ++i) {
                object2 = (String)object2 + stringArray2[i];
                if (i >= stringArray2.length - 1) continue;
                object2 = (String)object2 + ":";
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object2).getBytes());
        }
        int n = 0;
        try {
            void var6_32;
            int n2;
            while (-1 != (n2 = var6_32.read())) {
                if (n2 == 0 || n2 == 10 || n2 == 13 || n2 == 32) continue;
                if (!(n2 == 58 || n2 == 44 || n2 == 46 || n2 == 45 || n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57) && n2 > 32) throw new SQLException(Translator.Invalid_character_in_cluster_string());
                if (n == 46 && n2 == 46) {
                    string2 = string2 + '#';
                    n = 0;
                    continue;
                }
                if (n == 46 && n2 != 46) {
                    if (n2 <= 32) {
                        string2 = string2 + (char)n;
                    } else {
                        string2 = string2 + (char)n;
                        string2 = string2 + (char)n2;
                    }
                } else if (n2 != 46 && n2 > 32) {
                    string2 = string2 + (char)n2;
                }
                n = n2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(Translator.Error_interpreting_the_cluster_string() + iOException.toString());
        }
        String[] stringArray3 = TextUtil.split("#", string2);
        try {
            if (stringArray3.length > 1) {
                string2 = "";
                for (int i = 0; i < stringArray3.length - 1; ++i) {
                    int n3 = 1;
                    boolean bl = false;
                    String string7 = "";
                    object = "";
                    String string8 = "";
                    int n4 = 0;
                    int n5 = 0;
                    char c = '\u0000';
                    do {
                        if ((c = stringArray3[i].charAt(stringArray3[i].length() - n3)) < '0' || c > '9') continue;
                        object = (String)object + c;
                    } while (++n3 <= stringArray3[i].length() && c >= '0' && c <= '9');
                    if (((String)object).length() == 0) {
                        throw new SQLException(Translator.A_range_must_be_between_numbers());
                    }
                    byte[] byArray = ((String)object).getBytes();
                    object = "";
                    for (int j = byArray.length - 1; j >= 0; --j) {
                        object = (String)object + (char)byArray[j];
                    }
                    n4 = Integer.parseInt((String)object);
                    boolean bl2 = bl = 0 < ((String)object).length() - Integer.toString(n4).length();
                    while (n3 <= stringArray3[i].length() && c != ',' && c != ':') {
                        string7 = string7 + c;
                        c = stringArray3[i].charAt(stringArray3[i].length() - n3);
                        ++n3;
                    }
                    if (stringArray3[i].length() - n3 < 0) {
                        string7 = string7 + stringArray3[i].charAt(0);
                    } else if (string7.length() > 0 && c != ',' && c != ':' && c != '.') {
                        string7 = string7 + c;
                    }
                    byte[] byArray2 = string7.getBytes();
                    string7 = "";
                    if (byArray2.length > 0) {
                        for (int j = byArray2.length - 1; j >= 0; --j) {
                            string7 = string7 + (char)byArray2[j];
                        }
                    }
                    n3 = 0;
                    do {
                        if ((c = stringArray3[i + 1].charAt(n3)) < '0' || c > '9') continue;
                        string8 = string8 + c;
                    } while (++n3 < stringArray3[i + 1].length() && c >= '0' && c <= '9');
                    if (string8.length() == 0) {
                        throw new SQLException(Translator.A_range_must_be_between_numbers());
                    }
                    n5 = Integer.parseInt(string8);
                    string2 = string2 + stringArray3[i];
                    if (n4 > n5) {
                        throw new SQLException(Translator.A_range_must_begin_with_the_smaller_number());
                    }
                    String string9 = "";
                    if (n3 < stringArray3[i + 1].length()) {
                        while (n3 <= stringArray3[i + 1].length() && c != ',' && c != ':') {
                            string9 = string9 + c;
                            if (n3 < stringArray3[i + 1].length()) {
                                c = stringArray3[i + 1].charAt(n3);
                            }
                            ++n3;
                        }
                    }
                    string2 = string2 + string9;
                    if (n4 >= n5) continue;
                    for (n3 = n4 + 1; n3 < n5; ++n3) {
                        string2 = bl ? string2 + "," + string7 + this.FormatNumWithLeadingNulls(((String)object).length(), n3) + string9 : string2 + "," + string7 + n3 + string9;
                    }
                    string2 = string2 + "," + string7;
                }
                string2 = string2 + stringArray3[stringArray3.length - 1];
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException(Translator.Error_parsing_a_range_in_the_cluster_string() + numberFormatException.toString());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        boolean bl = false;
        Vector vector = parserResult.clusterNodes;
        int n6 = 0;
        object = new Long(0L);
        try {
            String string10;
            while (null != (string10 = this.GetNextWord(byteArrayInputStream))) {
                boolean bl3 = true;
                try {
                    object = new Long(string10);
                }
                catch (NumberFormatException numberFormatException) {
                    bl3 = false;
                }
                if (bl3) {
                    if (bl) {
                        if (n6 == 0) {
                            throw new SQLException(Translator.A_port_was_that_cannot_be_assigned_to_any_host());
                        }
                        if (n6 > 1) {
                            throw new SQLException(Translator.Cartesian_product_hosts_ports_found());
                        }
                        if (vector.size() <= 0) throw new SQLException(Translator.A_port_was_that_cannot_be_assigned_to_any_host());
                        vector.add(new ClusterNode(((ClusterNode)vector.get(vector.size() - 1)).GetHost(), new Long(string10).intValue()));
                    } else {
                        for (int i = vector.size() - 1; i >= vector.size() - n6; --i) {
                            ((ClusterNode)vector.get(i)).SetPort(((Long)object).intValue());
                        }
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    n6 = 0;
                }
                vector.add(new ClusterNode(string10, 0));
                ++n6;
                bl = false;
            }
        }
        catch (IOException iOException) {
            throw new SQLException(Translator.Error_reading_the_hosts_form_cluster_string() + iOException.toString());
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray4 = TextUtil.split("=", stringArray[i]);
            if (stringArray4 == null || stringArray4.length != 2) {
                this.log("Cannot parse option: " + stringArray[i]);
                throw new SQLException(Translator.Cannot_parse_option() + stringArray[i]);
            }
            parserResult.params.put(stringArray4[0], stringArray4[1]);
        }
        return parserResult;
    }

    private ParserResult expandDNSPool(ParserResult parserResult) {
        ParserResult parserResult2 = new ParserResult();
        parserResult2.params = parserResult.params;
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            ClusterNode clusterNode = (ClusterNode)parserResult.clusterNodes.get(i);
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(clusterNode.GetHost());
                if (inetAddressArray.length > 1) {
                    ParserResult parserResult3 = new ParserResult();
                    for (int j = 0; j < inetAddressArray.length; ++j) {
                        ClusterNode clusterNode2 = new ClusterNode(inetAddressArray[j].getHostAddress(), clusterNode.GetPort());
                        parserResult3.clusterNodes.add(clusterNode2);
                    }
                    ParserResult parserResult4 = this.sortNodesByHostAndPort(parserResult3);
                    int n = parserResult2.clusterNodes.size();
                    for (int j = 0; j < parserResult4.clusterNodes.size(); ++j) {
                        parserResult2.clusterNodes.add((ClusterNode)parserResult4.clusterNodes.get(j));
                    }
                    continue;
                }
                parserResult2.clusterNodes.add(clusterNode);
                continue;
            }
            catch (Exception exception) {
                parserResult2.clusterNodes.add(clusterNode);
            }
        }
        return parserResult2;
    }

    private ParserResult sortNodesByHostAndPort(ParserResult parserResult) throws ConnectionException {
        Object[] objectArray = new String[parserResult.clusterNodes.size()];
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            objectArray[i] = ((ClusterNode)parserResult.clusterNodes.get(i)).GetHostAndPort();
        }
        Arrays.sort(objectArray);
        ParserResult parserResult2 = new ParserResult();
        parserResult2.params = parserResult.params;
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            ClusterNode clusterNode = new ClusterNode((String)objectArray[i]);
            parserResult2.clusterNodes.add(clusterNode);
        }
        return parserResult2;
    }

    private String FormatNumWithLeadingNulls(int n, int n2) {
        String string = "";
        for (int i = 0; i < n - Integer.toString(n2).length(); ++i) {
            string = string + "0";
        }
        string = string + Integer.toString(n2);
        return string;
    }

    private void log(Object object) {
        if (this.debug != null) {
            this.debug.log(object.toString());
        }
    }

    public static int getProtocolVersion() {
        return EXAConnection.getProtocolVersion();
    }

    public static String getVersionInfo() {
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_MAJOR"));
            stringBuffer.append(".");
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_MINOR"));
            stringBuffer.append(".");
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_INC_jdbc"));
            return stringBuffer.toString();
        }
        return Translator.No_info_available();
    }

    protected static void readVersionRC() {
        try {
            Pattern pattern = Pattern.compile("^\\s*versioninfo\\((.*),(.*)\\)\\s*$");
            Matcher matcher = null;
            ClassLoader classLoader = Class.forName("com.exasol.jdbc.EXADriver").getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/exasol/jdbc/version.res");
            if (inputStream == null) {
                throw new Exception("File version.res missing.");
            }
            versionInfo = new HashMap();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                matcher = pattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    versionInfo.put(string2, TextUtil.stripQuotes(string3));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.err.println("Error when reading file version number: " + exception.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new EXADriver());
            EXADriver.readVersionRC();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

