/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.field.creditcard;

import com.jidesoft.field.creditcard.CardIssuer;
import com.jidesoft.field.creditcard.CreditCardMask;
import com.jidesoft.field.creditcard.CreditCardValidator;
import com.jidesoft.field.creditcard.CreditCardsIconsFactory;
import com.jidesoft.field.creditcard.DefaultCreditCardMask;
import com.jidesoft.swing.LabeledTextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CreditCardTextField
extends LabeledTextField {
    private String[] \u0109 = null;
    private CardIssuer \u0106 = null;
    private String \u010a = null;
    private boolean \u0103 = true;
    private CreditCardMask \u0108;
    private boolean \u0104 = true;
    private boolean \u0107 = false;
    private Icon \u0105;
    private Icon \u0102;
    public static final String PROPERTY_VALIDATE_ON_FLY = "validateOnFly";
    public static final String PROPERTY_MASK_ENABLED = "maskEnabled";

    public CreditCardTextField() {
        this((Icon)null);
    }

    public CreditCardTextField(Icon icon) {
        this(icon, null);
    }

    public CreditCardTextField(Icon icon, String string) {
        super(icon, string);
        this.getTextField().addFocusListener(new B());
        final A a2 = new A();
        this.getTextField().getDocument().addDocumentListener(a2);
        this.getTextField().addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Document document = CreditCardTextField.this.getTextField().getDocument();
                document.addDocumentListener(a2);
            }
        });
        this.setIcon(this.getCreditCardIcon());
    }

    @Override
    protected JTextField createTextField() {
        JTextField jTextField = super.createTextField();
        jTextField.setColumns(16);
        return jTextField;
    }

    public void setAllowedCardIssuerNames(String[] stringArray) {
        this.\u0109 = stringArray;
        this.validateCardNumber();
    }

    public String[] getAllowedCardIssuerNames() {
        return this.\u0109;
    }

    public String getCreditCardNumber() {
        return this.\u010a;
    }

    public CardIssuer getCardIssuer() {
        this.validateCardNumber();
        return this.\u0106;
    }

    public CreditCardMask getCreditCardMask() {
        if (this.\u0108 == null) {
            this.\u0108 = new DefaultCreditCardMask();
        }
        return this.\u0108;
    }

    public void setCreditCardMask(CreditCardMask creditCardMask) {
        this.\u0108 = creditCardMask;
    }

    public void setMaskEnabled(boolean bl) {
        boolean bl2 = this.\u0103;
        if (bl2 != bl) {
            this.\u0103 = bl;
            this.firePropertyChange(PROPERTY_MASK_ENABLED, bl2, this.\u0103);
            if (this.isMaskEnabled()) {
                if (this.getTextField().hasFocus()) {
                    this.unmaskCardNumber();
                } else {
                    this.maskCardNumber();
                }
            } else {
                this.unmaskCardNumber();
            }
        }
    }

    public boolean isMaskEnabled() {
        return this.\u0103;
    }

    public boolean isValidateOnFly() {
        return this.\u0104;
    }

    public void setValidateOnFly(boolean bl) {
        boolean bl2 = this.\u0104;
        if (bl2 != bl) {
            this.\u0104 = bl;
            this.firePropertyChange(PROPERTY_VALIDATE_ON_FLY, bl2, this.\u0104);
            if (this.isValidateOnFly()) {
                this.validateCardNumber();
            }
        }
    }

    public Icon getCreditCardIcon() {
        if (this.\u0105 == null) {
            this.\u0105 = CreditCardsIconsFactory.getImageIcon("icons/CreditCard.png");
        }
        return this.\u0105;
    }

    public void setCreditCardIcon(Icon icon) {
        this.\u0105 = icon;
    }

    public Icon getInvalidCreditCardIcon() {
        if (this.\u0102 == null) {
            this.\u0102 = CreditCardsIconsFactory.getImageIcon("icons/Invalid.png");
        }
        return this.\u0102;
    }

    public void setInvalidCreditCardIcon(Icon icon) {
        this.\u0102 = icon;
    }

    private static String \u0101(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isDigit(c2)) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public boolean validateCardNumber() {
        if (!this.\u0107) {
            this.\u010a = CreditCardTextField.\u0101(this.getTextField().getText());
        }
        if (this.\u010a != null) {
            if (this.\u010a.length() == 0) {
                this.setIcon(this.getCreditCardIcon());
            } else {
                CreditCardValidator creditCardValidator = new CreditCardValidator(this.\u0109);
                this.\u0106 = creditCardValidator.getCardIssuer(this.\u010a);
                if (this.\u0106 != null) {
                    this.setIcon(this.\u0106.getIcon());
                    return true;
                }
                this.setIcon(this.getInvalidCreditCardIcon());
            }
        }
        return false;
    }

    public void unmaskCardNumber() {
        if (this.\u0107 && this.\u010a != null) {
            this.\u0107 = false;
            this.getTextField().setText(this.\u010a);
        }
    }

    public void maskCardNumber() {
        if (!this.\u0107) {
            this.\u010a = CreditCardTextField.\u0101(this.getTextField().getText());
            String string = this.getCreditCardMask().mask(this.\u010a);
            this.\u0107 = true;
            this.getTextField().setText(string);
        }
    }

    private class A
    implements DocumentListener {
        private A() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!CreditCardTextField.this.isValidateOnFly()) {
                return;
            }
            if (!CreditCardTextField.this.\u0107) {
                CreditCardTextField.this.\u010a = this.\u0101(documentEvent);
            }
            CreditCardTextField.this.validateCardNumber();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!CreditCardTextField.this.isValidateOnFly()) {
                return;
            }
            if (!CreditCardTextField.this.\u0107) {
                CreditCardTextField.this.\u010a = this.\u0101(documentEvent);
            }
            CreditCardTextField.this.validateCardNumber();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (!CreditCardTextField.this.isValidateOnFly()) {
                return;
            }
            if (!CreditCardTextField.this.\u0107) {
                CreditCardTextField.this.\u010a = this.\u0101(documentEvent);
            }
            CreditCardTextField.this.validateCardNumber();
        }

        private String \u0101(DocumentEvent documentEvent) {
            try {
                Document document = documentEvent.getDocument();
                return document.getText(0, document.getLength());
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    private class B
    implements FocusListener {
        private B() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CreditCardTextField.this.unmaskCardNumber();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CreditCardTextField.this.\u010a = CreditCardTextField.\u0101(CreditCardTextField.this.getTextField().getText());
            if (CreditCardTextField.this.\u010a == null || CreditCardTextField.this.\u010a.length() == 0) {
                CreditCardTextField.this.setIcon(CreditCardTextField.this.getCreditCardIcon());
            } else if (CreditCardTextField.this.isMaskEnabled()) {
                CreditCardTextField.this.maskCardNumber();
            }
        }
    }
}

