/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.margin.AbstractLineMargin;
import com.jidesoft.margin.MarginSupport;
import com.jidesoft.margin.RowMarginSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LineNumberMargin
extends AbstractLineMargin {
    private static Color \u0107 = new Color(128, 0, 0);
    private transient int \u0106;
    private boolean \u0109 = false;
    private transient int \u0108 = -1;

    public LineNumberMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.setForeground(\u0107);
        this.\u0108 = codeEditor.getLineCount();
    }

    @Override
    public void paintLineMargin(Graphics graphics, Rectangle rectangle, int n2) {
        int n3 = this._editor.viewToModelLine(n2) + 1;
        if (n3 <= this._editor.getLineCount()) {
            String string = "" + n3;
            graphics.setColor(this.getForeground());
            graphics.drawString(string, rectangle.x + rectangle.width - this._editor.getPainter().getFontMetrics().stringWidth(string) - 3, rectangle.y + this._editor.getPainter().getFontMetrics().getAscent());
        }
    }

    @Override
    public int getPreferredWidth() {
        String string = "" + this._editor.getLineCount();
        this.\u0106 = string.length();
        return this._editor.getPainter().getFontMetrics().stringWidth(string) + 6;
    }

    @Override
    public String getToolTipText(int n2) {
        if (!this.isShowTooltip()) {
            return null;
        }
        if ((n2 = this._editor.viewToModelLine(n2)) >= this._editor.getLineCount()) {
            return null;
        }
        return "" + (n2 + 1);
    }

    public boolean isShowTooltip() {
        return this.\u0109;
    }

    public void setShowTooltip(boolean bl) {
        this.\u0109 = bl;
    }

    @Override
    protected MarginSupport.ModelChangedCallback createModelChangedCallback() {
        return new MarginSupport.ModelChangedCallback(){

            @Override
            public void modelChanged(Object object) {
                int n2 = ((RowMarginSupport)LineNumberMargin.this._marginSupport).getRowCount();
                if (LineNumberMargin.this.\u0108 == -1 || n2 != LineNumberMargin.this.\u0108 && (int)Math.log10(n2) != (int)Math.log10(LineNumberMargin.this.\u0108)) {
                    LineNumberMargin.this.revalidate();
                }
                LineNumberMargin.this.\u0108 = n2;
            }
        };
    }
}

