/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;
import java.sql.SQLException;

public class ValueByte
extends Value {
    private byte value;

    public ValueByte(byte value) {
        this.value = value;
    }

    public ValueByte(Object value) {
        this.value = value instanceof Number ? ((Number)value).byteValue() : (value instanceof Boolean ? (byte)(Boolean.TRUE.equals(value) ? 1 : 0) : Byte.parseByte(value.toString()));
    }

    @Override
    int getType() {
        return 4;
    }

    @Override
    int getScale() {
        return 0;
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeByte(this.value);
    }

    @Override
    String getString() {
        return ValueByte.getString(this.value, 0);
    }

    @Override
    byte getByte() {
        return this.value;
    }

    @Override
    short getShort() {
        return this.getByte();
    }

    @Override
    int getInt() {
        return this.getByte();
    }

    @Override
    long getLong() {
        return this.getByte();
    }

    @Override
    double getDouble() {
        return this.getByte();
    }

    @Override
    float getFloat() {
        return this.getByte();
    }

    @Override
    BigDecimal getBigDecimal() throws SQLException {
        return BigDecimal.valueOf(this.value, 0);
    }

    @Override
    Object getObject() {
        return this.getByte();
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.getByte());
    }
}

