/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc3;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSIEmptyResultSet;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc3.S3ForwardResultSet;
import com.vertica.jdbc.jdbc3.S3UpdatableForwardResultSet;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S3Statement
extends SStatement {
    public S3Statement(IStatement iStatement, SConnection sConnection, int n) {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC3;
    }

    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        SForwardResultSet sForwardResultSet = null;
        sForwardResultSet = this.createsUpdatableResults() ? new S3UpdatableForwardResultSet(this, (IResultSet)executionResult.getResult(), this.m_logger) : new S3ForwardResultSet(this, (IResultSet)executionResult.getResult(), this.m_logger);
        sForwardResultSet.setFetchSize(this.getFetchSize());
        return sForwardResultSet;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return new S3ForwardResultSet(this, new DSIEmptyResultSet(), this.m_logger);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

