/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.joda.time.convert;

import com.amazon.redshift.shaded.joda.time.Chronology;
import com.amazon.redshift.shaded.joda.time.DateTimeZone;
import com.amazon.redshift.shaded.joda.time.chrono.BuddhistChronology;
import com.amazon.redshift.shaded.joda.time.chrono.GJChronology;
import com.amazon.redshift.shaded.joda.time.chrono.GregorianChronology;
import com.amazon.redshift.shaded.joda.time.chrono.ISOChronology;
import com.amazon.redshift.shaded.joda.time.chrono.JulianChronology;
import com.amazon.redshift.shaded.joda.time.convert.AbstractConverter;
import com.amazon.redshift.shaded.joda.time.convert.InstantConverter;
import com.amazon.redshift.shaded.joda.time.convert.PartialConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();

    protected CalendarConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology != null) {
            return chronology;
        }
        Calendar calendar = (Calendar)object;
        DateTimeZone dateTimeZone = null;
        try {
            dateTimeZone = DateTimeZone.forTimeZone(calendar.getTimeZone());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)calendar, dateTimeZone);
    }

    @Override
    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(dateTimeZone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            long l = gregorianCalendar.getGregorianChange().getTime();
            if (l == Long.MIN_VALUE) {
                return GregorianChronology.getInstance(dateTimeZone);
            }
            if (l == Long.MAX_VALUE) {
                return JulianChronology.getInstance(dateTimeZone);
            }
            return GJChronology.getInstance(dateTimeZone, l, 4);
        }
        return ISOChronology.getInstance(dateTimeZone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        Calendar calendar = (Calendar)object;
        return calendar.getTime().getTime();
    }

    @Override
    public Class<?> getSupportedType() {
        return Calendar.class;
    }
}

