/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.apache.http.impl.cookie;

import com.amazon.redshift.shaded.apache.http.annotation.Immutable;
import com.amazon.redshift.shaded.apache.http.cookie.CommonCookieAttributeHandler;
import com.amazon.redshift.shaded.apache.http.cookie.MalformedCookieException;
import com.amazon.redshift.shaded.apache.http.cookie.SetCookie;
import com.amazon.redshift.shaded.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.amazon.redshift.shaded.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

