/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.apache.http.impl.conn;

import com.amazon.redshift.shaded.apache.http.HttpResponse;
import com.amazon.redshift.shaded.apache.http.HttpResponseFactory;
import com.amazon.redshift.shaded.apache.http.annotation.Immutable;
import com.amazon.redshift.shaded.apache.http.config.MessageConstraints;
import com.amazon.redshift.shaded.apache.http.impl.DefaultHttpResponseFactory;
import com.amazon.redshift.shaded.apache.http.impl.conn.DefaultHttpResponseParser;
import com.amazon.redshift.shaded.apache.http.io.HttpMessageParser;
import com.amazon.redshift.shaded.apache.http.io.HttpMessageParserFactory;
import com.amazon.redshift.shaded.apache.http.io.SessionInputBuffer;
import com.amazon.redshift.shaded.apache.http.message.BasicLineParser;
import com.amazon.redshift.shaded.apache.http.message.LineParser;

@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

