/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.plugin.InternalPluginException;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import com.amazon.redshift.plugin.httpserver.Server;
import com.amazon.redshift.plugin.utils.CheckUtils;
import com.amazon.redshift.plugin.utils.LogUtils;
import com.amazon.redshift.plugin.utils.ResponseUtils;
import com.amazon.redshift.shaded.apache.http.NameValuePair;
import com.amazon.support.LogUtilities;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;

public class BrowserSamlCredentialsProvider
extends SamlCredentialsProvider {
    public static final String KEY_LOGIN_URL = "login_url";
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    private static final String SAML_RESPONSE_PARAM_NAME = "SAMLResponse";
    private String m_login_url;
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 7890;

    @Override
    protected String getSamlAssertion() throws IOException {
        try {
            CheckUtils.checkMissingAndThrows(this.m_login_url, KEY_LOGIN_URL);
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port < 1 || this.m_listen_port > 65535, KEY_LISTEN_PORT);
            return this.authenticate();
        }
        catch (InternalPluginException internalPluginException) {
            throw new IOException(internalPluginException);
        }
    }

    @Override
    public void addParameter(String string, String string2) {
        switch (string) {
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(string2);
                break;
            }
            case "login_url": {
                this.m_login_url = string2;
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(string2);
                break;
            }
            default: {
                super.addParameter(string, string2);
            }
        }
    }

    private String authenticate() throws IOException {
        RequestHandler requestHandler = new RequestHandler(new Function<List<NameValuePair>, Object>(){

            @Override
            public Object apply(List<NameValuePair> list) {
                return ResponseUtils.findParameter(BrowserSamlCredentialsProvider.SAML_RESPONSE_PARAM_NAME, list);
            }
        });
        Server server = new Server(this.m_listen_port, requestHandler, Duration.ofSeconds(this.m_idp_response_timeout));
        server.listen();
        LogUtilities.logInfo(String.format("Listening for connection on port %d", this.m_listen_port), LogUtils.getLogger());
        try {
            this.openBrowser();
            server.waitForResult();
        }
        catch (IOException iOException) {
            server.stop();
            throw iOException;
        }
        server.waitForResult();
        Object object = requestHandler.getResult();
        if (object instanceof InternalPluginException) {
            throw (InternalPluginException)object;
        }
        if (object instanceof String) {
            LogUtilities.logInfo("Got SAML assertion", LogUtils.getLogger());
            return (String)object;
        }
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private void openBrowser() throws IOException {
        URI uRI = URI.create(this.m_login_url);
        LogUtilities.logDebug(String.format("SSO URI: \n%s", uRI.toString()), LogUtils.getLogger());
        Desktop.getDesktop().browse(uRI);
    }
}

