/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.services.redshift.model.HsmConfiguration;
import com.amazon.redshift.amazonaws.services.redshift.model.Tag;
import com.amazon.redshift.amazonaws.services.redshift.model.transform.TagStaxUnmarshaller;
import com.amazon.redshift.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazon.redshift.amazonaws.transform.StaxUnmarshallerContext;
import com.amazon.redshift.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class HsmConfigurationStaxUnmarshaller
implements Unmarshaller<HsmConfiguration, StaxUnmarshallerContext> {
    private static HsmConfigurationStaxUnmarshaller instance;

    @Override
    public HsmConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        HsmConfiguration hsmConfiguration = new HsmConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return hsmConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HsmConfigurationIdentifier", targetDepth)) {
                    hsmConfiguration.setHsmConfigurationIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    hsmConfiguration.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HsmIpAddress", targetDepth)) {
                    hsmConfiguration.setHsmIpAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HsmPartitionName", targetDepth)) {
                    hsmConfiguration.setHsmPartitionName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    hsmConfiguration.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                hsmConfiguration.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return hsmConfiguration;
    }

    public static HsmConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HsmConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

