/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.internal.SdkInternalList;
import com.amazon.redshift.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest;
import com.amazon.redshift.amazonaws.services.redshift.model.Tag;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class CreateHsmClientCertificateRequestMarshaller
implements Marshaller<Request<CreateHsmClientCertificateRequest>, CreateHsmClientCertificateRequest> {
    @Override
    public Request<CreateHsmClientCertificateRequest> marshall(CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        SdkInternalList tagsList;
        if (createHsmClientCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHsmClientCertificateRequest> request = new DefaultRequest<CreateHsmClientCertificateRequest>(createHsmClientCertificateRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateHsmClientCertificate");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createHsmClientCertificateRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString(createHsmClientCertificateRequest.getHsmClientCertificateIdentifier()));
        }
        if (!(tagsList = (SdkInternalList)createHsmClientCertificateRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

