/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.logging;

import com.nuodb.impl.util.NuoLogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Logging {
    private static final String NO_CONSOLEHANDLER = "NuoAgent is running without a ConsoleHandler. Diagnostics are limited";
    private static final String JUL_CONF = "java.util.logging.config.file";
    private static final Logger logger = Logger.getLogger(Logging.class.getName());
    private static final Formatter defaultFormatter = new NuoLogFormatter();
    private static final String mvnLogDir = System.getProperty("nuodb.testLogDir", null);
    private static final PrintStream origOut = System.out;
    private static final PrintStream origErr = System.err;

    public static void setupLogging(String logLevel, Class<?> loadingClass) {
        if (!Logging.checkExternalConfiguration()) {
            if (logLevel != null) {
                Logging.setLogging(logLevel, new NuoLogFormatter());
            } else {
                InputStream configStream = loadingClass.getResourceAsStream("/logging.properties");
                if (configStream != null) {
                    try {
                        try {
                            LogManager.getLogManager().readConfiguration(configStream);
                        }
                        finally {
                            configStream.close();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("default logging configured: " + e.getMessage());
                        Logging.setLogging("INFO", new NuoLogFormatter());
                    }
                }
            }
        }
    }

    public static void setLogging(String logLevel) {
        if (!Logging.checkExternalConfiguration()) {
            Logging.setLogging(logLevel, defaultFormatter);
        }
    }

    private static synchronized void setLogging(String logLevel, Formatter formatter) {
        if (logLevel != null) {
            Level level = Level.parse(logLevel.toUpperCase());
            LogManager.getLogManager().reset();
            Logger rootLogger = Logger.getLogger("");
            rootLogger.setLevel(level);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(level);
            handler.setFormatter(formatter);
            rootLogger.addHandler(handler);
        }
    }

    public static synchronized void redirectOutput(String testMethodName, String testClassName) throws SecurityException, IOException {
        if (mvnLogDir == null) {
            return;
        }
        File logFile = new File(mvnLogDir, testClassName + ".log");
        System.out.println(String.format("Redirecting output for %s to %s", testMethodName, logFile.getAbsolutePath()));
        PrintStream out = new PrintStream(new FileOutputStream(logFile, true));
        System.setOut(out);
        System.setErr(out);
        Logging.setLogging(Logger.getLogger("").getLevel().toString());
    }

    public static synchronized void resetOutput() {
        if (mvnLogDir == null) {
            return;
        }
        System.setOut(origOut);
        System.setErr(origErr);
        Logging.setLogging(Logger.getLogger("").getLevel().toString());
    }

    public static void checkConsoleHandler() {
        Handler[] handlers;
        logger.info("Validating ConsoleHandler");
        Logger rooteLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rooteLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            return;
        }
        logger.warning(NO_CONSOLEHANDLER);
        System.err.println(NO_CONSOLEHANDLER);
    }

    private static boolean checkExternalConfiguration() {
        String conf = System.getProperty(JUL_CONF);
        if (conf != null) {
            if (new File(conf).exists()) {
                logger.info(String.format("Using %s=%s", JUL_CONF, conf));
                return true;
            }
            System.out.println(String.format("Ignoring %s=%s, file doesn't exist", JUL_CONF, conf));
        }
        return false;
    }
}

