/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.runtime.filechooser.AbstractFileSystemChooser;
import com.install4j.runtime.filechooser.CustomFileChooser;
import com.install4j.runtime.filechooser.FileChooserQuestion;
import com.install4j.runtime.filechooser.FileChooserWithLowerAccessory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

class SwingFileChooserHelper {
    private Map<FileChooserQuestion, JCheckBox> checkboxes = new HashMap<FileChooserQuestion, JCheckBox>();

    public SwingFileChooserHelper(AbstractFileSystemChooser<?> fileSystemChooser, FileChooserWithLowerAccessory swingFileChooser) {
        swingFileChooser.setCurrentDirectory(fileSystemChooser.getCurrentDirectory());
        swingFileChooser.setDialogTitle(fileSystemChooser.getTitle());
        File defaultSelectedFile = fileSystemChooser.getDefaultSelectedFile();
        if (defaultSelectedFile != null) {
            swingFileChooser.setSelectedFile(defaultSelectedFile);
        }
        swingFileChooser.setFileHidingEnabled(fileSystemChooser.isFileHidingEnabled());
        Collection<FileChooserQuestion> fileChooserQuestions = fileSystemChooser.getFileChooserQuestions();
        if (fileChooserQuestions.size() > 0) {
            JPanel accessory = CustomFileChooser.createLowerAccessoryPanel();
            for (FileChooserQuestion fileChooserQuestion : fileChooserQuestions) {
                JCheckBox checkbox = new JCheckBox(fileChooserQuestion.getDescription(), fileChooserQuestion.isSelected());
                accessory.add(checkbox);
                this.checkboxes.put(fileChooserQuestion, checkbox);
            }
            swingFileChooser.setLowerAccessory(accessory);
        }
    }

    public void saveQuestions() {
        for (Map.Entry<FileChooserQuestion, JCheckBox> entry : this.checkboxes.entrySet()) {
            entry.getKey().setSelected(entry.getValue().isSelected());
        }
    }
}

