/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public class PortFinder {
    private static final String OS_NAME = System.getProperty("os.name");

    public static synchronized int findUnusedPort() {
        return PortFinder.findUnusedPort(0);
    }

    public static boolean isPortUnused(int port) {
        return PortFinder.findUnusedPort(port) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findUnusedPort(int port) {
        block15: {
            int n;
            ServerSocket ss = null;
            try {
                if (PortFinder.isWindows() || PortFinder.isMacos()) {
                    ss = new ServerSocket();
                    InetSocketAddress sa = new InetSocketAddress("127.0.0.1", port);
                    ss.bind(sa);
                    ss.setReuseAddress(true);
                    int n2 = ss.getLocalPort();
                    return n2;
                }
                ss = new ServerSocket(port);
                ss.setReuseAddress(true);
                n = ss.getLocalPort();
            }
            catch (IOException iOException) {
                break block15;
            }
            finally {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return n;
        }
        return -1;
    }

    private static boolean isMacos() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    private static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }
}

