/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.amazonaws.util.json.Jackson;
import com.amazon.redshift.plugin.InternalPluginException;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import com.amazon.redshift.plugin.httpserver.Server;
import com.amazon.redshift.plugin.utils.CheckUtils;
import com.amazon.redshift.plugin.utils.LogUtils;
import com.amazon.redshift.plugin.utils.RandomStateUtil;
import com.amazon.redshift.plugin.utils.ResponseUtils;
import com.amazon.redshift.shaded.apache.commons.codec.Charsets;
import com.amazon.redshift.shaded.apache.commons.codec.binary.Base64;
import com.amazon.redshift.shaded.apache.commons.codec.binary.StringUtils;
import com.amazon.redshift.shaded.apache.http.NameValuePair;
import com.amazon.redshift.shaded.apache.http.client.entity.UrlEncodedFormEntity;
import com.amazon.redshift.shaded.apache.http.client.methods.HttpPost;
import com.amazon.redshift.shaded.apache.http.client.utils.URIBuilder;
import com.amazon.redshift.shaded.apache.http.entity.ContentType;
import com.amazon.redshift.shaded.apache.http.message.BasicNameValuePair;
import com.amazon.redshift.shaded.fasterxml.jackson.databind.JsonNode;
import com.amazon.support.LogUtilities;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class BrowserAzureCredentialsProvider
extends SamlCredentialsProvider {
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    public static final String KEY_IDP_TENANT = "idp_tenant";
    public static final String KEY_CLIENT_ID = "client_id";
    public static final String OAUTH_STATE_PARAMETER_NAME = "state";
    public static final String OAUTH_REDIRECT_PARAMETER_NAME = "redirect_uri";
    public static final String OAUTH_IDP_CODE_PARAMETER_NAME = "code";
    public static final String OAUTH_CLIENT_ID_PARAMETER_NAME = "client_id";
    public static final String OAUTH_RESPONSE_TYPE_PARAMETER_NAME = "response_type";
    public static final String OAUTH_REQUESTED_TOKEN_TYPE_PARAMETER_NAME = "requested_token_type";
    public static final String OAUTH_GRANT_TYPE_PARAMETER_NAME = "grant_type";
    public static final String OAUTH_SCOPE_PARAMETER_NAME = "scope";
    public static final String OAUTH_RESOURCE_PARAMETER_NAME = "resource";
    public static final String OAUTH_RESPONSE_MODE_PARAMETER_NAME = "response_mode";
    private static final String MICROSOFT_IDP_HOST = "login.microsoftonline.com";
    private static final String CURRENT_INTERACTION_SCHEMA = "https";
    private String m_idp_tenant;
    private String m_clientId;
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 7890;
    private String redirectUri;

    @Override
    protected String getSamlAssertion() throws IOException {
        try {
            CheckUtils.checkMissingAndThrows(this.m_idp_tenant, KEY_IDP_TENANT);
            CheckUtils.checkMissingAndThrows(this.m_clientId, "client_id");
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port < 1 || this.m_listen_port > 65535, KEY_LISTEN_PORT);
            this.redirectUri = "http://localhost:" + this.m_listen_port + "/redshift/";
            String string = this.fetchAuthorizationToken();
            String string2 = this.fetchSamlResponse(string);
            String string3 = this.extractSamlAssertion(string2);
            return this.wrapAndEncodeAssertion(string3);
        }
        catch (InternalPluginException | URISyntaxException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void addParameter(String string, String string2) {
        switch (string) {
            case "idp_tenant": {
                this.m_idp_tenant = string2;
                break;
            }
            case "client_id": {
                this.m_clientId = string2;
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(string2);
                break;
            }
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(string2);
                break;
            }
            default: {
                super.addParameter(string, string2);
            }
        }
    }

    private String fetchAuthorizationToken() throws IOException, URISyntaxException {
        final String string = RandomStateUtil.generateRandomState();
        RequestHandler requestHandler = new RequestHandler(new Function<List<NameValuePair>, Object>(){

            @Override
            public Object apply(List<NameValuePair> list) {
                String string3 = ResponseUtils.findParameter(BrowserAzureCredentialsProvider.OAUTH_STATE_PARAMETER_NAME, list);
                if (!string.equals(string3)) {
                    return new InternalPluginException("Incoming state " + string3 + " does not match the outgoing state " + string);
                }
                String string2 = ResponseUtils.findParameter(BrowserAzureCredentialsProvider.OAUTH_IDP_CODE_PARAMETER_NAME, list);
                if (com.amazon.redshift.amazonaws.util.StringUtils.isNullOrEmpty(string2)) {
                    return new InternalPluginException("No valid code found");
                }
                return string2;
            }
        });
        Server server = new Server(this.m_listen_port, requestHandler, Duration.ofSeconds(this.m_idp_response_timeout));
        server.listen();
        try {
            LogUtilities.logInfo(String.format("Listening for connection on port %d", this.m_listen_port), LogUtils.getLogger());
            this.openBrowser(string);
            server.waitForResult();
        }
        catch (IOException | URISyntaxException exception) {
            server.stop();
            throw exception;
        }
        Object object = requestHandler.getResult();
        if (object instanceof InternalPluginException) {
            throw (InternalPluginException)object;
        }
        if (object instanceof String) {
            LogUtilities.logInfo("Got SAML assertion", LogUtils.getLogger());
            return (String)object;
        }
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private String wrapAndEncodeAssertion(String string) {
        String string2 = "<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"><samlp:Status><samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/></samlp:Status>" + string + "</samlp:Response>";
        return StringUtils.newStringUtf8(Base64.encodeBase64(string2.getBytes()));
    }

    /*
     * Exception decompiling
     */
    private String fetchSamlResponse(String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String extractSamlAssertion(String string) {
        JsonNode jsonNode = Jackson.jsonNodeOf(string).findValue("access_token");
        CheckUtils.checkAndThrowsWithMessage(jsonNode == null, "Failed to find access_token");
        String string2 = jsonNode.textValue();
        CheckUtils.checkAndThrowsWithMessage(com.amazon.redshift.amazonaws.util.StringUtils.isNullOrEmpty(string2), "Invalid access_token value.");
        LogUtilities.logInfo("Successfully got SAML assertion", LogUtils.getLogger());
        return StringUtils.newStringUtf8(Base64.decodeBase64(string2));
    }

    private HttpPost createAuthorizationRequest(String string) {
        URIBuilder uRIBuilder = new URIBuilder().setScheme(CURRENT_INTERACTION_SCHEMA).setHost(MICROSOFT_IDP_HOST).setPath("/" + this.m_idp_tenant + "/oauth2/token");
        String string2 = uRIBuilder.toString();
        HttpPost httpPost = new HttpPost(string2);
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair(OAUTH_IDP_CODE_PARAMETER_NAME, string));
        arrayList.add(new BasicNameValuePair(OAUTH_REQUESTED_TOKEN_TYPE_PARAMETER_NAME, "urn:ietf:params:oauth:token-type:saml2"));
        arrayList.add(new BasicNameValuePair(OAUTH_GRANT_TYPE_PARAMETER_NAME, "authorization_code"));
        arrayList.add(new BasicNameValuePair(OAUTH_SCOPE_PARAMETER_NAME, "openid"));
        arrayList.add(new BasicNameValuePair(OAUTH_RESOURCE_PARAMETER_NAME, this.m_clientId));
        arrayList.add(new BasicNameValuePair("client_id", this.m_clientId));
        arrayList.add(new BasicNameValuePair(OAUTH_REDIRECT_PARAMETER_NAME, this.redirectUri));
        httpPost.addHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        httpPost.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
        httpPost.setEntity(new UrlEncodedFormEntity(arrayList, Charsets.UTF_8));
        LogUtilities.logDebug(String.format("Request token URI: \n%s\nRequest parameters:\n%s", string2, Arrays.toString(arrayList.toArray())), LogUtils.getLogger());
        return httpPost;
    }

    private void openBrowser(String string) throws URISyntaxException, IOException {
        URIBuilder uRIBuilder = new URIBuilder().setScheme(CURRENT_INTERACTION_SCHEMA).setHost(MICROSOFT_IDP_HOST).setPath("/" + this.m_idp_tenant + "/oauth2/authorize").addParameter(OAUTH_SCOPE_PARAMETER_NAME, "openid").addParameter(OAUTH_RESPONSE_TYPE_PARAMETER_NAME, OAUTH_IDP_CODE_PARAMETER_NAME).addParameter(OAUTH_RESPONSE_MODE_PARAMETER_NAME, "form_post").addParameter("client_id", this.m_clientId).addParameter(OAUTH_REDIRECT_PARAMETER_NAME, this.redirectUri).addParameter(OAUTH_STATE_PARAMETER_NAME, string);
        URI uRI = uRIBuilder.build();
        Desktop.getDesktop().browse(uRI);
        LogUtilities.logDebug(String.format("Authorization code request URI: \n%s", uRI.toString()), LogUtils.getLogger());
    }
}

