/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.redshift.model.transform;

import com.amazon.redshift.amazonaws.DefaultRequest;
import com.amazon.redshift.amazonaws.Request;
import com.amazon.redshift.amazonaws.SdkClientException;
import com.amazon.redshift.amazonaws.http.HttpMethodName;
import com.amazon.redshift.amazonaws.internal.SdkInternalList;
import com.amazon.redshift.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazon.redshift.amazonaws.transform.Marshaller;
import com.amazon.redshift.amazonaws.util.StringUtils;

public class DescribeClustersRequestMarshaller
implements Marshaller<Request<DescribeClustersRequest>, DescribeClustersRequest> {
    @Override
    public Request<DescribeClustersRequest> marshall(DescribeClustersRequest describeClustersRequest) {
        SdkInternalList tagValuesList;
        SdkInternalList tagKeysList;
        if (describeClustersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeClustersRequest> request = new DefaultRequest<DescribeClustersRequest>(describeClustersRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeClusters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClustersRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(describeClustersRequest.getClusterIdentifier()));
        }
        if (describeClustersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeClustersRequest.getMaxRecords()));
        }
        if (describeClustersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeClustersRequest.getMarker()));
        }
        if (!(tagKeysList = (SdkInternalList)describeClustersRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!(tagValuesList = (SdkInternalList)describeClustersRequest.getTagValues()).isEmpty() || !tagValuesList.isAutoConstruct()) {
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString(tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

