/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.newdataimp.target;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.onseven.dbvis.db.k.i;
import com.onseven.dbvis.newdataimp.analyze.DataRecordColumnInfo;
import com.onseven.dbvis.newdataimp.analyze.DataRecordColumnInfoSet;
import com.onseven.dbvis.newdataimp.f;
import com.onseven.dbvis.newdataimp.g.e;
import com.onseven.dbvis.newdataimp.target.SqlStatistics;
import com.onseven.dbvis.newdataimp.target.Table;
import com.onseven.dbvis.newdataimp.target.b;
import com.onseven.dbvis.newdataimp.target.c;
import com.onseven.dbvis.newdataimp.target.d;
import com.onseven.dbvis.newdataimp.target.g;
import com.onseven.dbvis.newdataimp.target.h;
import com.onseven.dbvis.newdataimp.target.j;
import com.onseven.dbvis.newdataimp.target.l;
import com.onseven.dbvis.newdataimp.target.m;
import com.onseven.dbvis.newdataimp.target.n;
import com.onseven.dbvis.newdataimp.target.p;
import com.onseven.dbvis.util.t;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class TableImportTarget
implements m {
    private static Logger LOG = Logger.getLogger(TableImportTarget.class.getName());
    private Table table = null;
    private String ddl = null;
    b columnValidator;
    @JsonIgnore
    private i dbConnection = null;
    @JsonIgnore
    private f importContext = null;
    private boolean statementDropTableDone;
    private boolean statementCreateTableDone;
    private boolean statementClearedTableDone;
    private String clearMessage;
    private boolean isDryRun = false;
    private static l._b PARAM_FAULT = l._b.e;

    public TableImportTarget() {
    }

    public TableImportTarget(Table table) {
        this.table = table;
    }

    @Override
    public com.onseven.dbvis.newdataimp.record.d createRecordHandler() {
        return new h(this.importContext, this);
    }

    @Override
    public void init(i i2, f f2) throws p {
        this.dbConnection = i2;
        this.importContext = f2;
        this.isDryRun = f2.o();
    }

    @Override
    public void checkPrerequisites() throws p {
        if (this.getMappings() == null || this.getMappings().b.size() == 0) {
            throw new p(TableImportTarget.getText("NoMapping", new Object[0]));
        }
        if (this.table == null) {
            throw new p(TableImportTarget.getText("NoTable", new Object[0]));
        }
        if (this.table.getColumns().isEmpty()) {
            throw new p(TableImportTarget.getText("NoColumnsFound", this.table.getFullyQualifiedTableName()));
        }
    }

    private DataRecordColumnInfoSet getSourceColumnInfo() {
        return this.importContext.c();
    }

    @Override
    public n checkDataCompatibility() throws p {
        n n2 = new n();
        if (this.getSourceColumnInfo() == null || this.getMappings() == null || this.table.getColumns() == null) {
            return n2;
        }
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.getSourceColumnInfo().getInfoMap().entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            this.check(entry, n2);
        }
        return n2;
    }

    private d getMappings() {
        return this.importContext.l();
    }

    public Table getTable() {
        return this.table;
    }

    public i getDbConnection() {
        return this.dbConnection;
    }

    private void check(Map.Entry<Integer, DataRecordColumnInfo> entry, n n2) {
        DataRecordColumnInfo dataRecordColumnInfo = entry.getValue();
        String string = dataRecordColumnInfo.getColumnName();
        String string2 = this.getTargetColumnName(dataRecordColumnInfo);
        if (string2 == null) {
            return;
        }
        c c2 = this.table.getColumn(string2);
        if (c2 == null) {
            this.fail(n2, "ColumnNotFound", n._b._b.e, string, string2, this.table.getFullyQualifiedTableName());
            return;
        }
        if (this.columnValidator.b(c2)) {
            return;
        }
        n._b _b2 = this.columnValidator.b(this.table, c2, dataRecordColumnInfo);
        if (_b2 != null) {
            n2.b(_b2);
        }
    }

    private d createAutoMapping(DataRecordColumnInfoSet dataRecordColumnInfoSet, Table table) {
        d d2 = new d();
        d2.b(dataRecordColumnInfoSet, table);
        LOG.log(Level.FINE, "Automapping of colums created. " + d2.b().size() + " columns mapped");
        this.importContext.b(d2);
        return d2;
    }

    @Override
    public l prepareTargetForImport(boolean bl) throws p {
        boolean bl2;
        l l2 = new l();
        e e2 = this.importContext.k();
        com.onseven.dbvis.newdataimp.g.f f2 = null;
        if (bl) {
            f2 = com.onseven.dbvis.newdataimp.g.f.g;
            this.initDefaultColumnValidator();
        } else {
            f2 = this.getCleanData(e2);
        }
        if (!this.initDDL(this.importContext, f2, l2)) {
            return l2;
        }
        if (f2 == com.onseven.dbvis.newdataimp.g.f.e) {
            if (this.dropAndCreateTable(this.dbConnection, this.importContext, l2)) {
                bl2 = this.initTableColumnInfo(l2, this.dbConnection);
                if (!l2.i()) {
                    return l2;
                }
                if (bl2) {
                    if (this.getMappings() == null) {
                        this.createAutoMapping(this.getSourceColumnInfo(), this.table);
                    } else {
                        this.resolveTargetMappings(l2);
                    }
                    this.checkSourceDataAgainstTable(l2);
                } else {
                    String string = TableImportTarget.getText("NoColumnInfoAfterCreatTable", this.table.getFullyQualifiedTableName());
                    l2.b(string, l._b.b);
                }
            }
        } else if (f2 == com.onseven.dbvis.newdataimp.g.f.b) {
            bl2 = this.initTableColumnInfo(l2, this.dbConnection);
            if (!bl2) {
                String string = TableImportTarget.getText("NoColumnInfoWhenClear", this.table.getFullyQualifiedTableName());
                l2.b(string, l._b.b);
                return l2;
            }
            if (this.getMappings() == null) {
                this.createAutoMapping(this.getSourceColumnInfo(), this.table);
            }
            this.resolveTargetMappings(l2);
            if (this.checkSourceDataAgainstTable(l2)) {
                this.clearTableData(this.dbConnection, this.importContext, l2);
            }
        } else if (f2 == com.onseven.dbvis.newdataimp.g.f.g || f2 == com.onseven.dbvis.newdataimp.g.f.d) {
            bl2 = this.initTableColumnInfo(l2, this.dbConnection);
            if (!bl2 && bl) {
                if (this.is(com.onseven.dbvis.newdataimp.g.d.dc)) {
                    String string = TableImportTarget.getText("NoColumnsFound", this.table.getFullyQualifiedTableName());
                    l2.b(string, l._b.b);
                    return l2;
                }
            } else if (!bl2) {
                if (!this.initDDLFromFileOrParam(this.importContext, l2, e2)) {
                    return l2;
                }
                if (t.i(this.ddl)) {
                    if (!this.isDryRun) {
                        long l3 = j.b(this.table, this.dbConnection, this.ddl, l2, "RunDDL");
                        if (!l2.i()) {
                            return l2;
                        }
                        this.addUpdateRowsToStats(l3, this.importContext);
                        bl2 = this.initTableColumnInfo(l2, this.dbConnection);
                        if (!bl2 && this.is(com.onseven.dbvis.newdataimp.g.d.dc)) {
                            String string = TableImportTarget.getText("NoColumnInfoAfterCreatTable", this.table.getFullyQualifiedTableName());
                            l2.b(string, l._b.b);
                            return l2;
                        }
                    } else {
                        LOG.log(Level.FINE, "Dry Run: SQL not run: " + this.ddl);
                        l2.b(TableImportTarget.getText("DryNoCreateTable", new Object[0]));
                    }
                } else if (this.is(com.onseven.dbvis.newdataimp.g.d.dc)) {
                    String string = TableImportTarget.getText("NoColumnsFound", this.table.getFullyQualifiedTableName());
                    l2.b(string, l._b.b);
                    return l2;
                }
            } else {
                this.resolveTargetMappings(l2);
            }
            if (this.getMappings() == null) {
                this.createAutoMapping(this.getSourceColumnInfo(), this.table);
            }
            this.checkSourceDataAgainstTable(l2);
        }
        if (l2.i()) {
            String string = null;
            if (this.statementDropTableDone && this.statementCreateTableDone) {
                string = TableImportTarget.getText("ResultDropAndCreate", new Object[0]);
            } else if (this.statementClearedTableDone) {
                string = this.clearMessage;
            }
            if (string != null) {
                l2.c(string);
            }
        }
        return l2;
    }

    private void resolveTargetMappings(l l2) {
        if (this.table != null && this.getMappings() != null) {
            this.getMappings().b(this.table);
        }
    }

    private boolean is(com.onseven.dbvis.newdataimp.g.d d2) {
        return this.importContext.k().c(d2);
    }

    private boolean clearTableData(i i2, f f2, l l2) {
        String string = null;
        String string2 = null;
        if (f2.k().e(com.onseven.dbvis.newdataimp.g.d.jc)) {
            LOG.log(Level.FINE, "Using SQL from parameter ClearTableSQL for clear");
            string = f2.k().h(com.onseven.dbvis.newdataimp.g.d.jc);
            string2 = "ClearMsgCustom";
        } else {
            LOG.log(Level.FINE, "Using SQL from Generator for clear data");
            com.onseven.dbvis.newdataimp.g.g g2 = com.onseven.dbvis.newdataimp.g.g.b(f2.k());
            if (g2 == com.onseven.dbvis.newdataimp.g.g.b) {
                string = g.b(i2, this.table, true);
                string2 = "ClearMsgTruncate";
            } else if (g2 == com.onseven.dbvis.newdataimp.g.g.e) {
                string = g.d(i2, this.table, true);
                string2 = "ClearMsgDelete";
            } else if (g2 == com.onseven.dbvis.newdataimp.g.g.g) {
                if (g.b(i2)) {
                    string = g.b(i2, this.table, true);
                    string2 = "ClearMsgTruncate";
                } else {
                    LOG.log(Level.FINE, "Truncate not supported using Delete");
                    string = g.d(i2, this.table, true);
                    string2 = "ClearMsgDelete";
                }
            } else {
                l2.b(TableImportTarget.getText("BothDDLSpecified", new Object[0]), PARAM_FAULT);
                return false;
            }
        }
        if (string == null) {
            return false;
        }
        long l3 = 0L;
        if (!this.isDryRun) {
            l3 = j.b(this.table, i2, string, l2, "RunClearSQL");
            this.addUpdateRowsToStats(l3, f2);
        } else {
            LOG.log(Level.FINE, "Dry Run: SQL not executed: " + string);
            l2.b(TableImportTarget.getText("DryNoClear", new Object[0]));
        }
        this.statementClearedTableDone = l2.i();
        if (this.statementClearedTableDone) {
            String string3 = string2 = string2 != null ? string2 : "ResultClearOK";
            if (l3 > 0L) {
                string2 = string2 + "WithRows";
            }
            this.clearMessage = TableImportTarget.getText(string2, l3);
        }
        return this.statementClearedTableDone;
    }

    private boolean checkSourceDataAgainstTable(l l2) {
        n n2 = new n();
        if (this.getSourceColumnInfo() == null || this.getMappings() == null || this.table.getColumns() == null) {
            l2.b(n2);
            return false;
        }
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.getSourceColumnInfo().getInfoMap().entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            this.check(entry, n2);
        }
        l2.b(n2);
        return n2.b();
    }

    private void fail(n n2, String string, n._b._b _b2, String string2, String string3, Object ... objectArray) {
        Object[] objectArray2 = new Object[2 + objectArray.length];
        objectArray2[0] = string2;
        objectArray2[1] = string3;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        String string4 = TableImportTarget.getText(string, objectArray2);
        n2.b(string2, string3, string4, _b2);
    }

    private String getTargetColumnName(DataRecordColumnInfo dataRecordColumnInfo) {
        String string = this.getMappings().c(dataRecordColumnInfo.getIndex());
        if (string == null) {
            string = this.getMappings().b(dataRecordColumnInfo.getColumnName());
        }
        return string;
    }

    private boolean initTableColumnInfo(l l2, i i2) {
        try {
            this.table.clearColumns();
            boolean bl = j.c(i2, this.table);
            if (bl) {
                LOG.log(Level.FINE, "Initiated table information. Got " + this.table.getColumnCount() + " columns");
            }
            return bl;
        }
        catch (p p2) {
            l2.b(p2.getMessage(), p2.f(), p2);
            return false;
        }
    }

    private boolean dropAndCreateTable(i i2, f f2, l l2) {
        long l3;
        String string = this.getDropSql(i2, f2);
        if (!t.i(string)) {
            String string2 = TableImportTarget.getText("FailedGetDrop", this.table.getFullyQualifiedTableName());
            l2.b(string2, l._b.b);
            LOG.log(Level.FINE, string2 + " Catalog: " + this.table.getCatalog() + " Schema: " + this.table.getSchema());
            return false;
        }
        if (!this.isDryRun) {
            l3 = j.b(this.table, i2, string, l2, "RunDropSQL", com.onseven.dbvis.newdataimp.g.d.ub, f2.k());
            this.addUpdateRowsToStats(l3, f2);
        } else {
            LOG.log(Level.FINE, "Dry Run: Drop SQL not run: " + string);
        }
        if (l2.i() && !this.isDryRun) {
            this.statementDropTableDone = true;
            l3 = j.b(this.table, i2, this.ddl, l2, "RunDDL");
            this.addUpdateRowsToStats(l3, f2);
            this.statementCreateTableDone = l2.i();
        }
        if (this.isDryRun) {
            l2.b(TableImportTarget.getText("DryDropCreate", new Object[0]));
        }
        return l2.i();
    }

    private void addUpdateRowsToStats(long l2, f f2) {
        SqlStatistics sqlStatistics = f2.bb();
        if (sqlStatistics != null) {
            sqlStatistics.addUpdateCount(l2);
        }
    }

    private String getDropSql(i i2, f f2) {
        String string = null;
        if (f2.k().e(com.onseven.dbvis.newdataimp.g.d.fc)) {
            LOG.log(Level.FINE, "Using SQL from parameter DropTableSQL for drop");
            string = f2.k().h(com.onseven.dbvis.newdataimp.g.d.fc);
        } else {
            LOG.log(Level.FINE, "Using SQL from Generator for drop");
            string = g.c(i2, this.table, true);
        }
        return string;
    }

    private com.onseven.dbvis.newdataimp.g.f getCleanData(e e2) {
        com.onseven.dbvis.newdataimp.g.f f2 = com.onseven.dbvis.newdataimp.g.f.b(e2);
        if (f2 == com.onseven.dbvis.newdataimp.g.f.d) {
            f2 = com.onseven.dbvis.newdataimp.g.f.g;
        }
        return f2;
    }

    private boolean initDDL(f f2, com.onseven.dbvis.newdataimp.g.f f3, l l2) {
        e e2 = f2.k();
        if (f3 == com.onseven.dbvis.newdataimp.g.f.e) {
            if (!e2.h(com.onseven.dbvis.newdataimp.g.d.h) && !e2.h(com.onseven.dbvis.newdataimp.g.d.yb)) {
                l2.b(TableImportTarget.getText("DDLNotSpecified", new Object[0]), PARAM_FAULT);
                return false;
            }
            if (e2.h(com.onseven.dbvis.newdataimp.g.d.h) && e2.h(com.onseven.dbvis.newdataimp.g.d.yb)) {
                l2.b(TableImportTarget.getText("BothDDLSpecified", new Object[0]), PARAM_FAULT);
                return false;
            }
            return this.initDDLFromFileOrParam(f2, l2, e2);
        }
        return true;
    }

    private boolean initDDLFromFileOrParam(f f2, l l2, e e2) {
        boolean bl = true;
        if (e2.h(com.onseven.dbvis.newdataimp.g.d.h)) {
            String string = e2.h(com.onseven.dbvis.newdataimp.g.d.h);
            if (t.i(string)) {
                this.ddl = string;
            } else {
                l2.b(TableImportTarget.getText("EmptyDDL", this.table.getFullyQualifiedTableName()), PARAM_FAULT);
                bl = false;
            }
        } else if (e2.h(com.onseven.dbvis.newdataimp.g.d.yb)) {
            String string = e2.h(com.onseven.dbvis.newdataimp.g.d.yb);
            bl = this.getDdlFromFile(string, f2, l2);
        }
        return bl;
    }

    private b initColumnValidator(e e2, DataRecordColumnInfoSet dataRecordColumnInfoSet) {
        String string = e2.h(com.onseven.dbvis.newdataimp.g.d.vb);
        String string2 = e2.h(com.onseven.dbvis.newdataimp.g.d.i);
        String string3 = e2.h(com.onseven.dbvis.newdataimp.g.d.kb);
        b b2 = b.d(string2, string, string3);
        return b2;
    }

    private boolean getDdlFromFile(String string, f f2, l l2) {
        File file = f2.d(string);
        try {
            String string2 = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (!t.i(string2)) {
                l2.b(TableImportTarget.getText("EmptyDDL", this.table.getFullyQualifiedTableName()), PARAM_FAULT);
                return false;
            }
            this.ddl = string2;
        }
        catch (IOException iOException) {
            l2.b(TableImportTarget.getText("FailReadDDLFile", string, iOException), PARAM_FAULT);
            return false;
        }
        return true;
    }

    public void initDefaultColumnValidator() {
        this.setColumnValidator(this.initColumnValidator(this.importContext.k(), this.importContext.d().getAnalyzeColumnInfoSet()));
    }

    private void setColumnValidator(b b2) {
        this.columnValidator = b2;
    }

    public String toString() {
        return "TableImportTarget [table=" + this.table + ", statementDropTableDone=" + this.statementDropTableDone + ", statementCreateTableDone=" + this.statementCreateTableDone + ", statementClearedTableDone=" + this.statementClearedTableDone + "]";
    }

    private static String getText(String string, Object ... objectArray) {
        return com.onseven.dbvis.util.o.b.b(TableImportTarget.class, "TableImportTarget." + string, objectArray);
    }
}

