/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.newdataimp.analyze;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.onseven.dbvis.newdataimp.analyze.DataRecordColumnInfo;
import com.onseven.dbvis.newdataimp.analyze.b;
import com.onseven.dbvis.newdataimp.target.d;
import com.onseven.dbvis.util.t;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataRecordColumnInfoSet {
    private TreeMap<Integer, DataRecordColumnInfo> infoMap = new TreeMap();
    @JsonIgnore
    private int currentAutoIndex = 0;
    private static final String AUTO_COLUMN_PREFIX = System.getProperty("dbvis.import.autocolumn.prefix", "column");
    private static final int MAX_AUTO_INDEX = Integer.getInteger("dbvis.import.autocolumn.max", 5000);
    private static Logger LOG = Logger.getLogger(DataRecordColumnInfoSet.class.getName());

    public DataRecordColumnInfoSet() {
    }

    @JsonIgnore
    public long getSumBytesExcludingLobs() {
        long l2 = 0L;
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.infoMap.entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            DataRecordColumnInfo dataRecordColumnInfo = entry.getValue();
            b b2 = dataRecordColumnInfo.getJavaDataType();
            if (b2 == b.r || b2 == b.n) continue;
            l2 += dataRecordColumnInfo.getSizeOfDataAnalyzed();
        }
        return l2;
    }

    public DataRecordColumnInfoSet(DataRecordColumnInfoSet dataRecordColumnInfoSet) {
        this.currentAutoIndex = dataRecordColumnInfoSet.currentAutoIndex;
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = dataRecordColumnInfoSet.infoMap.entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            DataRecordColumnInfo dataRecordColumnInfo = entry.getValue();
            DataRecordColumnInfo dataRecordColumnInfo2 = null;
            if (dataRecordColumnInfo != null) {
                dataRecordColumnInfo2 = new DataRecordColumnInfo(dataRecordColumnInfo);
            }
            this.infoMap.put(entry.getKey(), dataRecordColumnInfo2);
        }
    }

    public DataRecordColumnInfoSet(Map<Integer, String> map) {
        if (map != null) {
            for (Map.Entry<Integer, String> entry : map.entrySet()) {
                DataRecordColumnInfo dataRecordColumnInfo = new DataRecordColumnInfo(entry.getKey(), entry.getValue());
                this.infoMap.put(entry.getKey(), dataRecordColumnInfo);
            }
        }
    }

    @JsonIgnore
    public boolean anyColumnHasName() {
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.infoMap.entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            DataRecordColumnInfo dataRecordColumnInfo = entry.getValue();
            if (dataRecordColumnInfo == null || !t.i(dataRecordColumnInfo.getColumnName())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public boolean containsBlobOrClobColumns() {
        Set<Map.Entry<Integer, DataRecordColumnInfo>> set = this.infoMap.entrySet();
        for (Map.Entry<Integer, DataRecordColumnInfo> entry : set) {
            DataRecordColumnInfo dataRecordColumnInfo = entry.getValue();
            if (dataRecordColumnInfo == null || dataRecordColumnInfo.getJavaDataType() != b.r && dataRecordColumnInfo.getJavaDataType() != b.n) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public int getNumOfColumns() {
        return this.infoMap.size();
    }

    @JsonIgnore
    public Collection<DataRecordColumnInfo> getAll() {
        return this.infoMap.values();
    }

    public DataRecordColumnInfo getOrCreateColInfo(int n2, String string) {
        DataRecordColumnInfo dataRecordColumnInfo = this.infoMap.get(n2);
        if (dataRecordColumnInfo != null) {
            return dataRecordColumnInfo;
        }
        if (t.i(string)) {
            dataRecordColumnInfo = new DataRecordColumnInfo(n2, string);
            dataRecordColumnInfo.setAutoNamed(false);
            this.infoMap.put(n2, dataRecordColumnInfo);
            return dataRecordColumnInfo;
        }
        int n3 = n2;
        String string2 = AUTO_COLUMN_PREFIX + n3;
        if (this.hasColInfoWithName(string2)) {
            for (int i2 = this.currentAutoIndex; i2 < MAX_AUTO_INDEX; ++i2) {
                String string3 = AUTO_COLUMN_PREFIX + i2;
                this.currentAutoIndex = i2 + 1;
                if (this.hasColInfoWithName(string3)) continue;
                n3 = i2;
                break;
            }
        }
        if (this.currentAutoIndex == MAX_AUTO_INDEX) {
            LOG.log(Level.WARNING, "We where not able to generate a unique column name");
        }
        String string4 = AUTO_COLUMN_PREFIX + n3;
        dataRecordColumnInfo = new DataRecordColumnInfo(n2, string4);
        dataRecordColumnInfo.setAutoNamed(true);
        this.infoMap.put(n2, dataRecordColumnInfo);
        return dataRecordColumnInfo;
    }

    public void overrideColumnTypesFromMappings(d d2) {
        List<d._b> list = d2.b();
        for (d._b _b2 : list) {
            if (_b2.i() == null || _b2.i() == b.o) continue;
            DataRecordColumnInfo dataRecordColumnInfo = this.getColInfo(_b2.c());
            b b2 = _b2.i();
            if (dataRecordColumnInfo == null) continue;
            b b3 = dataRecordColumnInfo.getJavaDataType();
            dataRecordColumnInfo.setJavaDataType(b2);
            if (b2 == b3) continue;
            LOG.log(Level.FINE, "Mapping changed type for column " + dataRecordColumnInfo.getIndex() + " from " + (Object)((Object)b3) + " to " + (Object)((Object)b2));
        }
    }

    public void add(int n2, DataRecordColumnInfo dataRecordColumnInfo) {
        this.infoMap.put(n2, dataRecordColumnInfo);
    }

    public DataRecordColumnInfo getColInfo(int n2) {
        return this.infoMap.get(n2);
    }

    private boolean hasColInfoWithName(String string) {
        return this.getColInfoWithName(string) != null;
    }

    public DataRecordColumnInfo getColInfoWithName(String string) {
        for (DataRecordColumnInfo dataRecordColumnInfo : this.infoMap.values()) {
            if (!string.equals(dataRecordColumnInfo.getColumnName())) continue;
            return dataRecordColumnInfo;
        }
        return null;
    }

    public TreeMap<Integer, DataRecordColumnInfo> getInfoMap() {
        return this.infoMap;
    }

    public void setInfoMap(TreeMap<Integer, DataRecordColumnInfo> treeMap) {
        this.infoMap = treeMap;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.getNumOfColumns() == 0;
    }

    public String toString() {
        int n2 = this.infoMap.size();
        StringBuilder stringBuilder = new StringBuilder("" + n2 + " infos ");
        if (n2 > 0) {
            stringBuilder.append("[").append("" + this.infoMap.firstEntry().getValue());
            if (n2 == 2) {
                stringBuilder.append(", ");
            } else if (n2 > 2) {
                stringBuilder.append(" ... ");
            }
            if (n2 != 1) {
                stringBuilder.append("" + this.infoMap.lastEntry().getValue());
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

