/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.jydocking;

import de.javasoft.swing.jydocking.DockingPath;
import de.javasoft.swing.jydocking.DockingState;
import de.javasoft.swing.jydocking.FloatingGroup;
import de.javasoft.swing.jydocking.IDockable;
import de.javasoft.swing.jydocking.ILayoutNode;
import de.javasoft.swing.jydocking.IPerspectiveManager;
import de.javasoft.swing.jydocking.Perspective;
import de.javasoft.swing.jydocking.PerspectiveManager;
import de.javasoft.swing.jydocking.PerspectiveModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class XMLPersister {
    private static final String PERSPECTIVES_ELEMENT_NAME = "Perspectives";
    private static final String PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID = "currentPerspectiveId";
    private static final String PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID = "defaultPerspectiveId";
    private static final String PERSPECTIVE_ELEMENT_NAME = "Perspective";
    private static final String PERSPECTIVE_ATTRIBUTE_ID = "id";
    private static final String PERSPECTIVE_ATTRIBUTE_NAME = "name";
    private static final String MODEL_ELEMENT_NAME = "Model";
    private static final String FLOATING_GROUP_ELEMENT_NAME = "FloatingGroup";
    private static final String FLOATING_GROUP_ATTRIBUTE_ID = "id";
    private static final String RECTANGLE_ELEMENT_NAME = "Rectangle";
    private static final String POINT_ELEMENT_NAME = "Point";
    private static final String POINT_ATTRIBUTE_X = "x";
    private static final String POINT_ATTRIBUTE_Y = "y";
    private static final String DIMENSION_ELEMENT_NAME = "Dimension";
    private static final String DIMENSION_ATTRIBUTE_WIDTH = "width";
    private static final String DIMENSION_ATTRIBUTE_HEIGHT = "height";
    private static final String DOCKING_STATE_ELEMENT_NAME = "DockingState";
    private static final String DOCKING_STATE_ATTRIBUTE_STATE = "state";
    private static final String DOCKING_STATE_ATTRIBUTE_SPLIT_RATIO = "splitRatio";
    private static final String DOCKING_STATE_ATTRIBUTE_PLACEMENT = "placement";
    private static final String DOCKING_STATE_ATTRIBUTE_DOCKABLE_ID = "dockableId";
    private static final String DOCKING_STATE_ATTRIBUTE_RELATIVE_PARENT_ID = "relativeParentId";
    private static final String DOCKING_STATE_ATTRIBUTE_REGION = "dockingRegion";
    private static final String DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID = "floatingGroupId";
    private static final String DOCKING_STATE_ATTRIBUTE_ACTIVE = "active";
    private static final String DOCKING_STATE_ATTRIBUTE_SELECTED = "selected";
    private static final String DOCKING_PATH_ELEMENT_NAME = "DockingPath";
    private static final String DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID = "rootPortId";
    private static final String DOCKING_PATH_ATTRIBUTE_SIBLING_ID = "siblingId";
    private static final String SPLIT_NODE_ELEMENT_NAME = "SplitNode";
    private static final String SPLIT_NODE_ATTRIBUTE_ORIENTATION = "orientation";
    private static final String SPLIT_NODE_ATTRIBUTE_REGION = "region";
    private static final String SPLIT_NODE_ATTRIBUTE_PERCENTAGE = "percentage";
    private static final String SPLIT_NODE_ATTRIBUTE_SIBLING_ID = "siblingId";
    private static final String SPLIT_NODE_ATTRIBUTE_DOCKING_REGION = "dockingRegion";
    private static final String DOCKABLE_SEQUENCE_ELEMENT_NAME = "DockableSequence";
    private static final String DOCKABLE_NODE_ELEMENT_NAME = "DockableNode";
    private static final String DOCKABLE_NODE_ATTRIBUTE_DOCKABLE_ID = "dockableId";
    private static final String DOCKING_PORT_NODE_ELEMENT_NAME = "DockingPortNode";
    private static final String DOCKABLE_ELEMENT_NAME = "Dockable";
    private static final String DOCKABLE_ATTRIBUTE_ID = "id";
    private static final String OPENED_STATE = "opened";
    private static final String MINIMIZED_STATE = "minimized";
    private static final String MAXIMIZED_STATE = "maximized";
    private static final String FLOATING_STATE = "floating";
    private static final String DEFAULT_DIRECTORY = String.valueOf(System.getProperty("user.home")) + "/.jydocking";
    private static final String DEFAULT_FILENAME = "perspectives.xml";
    private IPerspectiveManager pm;
    private String fileName;
    private InputStream inputStream;
    private OutputStream outputStream;

    public XMLPersister(String string, IPerspectiveManager iPerspectiveManager) {
        this.fileName = string;
        this.pm = iPerspectiveManager;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean store() throws IOException {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            File file = this.getPerspectiveFile(this.fileName);
            this.validatePerspectiveFile(file);
            outputStream = new FileOutputStream(file);
        }
        try {
            boolean bl = this.store(outputStream);
            return bl;
        }
        finally {
            outputStream.close();
        }
    }

    private boolean store(OutputStream outputStream) throws IOException {
        DocumentBuilder documentBuilder = this.createDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = this.serializePerspectives(document, this.pm);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(new OutputStreamWriter(outputStream));
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException("Unable to serialize perspectives to XML", transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Unable to serialize perspectives to XML", transformerException);
        }
        return true;
    }

    public boolean load() throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            File file = this.getPerspectiveFile(this.fileName);
            if (file == null || !file.exists()) {
                return false;
            }
            inputStream = new FileInputStream(file);
        }
        try {
            boolean bl = this.load(inputStream);
            return bl;
        }
        finally {
            inputStream.close();
        }
    }

    private boolean load(InputStream inputStream) throws IOException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            DocumentBuilder documentBuilder = this.createDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName(PERSPECTIVES_ELEMENT_NAME);
            if (nodeList.getLength() > 0 && nodeList.item(0) instanceof Element) {
                Element element = (Element)nodeList.item(0);
                this.deserializePerspectives(element);
            }
        }
        catch (SAXException sAXException) {
            throw new IOException("Unable to deserialize perspectives from XML", sAXException);
        }
        return true;
    }

    private void validatePerspectiveFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    private File getPerspectiveFile(String string) {
        if (string == null) {
            return new File(DEFAULT_FILENAME);
        }
        String string2 = string;
        if (string2.indexOf(47) == -1 && string2.indexOf(92) == -1) {
            string2 = String.valueOf(new File(DEFAULT_DIRECTORY).getAbsolutePath()) + "/" + string2;
        }
        return new File(string2);
    }

    private DocumentBuilder createDocumentBuilder() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Unable to create document builder", parserConfigurationException);
        }
    }

    private Element serializePerspectives(Document document, Object object) {
        Element element = document.createElement(PERSPECTIVES_ELEMENT_NAME);
        element.setAttribute(PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID, PerspectiveManager.getCurrentPerspectiveID());
        element.setAttribute(PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID, PerspectiveManager.getDefaultPerspectiveID());
        ArrayList<Perspective> arrayList = new ArrayList<Perspective>();
        for (Perspective perspective : this.pm.getPerspectives()) {
            arrayList.add((Perspective)perspective.clone());
        }
        for (Perspective perspective : arrayList) {
            Element element2 = this.serializePerspective(document, perspective);
            element.appendChild(element2);
        }
        return element;
    }

    private Object deserializePerspectives(Element element) {
        String string = element.getAttribute(PERSPECTIVES_ATTRIBUTE_CURRENT_PERSPECTIVE_ID);
        String string2 = element.getAttribute(PERSPECTIVES_ATTRIBUTE_DEFAULT_PERSPECTIVE_ID);
        NodeList nodeList = element.getElementsByTagName(PERSPECTIVE_ELEMENT_NAME);
        ArrayList<Perspective> arrayList = new ArrayList<Perspective>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                Perspective perspective = (Perspective)this.deserializePerspective(element2);
                arrayList.add(perspective);
            }
            ++n;
        }
        PerspectiveManager.setDefaultPerspectiveID(string2);
        PerspectiveManager.setCurrentPerspectiveID(string);
        PerspectiveManager.setPerspectives(arrayList.toArray(new Perspective[arrayList.size()]));
        return this.pm;
    }

    private Element serializePerspective(Document document, Object object) {
        Perspective perspective = (Perspective)object;
        Element element = document.createElement(PERSPECTIVE_ELEMENT_NAME);
        element.setAttribute("id", perspective.getID());
        element.setAttribute(PERSPECTIVE_ATTRIBUTE_NAME, perspective.getName());
        Element element2 = this.serializeModel(document, perspective.getModel());
        element.appendChild(element2);
        return element;
    }

    private Object deserializePerspective(Element element) {
        String string = element.getAttribute("id");
        String string2 = element.getAttribute(PERSPECTIVE_ATTRIBUTE_NAME);
        Perspective perspective = new Perspective(string, string2);
        NodeList nodeList = element.getElementsByTagName(MODEL_ELEMENT_NAME);
        if (nodeList.getLength() > 0 && nodeList.item(0) instanceof Element) {
            Element element2 = (Element)nodeList.item(0);
            PerspectiveModel perspectiveModel = (PerspectiveModel)this.deserializeModel(element2);
            perspective.setModel(perspectiveModel);
        }
        return perspective;
    }

    private Element serializeModel(Document document, Object object) {
        List<DockingState> list;
        Object object2;
        PerspectiveModel perspectiveModel = (PerspectiveModel)object;
        Element element = document.createElement(MODEL_ELEMENT_NAME);
        IDockable[] iDockableArray = perspectiveModel.getDockables();
        int n = 0;
        while (n < iDockableArray.length) {
            IDockable iDockable = iDockableArray[n];
            object2 = perspectiveModel.getDockingState(iDockable, false);
            list = this.serializeDockingState(document, object2);
            element.appendChild((Node)((Object)list));
            ++n;
        }
        String[] stringArray = perspectiveModel.getFloatingGroupIDs();
        int n2 = 0;
        while (n2 < stringArray.length) {
            object2 = stringArray[n2];
            list = perspectiveModel.getGroup((String)object2);
            Element element2 = this.serializeFloatingGroup(document, list);
            element.appendChild(element2);
            ++n2;
        }
        ILayoutNode iLayoutNode = perspectiveModel.getRestorationLayout();
        if (iLayoutNode != null) {
            object2 = this.serializeLayoutNode(document, iLayoutNode);
            element.appendChild((Node)object2);
        }
        object2 = document.createElement(DOCKABLE_SEQUENCE_ELEMENT_NAME);
        list = perspectiveModel.getDockableSequence();
        int n3 = 0;
        while (n3 < list.size()) {
            DockingState dockingState = list.get(n3);
            Element element3 = this.serializeDockingState(document, dockingState);
            object2.appendChild(element3);
            ++n3;
        }
        element.appendChild((Node)object2);
        return element;
    }

    private Object deserializeModel(Element element) {
        PerspectiveModel perspectiveModel = new PerspectiveModel();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Object object;
                Cloneable cloneable;
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getNodeName();
                if (string.equals(DOCKING_STATE_ELEMENT_NAME)) {
                    cloneable = (DockingState)this.deserializeDockingState(element2);
                    object = ((DockingState)cloneable).getDockableID();
                    perspectiveModel.setDockingState((String)object, (DockingState)cloneable);
                } else if (string.equals(FLOATING_GROUP_ELEMENT_NAME)) {
                    cloneable = (FloatingGroup)this.deserializeFloatingGroup(element2);
                    perspectiveModel.addFloatingGroup((FloatingGroup)cloneable);
                } else if (string.equals(DOCKING_PORT_NODE_ELEMENT_NAME)) {
                    cloneable = (ILayoutNode)this.deserializeLayoutNode(element2);
                    perspectiveModel.setRestorationLayout((ILayoutNode)cloneable);
                } else if (string.equals(DOCKABLE_SEQUENCE_ELEMENT_NAME)) {
                    cloneable = new ArrayList();
                    object = element2.getElementsByTagName(DOCKING_STATE_ELEMENT_NAME);
                    int n2 = 0;
                    while (n2 < object.getLength()) {
                        Node node = object.item(n2);
                        if (node instanceof Element) {
                            Element element3 = (Element)node;
                            DockingState dockingState = (DockingState)this.deserializeDockingState(element3);
                            cloneable.add(dockingState);
                        }
                        ++n2;
                    }
                    perspectiveModel.setDockableSequence((List<DockingState>)((Object)cloneable));
                }
            }
            ++n;
        }
        return perspectiveModel;
    }

    private Element serializeDockingState(Document document, Object object) {
        Object object2;
        DockingState dockingState = (DockingState)object;
        Element element = document.createElement(DOCKING_STATE_ELEMENT_NAME);
        element.setAttribute("dockableId", dockingState.getDockableID());
        if (dockingState.getRelativeParentID() != null && !dockingState.getRelativeParentID().equals("")) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_RELATIVE_PARENT_ID, dockingState.getRelativeParentID());
        }
        element.setAttribute("dockingRegion", dockingState.getRegion().toLowerCase());
        if (dockingState.getSplitRatio() != -1.0f) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_SPLIT_RATIO, String.valueOf(dockingState.getSplitRatio()));
        }
        if (dockingState.isMinimized()) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, MINIMIZED_STATE);
        } else if (dockingState.isMaximized()) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, MAXIMIZED_STATE);
        } else if (dockingState.isFloating()) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, FLOATING_STATE);
        } else {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_STATE, OPENED_STATE);
        }
        if (dockingState.isActive()) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_ACTIVE, "true");
        }
        if (dockingState.isSelected()) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_SELECTED, "true");
        }
        if (dockingState.isFloating()) {
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID, dockingState.getFloatingGroupID());
        } else if (dockingState.isMinimized()) {
            object2 = null;
            int n = dockingState.getPlacement();
            switch (n) {
                case 2: {
                    object2 = "left";
                    break;
                }
                case 3: {
                    object2 = "bottom";
                    break;
                }
                case 4: {
                    object2 = "right";
                    break;
                }
                case 1: {
                    object2 = "top";
                    break;
                }
                case -1: {
                    object2 = "unspecified";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown dockbar placement");
                }
            }
            element.setAttribute(DOCKING_STATE_ATTRIBUTE_PLACEMENT, (String)object2);
        }
        if (dockingState.hasCenterPoint()) {
            object2 = this.serializePoint(document, dockingState.getCenterPoint());
            element.appendChild((Node)object2);
        }
        if (dockingState.hasDockingPath()) {
            object2 = this.serializeDockingPath(document, dockingState.getPath());
            element.appendChild((Node)object2);
        }
        return element;
    }

    private Object deserializeDockingState(Element element) {
        NodeList nodeList;
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        String string4 = element.getAttribute("dockableId");
        String string5 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_RELATIVE_PARENT_ID);
        String string6 = element.getAttribute("dockingRegion");
        DockingState dockingState = new DockingState(string4);
        if (string5 != null && !string5.equals("")) {
            dockingState.setRelativeParentID(string5);
        }
        dockingState.setRegion(string6.toUpperCase());
        String string7 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_SPLIT_RATIO);
        if (string7 != null && !string7.equals("")) {
            float f = Float.parseFloat(string7);
            dockingState.setSplitRatio(f);
        }
        if ((string3 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_ACTIVE)) != null && !string3.equals("")) {
            boolean bl = Boolean.parseBoolean(string3);
            dockingState.setActive(bl);
        }
        if ((string2 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_SELECTED)) != null && !string2.equals("")) {
            boolean bl = Boolean.parseBoolean(string2);
            dockingState.setSelected(bl);
        }
        if ((string = element.getAttribute(DOCKING_STATE_ATTRIBUTE_STATE)).equals(FLOATING_STATE)) {
            object2 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_FLOATING_GROUP_ID);
            if (object2 != null && !((String)object2).equals("")) {
                dockingState.setFloatingGroupID((String)object2);
            }
        } else if (string.equals(MINIMIZED_STATE)) {
            object2 = element.getAttribute(DOCKING_STATE_ATTRIBUTE_PLACEMENT);
            int n = -1;
            if (((String)object2).equals("left")) {
                n = 2;
            } else if (((String)object2).equals("bottom")) {
                n = 3;
            } else if (((String)object2).equals("right")) {
                n = 4;
            } else if (((String)object2).equals("top")) {
                n = 1;
            } else {
                throw new RuntimeException("Minimization conversion error!");
            }
            dockingState.setPlacement(n);
        } else if (string.equals(MAXIMIZED_STATE)) {
            dockingState.setMaximized(true);
        }
        if ((object2 = element.getElementsByTagName(POINT_ELEMENT_NAME)).getLength() > 0 && object2.item(0) instanceof Element) {
            Element element2 = (Element)object2.item(0);
            object = (Point)this.deserializePoint(element2);
            dockingState.setCenter((Point)object);
        }
        if ((nodeList = element.getElementsByTagName(DOCKING_PATH_ELEMENT_NAME)).getLength() > 0 && nodeList.item(0) instanceof Element) {
            object = (Element)nodeList.item(0);
            DockingPath dockingPath = (DockingPath)this.deserializeDockingPath((Element)object);
            dockingState.setPath(dockingPath);
        }
        return dockingState;
    }

    private Element serializeFloatingGroup(Document document, Object object) {
        Object object2;
        FloatingGroup floatingGroup = (FloatingGroup)object;
        Element element = document.createElement(FLOATING_GROUP_ELEMENT_NAME);
        element.setAttribute("id", floatingGroup.getID());
        Element element2 = this.serializeRectangle(document, floatingGroup.getBounds());
        element.appendChild(element2);
        Object object3 = floatingGroup.getDockableIterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            Element element3 = document.createElement(DOCKABLE_ELEMENT_NAME);
            element3.setAttribute("id", (String)object2);
            element.appendChild(element3);
        }
        object3 = floatingGroup.getRestorationLayout();
        if (object3 != null) {
            object2 = this.serializeLayoutNode(document, object3);
            element.appendChild((Node)object2);
        }
        return element;
    }

    private Object deserializeFloatingGroup(Element element) {
        Object object;
        Object object2;
        String string = element.getAttribute("id");
        FloatingGroup floatingGroup = new FloatingGroup(string);
        NodeList nodeList = element.getElementsByTagName(RECTANGLE_ELEMENT_NAME);
        if (nodeList.getLength() > 0 && nodeList.item(0) instanceof Element && (object2 = nodeList.item(0)) instanceof Element) {
            Element element2 = (Element)object2;
            object = (Rectangle)this.deserializeRectangle(element2);
            floatingGroup.setBounds((Rectangle)object);
        }
        object2 = element.getElementsByTagName(DOCKABLE_ELEMENT_NAME);
        int n = 0;
        while (n < object2.getLength()) {
            object = object2.item(n);
            if (object instanceof Element) {
                Element element3 = (Element)object;
                String string2 = element3.getAttribute("id");
                floatingGroup.addDockable(string2);
            }
            ++n;
        }
        NodeList nodeList2 = element.getElementsByTagName(DOCKING_PORT_NODE_ELEMENT_NAME);
        if (nodeList2.getLength() > 0) {
            object = (ILayoutNode)this.deserializeLayoutNode((Element)nodeList2.item(0));
            floatingGroup.setRestorationLayout((ILayoutNode)object);
        }
        return floatingGroup;
    }

    private Element serializeLayoutNode(Document document, Object object) {
        if (object instanceof PerspectiveModel.DockingPortNode) {
            return this.serializeDockingPortNode(document, object);
        }
        if (object instanceof PerspectiveModel.SplitNode) {
            return this.serializeSplitNode(document, object);
        }
        if (object instanceof PerspectiveModel.DockableNode) {
            return this.serializeDockableNode(document, object);
        }
        throw new RuntimeException("Incorrect element: " + object);
    }

    private Object deserializeLayoutNode(Element element) {
        if (element.getTagName().equals(DOCKING_PORT_NODE_ELEMENT_NAME)) {
            return this.deserializeDockingPortNode(element);
        }
        if (element.getTagName().equals(SPLIT_NODE_ELEMENT_NAME)) {
            return this.deserializeSplitNode(element);
        }
        if (element.getTagName().equals(DOCKABLE_NODE_ELEMENT_NAME)) {
            return this.deserializeDockableNode(element);
        }
        throw new RuntimeException("Incorrect element: " + element);
    }

    private Element serializeDockingPortNode(Document document, Object object) {
        ILayoutNode iLayoutNode = (ILayoutNode)object;
        Element element = document.createElement(DOCKING_PORT_NODE_ELEMENT_NAME);
        int n = iLayoutNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)iLayoutNode.getChildAt(n2);
            Element element2 = this.serializeLayoutNode(document, mutableTreeNode);
            element.appendChild(element2);
            ++n2;
        }
        return element;
    }

    private Object deserializeDockingPortNode(Element element) {
        PerspectiveModel.DockingPortNode dockingPortNode = new PerspectiveModel.DockingPortNode();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                ILayoutNode iLayoutNode = (ILayoutNode)this.deserializeLayoutNode(element2);
                dockingPortNode.add(iLayoutNode);
            }
            ++n;
        }
        return dockingPortNode;
    }

    private Element serializeSplitNode(Document document, Object object) {
        PerspectiveModel.SplitNode splitNode = (PerspectiveModel.SplitNode)object;
        Element element = document.createElement(SPLIT_NODE_ELEMENT_NAME);
        int n = splitNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)splitNode.getChildAt(n2);
            Element element2 = this.serializeLayoutNode(document, mutableTreeNode);
            element.appendChild(element2);
            ++n2;
        }
        if (splitNode.getSiblingId() != null && !"".equals(splitNode.getSiblingId())) {
            element.setAttribute("siblingId", splitNode.getSiblingId());
        }
        element.setAttribute(SPLIT_NODE_ATTRIBUTE_ORIENTATION, splitNode.getOrientationDesc());
        element.setAttribute(SPLIT_NODE_ATTRIBUTE_REGION, splitNode.getRegionDesc());
        element.setAttribute(SPLIT_NODE_ATTRIBUTE_PERCENTAGE, String.valueOf(splitNode.getSplitRatio()));
        if (splitNode.getDockingRegion() != null) {
            element.setAttribute("dockingRegion", splitNode.getDockingRegion().toLowerCase());
        }
        return element;
    }

    private Object deserializeSplitNode(Element element) {
        Object object;
        Object object2;
        Object object3;
        PerspectiveModel.SplitNode splitNode = new PerspectiveModel.SplitNode(-1, -1, -1.0f, null);
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object3 = nodeList.item(n);
            if (object3 instanceof Element) {
                object2 = (Element)object3;
                object = (ILayoutNode)this.deserializeLayoutNode((Element)object2);
                splitNode.add((MutableTreeNode)object);
            }
            ++n;
        }
        String string = element.getAttribute("siblingId");
        object3 = element.getAttribute(SPLIT_NODE_ATTRIBUTE_ORIENTATION);
        object2 = element.getAttribute(SPLIT_NODE_ATTRIBUTE_REGION);
        object = element.getAttribute(SPLIT_NODE_ATTRIBUTE_PERCENTAGE);
        String string2 = element.getAttribute("dockingRegion");
        int n2 = -1;
        if (((String)object3).equals("vertical")) {
            n2 = 0;
        } else if (((String)object3).equals("horizontal")) {
            n2 = 1;
        }
        int n3 = -1;
        if (((String)object2).equals("top")) {
            n3 = 1;
        } else if (((String)object2).equals("bottom")) {
            n3 = 3;
        } else if (((String)object2).equals("left")) {
            n3 = 2;
        } else if (((String)object2).equals("right")) {
            n3 = 4;
        }
        splitNode.setOrientation(n2);
        splitNode.setRegion(n3);
        splitNode.setSplitRatio(Float.parseFloat((String)object));
        if (string != null && !"".equals(string)) {
            splitNode.setSiblingId(string);
        }
        if (string2 != null && !string2.equals("")) {
            splitNode.setDockingRegion(string2.toUpperCase());
        }
        return splitNode;
    }

    private Element serializeDockableNode(Document document, Object object) {
        PerspectiveModel.DockableNode dockableNode = (PerspectiveModel.DockableNode)object;
        Element element = document.createElement(DOCKABLE_NODE_ELEMENT_NAME);
        element.setAttribute("dockableId", dockableNode.getDockableID());
        return element;
    }

    private Object deserializeDockableNode(Element element) {
        String string = element.getAttribute("dockableId");
        PerspectiveModel.DockableNode dockableNode = new PerspectiveModel.DockableNode();
        dockableNode.setDockableID(string);
        return dockableNode;
    }

    private Element serializeDockingPath(Document document, Object object) {
        DockingPath dockingPath = (DockingPath)object;
        Element element = document.createElement(DOCKING_PATH_ELEMENT_NAME);
        element.setAttribute(DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID, dockingPath.getRootPortId());
        if (dockingPath.getSiblingID() != null && !dockingPath.getSiblingID().equals("")) {
            element.setAttribute("siblingId", dockingPath.getSiblingID());
        }
        List<PerspectiveModel.SplitNode> list = dockingPath.getNodes();
        for (PerspectiveModel.SplitNode splitNode : list) {
            Element element2 = this.serializeSplitNode(document, splitNode);
            element.appendChild(element2);
        }
        return element;
    }

    private Object deserializeDockingPath(Element element) {
        NodeList nodeList;
        DockingPath dockingPath = new DockingPath();
        String string = element.getAttribute(DOCKING_PATH_ATTRIBUTE_ROOT_PORT_ID);
        String string2 = element.getAttribute("siblingId");
        dockingPath.setRootPortId(string);
        if (string2 != null && !"".equals(string2)) {
            dockingPath.setSiblingId(string2);
        }
        if ((nodeList = element.getElementsByTagName(SPLIT_NODE_ELEMENT_NAME)).getLength() > 0 && nodeList.item(0) instanceof Element) {
            Element element2 = (Element)nodeList.item(0);
            PerspectiveModel.SplitNode splitNode = (PerspectiveModel.SplitNode)this.deserializeLayoutNode(element2);
            dockingPath.getNodes().add(splitNode);
        }
        return dockingPath;
    }

    private Element serializeRectangle(Document document, Object object) {
        Rectangle rectangle = (Rectangle)object;
        Element element = document.createElement(RECTANGLE_ELEMENT_NAME);
        Element element2 = this.serializePoint(document, rectangle.getLocation());
        Element element3 = this.serializeDimension(document, rectangle.getSize());
        element.appendChild(element2);
        element.appendChild(element3);
        return element;
    }

    private Object deserializeRectangle(Element element) {
        Object object;
        Object object2;
        Rectangle rectangle = new Rectangle();
        NodeList nodeList = element.getElementsByTagName(DIMENSION_ELEMENT_NAME);
        if (nodeList.getLength() > 0 && nodeList.item(0) instanceof Element) {
            object2 = (Element)nodeList.item(0);
            object = (Dimension)this.deserializeDimension((Element)object2);
            rectangle.setSize((Dimension)object);
        }
        if ((object2 = element.getElementsByTagName(POINT_ELEMENT_NAME)).getLength() > 0 && object2.item(0) instanceof Element) {
            object = (Element)object2.item(0);
            Point point = (Point)this.deserializePoint((Element)object);
            rectangle.setLocation(point);
        }
        return rectangle;
    }

    private Element serializeDimension(Document document, Object object) {
        Dimension dimension = (Dimension)object;
        Element element = document.createElement(DIMENSION_ELEMENT_NAME);
        element.setAttribute(DIMENSION_ATTRIBUTE_HEIGHT, String.valueOf(dimension.height));
        element.setAttribute(DIMENSION_ATTRIBUTE_WIDTH, String.valueOf(dimension.width));
        return element;
    }

    private Object deserializeDimension(Element element) {
        String string = element.getAttribute(DIMENSION_ATTRIBUTE_WIDTH);
        String string2 = element.getAttribute(DIMENSION_ATTRIBUTE_HEIGHT);
        return new Dimension(Integer.parseInt(string), Integer.parseInt(string2));
    }

    private Element serializePoint(Document document, Object object) {
        Point point = (Point)object;
        Element element = document.createElement(POINT_ELEMENT_NAME);
        element.setAttribute(POINT_ATTRIBUTE_X, String.valueOf(point.x));
        element.setAttribute(POINT_ATTRIBUTE_Y, String.valueOf(point.y));
        return element;
    }

    private Object deserializePoint(Element element) {
        String string = element.getAttribute(POINT_ATTRIBUTE_X);
        String string2 = element.getAttribute(POINT_ATTRIBUTE_Y);
        return new Point(Integer.parseInt(string), Integer.parseInt(string2));
    }
}

