/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIkscn
extends T4CTTIMsg {
    long kscnbas;
    int kscnwrp;

    T4CTTIkscn(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)0);
    }

    T4CTTIkscn(T4CConnection t4CConnection, byte by) {
        super(t4CConnection, by);
    }

    public void unmarshal() throws SQLException, IOException {
        this.kscnbas = this.meg.unmarshalUB4();
        this.kscnwrp = this.meg.unmarshalUB2();
    }

    public void marshal() throws SQLException, IOException {
        this.meg.marshalUB4(this.kscnbas);
        this.meg.marshalUB2(this.kscnwrp);
    }

    public long getSCN() {
        long l2 = this.kscnbas & 0xFFFFFFFFL | ((long)this.kscnwrp & 0xFFFFFFFFL) << 32;
        return l2;
    }

    public void setSCN(long l2) {
        this.kscnbas = l2 & 0xFFFFFFFFL;
        this.kscnwrp = (int)(l2 >> 32);
    }

    static boolean isLessThanUnsigned(long l2, long l3) {
        return l2 < l3 ^ l2 < 0L != l3 < 0L;
    }
}

