/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.alert;

import com.ejt.internal.CommonApplicationServices;
import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.Messages;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;

public class AlertOptionPane
extends JOptionPane {
    @Deprecated
    public static final String DONT_SHOW_AGAIN_MESSAGE = AlertOptionPane.getDontShowAgainMessage();
    private static boolean overrideDontShowAgain = false;
    private static boolean externalDontShowAgain = false;
    private static JCheckBox chkDontShowAgain;

    @Nls
    public static String getDontShowAgainMessage() {
        return Messages.getString(".AlertDontShowAgainLabel");
    }

    public static boolean isOverrideDontShowAgain() {
        return overrideDontShowAgain;
    }

    public static void setOverrideDontShowAgain(boolean overrideDontShowAgain) {
        AlertOptionPane.overrideDontShowAgain = overrideDontShowAgain;
    }

    public static boolean isExternalDontShowAgain() {
        return externalDontShowAgain;
    }

    public static void setExternalDontShowAgain(boolean externalDontShowAgain) {
        AlertOptionPane.externalDontShowAgain = externalDontShowAgain;
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        AlertOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon, false);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, boolean dontShowAgainOption) {
        AlertOptionPane.showOptionDialogWithSuppression(parentComponent, message, title, -1, messageType, icon, null, null, null, dontShowAgainOption);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, Object closedValue) {
        return AlertOptionPane.showOptionDialogWithSuppression(parentComponent, message, title, optionType, messageType, icon, options, initialValue, closedValue, false);
    }

    public static <E extends Enum<E>> E selectOption(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, E initialSelection, E closedSelection, boolean dontShowAgainOption) {
        Object[] options = (Enum[])initialSelection.getClass().getEnumConstants();
        int result = AlertOptionPane.showOptionDialogWithSuppression(parentComponent, message, title, optionType, messageType, icon, options, initialSelection, closedSelection, dontShowAgainOption);
        if (result == -1) {
            return closedSelection;
        }
        return (E)options[result];
    }

    public static int showOptionDialogWithSuppression(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, Object closedValue, boolean dontShowAgainOption) {
        int closedIndex;
        overrideDontShowAgain = false;
        Window parentWindow = AlertOptionPane.getOptionPaneParent(parentComponent);
        if (dontShowAgainOption) {
            message = new Object[]{message, AlertOptionPane.createDontShowAgainCheckbox()};
        }
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        JDialog dialog = pane.createDialog(parentWindow, title);
        dialog.setBackground(UIManager.getColor("control"));
        if (Util.isMacOS()) {
            ((JComponent)dialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 0));
        }
        dialog.pack();
        pane.selectInitialValue();
        dialog.setVisible(true);
        AlertOptionPane.disposeTempFrame(parentWindow);
        Object selectedValue = pane.getValue();
        int n = closedIndex = options != null ? Arrays.asList(options).indexOf(closedValue) : -1;
        if (selectedValue == null) {
            return closedIndex;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return closedIndex;
        }
        int optionsCount = options.length;
        for (int i = 0; i < optionsCount; ++i) {
            if (!options[i].equals(selectedValue)) continue;
            return i;
        }
        return closedIndex;
    }

    public static Window getOptionPaneParent(Component parentComponent) {
        Window parentWindow = null;
        if (parentComponent == null && Util.isWindows()) {
            parentWindow = new TempFrame();
        } else if (parentComponent instanceof Window) {
            parentWindow = (Window)parentComponent;
        } else if (parentComponent != null) {
            parentWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, parentComponent);
        }
        CommonApplicationServices applicationServices = CommonApplicationServices.getInstance();
        if (applicationServices != null) {
            applicationServices.beforeAlertOn(parentWindow);
        }
        return parentWindow;
    }

    public static void disposeTempFrame(Window parentWindow) {
        if (parentWindow instanceof TempFrame) {
            parentWindow.dispose();
        }
    }

    public static boolean isDontShowAgain() {
        if (overrideDontShowAgain) {
            return externalDontShowAgain;
        }
        return chkDontShowAgain != null && chkDontShowAgain.isSelected();
    }

    private static JCheckBox createDontShowAgainCheckbox() {
        chkDontShowAgain = new JCheckBox(AlertOptionPane.getDontShowAgainMessage());
        chkDontShowAgain.setFont(UIManager.getFont("OptionPane.font"));
        chkDontShowAgain.setSelected(false);
        chkDontShowAgain.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        return chkDontShowAgain;
    }

    public static void clearDontShowAgainCheckbox() {
        chkDontShowAgain = null;
    }

    public static interface ParentWindowHandler {
        public void handleParentWindow(Window var1);
    }

    public static class TempFrame
    extends JFrame {
        public TempFrame() {
            super(TempFrame.getApplicationName());
            this.setUndecorated(true);
            this.setVisible(true);
            this.setLocationRelativeTo(null);
            CommonApplicationServices applicationServices = CommonApplicationServices.getInstance();
            if (applicationServices != null) {
                this.setIconImages(applicationServices.getWindowImageIcons());
            }
        }

        private static String getApplicationName() {
            CommonApplicationServices applicationServices = CommonApplicationServices.getInstance();
            return applicationServices != null ? applicationServices.getApplicationName() : "";
        }
    }
}

