/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SortedList;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CellSpanTable
extends CellStyleTable {
    private static final String \u11bf = "CellSpanTableUI";
    private boolean \u11bb;
    private boolean \u11c0 = false;
    private boolean \u11b8 = false;
    private boolean \u11c2 = true;
    private boolean \u11c1 = true;
    public static final int AUTO_CELL_MERGE_OFF = 0;
    public static final int AUTO_CELL_MERGE_ROWS = 1;
    public static final int AUTO_CELL_MERGE_COLUMNS = 2;
    public static final int AUTO_CELL_MERGE_ROWS_LIMITED = 3;
    public static final int AUTO_CELL_MERGE_COLUMNS_LIMITED = 4;
    private int \u11be;
    public static final String PROPERTY_AUTO_CONVERT_CELL_SPAN = "autoConvertCellSpan";
    public static final String PROPERTY_PAINT_CELL_SPAN_AS_SELECTED = "paintCellSpanAsSelected";
    private List<CellSpan> \u11b9;
    private Set<A> \u11ba;
    private boolean \u11bc = true;
    private Boolean \u11bd = null;

    public CellSpanTable() {
        this.\u028e();
    }

    public CellSpanTable(int n2, int n3) {
        super(n2, n3);
        this.\u028e();
    }

    public CellSpanTable(TableModel tableModel) {
        super(tableModel);
        this.\u028e();
    }

    public CellSpanTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.\u028e();
    }

    public CellSpanTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.\u028e();
    }

    public CellSpanTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.\u028e();
    }

    public CellSpanTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.\u028e();
    }

    private void \u028e() {
        if (!this.\u11bb) {
            this.muteDefaultKeyStroke();
            this.\u11bb = true;
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        super.columnAdded(tableColumnModelEvent);
        if (this.getAutoCellMerge() != 0) {
            this.invalidateCellSpanCache();
        }
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnRemoved(tableColumnModelEvent);
        if (this.getAutoCellMerge() != 0) {
            this.invalidateCellSpanCache();
        }
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        super.columnMoved(tableColumnModelEvent);
        if (this.getAutoCellMerge() != 0) {
            this.invalidateCellSpanCache();
        }
    }

    @Override
    public String getActualUIClassID() {
        return \u11bf;
    }

    public TableModel getSpanModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof SpanModel) {
            return tableModel;
        }
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, SpanModel.class);
        if (tableModel2 != null) {
            return tableModel2;
        }
        return tableModel;
    }

    public CellSpan getCellSpanAt(SpanModel spanModel, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            return null;
        }
        return spanModel.getCellSpanAt(TableModelWrapperUtils.getActualRowAt(this.getModel(), n2, (TableModel)((Object)spanModel)), TableModelWrapperUtils.getActualColumnAt(this.getModel(), n3, (TableModel)((Object)spanModel)));
    }

    public CellSpan convertModelCellSpanToView(CellSpan cellSpan) {
        if (cellSpan == null) {
            return cellSpan;
        }
        TableModel tableModel = this.getSpanModel();
        if (!(tableModel instanceof SpanModel)) {
            return cellSpan;
        }
        int n2 = cellSpan.getRow();
        int n3 = cellSpan.getRow() + cellSpan.getRowSpan() - 1;
        int n4 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n2);
        int n5 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n3);
        while (n4 < 0 && ++n2 <= n3) {
            n4 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n2);
        }
        while (n5 < 0 && n2 <= --n3) {
            n5 = TableModelWrapperUtils.getRowAt(this.getModel(), tableModel, n3);
        }
        if (n4 < 0 || n5 < 0 || n4 > n5) {
            return null;
        }
        int n6 = n5 - n4 + 1;
        if (this.getModel().getColumnCount() == this.getColumnCount()) {
            if (cellSpan.getColumnSpan() == tableModel.getColumnCount()) {
                return n4 != cellSpan.getRow() || n6 != cellSpan.getRowSpan() ? new CellSpan(n4, cellSpan.getColumn(), n6, cellSpan.getColumnSpan()) : cellSpan;
            }
            return new CellSpan(n4, this.convertColumnIndexToView(cellSpan.getColumn()), n6, cellSpan.getColumnSpan());
        }
        if (cellSpan.getColumnSpan() == tableModel.getColumnCount()) {
            return new CellSpan(n4, cellSpan.getColumn(), cellSpan.getRowSpan(), this.getColumnCount());
        }
        int n7 = cellSpan.getColumn();
        int n8 = this.convertColumnIndexToView(n7);
        int n9 = cellSpan.getColumnSpan();
        for (int i2 = 0; i2 < cellSpan.getColumnSpan(); ++i2) {
            int n10 = this.convertColumnIndexToView(cellSpan.getColumn() + i2);
            if (n10 == -1) {
                --n9;
            }
            if (n8 != -1) continue;
            n8 = n10;
        }
        if (n9 == this.getColumnCount()) {
            n8 = 0;
        }
        if (n8 == -1 || n9 == 0) {
            return n4 != cellSpan.getRow() || n6 != cellSpan.getRowSpan() ? new CellSpan(n4, cellSpan.getColumn(), n6, cellSpan.getColumnSpan()) : cellSpan;
        }
        return new CellSpan(n4, n8, n6, n9);
    }

    public CellSpan convertViewCellSpanToModel(CellSpan cellSpan) {
        if (cellSpan == null) {
            return null;
        }
        int n2 = cellSpan.getColumn();
        int n3 = this.convertColumnIndexToModel(n2);
        int n4 = this.convertColumnIndexToModel(cellSpan.getColumn() + cellSpan.getColumnSpan() - 1);
        return new CellSpan(cellSpan.getRow(), n3, cellSpan.getRowSpan(), n4 - n2 + 1);
    }

    public boolean isAutoConvertCellSpan() {
        return this.\u11c2;
    }

    public void setAutoConvertCellSpan(boolean bl) {
        boolean bl2 = this.\u11c2;
        if (bl2 != bl) {
            this.\u11c2 = bl;
            this.firePropertyChange(PROPERTY_AUTO_CONVERT_CELL_SPAN, bl2, bl);
        }
    }

    public boolean isPaintCellSpanAsSelected() {
        return this.\u11c1;
    }

    public void setPaintCellSpanAsSelected(boolean bl) {
        boolean bl2 = this.\u11c1;
        if (bl2 != bl) {
            this.\u11c1 = bl;
            this.firePropertyChange(PROPERTY_PAINT_CELL_SPAN_AS_SELECTED, bl2, bl);
        }
    }

    public boolean isKeepColumnAtPoint() {
        return this.\u11b8;
    }

    public void setKeepColumnAtPoint(boolean bl) {
        this.\u11b8 = bl;
    }

    public boolean isKeepRowAtPoint() {
        return this.\u11c0;
    }

    public void setKeepRowAtPoint(boolean bl) {
        this.\u11c0 = bl;
    }

    public Rectangle originalGetCellRect(int n2, int n3, boolean bl) {
        return super.getCellRect(n2, n3, bl);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        if (this.getRowCount() == 0) {
            if (1 == n2) {
                int n4 = this.getRowHeight();
                return n4 > 0 ? Math.max(n4, rectangle.height / n4 * n4) : rectangle.height;
            }
            return rectangle.width;
        }
        if (!this.isVariousRowHeights() && 1 == n2) {
            int n5 = this.rowAtPoint(rectangle.getLocation());
            assert (n5 != -1);
            int n6 = this.columnAtPoint(rectangle.getLocation());
            Rectangle rectangle2 = this.originalGetCellRect(n5, n6, true);
            if (rectangle2.y == rectangle.y) {
                int n7 = this.getRowHeight();
                assert (n7 > 0);
                return Math.max(n7, rectangle.height / n7 * n7);
            }
        }
        if (n3 < 0) {
            return this.\u0103(rectangle, n2);
        }
        return this.\u0101(rectangle, n2);
    }

    private int \u0104(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y) : new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        return this.rowAtPoint(point);
    }

    private int \u0102(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y) : new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        return this.columnAtPoint(point);
    }

    private int \u0103(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x, rectangle.y + rectangle.height - 1) : new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        return this.rowAtPoint(point);
    }

    private int \u0101(Rectangle rectangle) {
        Point point = this.getComponentOrientation().isLeftToRight() ? new Point(rectangle.x + rectangle.width - 1, rectangle.y) : new Point(rectangle.x, rectangle.y);
        return this.columnAtPoint(point);
    }

    private int \u0102(Rectangle rectangle, int n2) {
        if (n2 == 1) {
            return rectangle.y;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            return rectangle.x;
        }
        return rectangle.x + rectangle.width;
    }

    private int \u0104(Rectangle rectangle, int n2) {
        if (n2 == 1) {
            return rectangle.y + rectangle.height;
        }
        if (this.getComponentOrientation().isLeftToRight()) {
            return rectangle.x + rectangle.width;
        }
        return rectangle.x;
    }

    private int \u0101(Rectangle rectangle, int n2) {
        boolean bl;
        int n3 = this.\u0103(rectangle);
        int n4 = this.\u0101(rectangle);
        int n5 = this.\u0102(rectangle, n2);
        if (n2 == 1 && n3 < 0) {
            return rectangle.height;
        }
        if (n2 == 0 && n4 < 0) {
            return rectangle.width;
        }
        Rectangle rectangle2 = this.originalGetCellRect(n3, n4, true);
        int n6 = this.\u0102(rectangle2, n2);
        int n7 = this.\u0104(rectangle2, n2);
        if (n2 == 1 || this.getComponentOrientation().isLeftToRight()) {
            bl = n6 <= n5;
        } else {
            boolean bl2 = bl = n6 >= n5;
        }
        int n8 = bl ? n7 : (n7 == this.\u0104(rectangle, n2) ? n7 : n6);
        return Math.abs(n8 - n5);
    }

    private int \u0103(Rectangle rectangle, int n2) {
        int n3;
        Point point;
        int n4;
        int n5 = this.\u0102(rectangle, n2);
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (n2 == 1) {
            n4 = n5 - rectangle.height;
            int n6 = rectangle.x + (bl ? 0 : rectangle.width);
            point = new Point(n6, n4);
        } else if (bl) {
            n4 = n5 - rectangle.width;
            point = new Point(n4, rectangle.y);
        } else {
            n4 = n5 + rectangle.width;
            point = new Point(n4 - 1, rectangle.y);
        }
        int n7 = this.rowAtPoint(point);
        int n8 = this.columnAtPoint(point);
        if (n2 == 1 & n7 < 0) {
            n3 = 0;
        } else if (n2 == 0 & n8 < 0) {
            n3 = bl ? 0 : this.getWidth();
        } else {
            Rectangle rectangle2 = this.originalGetCellRect(n7, n8, true);
            int n9 = this.\u0102(rectangle2, n2);
            int n10 = this.\u0104(rectangle2, n2);
            n3 = (n2 == 1 || bl) && n10 >= n5 ? n9 : (n2 == 0 && !bl && n10 <= n5 ? n9 : (n4 == n9 ? n9 : n10));
        }
        return Math.abs(n5 - n3);
    }

    @Override
    public Rectangle getCellRect(int n2, int n3, boolean bl) {
        if (n2 < 0 || n3 < 0 || this.getRowCount() <= n2 || this.getColumnCount() <= n3) {
            return super.getCellRect(n2, n3, bl);
        }
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan == null || this.\u1193) {
            return super.getCellRect(n2, n3, bl);
        }
        cellSpan = (CellSpan)cellSpan.clone();
        Rectangle rectangle = super.getCellRect(cellSpan.getRow(), cellSpan.getColumn(), bl);
        for (int i2 = Math.min(cellSpan.getRowSpan() - 1, this.getRowCount() - cellSpan.getRow() - 1); i2 >= 0; --i2) {
            for (int i3 = Math.min(cellSpan.getColumnSpan() - 1, this.getColumnCount() - cellSpan.getColumn() - 1); i3 >= 0; --i3) {
                Rectangle rectangle2 = super.getCellRect(cellSpan.getRow() + i2, cellSpan.getColumn() + i3, bl);
                if (rectangle2.getWidth() == 0.0 && rectangle2.getHeight() == 0.0) continue;
                if (rectangle2.getWidth() == 0.0 && rectangle2.x > rectangle.x) {
                    --rectangle2.x;
                }
                if (rectangle2.getHeight() == 0.0 && rectangle2.y > rectangle.y) {
                    --rectangle2.y;
                }
                rectangle = rectangle.union(rectangle2);
                return rectangle;
            }
        }
        return rectangle;
    }

    public int originalRowAtPoint(Point point) {
        return super.rowAtPoint(point);
    }

    public int originalColumnAtPoint(Point point) {
        return super.columnAtPoint(point);
    }

    @Override
    public int rowAtPoint(Point point) {
        if (!this.isKeepRowAtPoint() && this.isCellSpanOn() && !this.\u1193) {
            int n2;
            int n3 = super.rowAtPoint(point);
            CellSpan cellSpan = this.getCellSpanAt(n3, n2 = super.columnAtPoint(point));
            if (cellSpan != null) {
                return cellSpan.getRow();
            }
            return n3;
        }
        return super.rowAtPoint(point);
    }

    @Override
    public int columnAtPoint(Point point) {
        if (!this.isKeepColumnAtPoint() && this.isCellSpanOn()) {
            int n2;
            int n3 = super.rowAtPoint(point);
            CellSpan cellSpan = this.getCellSpanAt(n3, n2 = super.columnAtPoint(point));
            if (cellSpan != null) {
                return cellSpan.getColumn();
            }
            return n2;
        }
        return super.columnAtPoint(point);
    }

    @Override
    public boolean rolloverCellAt(int n2, int n3) {
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan != null) {
            return super.rolloverCellAt(cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.rolloverCellAt(n2, n3);
    }

    @Override
    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan != null) {
            return super.editCellAt(cellSpan.getRow(), cellSpan.getColumn(), eventObject);
        }
        return super.editCellAt(n2, n3, eventObject);
    }

    @Override
    protected boolean shouldCellBePaintedAsFocused(int n2, int n3) {
        CellSpan cellSpan;
        CellSpan cellSpan2;
        if (!this.isPaintCellSpanAsSelected() && !this.isNonContiguousCellSelection() && !this.getCellSelectionEnabled() && (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() ? (cellSpan2 = this.getCellSpanAt(n2, n3)) != null && cellSpan2.getRowSpan() > 1 && cellSpan2.getColumnSpan() < this.getColumnCount() : this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed() && (cellSpan = this.getCellSpanAt(n2, n3)) != null && cellSpan.getColumnSpan() > 1 && cellSpan.getRowSpan() < this.getRowCount())) {
            return false;
        }
        return super.shouldCellBePaintedAsFocused(n2, n3);
    }

    @Override
    protected boolean shouldCellBePaintedAsSelected(int n2, int n3) {
        CellSpan cellSpan;
        CellSpan cellSpan2;
        if (!this.isPaintCellSpanAsSelected() && !this.isNonContiguousCellSelection() && !this.getCellSelectionEnabled() && (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() ? (cellSpan2 = this.getCellSpanAt(n2, n3)) != null && cellSpan2.getRowSpan() > 1 && cellSpan2.getColumnSpan() < this.getColumnCount() : this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed() && (cellSpan = this.getCellSpanAt(n2, n3)) != null && cellSpan.getColumnSpan() > 1 && cellSpan.getRowSpan() < this.getRowCount())) {
            return false;
        }
        return super.shouldCellBePaintedAsSelected(n2, n3);
    }

    @Override
    public boolean isCellSelected(int n2, int n3) {
        CellSpan cellSpan;
        if (this.isNonContiguousCellSelection()) {
            CellSpan cellSpan2 = this.getCellSpanAt(n2, n3);
            if (cellSpan2 != null) {
                for (int i2 = cellSpan2.getRow(); i2 < cellSpan2.getRow() + cellSpan2.getRowSpan(); ++i2) {
                    for (int i3 = cellSpan2.getColumn(); i3 < cellSpan2.getColumn() + cellSpan2.getColumnSpan(); ++i3) {
                        if (!super.isCellSelected(i2, i3)) continue;
                        return true;
                    }
                }
                return false;
            }
        } else if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() || !this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
            CellSpan cellSpan3 = this.getCellSpanAt(n2, n3);
            if (cellSpan3 != null) {
                if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                    for (int i4 = cellSpan3.getRow(); i4 < cellSpan3.getRow() + cellSpan3.getRowSpan(); ++i4) {
                        if (!this.isRowSelected(i4)) continue;
                        return true;
                    }
                } else if (!this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
                    for (int i5 = cellSpan3.getColumn(); i5 < cellSpan3.getColumn() + cellSpan3.getColumnSpan(); ++i5) {
                        if (!this.isColumnSelected(i5)) continue;
                        return true;
                    }
                }
            }
        } else if (this.getRowSelectionAllowed() && this.getColumnSelectionAllowed() && (cellSpan = this.getCellSpanAt(n2, n3)) != null) {
            int n4;
            boolean bl = false;
            for (n4 = cellSpan.getRow(); n4 < cellSpan.getRow() + cellSpan.getRowSpan(); ++n4) {
                if (!this.isRowSelected(n4)) continue;
                bl = true;
                break;
            }
            n4 = 0;
            for (int i6 = cellSpan.getColumn(); i6 < cellSpan.getColumn() + cellSpan.getColumnSpan(); ++i6) {
                if (!this.isColumnSelected(i6)) continue;
                n4 = 1;
                break;
            }
            if (bl && n4 != 0) {
                return true;
            }
        }
        return super.isCellSelected(n2, n3);
    }

    @Override
    public TableCellEditor getCellEditor(int n2, int n3) {
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan != null) {
            return super.getCellEditor(cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.getCellEditor(n2, n3);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan != null) {
            return super.getCellRenderer(cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.getCellRenderer(n2, n3);
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n2, int n3) {
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan != null) {
            return super.prepareEditor(tableCellEditor, cellSpan.getRow(), cellSpan.getColumn());
        }
        return super.prepareEditor(tableCellEditor, n2, n3);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        TableScrollPane tableScrollPane = (TableScrollPane)this.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane != null && tableScrollPane.getRowHeaderTable() != this && tableScrollPane.getRowHeaderTable() instanceof GroupTable && tableScrollPane.getRowHeaderTable().getColumnCount() > 0 && DefaultGroupRow.class.isAssignableFrom(this.getCellClassAt(n2, n3))) {
            return null;
        }
        return super.getValueAt(n2, n3);
    }

    @Override
    protected boolean isCellFocused(int n2, int n3) {
        CellSpan cellSpan = this.getCellSpanAt(n2, n3);
        if (cellSpan != null) {
            int n4 = -1;
            int n5 = -1;
            if (this.isNonContiguousCellSelection()) {
                if (this.getTableSelectionModel() != null && !this.isTablePrinting()) {
                    n4 = this.getTableSelectionModel().getLeadRowIndex();
                    n5 = this.getTableSelectionModel().getLeadColumnIndex();
                }
            } else if (!SystemInfo.isJdk6Above() || !this.isPaintingForPrint()) {
                n4 = this.getSelectionModel().getLeadSelectionIndex();
                n5 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            }
            boolean bl = false;
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component != null && (component == this || component == this.\u1183)) {
                bl = true;
            }
            return cellSpan.contains(n4, n5) && bl;
        }
        return super.isCellFocused(n2, n3);
    }

    @Override
    protected Rectangle getDirtyRegion(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = super.getDirtyRegion(n2, n3, n4, n5);
        if (!this.isCellSpanOn()) {
            return rectangle;
        }
        if (!this.isCellSpanCacheEnabled() || n4 - n2 >= 10) {
            return new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        int n6 = n3;
        int n7 = n2 + 1;
        while (n7 <= n4 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n7, n3);
            if (cellSpan == null) {
                ++n7;
                continue;
            }
            n7 = Math.max(n7 + 1, cellSpan.getRow() + cellSpan.getRowSpan());
            n6 = Math.min(cellSpan.getColumn(), n6);
        }
        n7 = n5;
        int n8 = n2 + 1;
        while (n8 <= n4 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n8, n5);
            if (cellSpan == null) {
                ++n8;
                continue;
            }
            n8 = Math.max(n8 + 1, cellSpan.getRow() + cellSpan.getRowSpan());
            n7 = Math.max(cellSpan.getColumn() + cellSpan.getColumnSpan() - 1, n7);
        }
        n8 = n2;
        int n9 = n3 + 1;
        while (n9 <= n5 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n2, n9);
            if (cellSpan == null) {
                ++n9;
                continue;
            }
            n9 = Math.max(n9 + 1, cellSpan.getColumn() + cellSpan.getColumnSpan());
            n8 = Math.min(cellSpan.getRow(), n8);
        }
        n9 = n4;
        int n10 = n3 + 1;
        while (n10 <= n5 - 1) {
            CellSpan cellSpan = this.getCellSpanAt(n4, n10);
            if (cellSpan == null) {
                ++n10;
                continue;
            }
            n10 = Math.max(n10 + 1, cellSpan.getColumn() + cellSpan.getColumnSpan());
            n9 = Math.max(cellSpan.getRow() + cellSpan.getRowSpan() - 1, n9);
        }
        if (n7 != n5 || n6 != n3 || n8 != n2 || n9 != n4) {
            rectangle = super.getDirtyRegion(n8, n6, n9, n7);
        }
        return rectangle;
    }

    public boolean isCellSpanOn() {
        if (this.getAutoCellMerge() != 0) {
            return true;
        }
        if (this.isCellSpanCacheEnabled() && this.\u11bd != null) {
            return this.\u11bd;
        }
        TableModel tableModel = this.getSpanModel();
        this.\u11bd = tableModel instanceof SpanModel && ((SpanModel)((Object)tableModel)).isCellSpanOn();
        return this.\u11bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellSpan getCellSpanAt(int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 >= this.getRowCount() || n3 >= this.getColumnCount()) {
            return null;
        }
        if (!this.isCellSpanOn()) {
            return null;
        }
        int n4 = n3;
        if (this.isAutoConvertCellSpan() && n3 < this.getColumnModel().getColumnCount()) {
            n4 = this.convertColumnIndexToModel(n3);
        }
        boolean bl = this.getAutoCellMerge() != 0;
        List<CellSpan> list = this.getCache();
        Set<A> set = this.getCacheEmpty();
        if (this.\u11b9 == null) {
            this.\u11b9 = this.createCellSpanCache();
        }
        List<CellSpan> list2 = this.\u11b9;
        synchronized (list2) {
            CellSpan cellSpan;
            if (this.isCellSpanCacheEnabled()) {
                if (set.size() > 0 && set.contains(new A(n2, bl ? n3 : n4))) {
                    return null;
                }
                if (list.size() > 0 && (cellSpan = this.binarySearch(list, n2, bl ? n3 : n4)) != null) {
                    if (!bl && this.isAutoConvertCellSpan()) {
                        return this.convertModelCellSpanToView(cellSpan);
                    }
                    return cellSpan;
                }
            }
            cellSpan = null;
            if (bl) {
                cellSpan = this.getCellSpanFromAutoCellMerge(n2, n3);
            }
            if (cellSpan == null) {
                cellSpan = this.getCellSpanFromSpanModel(n2, n3);
            }
            if (this.isCellSpanCacheEnabled()) {
                if (cellSpan != null && (cellSpan.getRowSpan() > 1 || cellSpan.getColumnSpan() > 1)) {
                    list.add((CellSpan)cellSpan.clone());
                } else {
                    set.add(new A(n2, bl ? n3 : n4));
                }
            }
            CellSpan cellSpan2 = bl || !this.isAutoConvertCellSpan() ? cellSpan : (cellSpan != null ? this.convertModelCellSpanToView(cellSpan) : null);
            return cellSpan2;
        }
    }

    protected List<CellSpan> createCellSpanCache() {
        return new SortedList<CellSpan>(new ArrayList(), new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof CellSpan) || !(object2 instanceof CellSpan)) {
                    return 0;
                }
                CellSpan cellSpan = (CellSpan)object;
                CellSpan cellSpan2 = (CellSpan)object2;
                if (cellSpan.getRow() < cellSpan2.getRow()) {
                    return -1;
                }
                if (cellSpan.getRow() > cellSpan2.getRow()) {
                    return 1;
                }
                if (cellSpan.getColumn() < cellSpan2.getColumn()) {
                    return -1;
                }
                if (cellSpan.getColumn() > cellSpan2.getColumn()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected CellSpan binarySearch(List<CellSpan> list, int n2, int n3) {
        int n4 = 0;
        int n5 = list.size();
        int n6 = n5 / 2;
        while (n4 < n5) {
            CellSpan cellSpan = list.get(n6);
            if (cellSpan.contains(n2, n3)) {
                return cellSpan;
            }
            if (n2 > cellSpan.getRow() || n2 == cellSpan.getRow() && n3 > cellSpan.getColumn()) {
                n4 = n6 + 1;
            } else {
                n5 = n6;
            }
            n6 = n4 + (n5 - n4) / 2;
        }
        return null;
    }

    protected CellSpan getCellSpanFromAutoCellMerge(int n2, int n3) {
        if (this.getAutoCellMerge() == 1) {
            int n4;
            Object object = this.getValueAt(n2, n3);
            int n5 = n2;
            for (n4 = n2; n4 > 0 && JideSwingUtilities.equals(object, this.getValueAt(n4 - 1, n3)); --n4) {
            }
            while (n5 < this.getRowCount() - 1 && JideSwingUtilities.equals(object, this.getValueAt(n5 + 1, n3))) {
                ++n5;
            }
            if (n4 != n5) {
                return new CellSpan(n4, n3, n5 - n4 + 1, 1);
            }
            return null;
        }
        if (this.getAutoCellMerge() == 3) {
            int n6;
            Object object;
            int n7 = 0;
            int n8 = this.getRowCount() - 1;
            if (n3 > 0) {
                object = this.getCellSpanAt(n2, n3 - 1);
                if (object != null) {
                    n7 = ((CellSpan)object).getRow();
                    n8 = ((CellSpan)object).getRow() + ((CellSpan)object).getRowSpan() - 1;
                } else {
                    n7 = n2;
                    n8 = n2;
                }
            }
            object = this.getValueAt(n2, n3);
            int n9 = n2;
            for (n6 = n2; n6 > n7 && JideSwingUtilities.equals(object, this.getValueAt(n6 - 1, n3)); --n6) {
            }
            while (n9 < n8 && JideSwingUtilities.equals(object, this.getValueAt(n9 + 1, n3))) {
                ++n9;
            }
            if (n6 != n9) {
                return new CellSpan(n6, n3, n9 - n6 + 1, 1);
            }
            return null;
        }
        if (this.getAutoCellMerge() == 2) {
            int n10;
            Object object = this.getValueAt(n2, n3);
            int n11 = n3;
            for (n10 = n3; n10 > 0 && JideSwingUtilities.equals(object, this.getValueAt(n2, n10 - 1)); --n10) {
            }
            while (n11 < this.getColumnCount() - 1 && JideSwingUtilities.equals(object, this.getValueAt(n2, n11 + 1))) {
                ++n11;
            }
            if (n10 != n11) {
                return new CellSpan(n2, n10, 1, n11 - n10 + 1);
            }
            return null;
        }
        if (this.getAutoCellMerge() == 4) {
            int n12;
            Object object;
            int n13 = 0;
            int n14 = this.getColumnCount() - 1;
            if (n2 > 0) {
                object = this.getCellSpanAt(n2 - 1, n3);
                if (object != null) {
                    n13 = ((CellSpan)object).getColumn();
                    n14 = ((CellSpan)object).getColumn() + ((CellSpan)object).getColumnSpan() - 1;
                } else {
                    n13 = n3;
                    n14 = n3;
                }
            }
            object = this.getValueAt(n2, n3);
            int n15 = n3;
            for (n12 = n3; n12 > n13 && JideSwingUtilities.equals(object, this.getValueAt(n2, n12 - 1)); --n12) {
            }
            while (n15 < n14 && JideSwingUtilities.equals(object, this.getValueAt(n2, n15 + 1))) {
                ++n15;
            }
            if (n12 != n15) {
                return new CellSpan(n2, n12, 1, n15 - n12 + 1);
            }
            return null;
        }
        return null;
    }

    protected CellSpan getCellSpanFromSpanModel(int n2, int n3) {
        return this.isCellSpanOn() ? this.getCellSpanAt((SpanModel)((Object)this.getSpanModel()), n2, this.convertColumnIndexToModel(n3)) : null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n2;
        if (!this.isCellSpanOn()) {
            super.valueChanged(listSelectionEvent);
            return;
        }
        if (this.isRowAutoResizes()) {
            this.repaint();
            return;
        }
        int n3 = listSelectionEvent.getFirstIndex();
        int n4 = listSelectionEvent.getLastIndex();
        if (n3 == -1 && n4 == -1) {
            this.repaint();
        }
        Rectangle rectangle = this.getCellRect(n3, 0, false);
        int n5 = this.getColumnCount();
        int n6 = n3;
        for (n2 = 0; n2 < n5; ++n2) {
            rectangle.add(this.getCellRect(n6, n2, false));
        }
        n6 = n4;
        for (n2 = 0; n2 < n5; ++n2) {
            rectangle.add(this.getCellRect(n6, n2, false));
        }
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.invalidateCellSpanCache();
        super.tableChanged(tableModelEvent);
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 || tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1) {
            this.\u11bd = null;
        }
        this.invalidateCellSpanCache();
    }

    public void invalidateCellSpanCache() {
        if (this.\u11b9 != null) {
            this.\u11b9.clear();
        }
        if (this.\u11ba != null) {
            this.\u11ba.clear();
        }
    }

    protected void muteDefaultKeyStroke() {
        this.replaceAction(KeyStroke.getKeyStroke(9, 0));
        this.replaceAction(KeyStroke.getKeyStroke(9, 1));
        this.replaceAction(KeyStroke.getKeyStroke(37, 0));
        this.replaceAction(KeyStroke.getKeyStroke(37, 1));
        this.replaceAction(KeyStroke.getKeyStroke(39, 0));
        this.replaceAction(KeyStroke.getKeyStroke(39, 1));
        this.replaceAction(KeyStroke.getKeyStroke(38, 0));
        this.replaceAction(KeyStroke.getKeyStroke(38, 1));
        this.replaceAction(KeyStroke.getKeyStroke(40, 0));
        this.replaceAction(KeyStroke.getKeyStroke(40, 1));
    }

    protected Action createDelegateAction(Action action, KeyStroke keyStroke) {
        return new DelegateAction(action, keyStroke);
    }

    public boolean isCellSpanCacheEnabled() {
        return this.\u11bc;
    }

    public void setCellSpanCacheEnabled(boolean bl) {
        this.\u11bc = bl;
        if (!this.\u11bc) {
            this.invalidateCellSpanCache();
        }
    }

    protected void replaceAction(KeyStroke keyStroke) {
        this.replaceAction(keyStroke, 1);
    }

    protected void replaceAction(KeyStroke keyStroke, int n2) {
        Object object = this.getInputMap(n2).get(keyStroke);
        if (object != null) {
            Action action = this.getActionMap().get(object);
            this.getActionMap().put(object, this.createDelegateAction(action, keyStroke));
        } else {
            this.registerKeyboardAction(this.createDelegateAction(null, keyStroke), keyStroke, n2);
        }
    }

    protected void restoreAction(KeyStroke keyStroke) {
        this.restoreAction(keyStroke, 1);
    }

    protected void restoreAction(KeyStroke keyStroke, int n2) {
        ActionListener actionListener = this.getActionForKeyStroke(keyStroke);
        if (actionListener instanceof DelegateAction) {
            this.registerKeyboardAction(((DelegateAction)actionListener).getDefaultAction(), keyStroke, n2);
        }
    }

    public void calculateRowHeights() {
        int n2 = this.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.calculateRowHeight(i2, false);
        }
    }

    public void calculateRowHeight(int n2, boolean bl) {
        if (n2 < 0 || n2 > this.getRowCount() - 1) {
            return;
        }
        int n3 = this.getColumnCount();
        if (bl) {
            int n4;
            int n5 = n2;
            int n6 = n5 + 1;
            if (this.isCellSpanOn()) {
                for (n4 = 0; n4 < n3; ++n4) {
                    CellSpan cellSpan = this.getCellSpanAt(n2, n4);
                    if (cellSpan == null) continue;
                    n5 = Math.min(n5, cellSpan.getRow());
                    n6 = Math.max(n6, cellSpan.getRow() + cellSpan.getRowSpan());
                }
            }
            for (n4 = n5; n4 < n6; ++n4) {
                this.calculateRowHeight(n4, false);
            }
        } else {
            int n7 = this.calculateRowHeight(n2);
            if (n7 != this.getRowHeight(n2)) {
                this.setRowHeight(n2, n7);
            }
        }
    }

    @Override
    protected int calculateRowHeight(int n2) {
        if (n2 < 0 || n2 > this.getRowCount() - 1) {
            return -1;
        }
        int n3 = this.getColumnCount();
        int n4 = 0;
        HashMap hashMap = new HashMap();
        int n5 = 0;
        while (n5 < n3) {
            CellSpan cellSpan = this.getCellSpanAt(n2, n5);
            if (cellSpan != null && cellSpan.getRowSpan() > 1) {
                int n6 = cellSpan.getRow();
                int n7 = cellSpan.getRowSpan();
                Integer n8 = this.\u0118(n6, cellSpan.getColumn());
                n8 = (int)Math.ceil((n8 + n7 - 1) / n7);
                n4 = Math.max(n4, n8);
            } else {
                n4 = Math.max(n4, super.\u0118(n2, n5));
            }
            if (cellSpan == null) {
                ++n5;
                continue;
            }
            n5 = cellSpan.getColumn() + cellSpan.getColumnSpan();
        }
        if (this.getIntercellSpacing() != null) {
            n4 += this.getIntercellSpacing().height;
        }
        return n4;
    }

    public static boolean verifyCellSpan(SpanModel spanModel) {
        try {
            if (spanModel instanceof TableModel) {
                CellSpan cellSpan;
                int n2;
                int n3;
                TableModel tableModel = (TableModel)((Object)spanModel);
                CellSpan[][] cellSpanArray = new CellSpan[tableModel.getRowCount()][tableModel.getColumnCount()];
                int[][] nArray = new int[tableModel.getRowCount()][tableModel.getColumnCount()];
                for (n3 = 0; n3 < tableModel.getColumnCount(); ++n3) {
                    for (n2 = 0; n2 < tableModel.getRowCount(); ++n2) {
                        cellSpan = spanModel.getCellSpanAt(n2, n3);
                        cellSpanArray[n2][n3] = cellSpan == null ? new CellSpan(n2, n3, 1, 1) : (CellSpan)cellSpan.clone();
                    }
                }
                for (n3 = 0; n3 < tableModel.getRowCount(); ++n3) {
                    for (n2 = 0; n2 < tableModel.getColumnCount(); ++n2) {
                        cellSpan = cellSpanArray[n3][n2];
                        if (cellSpan == null) continue;
                        if (nArray[n3][n2] == 0) {
                            nArray[n3][n2] = 1;
                        }
                        for (int i2 = 0; i2 < cellSpan.getRowSpan(); ++i2) {
                            for (int i3 = 0; i3 < cellSpan.getColumnSpan(); ++i3) {
                                int n4 = cellSpan.getRow();
                                int n5 = cellSpan.getColumn();
                                String string = "(" + n4 + ", " + n5 + ")";
                                try {
                                    CellSpan cellSpan2 = cellSpanArray[n4 + i2][n5 + i3];
                                    String string2 = "(" + (n4 + i2) + ", " + (n5 + i3) + ")";
                                    if (cellSpan.equals(cellSpan2) || cellSpan2 == null) {
                                        if (nArray[n4 + i2][n5 + i3] != 0) continue;
                                        nArray[n4 + i2][n5 + i3] = 1;
                                        continue;
                                    }
                                    if (nArray[n4 + i2][n5 + i3] == 0) {
                                        nArray[n4 + i2][n5 + i3] = -1;
                                    }
                                    System.out.println("Cell at " + string2 + " has a different cell span from that of the anchor cell " + string);
                                    System.out.println("\t" + string + "-> " + cellSpan);
                                    System.out.println("\t" + string2 + "-> " + cellSpan2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getClass().getName() + " " + exception.getLocalizedMessage());
                                    System.out.println("\tcell span is " + cellSpan + ", cell is (" + n3 + "," + n2 + ") wrong cell is (" + (n3 + i2) + "," + (n2 + i3) + ")");
                                }
                            }
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean verifyCellSpan(CellSpanTable cellSpanTable) {
        try {
            if (cellSpanTable instanceof CellSpanTable) {
                CellSpan cellSpan;
                int n2;
                int n3;
                CellSpan[][] cellSpanArray = new CellSpan[cellSpanTable.getRowCount()][cellSpanTable.getColumnCount()];
                int[][] nArray = new int[cellSpanTable.getRowCount()][cellSpanTable.getColumnCount()];
                for (n3 = 0; n3 < cellSpanTable.getColumnCount(); ++n3) {
                    for (n2 = 0; n2 < cellSpanTable.getRowCount(); ++n2) {
                        cellSpan = cellSpanTable.getCellSpanAt(n2, n3);
                        cellSpanArray[n2][n3] = cellSpan == null ? new CellSpan(n2, n3, 1, 1) : (CellSpan)cellSpan.clone();
                    }
                }
                for (n3 = 0; n3 < cellSpanTable.getRowCount(); ++n3) {
                    for (n2 = 0; n2 < cellSpanTable.getColumnCount(); ++n2) {
                        cellSpan = cellSpanArray[n3][n2];
                        if (cellSpan == null) continue;
                        if (nArray[n3][n2] == 0) {
                            nArray[n3][n2] = 1;
                        }
                        for (int i2 = 0; i2 < cellSpan.getRowSpan(); ++i2) {
                            for (int i3 = 0; i3 < cellSpan.getColumnSpan(); ++i3) {
                                int n4 = cellSpan.getRow();
                                int n5 = cellSpan.getColumn();
                                String string = "(" + n4 + ", " + n5 + ")";
                                try {
                                    CellSpan cellSpan2 = cellSpanArray[n4 + i2][n5 + i3];
                                    String string2 = "(" + (n4 + i2) + ", " + (n5 + i3) + ")";
                                    if (cellSpan.equals(cellSpan2) || cellSpan2 == null) {
                                        if (nArray[n4 + i2][n5 + i3] != 0) continue;
                                        nArray[n4 + i2][n5 + i3] = 1;
                                        continue;
                                    }
                                    if (nArray[n4 + i2][n5 + i3] == 0) {
                                        nArray[n4 + i2][n5 + i3] = -1;
                                    }
                                    System.out.println("Cell at " + string2 + " has a different cell span from that of the anchor cell " + string);
                                    System.out.println("\t" + string + "-> " + cellSpan);
                                    System.out.println("\t" + string2 + "-> " + cellSpan2);
                                    continue;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception.getClass().getName() + " " + exception.getLocalizedMessage());
                                    System.out.println("\tcell span is " + cellSpan + ", cell is (" + n3 + "," + n2 + ") wrong cell is (" + (n3 + i2) + "," + (n2 + i3) + ")");
                                }
                            }
                        }
                    }
                }
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 1) {
            int n4 = this.originalRowAtPoint(rectangle.getLocation());
            return n4 < 0 || n4 >= this.getRowCount() ? this.getRowHeight() : this.getActualRowHeight(n4);
        }
        return super.getScrollableUnitIncrement(rectangle, n2, n3);
    }

    public int getActualRowHeight(int n2) {
        return this.getRowHeight(n2);
    }

    protected List<CellSpan> getCache() {
        if (this.\u11b9 == null) {
            this.\u11b9 = this.createCellSpanCache();
        }
        return this.\u11b9;
    }

    protected Set<A> getCacheEmpty() {
        if (this.\u11ba == null) {
            this.\u11ba = Collections.synchronizedSet(new HashSet());
        }
        return this.\u11ba;
    }

    public int getAutoCellMerge() {
        return this.\u11be;
    }

    public void setAutoCellMerge(int n2) {
        this.\u11be = n2;
        this.invalidateCellSpanCache();
        this.repaint();
    }

    private static class A {
        int \u0101;
        int \u0102;

        private A(int n2, int n3) {
            this.\u0101 = n2;
            this.\u0102 = n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            A a2 = (A)object;
            return this.\u0101 == a2.\u0101 && this.\u0102 == a2.\u0102;
        }

        public int hashCode() {
            int n2 = this.\u0101;
            n2 = 31 * n2 + this.\u0102;
            return n2;
        }
    }

    protected static class DelegateAction
    extends AbstractAction {
        protected KeyStroke _keyStroke;
        protected Action _defaultAction;
        private static final long \u0101 = -3494274276033219168L;

        public DelegateAction(Action action, KeyStroke keyStroke) {
            this._defaultAction = action;
            this._keyStroke = keyStroke;
        }

        public Action getDefaultAction() {
            return this._defaultAction;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            int n3;
            CellSpan cellSpan;
            CellSpanTable cellSpanTable = (CellSpanTable)actionEvent.getSource();
            if (cellSpanTable.isCellSpanOn() && (cellSpan = cellSpanTable.getCellSpanAt(n3 = cellSpanTable.getSelectionModel().getLeadSelectionIndex(), n2 = cellSpanTable.getColumnModel().getSelectionModel().getLeadSelectionIndex())) != null && cellSpan.contains(n3, n2)) {
                int n4 = this._keyStroke.getModifiers();
                switch (this._keyStroke.getKeyCode()) {
                    case 9: {
                        if (cellSpan.getColumnSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        if ((n4 & 1) != 0) {
                            this.\u0102(cellSpanTable, cellSpan, n3);
                        } else {
                            this.\u0101(cellSpanTable, cellSpan, n3);
                        }
                        return;
                    }
                    case 39: {
                        if (cellSpan.getColumnSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.\u0102(cellSpanTable, cellSpan, n3, (n4 & 1) != 0);
                        return;
                    }
                    case 37: {
                        if (cellSpan.getColumnSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.\u0101(cellSpanTable, cellSpan, n3, (n4 & 1) != 0);
                        return;
                    }
                    case 40: {
                        if (cellSpan.getRowSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.\u0103(cellSpanTable, cellSpan, n2, (n4 & 1) != 0);
                        return;
                    }
                    case 38: {
                        if (cellSpan.getRowSpan() <= 1) break;
                        if (cellSpanTable.isEditing() && !cellSpanTable.getCellEditor().stopCellEditing()) {
                            return;
                        }
                        this.\u0104(cellSpanTable, cellSpan, n2, (n4 & 1) != 0);
                        return;
                    }
                }
            }
            if (this._defaultAction != null) {
                this._defaultAction.actionPerformed(actionEvent);
            }
        }

        private void \u0104(CellSpanTable cellSpanTable, CellSpan cellSpan, int n2, boolean bl) {
            int n3 = cellSpan.getRow() - 1;
            CellSpan cellSpan2 = cellSpanTable.getCellSpanAt(n3, n2);
            if (cellSpan2 != null && cellSpan2.getRowSpan() > 1) {
                n3 = cellSpan2.getRow();
            }
            cellSpanTable.changeSelection(n3, n2, false, bl);
        }

        private void \u0103(CellSpanTable cellSpanTable, CellSpan cellSpan, int n2, boolean bl) {
            int n3 = cellSpan.getRow() + cellSpan.getRowSpan();
            if (n3 >= cellSpanTable.getRowCount()) {
                n3 = cellSpanTable.getRowCount() - 1;
            }
            cellSpanTable.changeSelection(n3, n2, false, bl);
        }

        private void \u0101(CellSpanTable cellSpanTable, CellSpan cellSpan, int n2, boolean bl) {
            int n3 = cellSpan.getColumn() - 1;
            CellSpan cellSpan2 = cellSpanTable.getCellSpanAt(n2, n3);
            if (cellSpan2 != null && cellSpan2.getColumnSpan() > 1) {
                n3 = cellSpan2.getColumn();
            }
            cellSpanTable.changeSelection(n2, n3, false, bl);
        }

        private void \u0102(CellSpanTable cellSpanTable, CellSpan cellSpan, int n2, boolean bl) {
            int n3 = cellSpan.getColumn() + cellSpan.getColumnSpan();
            if (n3 >= cellSpanTable.getColumnCount()) {
                n3 = cellSpanTable.getColumnCount() - 1;
            }
            cellSpanTable.changeSelection(n2, n3, false, bl);
        }

        private void \u0102(CellSpanTable cellSpanTable, CellSpan cellSpan, int n2) {
            int n3 = cellSpan.getColumn() - 1;
            if (n3 < 0) {
                n3 = cellSpanTable.getColumnCount() - 1;
                if (--n2 < 0) {
                    n2 = cellSpanTable.getRowCount() - 1;
                }
            }
            cellSpanTable.changeSelection(n2, n3, false, false);
        }

        private void \u0101(CellSpanTable cellSpanTable, CellSpan cellSpan, int n2) {
            int n3 = cellSpan.getColumn() + cellSpan.getColumnSpan();
            if (n3 >= cellSpanTable.getColumnCount()) {
                n3 = 0;
                if (++n2 >= cellSpanTable.getRowCount()) {
                    n2 = 0;
                }
            }
            cellSpanTable.changeSelection(n2, n3, false, false);
        }
    }
}

