/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.net.HttpUploadMethod;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import com.install4j.runtime.installer.helper.content.TransferFileHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;

public class Uploader
extends TransferFileHandler {
    private HttpUploadMethod uploadMethod = HttpUploadMethod.POST;

    public Uploader(Context context, ProgressInterface progressInterface) {
        super(context, progressInterface);
    }

    public Uploader(int mode, ProgressInterface progressInterface) {
        super(mode, progressInterface);
    }

    public void setUploadMethod(HttpUploadMethod uploadMethod) {
        this.uploadMethod = uploadMethod;
    }

    public int upload(String urlString, final File file) throws IOException, UserCanceledException {
        this.setFileSize(file.length());
        this.connect(urlString, new HttpRequestHandler.ConnectionPreparer(){

            @Override
            public void prepare(URLConnection urlConnection) throws IOException {
                HttpURLConnection connection = (HttpURLConnection)urlConnection;
                connection.setRequestMethod(Uploader.this.uploadMethod.getMethodName());
                connection.setRequestProperty("Content-Type", "application/octet-stream");
                connection.setRequestProperty("Accept", "application/octet-stream");
                connection.setRequestProperty("User-Agent", "Transport");
                connection.setRequestProperty("Cache-Control", "no-cache");
                connection.setRequestProperty("Content-Length", String.valueOf(Uploader.this.getFileSize()));
                connection.setDoOutput(true);
                OutputStream out = connection.getOutputStream();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
                FileUtil.pumpStream(in, out, new FileUtil.CopyProgressListener(){

                    @Override
                    public boolean progressPerformed(long val) {
                        Uploader.this.addProgress(val);
                        if (Uploader.this.isCancelled()) {
                            return false;
                        }
                        Uploader.this.updateProgress(false);
                        return true;
                    }
                });
                out.close();
            }
        });
        return ((HttpURLConnection)this.getConnection()).getResponseCode();
    }
}

