/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.BuildVersion;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcConnectionInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.Help;
import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.DB2Wrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class DataVersion {
    private static final Tool tool_ = Tool.DATA_VERSION;

    public static void main(String[] stringArray) {
        Configuration.printProductNameAndCopyrightInformation(null);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = null;
        String string2 = "com.ibm.db2.jcc.DB2Driver";
        String string3 = null;
        String string4 = null;
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = null;
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            string5 = stringArray[i10];
            if (Help.ARGS.isHelpRequest(string5)) {
                bl2 = true;
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.CONFIGURATION.externalOptionName())) {
                bl4 = true;
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.VERSION.externalOptionName())) {
                bl3 = true;
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.FEATURES.externalOptionName())) {
                bl5 = true;
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.VALIDATE.externalOptionName())) {
                bl6 = true;
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.URL.externalOptionName())) {
                if (stringArray.length <= i10 + 1) continue;
                string = stringArray[++i10];
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.DRIVER_NAME.externalOptionName())) {
                if (stringArray.length <= i10 + 1) continue;
                string2 = stringArray[++i10];
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.USERNAME.externalOptionName())) {
                if (stringArray.length <= i10 + 1) continue;
                string3 = stringArray[++i10];
                continue;
            }
            if (string5.equalsIgnoreCase(DataVersionPossibleArgs.PASSWORD.externalOptionName())) {
                if (stringArray.length <= i10 + 1) continue;
                string4 = stringArray[++i10];
                continue;
            }
            if (0 != stringBuilder.length()) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(Messages.getText("ERR_OPTION_NOT_RECOGNIZED", string5));
        }
        if (stringArray.length == 0 || bl2) {
            Help.displayHelp(tool_, null);
        } else {
            if (0 != stringBuilder.length()) {
                System.out.println();
                System.out.println(stringBuilder.toString() + '\n');
            }
            if (bl3) {
                // empty if block
            }
            if (bl5) {
                DataVersion.writeFeatureActivationInfo(new PrintWriter(System.out, true));
            }
            if (bl6) {
                DataVersion.writeValidationStatus(new PrintWriter(System.out, true));
            }
            if (bl4) {
                DataVersion.writeProductConfiguration(new PrintWriter(System.out, true));
                if (string != null) {
                    DataVersion.testConnection(string, string3, string4, string2);
                }
            }
        }
    }

    private static void testConnection(String string, String string2, String string3, String string4) {
        try {
            String string5 = DataVersion.getConfiguration(string, string2, string3, string4);
            System.out.println(string5);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfiguration(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        if (string == null) {
            throw new SQLException(Messages.getText("ERR_DATA_VERSION_URL_REQUIRED", new Object[0]));
        }
        if (string4 == null) {
            string4 = "com.ibm.db2.jcc.DB2Driver";
        }
        Class.forName(string4);
        Properties properties = new Properties();
        if (string2 != null && string2.length() > 0) {
            properties.put("user", string2);
        }
        if (string3 != null && string3.length() > 0) {
            properties.put("password", string3);
        }
        Connection connection = DriverManager.getConnection(string, properties);
        try {
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            connection.rollback();
            String string5 = DataVersion.getConfiguration(connection);
            return string5;
        }
        finally {
            connection.close();
        }
    }

    public static String getConfiguration(Connection connection) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_CONNECTION_INFO", new Object[0]));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_JDBC_URL", StaticProfileConstants.maskJdbcURLPasswords(databaseMetaData.getURL())));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DATABASE_PRODUCT_NAME", databaseMetaData.getDatabaseProductName()));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DATABASE_PRODUCT_VERSION", databaseMetaData.getDatabaseProductVersion()));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DATABASE_MAJOR_VERSION", String.valueOf(databaseMetaData.getDatabaseMajorVersion())));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DATABASE_MINOR_VERSION", String.valueOf(databaseMetaData.getDatabaseMinorVersion())));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_USERNAME", databaseMetaData.getUserName()));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DRIVER_NAME", databaseMetaData.getDriverName()));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DRIVER_VERSION", databaseMetaData.getDriverVersion()));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DRIVER_MAJOR_VERSION", databaseMetaData.getDriverMajorVersion()));
        stringBuilder.append("\n");
        stringBuilder.append(Messages.getText("MSG_DRIVER_MINOR_VERSION", databaseMetaData.getDriverMinorVersion()));
        stringBuilder.append("\n");
        if (Configuration.isJCCPresent__) {
            try {
                connection = DataVersion.unwrapConnectionIfWrapped(connection, stringBuilder);
                DataVersion.dumpJccDetails(connection, stringBuilder);
                DataVersion.dumpCmxDetails(connection, stringBuilder);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    private static void dumpJccDetails(Connection connection, StringBuilder stringBuilder) throws SQLException {
        if (connection instanceof DB2Connection) {
            DB2Connection dB2Connection = (DB2Connection)connection;
            stringBuilder.append(Messages.getText("MSG_CLIENT_USER", dB2Connection.getDB2ClientUser()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_CLIENT_WORKSTATION", dB2Connection.getDB2ClientWorkstation()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_CLIENT_APPLICATION_INFORMATION", dB2Connection.getDB2ClientApplicationInformation()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_CLIENT_ACCOUNTING_INFORMATION", dB2Connection.getDB2ClientAccountingInformation()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_CLIENT_PROGRAM_ID", dB2Connection.getDB2ClientProgramId()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_CURRENT_PACKAGE_SET", dB2Connection.getDB2CurrentPackageSet()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_CURRENT_PACKAGE_PATH", dB2Connection.getDB2CurrentPackagePath()));
            stringBuilder.append("\n");
            stringBuilder.append(Messages.getText("MSG_IS_DB2_GATEWAY_CONNECTION", dB2Connection.isDB2GatewayConnection()));
            stringBuilder.append("\n");
            DataVersion.dumpCentralStoreDetails(connection, stringBuilder);
        }
    }

    private static void dumpCmxDetails(Connection connection, StringBuilder stringBuilder) throws SQLException {
        stringBuilder.append("\n");
        if (connection instanceof Proxy) {
            Proxy proxy = (Proxy)((Object)connection);
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(proxy);
            if (invocationHandler instanceof ProxiedJdbcConnectionInvocationHandler) {
                ProxiedJdbcConnectionInvocationHandler proxiedJdbcConnectionInvocationHandler = (ProxiedJdbcConnectionInvocationHandler)invocationHandler;
                stringBuilder.append("Controller connection:\n");
                proxiedJdbcConnectionInvocationHandler.getControllerInfo(stringBuilder);
                stringBuilder.append("Monitor connection:\n");
                proxiedJdbcConnectionInvocationHandler.getMonitorInfo(stringBuilder);
                stringBuilder.append("Resolved monitor properties:\n");
                proxiedJdbcConnectionInvocationHandler.getMonitorProperties(stringBuilder);
                stringBuilder.append("\n");
            } else {
                stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN", new Object[0])).append("\n\n");
                stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN_REASON_PROXY_WRONG", new Object[0])).append("\n\n");
            }
        } else {
            stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN", new Object[0])).append("\n\n");
            stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN_REASON_NOPOXY", new Object[0])).append("\n\n");
        }
    }

    private static void dumpCentralStoreDetails(Connection connection, StringBuilder stringBuilder) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        stringBuilder.append("\n");
        Properties properties = null;
        if (connection instanceof Proxy) {
            object3 = (Proxy)((Object)connection);
            object2 = Proxy.getInvocationHandler(object3);
            if (object2 instanceof ProxiedJdbcConnectionInvocationHandler) {
                object = (ProxiedJdbcConnectionInvocationHandler)object2;
                ((ProxiedJdbcConnectionInvocationHandler)object).writeCentralStoreInformation(stringBuilder);
                properties = ((ProxiedJdbcConnectionInvocationHandler)object).getConnectionSpecificPropertiesWithRedirect();
            } else {
                stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN", new Object[0])).append("\n\n");
                stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN_REASON_PROXY_WRONG", new Object[0])).append("\n\n");
            }
        }
        if (properties != null) {
            stringBuilder.append('\n');
            stringBuilder.append("Connection-specific properties in effect:\n");
            object3 = DataProperties.getAvailablePropertyNames();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if ("pdq.allowMDMBeanRules".equals(object) || "pdq.allowGetterSetterMethodWithPublicField".equals(object) || "pdq.ignoreOrphanGetterSetterMethods".equals(object) || "pdq.disableJDBCPrerequisiteEnforcement".equals(object)) continue;
                String string = properties.getProperty((String)object);
                if (string != null) {
                    stringBuilder.append((String)object + "=" + string + '\n');
                    continue;
                }
                stringBuilder.append((String)object + "=" + '\n');
            }
        }
    }

    public static String getVersion() {
        return DataVersion.getProductNameAndVersion();
    }

    public static String getConfiguration() {
        StringWriter stringWriter = new StringWriter();
        DataVersion.writeProductConfiguration(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void getConfiguration(PrintWriter printWriter) {
        DataVersion.writeProductConfigurationWithBreaks(printWriter);
    }

    public static String getFeatures() {
        StringWriter stringWriter = new StringWriter();
        DataVersion.writeFeatureActivationInfo(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String validate() {
        StringWriter stringWriter = new StringWriter();
        DataVersion.writeValidationStatus(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void validate(PrintWriter printWriter) {
        DataVersion.writeValidationStatusWithBreaks(printWriter);
    }

    public static String getProductNameAndVersion() {
        return Messages.getText("MSG_PRODUCTNAME_PRODUCTVERSION_BUILD", "IBM InfoSphere Optim pureQuery Runtime", "3.3.0.6", "3.3306.7");
    }

    public static String getProductVersion() {
        return "3.3306.7";
    }

    private static String[] getCompatibleJREVersions() {
        return BuildVersion.compatibleJREVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProductConfiguration(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(DataVersion.getProductNameAndVersion());
            if (Configuration.pureQueryDriverPath__ != null) {
                printWriter.println("Detected pdq jar: " + Configuration.pureQueryDriverPath__);
            }
            DataVersion.writeFeatureActivationInfo(printWriter);
            printWriter.println("\n");
            printWriter.println("Global pureQuery properties in effect");
            printWriter.println("Note: These may be overridden by connection-specific settings:");
            List<String> list = DataProperties.getAvailablePropertyNames();
            for (String string : list) {
                if ("pdq.allowMDMBeanRules".equals(string) || "pdq.allowGetterSetterMethodWithPublicField".equals(string) || "pdq.ignoreOrphanGetterSetterMethods".equals(string) || "pdq.disableJDBCPrerequisiteEnforcement".equals(string)) continue;
                String string2 = DataProperties.getProperty(string);
                if (string2 != null) {
                    printWriter.println(string + "=" + StaticProfileConstants.maskJdbcURLPasswords(string2));
                    continue;
                }
                printWriter.println(string + "=");
            }
            printWriter.println("");
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                printWriter.println("No security manager detected.");
            } else {
                printWriter.println("Security manager detected.");
            }
            DataVersion.detectLocalHost(System.getSecurityManager(), printWriter);
            printWriter.println("");
            DataVersion.writeValidationStatus(printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment vendor = ", "java.vendor", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java vendor URL = ", "java.vendor.url", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java installation directory = ", "java.home", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine specification version = ", "java.vm.specification.version", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine specification vendor = ", "java.vm.specification.vendor", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine specification name = ", "java.vm.specification.name", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine implementation version = ", "java.vm.version", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine implementation vendor = ", "java.vm.vendor", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine implementation name = ", "java.vm.name", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment specification version = ", "java.specification.version", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment specification vendor = ", "java.specification.vendor", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment specification name = ", "java.specification.name", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java class format version number = ", "java.class.version", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java class path (java.class.path) = ", "java.class.path", printWriter);
            DataVersion.printSystemProperty(securityManager, "Java native library path = ", "java.library.path", printWriter);
            DataVersion.printSystemProperty(securityManager, "Path of extension directory or directories = ", "java.ext.dirs", printWriter);
            DataVersion.printSystemProperty(securityManager, "Operating system name = ", "os.name", printWriter);
            DataVersion.printSystemProperty(securityManager, "Operating system architecture = ", "os.arch", printWriter);
            DataVersion.printSystemProperty(securityManager, "Operating system version = ", "os.version", printWriter);
            DataVersion.printSystemProperty(securityManager, "File separator (\"/\" on UNIX) = ", "file.separator", printWriter);
            DataVersion.printSystemProperty(securityManager, "Path separator (\":\" on UNIX) = ", "path.separator", printWriter);
            DataVersion.printSystemProperty(securityManager, "User's account name = ", "user.name", printWriter);
            DataVersion.printSystemProperty(securityManager, "User's home directory = ", "user.home", printWriter);
            DataVersion.printSystemProperty(securityManager, "User's current working directory = ", "user.dir", printWriter);
            printWriter.println("");
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProductConfigurationWithBreaks(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(DataVersion.getProductNameAndVersion());
            printWriter.println("<BR/>");
            if (Configuration.pureQueryDriverPath__ != null) {
                printWriter.println("Detected pdq jar: " + Configuration.pureQueryDriverPath__);
            }
            printWriter.println("<BR/>");
            DataVersion.writeFeatureActivationInfo(printWriter);
            printWriter.println("<BR/>");
            printWriter.println("<BR/>");
            printWriter.println("Global pureQuery properties in effect");
            printWriter.println("<BR/>");
            printWriter.println("Note: These may be overridden by DataSource specific settings:");
            printWriter.println("<BR/>");
            List<String> list = DataProperties.getAvailablePropertyNames();
            for (String string : list) {
                if ("pdq.allowMDMBeanRules".equals(string) || "pdq.allowGetterSetterMethodWithPublicField".equals(string) || "pdq.ignoreOrphanGetterSetterMethods".equals(string) || "pdq.disableJDBCPrerequisiteEnforcement".equals(string)) continue;
                String string2 = DataProperties.getProperty(string);
                if (string2 != null) {
                    printWriter.println(string + "=" + StaticProfileConstants.maskJdbcURLPasswords(string2));
                    printWriter.println("<BR/>");
                    continue;
                }
                printWriter.println(string + "=");
                printWriter.println("<BR/>");
            }
            printWriter.println("<BR/>");
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                printWriter.println("No security manager detected.");
                printWriter.println("<BR/>");
            } else {
                printWriter.println("Security manager detected.");
                printWriter.println("<BR/>");
            }
            DataVersion.detectLocalHost(System.getSecurityManager(), printWriter);
            printWriter.println("<BR/>");
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment vendor = ", "java.vendor", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java vendor URL = ", "java.vendor.url", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java installation directory = ", "java.home", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine specification version = ", "java.vm.specification.version", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine specification vendor = ", "java.vm.specification.vendor", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine specification name = ", "java.vm.specification.name", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine implementation version = ", "java.vm.version", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine implementation vendor = ", "java.vm.vendor", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Virtual Machine implementation name = ", "java.vm.name", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment specification version = ", "java.specification.version", printWriter);
            printWriter.println("<BR>");
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment specification vendor = ", "java.specification.vendor", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java Runtime Environment specification name = ", "java.specification.name", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java class format version number = ", "java.class.version", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java class path (java.class.path) = ", "java.class.path", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Java native library path = ", "java.library.path", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Path of extension directory or directories = ", "java.ext.dirs", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Operating system name = ", "os.name", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Operating system architecture = ", "os.arch", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Operating system version = ", "os.version", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "File separator (\"/\" on UNIX) = ", "file.separator", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "Path separator (\":\" on UNIX) = ", "path.separator", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "User's account name = ", "user.name", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "User's home directory = ", "user.home", printWriter);
            printWriter.println("<BR/>");
            DataVersion.printSystemProperty(securityManager, "User's current working directory = ", "user.dir", printWriter);
            printWriter.println("<BR/>");
            printWriter.println("<BR/>");
            DataVersion.writeValidationStatusWithBreaks(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemProperty(SecurityManager securityManager, String string, String string2, PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            try {
                if (securityManager != null) {
                    securityManager.checkPropertyAccess(string2);
                }
                String string3 = System.getProperty(string2);
                printWriter.println(string + string3);
                printWriter.flush();
            }
            catch (SecurityException securityException) {
                printWriter.println("Security manager does not permit access to system property " + string2);
                printWriter.flush();
            }
        }
    }

    private static void detectLocalHost(SecurityManager securityManager, PrintWriter printWriter) {
        if (securityManager == null) {
            try {
                printWriter.print("Detected local client host: ");
                printWriter.println(InetAddress.getLocalHost().toString());
                printWriter.flush();
            }
            catch (UnknownHostException unknownHostException) {
                printWriter.print("Detected an improper TCP/IP client configuration.");
                printWriter.print("Unable to determine the IP address of your local host: ");
                printWriter.print(unknownHostException.getMessage());
                printWriter.println("Make sure your client machine has a properly configured IP address.");
                printWriter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFeatureActivationInfo(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println("pureQuery Features: ");
            printWriter.println("   pureQuery Base Function:          Activated");
            if (Configuration.isLicensed__) {
                printWriter.println("   pureQuery Runtime:                Activated");
            } else {
                printWriter.println("   pureQuery Runtime:                Not Activated");
            }
            if (Configuration.isExtendedInsightLicensed__) {
                if (Configuration.isExtendedInsightZosLicensed__) {
                    printWriter.println("   Extended Insight Server (Zos):  Activated");
                }
                if (Configuration.isExtendedInsightLUWLicensed__) {
                    printWriter.println("   Extended Insight Server (LUW):  Activated");
                }
            } else {
                printWriter.println("   Extended Insight Server:  Not Activated");
            }
            printWriter.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValidationStatus(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            String string;
            SecurityManager securityManager = System.getSecurityManager();
            try {
                if (securityManager != null) {
                    securityManager.checkPropertyAccess("java.version");
                }
                string = System.getProperty("java.version");
            }
            catch (SecurityException securityException) {
                printWriter.println(Messages.getText("ERR_CANT_VERIFY_JAVA", new Object[0]));
                return;
            }
            if (Configuration.isJCCPresent__ && !Configuration.isJCCAtPrerequisiteLevel__) {
                printWriter.println(Messages.getText("MSG_PRE_REQ_NOT_MET", "pureQuery Runtime"));
            } else {
                printWriter.println(Messages.getText("MSG_PRE_REQ_MET", "pureQuery Runtime"));
            }
            if (Configuration.isJCCPresent__) {
                printWriter.println(Messages.getText("MSG_PROD_NAME_VERSION", "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__));
                if (Configuration.JCCMajorVersion__ == 3) {
                    printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "3.57"));
                } else if (Configuration.JCCMajorVersion__ == 4) {
                    printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "4.7"));
                }
            }
            printWriter.println(Messages.getText("MSG_JAVA_VERSION", string));
            if (Configuration.isJCCPresent__ && Configuration.JCCMajorVersion__ == 4) {
                printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "1.6"));
            } else {
                printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "1.5"));
            }
            if (!Configuration.isJCCPresent__) {
                printWriter.println(Messages.getText("MSG_PROD_NOT_ON_CP", "IBM Data Server Driver for JDBC and SQLJ"));
                System.out.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValidationStatusWithBreaks(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            String string;
            SecurityManager securityManager = System.getSecurityManager();
            try {
                if (securityManager != null) {
                    securityManager.checkPropertyAccess("java.version");
                }
                string = System.getProperty("java.version");
            }
            catch (SecurityException securityException) {
                printWriter.println(Messages.getText("ERR_CANT_VERIFY_JAVA", new Object[0]));
                printWriter.println("<BR/>");
                return;
            }
            if (Configuration.isJCCPresent__ && !Configuration.isJCCAtPrerequisiteLevel__) {
                printWriter.println("<B>");
                printWriter.println(Messages.getText("MSG_PRE_REQ_NOT_MET", "pureQuery Runtime"));
                printWriter.println("</B><BR/>");
            } else {
                printWriter.println("<B>");
                printWriter.println(Messages.getText("MSG_PRE_REQ_MET", "pureQuery Runtime"));
                printWriter.println("</B><BR/>");
            }
            if (Configuration.isJCCPresent__) {
                printWriter.println("<BR/>");
                printWriter.println(Messages.getText("MSG_PROD_NAME_VERSION", "IBM Data Server Driver for JDBC and SQLJ", Configuration.JCCVersionAsString__));
                if (Configuration.JCCMajorVersion__ == 3) {
                    printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "3.57"));
                } else if (Configuration.JCCMajorVersion__ == 4) {
                    printWriter.print("<br>" + Messages.getText("MSG_PRE_REQ_LEVEL", "4.7") + "<\br>");
                }
                printWriter.println("<BR/>");
            }
            printWriter.println(Messages.getText("MSG_JAVA_VERSION", string));
            printWriter.println("<BR/>");
            if (Configuration.isJCCPresent__ && Configuration.JCCMajorVersion__ == 4) {
                printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "1.6"));
            } else {
                printWriter.print(Messages.getText("MSG_PRE_REQ_LEVEL", "1.5"));
            }
            printWriter.println("<BR/>");
            if (!Configuration.isJCCPresent__) {
                printWriter.println(Messages.getText("MSG_PROD_NOT_ON_CP", "IBM Data Server Driver for JDBC and SQLJ"));
                printWriter.println("<br>");
            }
        }
    }

    private int[] getVersionParts(String string) throws NumberFormatException {
        int[] nArray = new int[]{0, 0, 0};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        if (stringTokenizer.hasMoreTokens()) {
            nArray[0] = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[1] = Integer.valueOf(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            nArray[2] = Integer.valueOf(stringTokenizer.nextToken());
        }
        return nArray;
    }

    public void checkCompatibleGeneratorVersion(String string, String string2) {
        int[] nArray;
        int[] nArray2;
        try {
            nArray2 = this.getVersionParts(string);
            nArray = this.getVersionParts(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_UNABLE_GEN_TOOLS_VCHECK", string2, string), numberFormatException, 10058);
        }
        if (nArray2[0] < nArray[0]) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GEN_INCOMPAT_TOOLS", string, string2), null, 10059);
        }
        if (nArray2[0] == nArray[0]) {
            if (nArray2[1] < nArray[1]) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GEN_INCOMPAT_TOOLS", string, string2), null, 10060);
            }
            if (nArray2[1] == nArray[1] && nArray2[2] < nArray[2]) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_GEN_INCOMPAT_TOOLS", string, string2), null, 10061);
            }
        }
    }

    protected static Connection unwrapConnectionIfWrapped(Connection connection, StringBuilder stringBuilder) {
        if (connection instanceof DB2Wrapper) {
            return (Connection)((DB2Wrapper)((Object)connection)).getDB2Object();
        }
        if (!(connection instanceof DB2Connection)) {
            try {
                Method method = DataVersion.getMethodForClass(connection.getClass(), "isWrapperFor", Class.class);
                Method method2 = DataVersion.getMethodForClass(connection.getClass(), "unwrap", Class.class);
                if (((Boolean)method.invoke((Object)connection, DB2Connection.class)).booleanValue()) {
                    return (Connection)method2.invoke((Object)connection, DB2Connection.class);
                }
            }
            catch (Throwable throwable) {
                stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN", new Object[0])).append("\n\n");
                stringBuilder.append(Messages.getText("ERR_WRAPPED_CONN_REASON_CANT_UNWRAP", new Object[0])).append("\n\n");
            }
        }
        return connection;
    }

    private static Method getMethodForClass(Class clazz, String string, Class ... classArray) throws PrivilegedActionException, SecurityException, NoSuchMethodException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(DataVersion.getMethodForClassPrivilegedAction(clazz, string, classArray));
        }
        return DataVersion.getMethodForClassNoSM(clazz, string, classArray);
    }

    private static final PrivilegedExceptionAction<Method> getMethodForClassPrivilegedAction(final Class clazz, final String string, final Class ... classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return DataVersion.getMethodForClassNoSM(clazz, string, classArray);
            }
        };
    }

    private static Method getMethodForClassNoSM(Class clazz, String string, Class ... classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    public static enum DataVersionPossibleArgs {
        CONFIGURATION("configuration", "MSG_DATAVERSION_CONFIGURATION"),
        VERSION("version", "MSG_DATAVERSION_VERSION"),
        FEATURES("features", "MSG_DATAVERSION_FEATURES"),
        VALIDATE("validate", "MSG_DATAVERSION_VALIDATE"),
        URL("url", "MSG_DATA_VERSION_URL_HELP"),
        DRIVER_NAME("driverName", "MSG_DATA_VERSION_DRIVERNAME_HELP"),
        USERNAME("username", "MSG_DATA_VERSION_USERNAME_HELP"),
        PASSWORD("password", "MSG_DATA_VERSION_PASSWORD_HELP");

        private final String externalOptionName_;
        private final String helpMessage_;

        private DataVersionPossibleArgs(String string2, String string3) {
            this.externalOptionName_ = string2;
            this.helpMessage_ = Messages.getText(string3, new Object[0]);
        }

        public String externalOptionName() {
            return '-' + this.externalOptionName_;
        }

        public String helpMessage() {
            return this.helpMessage_;
        }

        public String usageDescription() {
            return "[" + this.externalOptionName() + "]";
        }
    }
}

