/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.Environment;
import com.ibm.db2.cmx.HttpControllerInterface;
import com.ibm.db2.cmx.ProductInformation;
import com.ibm.db2.cmx.impl.HttpControllerProcessorAS;
import com.ibm.db2.cmx.impl.Registry;
import com.ibm.db2.cmx.internal.core.CoreProcessor;
import com.ibm.db2.cmx.internal.core.HttpReply;
import com.ibm.db2.cmx.internal.core.HttpRequest;
import com.ibm.db2.cmx.internal.core.LogLookupInfo;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.ProcessingException;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.GetSystemPropertyAction;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class HttpController
implements HttpControllerInterface {
    private Logger logger_ = Log.getCMXServerLogger();
    private CoreProcessor coreProcessor_ = new CoreProcessor();
    private HttpControllerProcessorAS controllerProcessor_ = new HttpControllerProcessorAS(this.logger_);
    private Timer timer_ = null;
    private ReclaimInactiveDriversTask reclaimInactiveDriversTask_ = null;
    private ReclaimInactiveDataSourcesTask reclaimInactiveDataSourcesTask_ = null;
    private int defaultIntervalToReclaimInactiveDrivers_ = Environment.intervalToReclaimInactiveDrivers__;
    private int defaultIntervalToReclaimInactiveDataSources_ = Environment.intervalToReclaimInactiveDataSources__;
    private int ReclaimtimerTaskInterval = 60;

    HttpController() {
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(this.logger_, this, "<init>", "ENTRY " + Arrays.deepToString(new Object[]{this.getSystemProperty("user.dir"), this.getSystemProperty("osgi.syspath")}));
        }
        this.timer_ = new Timer(DataLogger.getShortName(this), true);
        this.initializeReclaimInactiveDriversTask();
        this.initializeReclaimInactiveDataSourcesTask();
    }

    private String getSystemProperty(String string) {
        String string2 = null;
        try {
            string2 = AccessController.doPrivileged(new GetSystemPropertyAction(string));
        }
        catch (AccessControlException accessControlException) {
            DataLogger.logThrowable(this.logger_, accessControlException);
            string2 = null;
        }
        return string2;
    }

    private void setReclaimInactiveDriversInterval(int n2) {
        if (n2 > 0 && n2 != this.defaultIntervalToReclaimInactiveDrivers_) {
            if (this.defaultIntervalToReclaimInactiveDrivers_ > 0 && this.reclaimInactiveDriversTask_ != null) {
                this.reclaimInactiveDriversTask_.cancel();
                this.reclaimInactiveDriversTask_ = null;
            }
            this.defaultIntervalToReclaimInactiveDrivers_ = n2;
            if (this.logger_.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(this.logger_, this, "setReclaimInactiveDriversInterval", "Setting new lookup interval: " + n2);
            }
            this.initializeReclaimInactiveDriversTask();
        }
    }

    private void setReclaimInactiveDataSourcesInterval(int n2) {
        if (n2 > 0 && n2 != this.defaultIntervalToReclaimInactiveDataSources_) {
            if (this.defaultIntervalToReclaimInactiveDataSources_ > 0 && this.reclaimInactiveDataSourcesTask_ != null) {
                this.reclaimInactiveDataSourcesTask_.cancel();
                this.reclaimInactiveDataSourcesTask_ = null;
            }
            this.defaultIntervalToReclaimInactiveDataSources_ = n2;
            if (this.logger_.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(this.logger_, this, "setReclaimInactiveDataSourcesInterval", "Setting new lookup interval: " + n2);
            }
            this.initializeReclaimInactiveDataSourcesTask();
        }
    }

    private void initializeReclaimInactiveDriversTask() {
        if (this.reclaimInactiveDriversTask_ == null) {
            this.reclaimInactiveDriversTask_ = new ReclaimInactiveDriversTask();
            this.timer_.schedule((TimerTask)this.reclaimInactiveDriversTask_, this.ReclaimtimerTaskInterval * 1000, (long)(this.ReclaimtimerTaskInterval * 1000));
        }
    }

    private void initializeReclaimInactiveDataSourcesTask() {
        if (this.reclaimInactiveDataSourcesTask_ == null) {
            this.reclaimInactiveDataSourcesTask_ = new ReclaimInactiveDataSourcesTask();
            this.timer_.schedule((TimerTask)this.reclaimInactiveDataSourcesTask_, this.ReclaimtimerTaskInterval * 1000, (long)(this.ReclaimtimerTaskInterval * 1000));
        }
    }

    private void displayHttpRequestProperties(HttpServletRequest httpServletRequest) {
        String string;
        System.out.println("========================================");
        System.out.println("Request AuthType: " + httpServletRequest.getAuthType());
        System.out.println("Request CharacterEncoding: " + httpServletRequest.getCharacterEncoding());
        System.out.println("Request ContentLength: " + httpServletRequest.getContentLength());
        System.out.println("Request ContentType: " + httpServletRequest.getContentType());
        System.out.println("Request ContextPath: " + httpServletRequest.getContextPath());
        System.out.println("Request Header Names: ");
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println(string + ": " + httpServletRequest.getHeader(string));
        }
        System.out.println("Request Method: " + httpServletRequest.getMethod());
        System.out.println("Request PathInfo: " + httpServletRequest.getPathInfo());
        System.out.println("Request Protocol: " + httpServletRequest.getProtocol());
        System.out.println("Request QueryString: " + httpServletRequest.getQueryString());
        System.out.println("Request RemoteAddr: " + httpServletRequest.getRemoteAddr());
        System.out.println("Request RemoteHost: " + httpServletRequest.getRemoteHost());
        System.out.println("Request RemoteUser: " + httpServletRequest.getRemoteUser());
        System.out.println("Request RequestedSessionId: " + httpServletRequest.getRequestedSessionId());
        System.out.println("Request RequestURI: " + httpServletRequest.getRequestURI());
        System.out.println("Request Scheme: " + httpServletRequest.getScheme());
        System.out.println("Request ServerName: " + httpServletRequest.getServerName());
        System.out.println("Request ServerPort: " + httpServletRequest.getServerPort());
        System.out.println("Request ServletPath: " + httpServletRequest.getServletPath());
        System.out.println("Request Session: " + httpServletRequest.getSession(false));
        System.out.println("Request Attribute Names: ");
        enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println(string + ": " + httpServletRequest.getAttribute(string));
        }
        if (httpServletRequest.getMethod().equals("GET")) {
            System.out.println("Request Parameter Names: ");
            enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                System.out.println(string + ": " + httpServletRequest.getParameter(string));
            }
        }
        System.out.println("========================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDoGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Map map;
        try {
            String[] stringArray;
            map = null;
            ProductInformation.Server server = Environment.getServerProductInformation();
            map = httpServletRequest.getParameterMap();
            if (map == null || map.size() == 0) {
                httpServletResponse.setContentType("text/plain");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.write("CMX Controller\n");
                if (server != null) {
                    ProductInformation.OCM oCM;
                    ProductInformation.CMX cMX = server.getCMXServerProductInformation();
                    if (cMX != null) {
                        printWriter.write(cMX.getFullVersionString() + "\n");
                    }
                    if ((oCM = server.getOCMServerProductInformation()) != null) {
                        printWriter.write(oCM.getFullVersionString() + "\n");
                    }
                }
            } else if (map != null && (stringArray = (String[])map.get("action")) != null && Arrays.asList(stringArray).contains("clearCache")) {
                Registry registry = Environment.getRegistry();
                if (this.logger_.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(this.logger_, this, "processDoGet", "clearCache called, registry = " + registry);
                }
                if (registry != null) {
                    registry.purgeCache();
                } else {
                    httpServletResponse.setStatus(500);
                }
            }
        }
        finally {
            map = httpServletRequest.getSession(false);
            if (map != null) {
                map.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDoPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletInputStream servletInputStream = null;
        ServletOutputStream servletOutputStream = null;
        HttpReply httpReply = null;
        HttpRequest httpRequest = null;
        Message message = null;
        int n2 = -1;
        LogLookupInfo logLookupInfo = new LogLookupInfo();
        try {
            Processor processor = null;
            servletInputStream = httpServletRequest.getInputStream();
            servletOutputStream = httpServletResponse.getOutputStream();
            n2 = httpServletRequest.getIntHeader("CMX-Num-Chained-Requests");
            for (int i10 = 0; i10 < n2; ++i10) {
                httpReply = new HttpReply((InputStream)servletInputStream);
                message = httpReply.parseReply();
                httpRequest = new HttpRequest((OutputStream)servletOutputStream);
                if (this.logger_.isLoggable(Level.FINEST)) {
                    DataLogger.logMonitorBuffer(this.logger_, this, "processDoPost", "Message received, payload(UTF-8): ", message);
                }
                processor = null;
                processor = message.getProcessorName().equals("CMXCoreProcessor") ? this.coreProcessor_ : this.controllerProcessor_;
                if (processor == null) {
                    throw new ProcessingException("processor not found: " + message.getProcessorName());
                }
                if (httpReply.getType() == 1) {
                    Message message2 = processor.processRequest(message, httpServletRequest, httpServletResponse, logLookupInfo);
                    if (message2 == null) {
                        message2 = new Message(message.getProcessorName(), ByteBuffer.allocate(0));
                    }
                    httpRequest.flushMessage(message2, (byte)2);
                    if (!this.logger_.isLoggable(Level.FINEST)) continue;
                    DataLogger.logMonitorBuffer(this.logger_, this, "processDoPost", "Message sent, payload(UTF-8): ", message2);
                    continue;
                }
                if (httpReply.getType() != 3) continue;
                processor.processMessage(message, httpServletRequest);
            }
            if (processor != null) {
                processor.invokeLogLookup(logLookupInfo);
            }
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            StringWriter stringWriter = new StringWriter();
            ProductInformation.OCM oCM = null;
            if (Environment.getServerProductInformation() != null) {
                oCM = Environment.getServerProductInformation().getOCMServerProductInformation();
            }
            exception.printStackTrace(new PrintWriter(stringWriter));
            stringBuilder.append("CMX Server processing error: ").append(exception.getMessage()).append(". CMX Client [").append(httpServletRequest != null ? httpServletRequest.getRemoteAddr() : null).append("][").append(httpServletRequest != null ? httpServletRequest.getHeader("X-Forwarded-For") : null).append("][").append(httpServletRequest != null ? httpServletRequest.getHeader("CMX-Client-Version") : null).append("], CMX Server [").append(Configuration.localHostAddress__).append("][").append("3.3306.7").append("], OCM Product Information: ").append(oCM != null ? oCM.getFullVersionString() : null);
            if (Environment.getServerProductInformation() == null) {
                stringBuilder.append(". Environment.initialize not called as yet. DSM/OCM/OPM might be initializing.");
            }
            DataLogger.logTrappedException(this.logger_, this, "processDoPost", exception, stringBuilder.toString());
            if (httpReply != null && httpRequest != null && httpReply.getType() == 1) {
                Message message3 = CoreProcessor.createErrorReply(stringBuilder.toString() + "\n" + stringWriter.toString(), -1);
                httpRequest.flushMessage(message3, (byte)2);
            }
            System.err.println(stringBuilder.toString() + "\n" + stringWriter.toString());
        }
        finally {
            HttpSession httpSession;
            if (servletInputStream != null) {
                servletInputStream.close();
            }
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
            if (httpServletRequest != null && (httpSession = httpServletRequest.getSession(false)) != null) {
                httpSession.invalidate();
            }
        }
    }

    private class ReclaimInactiveDriversTask
    extends TimerTask
    implements Runnable {
        private ReclaimInactiveDriversTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (HttpController.this.logger_.isLoggable(Level.FINER)) {
                DataLogger.enter(HttpController.this.logger_, this, "run");
            }
            if (Environment.getRegistry() != null) {
                Registry registry = Environment.getRegistry();
                synchronized (registry) {
                    long l8 = System.currentTimeMillis();
                    Iterator<Map.Entry<String, Long>> iterator = Environment.getRegistry().timeOfDriverIdReferenceMap_.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Long> entry = iterator.next();
                        if (l8 - entry.getValue() < (long)(HttpController.this.defaultIntervalToReclaimInactiveDrivers_ * 1000)) continue;
                        HttpController.this.controllerProcessor_.deregisterDriver(entry.getKey(), iterator);
                    }
                }
            }
            HttpController.this.setReclaimInactiveDriversInterval(Environment.intervalToReclaimInactiveDrivers__);
        }
    }

    private class ReclaimInactiveDataSourcesTask
    extends TimerTask
    implements Runnable {
        private ReclaimInactiveDataSourcesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (HttpController.this.logger_.isLoggable(Level.FINER)) {
                DataLogger.enter(HttpController.this.logger_, this, "run");
            }
            if (Environment.getRegistry() != null) {
                Registry registry = Environment.getRegistry();
                synchronized (registry) {
                    long l8 = System.currentTimeMillis();
                    Iterator<Map.Entry<String, Long>> iterator = Environment.getRegistry().timeOfDataSourceIdReferenceMap_.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Long> entry = iterator.next();
                        if (l8 - entry.getValue() < (long)(HttpController.this.defaultIntervalToReclaimInactiveDataSources_ * 1000)) continue;
                        HttpController.this.controllerProcessor_.deregisterDataSource(entry.getKey(), iterator);
                    }
                }
            }
            HttpController.this.setReclaimInactiveDataSourcesInterval(Environment.intervalToReclaimInactiveDataSources__);
        }
    }
}

