/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.InputStream;

public class AsciiParameterStream
extends AbstractParameterStream {
    public AsciiParameterStream(InputStream inputStream, long l, ParameterMetadata parameterMetadata, int n) {
        super(inputStream, l, parameterMetadata, n);
    }

    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        int n = this.getNumToFetch();
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            n2 = this.m_stream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
        }
        this.m_numRead += (long)n2;
        DataWrapper dataWrapper = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == n2) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = n2;
            if (n2 < byArray.length && -1 != n2) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                byArray = byArray2;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == n2) {
                byArray = new byte[]{};
            }
        }
        if (12 == this.m_type) {
            dataWrapper.setVarChar(new String(byArray));
        } else {
            dataWrapper.setLongVarChar(new String(byArray));
        }
        return new ParameterInputValue(this.m_parameterMetadata, dataWrapper);
    }
}

