/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.kv;

import com.vertica.jdbc.kv.KVErrors;
import com.vertica.jdbc.kv.OutputColumn;
import com.vertica.jdbc.kv.RoutableQuery;
import com.vertica.jdbc.kv.SQLWarningChainer;
import com.vertica.jdbc.kv.SortColumn;
import com.vertica.jdbc.kv.VGet;
import com.vertica.jdbc.kv.VerticaJdbc4RoutableConnectionImpl;
import com.vertica.parser.Tokenizer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VGetImpl
implements VGet {
    private Map<String, Object> predicateCols = new HashMap<String, Object>();
    private Set<String> predicateExprs = new HashSet<String>();
    private List<OutputColumn> outputCols;
    private List<SortColumn> sortCols = new ArrayList<SortColumn>();
    private RoutableQuery query;
    private int limit;
    private boolean closed;
    SQLWarningChainer warnings;

    VGetImpl(VerticaJdbc4RoutableConnectionImpl verticaJdbc4RoutableConnectionImpl, String string, String string2) throws SQLException {
        this.outputCols = new ArrayList<OutputColumn>();
        this.warnings = new SQLWarningChainer();
        this.query = new RoutableQuery(verticaJdbc4RoutableConnectionImpl, string, string2, this.warnings);
    }

    public synchronized ResultSet execute() throws SQLException {
        this.checkClosed();
        this.warnings.clear();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        boolean bl = true;
        for (OutputColumn object : this.outputCols) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            if (object.isExpr) {
                stringBuilder.append(object.colOrExpr);
            } else {
                stringBuilder.append(Tokenizer.quoteIdentifier(object.colOrExpr));
            }
            bl = false;
        }
        if (this.outputCols.isEmpty()) {
            stringBuilder.append("*");
        }
        stringBuilder.append(" from ? as ");
        stringBuilder.append(Tokenizer.quoteIdentifier(this.query.table));
        bl = true;
        for (SortColumn sortColumn : this.sortCols) {
            stringBuilder.append(bl ? " order by " : ", ");
            stringBuilder.append(Tokenizer.quoteIdentifier(sortColumn.col));
            switch (sortColumn.order) {
                case ASC: {
                    stringBuilder.append(" asc");
                    break;
                }
                case DESC: {
                    stringBuilder.append(" desc");
                }
            }
            bl = false;
        }
        if (this.limit > 0) {
            stringBuilder.append(" limit ");
            stringBuilder.append(this.limit);
        }
        return this.query.execute(this.predicateCols, this.predicateExprs, this.outputCols, this.sortCols, stringBuilder.toString());
    }

    public synchronized void addPredicate(String string, Object object) throws SQLException {
        this.checkClosed();
        string = this.normalizeColumn(string);
        this.checkIfColumnExists(string, true);
        this.query.checkTypeSupported(string, object);
        this.predicateCols.put(string, object);
    }

    public synchronized void addPredicateExpression(String string) throws SQLException {
        this.checkClosed();
        this.predicateExprs.add(string);
    }

    public synchronized void clearPredicates() {
        this.predicateCols.clear();
        this.predicateExprs.clear();
    }

    public synchronized void addSortColumn(String string, VGet.SortOrder sortOrder) throws SQLException {
        this.checkClosed();
        string = this.normalizeColumn(string);
        this.checkIfColumnExists(string, false);
        this.sortCols.add(new SortColumn(string, sortOrder));
    }

    public synchronized void clearSortColumns() {
        this.sortCols.clear();
    }

    public synchronized void addOutputColumn(String string) throws SQLException {
        this.checkClosed();
        string = this.normalizeColumn(string);
        this.checkIfColumnExists(string, false);
        this.outputCols.add(new OutputColumn(string, false));
    }

    public synchronized void addOutputExpression(String string) throws SQLException {
        this.checkClosed();
        if (this.query.metadata.isFlexTable()) {
            throw KVErrors.FlexTableOutputExpressionsNotSupported.makeException(new Object[0]);
        }
        this.outputCols.add(new OutputColumn(string, true));
    }

    public synchronized void clearOutputs() {
        this.outputCols.clear();
    }

    public synchronized void setLimit(int n) {
        this.limit = n;
    }

    private void checkIfColumnExists(String string, boolean bl) throws SQLException {
        if (this.query.metadata.isFlexTable() && !bl) {
            return;
        }
        if (!this.query.metadata.containsColumn(string)) {
            throw KVErrors.NoSuchColumn.makeException(string);
        }
    }

    private String normalizeColumn(String string) throws SQLException {
        if (string == null) {
            throw KVErrors.InvalidColumnName.makeException(string);
        }
        return string.toLowerCase();
    }

    public synchronized void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.query.close();
        }
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw KVErrors.VGetClosed.makeException(new Object[0]);
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings.get();
    }

    public synchronized String getLastNodeUsed() {
        return this.query.lastNodeUsed;
    }

    public synchronized String getLastProjectionUsed() {
        return this.query.lastProjUsed == null ? null : this.query.lastProjUsed.name;
    }

    RoutableQuery getRoutableQuery() {
        return this.query;
    }
}

