/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EncodedDataStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class NuoXid
implements Xid {
    protected int formatId;
    protected byte[] branchId;
    protected byte[] globalTranId;
    protected long nuodbTransId;

    public NuoXid() {
    }

    public NuoXid(int fid, byte[] tid, byte[] bid) {
        this.formatId = fid;
        this.globalTranId = tid;
        this.branchId = bid;
        this.nuodbTransId = 0L;
    }

    public NuoXid(int fid, int[] tid, int[] bid, long transId) {
        this.formatId = fid;
        this.globalTranId = this.convertToByteArray(tid);
        this.branchId = this.convertToByteArray(bid);
        this.nuodbTransId = transId;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTranId;
    }

    public int[] getTidIntArray() {
        return this.convertToIntArray(this.getGlobalTransactionId());
    }

    public int[] getBidIntArray() {
        return this.convertToIntArray(this.getBranchQualifier());
    }

    public long getNuodbTransId() {
        return this.nuodbTransId;
    }

    public Boolean equals(Xid otherXid) {
        if (!Arrays.equals(this.globalTranId, otherXid.getGlobalTransactionId())) {
            return false;
        }
        if (!Arrays.equals(this.branchId, otherXid.getBranchQualifier())) {
            return false;
        }
        return this.formatId == otherXid.getFormatId();
    }

    private int[] convertToIntArray(byte[] bArray) {
        if (bArray.length == 0) {
            return new int[0];
        }
        int arrayLen = bArray.length - 1;
        while (arrayLen > 0 && bArray[arrayLen--] == 0) {
        }
        ++arrayLen;
        arrayLen += 4 - arrayLen % 4;
        byte[] arr = bArray;
        if (arrayLen > bArray.length) {
            arr = new byte[arrayLen];
            System.arraycopy(bArray, 0, arr, 0, bArray.length);
        }
        int[] intArray = new int[arrayLen / 4];
        int i = 0;
        int bi = 0;
        while (bi < arrayLen) {
            intArray[i] = arr[0 + bi] & 0xFF | (arr[1 + bi] & 0xFF) << 8 | (arr[2 + bi] & 0xFF) << 16 | (arr[3 + bi] & 0xFF) << 24;
            bi += 4;
            ++i;
        }
        return intArray;
    }

    private byte[] convertToByteArray(int[] intArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        for (int val : intArray) {
            byteBuffer.putInt(Integer.reverseBytes(val));
        }
        return byteBuffer.array();
    }

    public void encodeDataStream(EncodedDataStream dataStream) {
        int i;
        int[] tid = this.getTidIntArray();
        int[] bid = this.getBidIntArray();
        int size = tid.length + bid.length + 4;
        dataStream.encodeInt(size);
        dataStream.encodeInt(tid.length);
        dataStream.encodeInt(bid.length);
        for (i = 0; i < tid.length; ++i) {
            dataStream.encodeInt(tid[i]);
        }
        for (i = 0; i < bid.length; ++i) {
            dataStream.encodeInt(bid[i]);
        }
        dataStream.encodeInt(this.getFormatId());
    }

    public void decodeDataStream(EncodedDataStream dataStream) throws SQLException {
        int ii;
        this.nuodbTransId = dataStream.getLong();
        int sz = dataStream.getInt();
        int tidSz = dataStream.getInt();
        int[] tid = new int[tidSz];
        int bidSz = dataStream.getInt();
        int[] bid = new int[bidSz];
        for (ii = 0; ii < tidSz; ++ii) {
            tid[ii] = dataStream.getInt();
        }
        for (ii = 0; ii < bidSz; ++ii) {
            bid[ii] = dataStream.getInt();
        }
        this.globalTranId = this.convertToByteArray(tid);
        this.branchId = this.convertToByteArray(bid);
        this.formatId = dataStream.getInt();
    }
}

