/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent.plugin;

import com.nuodb.agent.PropertiesProvider;
import com.nuodb.impl.util.Env;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLPropertiesProvider
implements PropertiesProvider {
    private static final Logger logger = Logger.getLogger(URLPropertiesProvider.class.getName());
    private final Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLPropertiesProvider(Properties systemProperties) {
        String urlPath = systemProperties.getProperty("propertiesUrl", null);
        InputStream input = null;
        if (urlPath != null) {
            try {
                URL url = new URL(urlPath);
                input = url.openStream();
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "failed to resolve url", ioe);
                throw new IllegalArgumentException("Invalid URL", ioe);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("using properties from: " + urlPath);
            }
        } else {
            File defaultProperties;
            File etcDir;
            File rootDir = Env.getContainingDirectory(Env.class).getParentFile();
            if (rootDir != null && (etcDir = new File(rootDir, "etc")).exists() && etcDir.isDirectory() && etcDir.canRead() && (defaultProperties = new File(etcDir, "default.properties")).exists() && defaultProperties.canRead()) {
                try {
                    input = new FileInputStream(defaultProperties);
                }
                catch (FileNotFoundException fnfe) {
                    throw new IllegalStateException("No default file");
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("using default properties file: " + defaultProperties.getPath());
                }
            }
        }
        if (input == null) {
            logger.config("no source of backing properties is available");
            return;
        }
        try {
            try {
                this.properties.load(input);
            }
            finally {
                input.close();
            }
        }
        catch (IOException ioe) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "failed to load properties", ioe);
            }
            throw new IllegalArgumentException("Failed to load properties", ioe);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key, null);
    }
}

