/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.core;

import com.amazon.dsi.core.utilities.ConnSettingRequestMap;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.jdbc.common.CustomNetworkHooksSettings;
import com.amazon.jdbc.common.OAuthSettings;
import com.amazon.jdbc.common.SSLSettings;
import com.amazon.jdbc.core.DSDriver;
import com.amazon.jdbc.exceptions.CommonJDBCMessageKey;
import com.amazon.support.IWarningListener;
import com.amazon.support.Warning;
import com.amazon.support.WarningCode;
import com.amazon.support.exceptions.ErrorException;

public class DSConnectionUtils {
    public static final String O_AUTH_TOKEN_ENDPOINT = "OAuth_";

    public static void readCustomNetworkHooksProperties(ConnSettingRequestMap connSettingRequestMap, CustomNetworkHooksSettings customNetworkHooksSettings) {
        Variant variant = connSettingRequestMap.getProperty("SocketFactory");
        if (null != variant) {
            customNetworkHooksSettings.m_socketFactory = variant.getString();
            variant = connSettingRequestMap.getProperty("SocketFactoryArg");
            if (null != variant) {
                customNetworkHooksSettings.m_socketFactoryArg = variant.getString();
            }
        }
        if (null != (variant = connSettingRequestMap.getProperty("DnsResolver"))) {
            customNetworkHooksSettings.m_dnsResolver = variant.getString();
            variant = connSettingRequestMap.getProperty("DnsResolverArg");
            if (null != variant) {
                customNetworkHooksSettings.m_dnsResolverArg = variant.getString();
            }
        }
    }

    public static void readOAuthProperties(ConnSettingRequestMap connSettingRequestMap, OAuthSettings oAuthSettings, SSLSettings sSLSettings, IWarningListener iWarningListener) throws ErrorException {
        block7: {
            Variant variant = connSettingRequestMap.getProperty("Auth_Client_ID");
            if (null != variant) {
                oAuthSettings.m_authClientID = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Client_Secret"))) {
                oAuthSettings.m_authClientSecret = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("AuthorizationUrl"))) {
                oAuthSettings.m_authrizationUrl = variant.getString();
            }
            if (null != (variant = connSettingRequestMap.getProperty("Auth_Scope"))) {
                oAuthSettings.m_authScope = variant.getString();
            }
            variant = connSettingRequestMap.getProperty("Auth_Token_Expiry_Buffer");
            oAuthSettings.m_tokenExpiryBuffer = 60;
            if (null != variant) {
                try {
                    oAuthSettings.m_tokenExpiryBuffer = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block7;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{String.valueOf("Auth_Token_Expiry_Buffer"), variant.getString(), "Integers"}));
                }
            }
        }
        DSConnectionUtils.readSSLSettings(connSettingRequestMap, sSLSettings, oAuthSettings.m_tokenEndpointSSLSettings, true, O_AUTH_TOKEN_ENDPOINT, iWarningListener);
    }

    public static void readSSLSettings(ConnSettingRequestMap connSettingRequestMap, SSLSettings sSLSettings, SSLSettings sSLSettings2, boolean bl, String string, IWarningListener iWarningListener) throws ErrorException {
        Variant variant;
        block52: {
            variant = connSettingRequestMap.getProperty(string + "ssl");
            if (bl) {
                sSLSettings2.m_enableSSL = true;
            } else if (variant != null) {
                try {
                    int n = variant.getInt();
                    if (1 == n) {
                        sSLSettings2.m_sslSpecifiedByUser = true;
                        sSLSettings2.m_enableSSL = true;
                    } else if (0 == n) {
                        sSLSettings2.m_sslSpecifiedByUser = true;
                        sSLSettings2.m_enableSSL = false;
                    } else if (null != iWarningListener) {
                        iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "ssl", variant.getString(), "0 or 1"}));
                    }
                }
                catch (Exception exception) {
                    ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "ssl", variant.getString(), "0 , 1"});
                    errorException.initCause(exception);
                    throw errorException;
                }
            }
            variant = connSettingRequestMap.getProperty(string + "SSLKeyStore");
            if (null != variant) {
                sSLSettings2.m_sslKeyStore = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslKeyStore = sSLSettings.m_sslKeyStore;
            }
            variant = connSettingRequestMap.getProperty(string + "SSLKeyStorePwd");
            if (null != variant) {
                sSLSettings2.m_sslKeyStorePwd = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslKeyStorePwd = sSLSettings.m_sslKeyStorePwd;
            }
            variant = connSettingRequestMap.getProperty(string + "SSLTrustStore");
            if (null != variant) {
                sSLSettings2.m_sslTrustStore = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslTrustStore = sSLSettings.m_sslTrustStore;
            }
            variant = connSettingRequestMap.getProperty(string + "SSLTrustStorePwd");
            if (null != variant) {
                sSLSettings2.m_sslTrustStorePwd = variant.getString();
            } else if (null != sSLSettings) {
                sSLSettings2.m_sslTrustStorePwd = sSLSettings.m_sslTrustStorePwd;
            }
            sSLSettings2.m_allowSelfSigned = false;
            variant = connSettingRequestMap.getProperty(string + "AllowSelfSignedCerts");
            if (variant != null) {
                try {
                    if (1 == variant.getInt()) {
                        sSLSettings2.m_allowSelfSigned = true;
                        sSLSettings2.m_allowSelfSignedSpecifiedByUser = true;
                    }
                    if (0 == variant.getInt()) {
                        sSLSettings2.m_allowSelfSigned = false;
                        sSLSettings2.m_allowSelfSignedSpecifiedByUser = true;
                    }
                    break block52;
                }
                catch (Exception exception) {
                    if (null != iWarningListener) {
                        iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "AllowSelfSignedCerts", variant.getString(), "0 or 1"}));
                    }
                    break block52;
                }
            }
            if (null != sSLSettings) {
                sSLSettings2.m_allowSelfSigned = sSLSettings.m_allowSelfSigned;
            }
        }
        sSLSettings2.m_certNamesMismatch = false;
        Variant variant2 = connSettingRequestMap.getProperty(string + "AllowAllHostNames");
        Variant variant3 = connSettingRequestMap.getProperty(string + "CAIssuedCertNamesMismatch");
        int n = -1;
        if (null != variant3) {
            block53: {
                try {
                    n = variant3.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block53;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "CAIssuedCertNamesMismatch", variant.getString(), "0 or 1"}));
                }
            }
            if (1 == n) {
                sSLSettings2.m_certNamesMismatch = true;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            } else if (0 == n) {
                sSLSettings2.m_certNamesMismatch = false;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            }
        } else if (variant2 != null) {
            block54: {
                try {
                    n = variant2.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block54;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "AllowAllHostNames", variant.getString(), "0 or 1"}));
                }
            }
            if (1 == n) {
                sSLSettings2.m_certNamesMismatch = true;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            } else if (0 == n) {
                sSLSettings2.m_certNamesMismatch = false;
                sSLSettings2.m_certNamesMismatchSpecifiedByUser = true;
            }
        } else if (null != sSLSettings) {
            sSLSettings2.m_certNamesMismatch = sSLSettings.m_certNamesMismatch;
        }
        sSLSettings2.m_hostNameInSAN = true;
        variant = connSettingRequestMap.getProperty(string + "SubjectAlternativeNamesHostNames");
        n = -1;
        if (variant != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "SubjectAlternativeNamesHostNames", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (0 == n) {
                sSLSettings2.m_hostNameInSAN = false;
            } else if (1 == n) {
                sSLSettings2.m_hostNameInSAN = true;
            }
        } else if (null != sSLSettings) {
            sSLSettings2.m_hostNameInSAN = sSLSettings.m_hostNameInSAN;
        }
    }
}

