/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.beans.ErrorHandlingCallback;
import com.install4j.api.beans.ErrorHandlingMode;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class HttpRequestHandler {
    public static final int MODE_GUI = 1;
    public static final int MODE_CONSOLE = 2;
    public static final int MODE_UNATTENDED = 3;
    public static final String SYSPROP_SHOW_CONNECT_ERROR = "install4j.showConnectError";
    private static final String SYSPROP_SHOW_PROXY_CONFIG = "install4j.showProxyConfig";
    private static final String SYSPROP_NO_PROXY_AUTO_DETECT = "install4j.noProxyAutoDetect";
    private static final String SYSPROP_NO_PROXY = "install4j.noProxy";
    private static final String SYSPROP_CONNECT_TIMEOUT = "install4j.connectTimeout";
    private static final String SYSPROP_INSTALL4J_READ_TIMEOUT = "install4j.readTimeout";
    private Context context;
    private boolean askForProxy = false;
    private ErrorHandlingCallback errorHandlingCallback;
    private boolean showProxyOnErrorCode = false;
    private boolean acceptAllCertificates = false;
    private URLConnection connection;
    private int mode;
    private ProxyHostInfo proxyHostInfo;
    private Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private boolean readResponse = true;
    private boolean readErrors = false;
    private volatile boolean canceled;
    private Window parentWindow;

    protected HttpRequestHandler(Context context) {
        this(context, context.isUnattended() ? 3 : (context.isConsole() ? 2 : 1));
    }

    protected HttpRequestHandler(Context context, int mode) {
        this.context = context;
        this.mode = mode;
    }

    public void cancel() {
        this.canceled = true;
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public void setAskForProxy(boolean askForProxy) {
        this.askForProxy = askForProxy;
    }

    public void setShowProxyOnErrorCode(boolean showProxyOnErrorCode) {
        this.showProxyOnErrorCode = showProxyOnErrorCode;
    }

    public void setErrorHandlingCallback(ErrorHandlingCallback errorHandlingCallback) {
        this.errorHandlingCallback = errorHandlingCallback;
    }

    public void setRequestHeaders(Map<String, List<String>> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setAcceptAllCertificates(boolean acceptAllCertificates) {
        this.acceptAllCertificates = acceptAllCertificates;
    }

    public void setReadResponse(boolean readResponse) {
        this.readResponse = readResponse;
    }

    protected boolean isReadResponse() {
        return this.readResponse;
    }

    public boolean isReadErrors() {
        return this.readErrors;
    }

    public void setReadErrors(boolean readErrors) {
        this.readErrors = readErrors;
    }

    protected Context getContext() {
        return this.context;
    }

    public HttpRequestHandler connect(String urlString) throws IOException, UserCanceledException {
        return this.connect(urlString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestHandler connect(String urlString, ConnectionPreparer connectionPreparer) throws IOException, UserCanceledException {
        URL url = new URL(urlString);
        Runnable resetter = this.maybeAcceptAllCertificates(url);
        try {
            this.connection = this.getURLConnection(url, connectionPreparer, this.showProxyOnErrorCode);
        }
        finally {
            if (resetter != null) {
                resetter.run();
            }
        }
        this.connectionInitialized(this.connection);
        if (this.isReadResponse()) {
            try {
                this.getUsedInputStream();
            }
            catch (IOException e) {
                String message;
                String string = message = this.proxyHostInfo == null ? "No auto-detected proxy was used" : "Auto-detected proxy was " + this.proxyHostInfo;
                if (this.context != null) {
                    ContextInt contextInt = ContextImpl.getContextInt(this.context);
                    if (contextInt != null) {
                        Logger.getInstance().info(contextInt.getEventSource(), message);
                    }
                } else if (Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR)) {
                    System.err.println(message);
                    System.err.println("proxySet = " + HelperCommunication.getUnelevatedBooleanProperty("proxySet"));
                    System.err.println("proxyHost = " + HelperCommunication.getUnelevatedBooleanProperty("proxyHost"));
                    System.err.println("proxyPort = " + HelperCommunication.getUnelevatedBooleanProperty("proxyPort"));
                }
                throw e;
            }
        }
        return this;
    }

    protected InputStream getUsedInputStream() throws IOException {
        URLConnection connection = this.connection;
        if (this.readErrors && connection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
            httpURLConnection.getResponseCode();
            InputStream stream = httpURLConnection.getErrorStream();
            if (stream == null) {
                stream = connection.getInputStream();
            }
            return stream;
        }
        return connection.getInputStream();
    }

    private Runnable maybeAcceptAllCertificates(URL url) {
        if (!this.acceptAllCertificates || !Objects.equals(url.getProtocol(), "https")) {
            return null;
        }
        final SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        final HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Runnable(){

            @Override
            public void run() {
                HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
            }
        };
    }

    protected void connectionInitialized(URLConnection connection) {
    }

    public void disconnect() throws IOException {
        this.getUsedInputStream().close();
    }

    protected boolean isCancelled() {
        return this.context != null && this.context.isCancelling() || this.canceled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URLConnection getURLConnection(URL url, ConnectionPreparer connectionPreparer, boolean showProxyOnErrorCode) throws IOException, UserCanceledException {
        if (!Boolean.getBoolean(SYSPROP_NO_PROXY)) {
            if (!HelperCommunication.getUnelevatedBooleanProperty(SYSPROP_NO_PROXY_AUTO_DETECT) && !HelperCommunication.getUnelevatedBooleanProperty(SYSPROP_SHOW_PROXY_CONFIG)) {
                this.proxyHostInfo = ProxyHelper.getProxyHostInfo(url);
                ProxyConfig.update(this.proxyHostInfo);
            } else {
                this.proxyHostInfo = null;
                ProxyConfig.setProperties();
            }
        }
        HttpAuthenticator.setRequestHandler(this);
        int redirectCount = 0;
        while (true) {
            if (this.context != null && this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                HttpURLConnection httpURLConnection;
                if (HelperCommunication.getUnelevatedBooleanProperty(SYSPROP_SHOW_PROXY_CONFIG)) {
                    HelperCommunication.setUnelevatedBooleanProperty(SYSPROP_SHOW_PROXY_CONFIG, false);
                    HelperCommunication.setUnelevatedBooleanProperty(SYSPROP_NO_PROXY_AUTO_DETECT, true);
                    this.askForProxyPassword();
                }
                URLConnection connection = url.openConnection();
                if (!Boolean.getBoolean("install4j.noClientHttpProperty")) {
                    connection.addRequestProperty("X-Client-Application", "install4j");
                }
                connection.setConnectTimeout(Integer.getInteger(SYSPROP_CONNECT_TIMEOUT, this.connectTimeout));
                connection.setReadTimeout(Integer.getInteger(SYSPROP_INSTALL4J_READ_TIMEOUT, this.readTimeout));
                ProxyConfig.updateConnection(connection);
                for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
                    String key = entry.getKey();
                    List<String> values = entry.getValue();
                    if (key.isEmpty()) continue;
                    for (String value : values) {
                        if (value.isEmpty()) continue;
                        connection.addRequestProperty(key, value);
                    }
                }
                String cookies = HelperCommunication.getUnelevatedProperty("install4j.cookies");
                if (cookies != null && !this.requestHeaders.containsKey("Cookie")) {
                    connection.setRequestProperty("Cookie", cookies);
                }
                connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64)");
                if (connectionPreparer != null) {
                    connectionPreparer.prepare(connection);
                }
                connection.connect();
                if (connection instanceof HttpURLConnection) {
                    httpURLConnection = (HttpURLConnection)connection;
                    int responseCode = httpURLConnection.getResponseCode();
                    if (responseCode == 302 || responseCode == 301) {
                        if (redirectCount++ < 5) {
                            url = new URL(httpURLConnection.getHeaderField("Location"));
                            continue;
                        }
                        System.err.println("Too many redirects");
                    }
                    if (showProxyOnErrorCode && this.askForProxy && this.mode != 3 && responseCode / 200 != 1) {
                        throw new IOException();
                    }
                }
                if (!Boolean.getBoolean(SYSPROP_SHOW_CONNECT_ERROR) || !(connection instanceof HttpURLConnection)) return connection;
                httpURLConnection = (HttpURLConnection)connection;
                System.err.println("response code = " + httpURLConnection.getResponseCode());
                System.err.println("response message = " + httpURLConnection.getResponseMessage());
                System.err.println("header fields = " + httpURLConnection.getHeaderFields());
                return connection;
            }
            catch (FileNotFoundException | SSLHandshakeException e) {
                throw e;
            }
            catch (IOException | IllegalArgumentException e) {
                if (!this.handleProxyFailure(url, e)) throw e;
                continue;
            }
            break;
        }
    }

    private boolean handleProxyFailure(URL url, Exception e) throws IOException, UserCanceledException {
        ErrorHandlingMode errorHandlingMode;
        String host;
        if (e != null && Boolean.getBoolean("install4j.logProxyException")) {
            Logger.getInstance().log(e);
        }
        if ((host = url.getHost()).equals("localhost") || host.equals("127.0.0.1")) {
            return false;
        }
        if (!ProxyConfig.isProxySet() && ProxyConfig.getHost().length() > 0) {
            ProxyConfig.setProxySet(true);
            ProxyConfig.setProperties();
            return true;
        }
        if (ProxyConfig.shouldTrySavedValues()) {
            ProxyConfig.applySavedValues();
            return true;
        }
        if (this.errorHandlingCallback != null && (errorHandlingMode = this.errorHandlingCallback.errorOccurred(e)) != null) {
            switch (errorHandlingMode) {
                case CANCEL: {
                    return false;
                }
                case RETRY: {
                    return true;
                }
            }
        }
        if (this.mode == 3 || !this.askForProxy) {
            return false;
        }
        ProxyConfig.show(this.mode == 2, false, this.parentWindow);
        if (ProxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
        return true;
    }

    public void askForProxyPassword() throws IOException, UserCanceledException {
        if (this.mode == 3 && HelperCommunication.getUnelevatedProperty("proxyAuthPassword") != null) {
            return;
        }
        if (this.mode == 3 || !this.askForProxy) {
            throw new IOException(Messages.getMessages().getString("ProxyPasswordRequired"));
        }
        ProxyConfig.show(this.mode == 2, true, this.parentWindow);
        if (ProxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setParentWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
    }

    public static interface ConnectionPreparer {
        public void prepare(URLConnection var1) throws IOException;
    }
}

