/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.framework.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class CommonStringUtil {
    public static String decapitalizeFirstLetter(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string.toLowerCase();
        }
        if (Character.isUpperCase(string.charAt(0)) && Character.isLowerCase(string.charAt(1))) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(Character.toLowerCase(string.charAt(0)));
            buffer.append(string.substring(1));
            return buffer.toString();
        }
        return string;
    }

    public static String removePrefix(String string, String prefix) {
        if (string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String wrapString(String string, int maxLength, String prepend) {
        return CommonStringUtil.wrapString(string, maxLength, prepend, true);
    }

    public static String wrapString(String string, int maxLength, String prepend, boolean prependFirst) {
        if (prepend == null) {
            prepend = "";
        }
        StringBuilder output = new StringBuilder(prependFirst ? prepend : "");
        StringTokenizer tokenizer = new StringTokenizer(string, " ," + File.pathSeparator, true);
        int lineLength = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            do {
                if (lineLength + token.length() > maxLength) {
                    if (lineLength < maxLength / 2) {
                        output.append(token, 0, maxLength - lineLength);
                        token = token.substring(maxLength - lineLength);
                    }
                    output.append('\n');
                    output.append(prepend);
                    lineLength = 0;
                    continue;
                }
                if (lineLength == 0) {
                    token = token.trim();
                }
                output.append(token);
                lineLength += token.length();
                token = null;
            } while (token != null);
        }
        return output.toString();
    }

    public static String ellipse(String text, int maxLength) {
        int length = text.length();
        if (length <= maxLength) {
            return text;
        }
        int deltaLeft = (length - (maxLength -= 3)) / 2;
        int deltaRight = length - maxLength - deltaLeft;
        StringBuilder buffer = new StringBuilder();
        buffer.append(text, 0, length / 2 - deltaLeft);
        buffer.append("...");
        buffer.append(text.substring(length / 2 + deltaRight));
        return buffer.toString();
    }

    public static String capitalizeFirstLetter(String string) {
        if (string == null) {
            return null;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(Character.toUpperCase(string.charAt(0)));
        buffer.append(string.substring(1));
        return buffer.toString();
    }

    public static String ellipseFileName(File file, int maxLength) {
        ArrayList<String> components = new ArrayList<String>();
        for (File currentFile = file; currentFile != null; currentFile = currentFile.getParentFile()) {
            String name = currentFile.getName();
            if (name.length() == 0) {
                name = currentFile.getPath();
            }
            if (name.endsWith(File.separator)) {
                name = name.substring(0, name.length() - File.separator.length());
            }
            components.add(name);
        }
        Collections.reverse(components);
        boolean[] included = new boolean[components.size()];
        int length = 0;
        int leftIndex = 0;
        for (int rightIndex = components.size() - 1; leftIndex <= rightIndex; ++leftIndex, --rightIndex) {
            included[leftIndex] = true;
            if ((length += ((String)components.get(leftIndex)).length() + 1) > maxLength && leftIndex > 0 || leftIndex == rightIndex) break;
            included[rightIndex] = true;
            length += ((String)components.get(rightIndex)).length() + 1;
        }
        StringBuilder buffer = new StringBuilder();
        boolean ellipsePrinted = false;
        for (int i = 0; i < included.length; ++i) {
            if (included[i]) {
                if (i > 0) {
                    buffer.append(File.separator);
                }
                buffer.append((String)components.get(i));
                continue;
            }
            if (ellipsePrinted) continue;
            buffer.append(File.separator);
            buffer.append("...");
            ellipsePrinted = true;
        }
        return buffer.toString();
    }

    public static List<String> splitupCommandLine(String command) {
        ArrayList<String> cmdList = new ArrayList<String>();
        CommonStringUtil.splitupQuotedList(cmdList, command, " ");
        return cmdList;
    }

    public static void splitupCommandLine(List<String> cmdList, String command) {
        CommonStringUtil.splitupQuotedList(cmdList, command, " ");
    }

    public static void splitupQuotedList(List<String> list, String line, String delimiter) {
        ArrayList<SplitEntry> entryList = new ArrayList<SplitEntry>();
        CommonStringUtil.splitupToEntries(entryList, line, delimiter);
        for (SplitEntry splitEntry : entryList) {
            list.add(splitEntry.value);
        }
    }

    public static List<SplitEntry> splitupCommandLineToEntries(String command) {
        ArrayList<SplitEntry> cmdList = new ArrayList<SplitEntry>();
        CommonStringUtil.splitupToEntries(cmdList, command, " ");
        return cmdList;
    }

    public static void splitupToEntries(List<SplitEntry> list, String line, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(line, delimiter + "\"", true);
        boolean insideQuotes = false;
        StringBuilder argument = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\"")) {
                if (insideQuotes && argument.length() > 0) {
                    list.add(new SplitEntry(true, argument.toString()));
                    argument.setLength(0);
                }
                insideQuotes = !insideQuotes;
                continue;
            }
            if (delimiter.contains(token)) {
                if (insideQuotes) {
                    argument.append(delimiter);
                    continue;
                }
                if (argument.length() <= 0) continue;
                list.add(new SplitEntry(false, argument.toString()));
                argument.setLength(0);
                continue;
            }
            argument.append(token);
        }
        if (argument.length() > 0) {
            list.add(new SplitEntry(false, argument.toString()));
        }
    }

    public static class SplitEntry {
        private boolean quoted;
        private String value;

        public SplitEntry(boolean quoted, String value) {
            this.quoted = quoted;
            this.value = value;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "SplitEntry{quoted=" + this.quoted + ", value='" + this.value + '\'' + '}';
        }
    }
}

