/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ChaCha20_encoder;
import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectFailed;
import com.exasol.jdbc.ConnectRefused;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DialectFactory;
import com.exasol.jdbc.DialectGeneric;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADatabaseMetaData;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAPooledConnection;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStillExecuting;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.EncryptedOutputStream;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.GSSAuthentication;
import com.exasol.jdbc.Header;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.LoaderException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.Protocol;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.RC4_encoder;
import com.exasol.jdbc.RSA_encoder;
import com.exasol.jdbc.RecoverableOperation;
import com.exasol.jdbc.RollbackException;
import com.exasol.jdbc.SSPIClient;
import com.exasol.jdbc.SchemaEvent;
import com.exasol.jdbc.SchemaListener;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.StreamEncoder;
import com.exasol.jdbc.TimeoutException;
import com.exasol.jdbc.Translator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Executor;

public abstract class AbstractEXAConnection
extends ServerCommunication
implements Connection,
Protocol {
    Properties clientInfo = new Properties();
    private boolean isSlaveNode = false;
    private long slaveToken = 0L;
    public static final String HIBERNATE = "hibernate";
    private static final String SYSSCHEMA_NEW = "\"$ODBCJDBC\"";
    private static final boolean AUTOCOMMIT_DEFAULT = true;
    private static final boolean SUPERCONNECTION_DEFAULT = false;
    private static final String CLIENT_NAME_DEFAULT = "Generic JDBC client";
    private int lastSerialNumber = 0;
    private static final int MAX_ATTRIBS = 1000;
    private int connectTimeout = 2000;
    private int feedbackInterval = -1;
    public static int defaultFeedbackInterval = 30;
    private int maxIdentifierLen = 128;
    private boolean snapshotTransactions = false;
    private byte[] kerberosToken = null;
    private String encoding = "utf-8";
    private int executionMode = 0;
    private DatabaseMetaData metadata;
    protected String exaServer;
    protected int exaPort;
    protected Vector clusterNodes;
    private String user;
    private String password;
    private Header lastHeader;
    private String currentCatalog = null;
    private int transactionIsolation;
    protected Socket csocket;
    protected InputStream from_database;
    protected EXAOutputStream to_database;
    private boolean vmuMode = false;
    private Properties connectionParam;
    boolean connected = false;
    boolean wasDisconnected = false;
    private int responseTimeout = 0;
    private int queryTimeout = 0;
    public static boolean defaultEncryptionEnabled = true;
    private boolean encryptionEnabled = defaultEncryptionEnabled;
    private StreamEncoder encryptor = null;
    private boolean encryptionRequired = false;
    public static int defaultDriverProtocollVersion = 15;
    private long maxMessageSize = 0x4000000L;
    private String kerberosServiceName = null;
    private String kerberosHostName = null;
    private String kerberosUserName = null;
    private String kerberosConfigFile = null;
    private String kerberosGssConfigFile = null;
    private String kerberosRealm = null;
    private String kerberosTargetName = null;
    private final int notSpecified = 0;
    private final int useSSPI = 1;
    private final int useGSSAPI = 2;
    private int loginType = 0;
    private boolean kerberosLogin = false;
    EXAPooledConnection connectionPool = null;
    private String connectionStatus = null;
    protected static boolean schemaChanged = false;
    private int activeProtocolVersion = defaultDriverProtocollVersion;
    private String dateFormat;
    private String timestampFormat;
    private String dateLanguage;
    private String currentSchema;
    private String databaseName;
    private String databaseProductName;
    private String databaseProductVersion;
    private String numericCharacters;
    private long sessionID = -1L;
    private byte[] publicKey;
    private byte[] randomPhrase;
    private byte[] encodedPwd;
    static final int _defaultFetchSize = 2000;
    private int defaultFetchSize = 2000;
    static final int defaultConnectTimeout = 2000;
    private Map typeMap = null;
    private SQLWarning warnings;
    private HashMap attributes;
    private String sysSchema;
    private int reconnectCount = 0;
    private static final int maxReconnects = 1;
    static final int exa_so_timeout = 10000;
    static final int network_retrys = 100000;
    private List schemaListeners = null;
    public boolean hibernate = false;
    DialectFactory dialectFactory = new DialectGeneric();
    private int[] slavePorts = null;
    private String[] slaveHosts = null;
    private boolean commandWasEnterParallel = false;

    public boolean isSlaveConnection() {
        return this.isSlaveNode;
    }

    protected long GetMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setPool(EXAPooledConnection eXAPooledConnection) {
        this.connectionPool = eXAPooledConnection;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public boolean getSchemaMayHaveChanged() {
        return schemaChanged;
    }

    public void setSchemaMayHaveChanged() {
        schemaChanged = true;
    }

    public int getMaxIdentifierLen() {
        return this.maxIdentifierLen;
    }

    public void metadataAcquired() {
        schemaChanged = false;
    }

    public Vector getNodes() {
        return this.clusterNodes;
    }

    public boolean IsEncrypted() {
        return this.encryptionEnabled;
    }

    @Override
    public synchronized boolean isValid(int n) throws SQLException {
        block11: {
            if (!this.connected) {
                return false;
            }
            int n2 = this.responseTimeout;
            if (0 != n) {
                this.responseTimeout = n;
            }
            try {
                if (this.activeProtocolVersion < 14) {
                    Statement statement = this.createStatement();
                    statement.executeUpdate("/*EXAConnection.isValid(" + n + ")*/");
                    statement.close();
                    break block11;
                }
                EXAResult[] eXAResultArray = this.communication_resultset(new byte[0], (byte)70, new ExecutionStatus());
                if (eXAResultArray != null && eXAResultArray.length > 0) {
                    if (eXAResultArray[0] instanceof EXASQLException) {
                        throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern((EXAConnection)this);
                    }
                    break block11;
                }
                throw new IOException("No vaild response from server, connection is not open");
            }
            catch (Exception exception) {
                this.connected = false;
                SQLException sQLException = exception instanceof SQLException ? (SQLException)exception : new SQLException(exception.getMessage());
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(sQLException);
                }
                throw sQLException;
            }
            finally {
                this.responseTimeout = n2;
            }
        }
        return this.connected;
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties) throws SQLException {
        this(string, n, string2, string3, debugLog, properties, null);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3) throws SQLException {
        this(string, n, string2, string3, null, new Properties(), null);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog) throws SQLException {
        this(string, n, string2, string3, debugLog, new Properties(), null);
    }

    public AbstractEXAConnection(Vector vector, String string, String string2, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        super(debugLog, "EXAConnection", null);
        this.Connect(vector, string, string2, debugLog, properties, hashMap);
    }

    public AbstractEXAConnection(String string, int n, String string2, String string3, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        super(debugLog, "EXAConnection", null);
        Vector<ClusterNode> vector = new Vector<ClusterNode>();
        vector.add(new ClusterNode(string, n));
        this.Connect(vector, string2, string3, debugLog, properties, hashMap);
    }

    @Override
    public void clearWarnings() {
        this.log("clearWarnings");
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeBase() throws SQLException {
        try {
            if (this.wasDisconnected) {
                this.log(" Info: this connection was allready disconnected, exiting close()");
                return;
            }
            boolean bl = trace_exception;
            trace_exception = false;
            try {
                this.communication(null, 0, (byte)32, this.isSlaveNode ? 0 : this.responseTimeout + this.connectTimeout, new ExecutionStatus());
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            try {
                this.csocket.close();
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            trace_exception = bl;
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            this.connected = false;
            this.wasDisconnected = true;
            this.reconnectCount = 1;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("EXAConnection.close()", 0);
        if (this.connectionPool != null) {
            this.log(" Closing a connection from the pool: make it available for reuse.");
            this.connectionPool.free();
            return;
        }
        this.closeBase();
    }

    protected void abort() {
        try {
            this.closeAbort(false);
        }
        catch (Exception exception) {
            this.log("Exception in abort(): " + exception);
        }
        this.wasDisconnected = true;
        if (this.connectionPool != null) {
            try {
                this.connectionPool.close();
            }
            catch (Exception exception) {
                this.log("Exception in abort() in connectionPool.close(): " + exception);
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        AbortCommand abortCommand = new AbortCommand();
        if (executor != null) {
            executor.execute(abortCommand);
        } else {
            abortCommand.run();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAbort(boolean bl) throws SQLException {
        try {
            this.log("closing socket ...", 0);
            if (this.wasDisconnected) {
                this.log(" Info: this connection was allready disconnected, exiting closeAbort()");
                return;
            }
            boolean bl2 = trace_exception;
            trace_exception = false;
            try {
                this.csocket.close();
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            trace_exception = bl2;
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            if (!bl) {
                this.connected = false;
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(null);
                }
            }
        }
    }

    protected void closeSocket() throws SQLException {
        boolean bl = trace_exception;
        trace_exception = false;
        if (this.csocket == null) {
            return;
        }
        try {
            this.csocket.close();
        }
        catch (Exception exception) {
            this.log(exception.toString(), 0);
        }
        trace_exception = bl;
        this.csocket = null;
        this.connected = false;
        if (this.connectionPool != null) {
            this.connectionPool.connectionError(null);
        }
        this.wasDisconnected = true;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.log("commit", 1);
        this.log("createStatement to execute commit");
        Statement statement = this.createStatement();
        statement.executeUpdate("/*EXAConnection.commit()*/ commit;");
        statement.close();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.log("createStatement()", 1);
        if (this.wasDisconnected) {
            this.log("   connection was already disconnected!", 1);
            throw new SQLException("No operations allowed on this connection because it was already closed.");
        }
        return this.dialectFactory.createStatement((EXAConnection)this);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.log("createStatement()", 1);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, n, n2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.log("createStatement()", 1);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, n, n2);
    }

    @Override
    public boolean getAutoCommit() {
        boolean bl = this.getBooleanParameter("autocommit", true);
        this.log("EXAConnection.getAutoCommit(): " + bl);
        return bl;
    }

    public boolean isSuperConnection() {
        boolean bl = this.getBooleanParameter("superconnection", false);
        this.log("EXAConnection.SUPERCONNECTION_DEFAULT(): " + bl);
        return bl;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.log("getCatalog(): " + this.currentCatalog, 1);
        return this.currentCatalog;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.log("getMetaData() - connection meta data");
        if (this.metadata == null) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
        }
        return this.metadata;
    }

    public DatabaseMetaData recreateMetaData() throws SQLException {
        this.metadata = this.IsConnected() ? new EXADatabaseMetaData((EXAConnection)this, this.debug) : null;
        return this.metadata;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public Map getTypeMap() throws SQLException {
        this.log("getTypeMap()", 0);
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        this.log("isClosed:" + (this.csocket == null), 3);
        if (this.connectionPool != null && !this.connectionPool.isOccupied()) {
            return true;
        }
        return this.csocket == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.log("isReadOnly()", 0);
        return false;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.log("prepareCall(" + string + ")", 0);
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.log("prepareCall(" + string + "," + n + "," + n2 + ")", 0);
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.log("prepareCall(" + string + "," + n + "," + n2 + "," + n3 + ")", 0);
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.log("prepareStatement(" + string + ")", 0);
        return this.dialectFactory.createPreparedStatement(string, (EXAConnection)this);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.log("prepareStatement(" + string + "," + n + "," + n2 + ")", 0);
        if (n2 != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.prepareStatement(string);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.log("prepareStatement(" + string + "," + nArray + ")", 0);
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(sql,int[])");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.log("prepareStatement(" + string + "," + stringArray + ")", 0);
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String,String[])");
    }

    public String getHostsList() {
        String string = "";
        for (int i = 0; i < this.clusterNodes.size(); ++i) {
            string = string + ((ClusterNode)this.clusterNodes.get(i)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(i)).GetPort();
            if (i >= this.clusterNodes.size() - 1) continue;
            string = string + ",";
        }
        return string;
    }

    private void Connect(Vector vector, String string, String string2, DebugLog debugLog, Properties properties, HashMap hashMap) throws SQLException {
        int n;
        this.log("Connect()");
        this.warnings = null;
        this.connection = (EXAConnection)this;
        this.clusterNodes = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            ClusterNode clusterNode = new ClusterNode(((ClusterNode)vector.get(n)).GetHost(), ((ClusterNode)vector.get(n)).GetPort());
            clusterNode.UnMark();
            this.clusterNodes.add(clusterNode);
        }
        n = this.clusterNodes.size();
        this.connectionParam = (Properties)properties.clone();
        Properties properties2 = (Properties)properties.clone();
        if (properties2.getProperty("password") != null && !properties2.getProperty("password").equals("")) {
            properties2.setProperty("password", "*****");
        }
        this.log("Connect connection param: " + properties2.toString());
        if (this.getParameter("TestConnectionStringOnly") != null && this.getParameter("TestConnectionStringOnly").equals("1")) {
            return;
        }
        if (this.getParameter("slave") != null && this.getParameter("slave").equals("1")) {
            this.isSlaveNode = true;
        }
        if (this.getParameter("slavetoken") != null) {
            this.slaveToken = new Long(this.getParameter("slavetoken"));
        }
        if (this.isSlaveNode && this.slaveToken == 0L) {
            throw new ConnectFailed(Translator.Slave_connection_needs_token());
        }
        Random random = new Random(System.currentTimeMillis());
        SQLException sQLException = new ConnectRefused(Translator.Connection_refused());
        while (true) {
            block29: {
                int n2;
                try {
                    n2 = random.nextInt(this.clusterNodes.size());
                }
                catch (Exception exception) {
                    throw new SQLException(exception.toString());
                }
                if (((ClusterNode)this.clusterNodes.get(n2)).IsMarked()) continue;
                --n;
                ((ClusterNode)this.clusterNodes.get(n2)).Mark();
                InetAddress[] inetAddressArray = null;
                try {
                    inetAddressArray = InetAddress.getAllByName(((ClusterNode)this.clusterNodes.get(n2)).GetHost());
                }
                catch (UnknownHostException unknownHostException) {
                    sQLException = new ConnectFailed(Translator.Unknown_host_name() + unknownHostException.getMessage());
                    break block29;
                }
                for (InetAddress inetAddress : inetAddressArray) {
                    this.exaServer = inetAddress.getHostAddress();
                    this.log("EXAServer " + this.exaServer);
                    this.exaPort = ((ClusterNode)this.clusterNodes.get(n2)).GetPort();
                    this.log("EXAPort " + this.exaPort);
                    this.log("new EXAConnection: " + this.exaServer + ":" + this.exaPort + " User: " + string);
                    this.user = string;
                    this.password = string2;
                    this.connectionParam = (Properties)properties.clone();
                    if (this.getParameter("TestConnectionStringOnly") != null && this.getParameter("TestConnectionStringOnly").equals("1")) {
                        return;
                    }
                    this.currentSchema = this.getParameter("schema");
                    this.transactionIsolation = 8;
                    this.defaultFetchSize = this.getIntParameter("fetchsize", 2000);
                    if (this.defaultFetchSize <= 0) {
                        this.log("Connect(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size remains: " + 2000);
                        this.defaultFetchSize = 2000;
                    }
                    this.connectTimeout = this.getIntParameter("connecttimeout", 2000);
                    if (this.connectTimeout < 0 || this.connectTimeout >= 2147483) {
                        this.connectTimeout = 0;
                    }
                    this.responseTimeout = this.getIntParameter("logintimeout", 0);
                    this.responseTimeout = this.responseTimeout < 0 || this.responseTimeout >= 2147483 ? 0 : (this.responseTimeout *= 1000);
                    this.encryptionEnabled = this.getBooleanParameter("encryption", true);
                    this.queryTimeout = this.getIntParameter("querytimeout", 0);
                    this.kerberosServiceName = this.getStringParameter("kerberosservicename", null);
                    this.kerberosHostName = this.getStringParameter("kerberoshostname", null);
                    this.kerberosRealm = this.getStringParameter("kerberosrealm", null);
                    this.kerberosUserName = this.getStringParameter("kerberosusername", null);
                    this.kerberosConfigFile = this.getStringParameter("kerberosconfig", null);
                    this.kerberosGssConfigFile = this.getStringParameter("kerberosgssconfig", null);
                    this.loginType = this.getIntParameter("loginType", 0);
                    if (this.kerberosServiceName != null && this.kerberosHostName == null) {
                        this.kerberosHostName = new String(this.exaServer);
                    }
                    if (this.kerberosServiceName == null && this.kerberosHostName != null) {
                        this.kerberosServiceName = new String("exasol");
                    }
                    this.kerberosLogin = this.kerberosServiceName != null || this.kerberosHostName != null;
                    if (this.kerberosLogin && null != this.user && null == this.kerberosUserName) {
                        this.kerberosUserName = this.user;
                    }
                    if (null != this.user && this.user.startsWith("Kerberos:")) {
                        this.kerberosTargetName = this.user.replaceFirst("Kerberos:", "");
                        this.kerberosLogin = true;
                    }
                    if (null == this.kerberosUserName) {
                        this.kerberosUserName = System.getProperty("user.name");
                    }
                    this.log("kerberosUserName = " + this.kerberosUserName);
                    this.log("kerberosServiceName = " + this.kerberosServiceName);
                    this.log("kerberosHostName = " + this.kerberosHostName);
                    this.log("kerberosLogin = " + this.kerberosLogin);
                    this.log("activeProtocolVersion = " + this.getActiveProtocolVersion());
                    this.log("kerberosConfigFile = " + this.kerberosConfigFile);
                    this.log("kerberosGssConfigFile = " + this.kerberosGssConfigFile);
                    this.log("kerberosTargetName = " + this.kerberosTargetName);
                    if (this.getActiveProtocolVersion() < 15) {
                        this.kerberosLogin = false;
                    }
                    try {
                        this.setupConnection(false, hashMap);
                    }
                    catch (ConnectRefused connectRefused) {
                        sQLException = connectRefused;
                        this.closeSocket();
                        this.log("Connection refused to " + this.exaServer + ":" + this.exaPort + " - " + connectRefused.toString());
                    }
                    catch (TimeoutException timeoutException) {
                        sQLException = timeoutException;
                        this.closeSocket();
                        this.log("Connection attempt timed out on " + this.exaServer + ":" + this.exaPort + " - " + timeoutException.toString());
                    }
                    catch (ConnectFailed connectFailed) {
                        sQLException = connectFailed;
                        this.closeSocket();
                        this.log("Connection failed to " + this.exaServer + ":" + this.exaPort + " - " + connectFailed.toString());
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                        this.closeSocket();
                        this.log("Connection exception from " + this.exaServer + ":" + this.exaPort + " - " + sQLException2.toString());
                        throw sQLException2;
                    }
                    if (!this.IsConnected()) continue;
                    try {
                        this.schemaListeners = (List)Class.forName("ArrayList").newInstance();
                    }
                    catch (Exception exception) {
                        this.schemaListeners = new Vector();
                    }
                    break;
                }
            }
            if (0 >= n || this.IsConnected()) break;
        }
        if (0 == n && !this.IsConnected()) {
            this.closeSocket();
            throw sQLException;
        }
        this.wasDisconnected = false;
    }

    private boolean IsConnected() {
        return this.connected;
    }

    public void addSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.add(schemaListener);
        }
    }

    public void removeSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.remove(schemaListener);
        }
    }

    public void fireSchemaChanged(String string, String string2) {
        if (null == this.schemaListeners) {
            return;
        }
        if (this.schemaListeners.isEmpty()) {
            return;
        }
        SchemaEvent schemaEvent = new SchemaEvent((EXAConnection)this, string, string2);
        for (int i = 0; i < this.schemaListeners.size(); ++i) {
            ((SchemaListener)this.schemaListeners.get(i)).schemaChanged(schemaEvent);
        }
    }

    private void setupConnection(boolean bl, HashMap hashMap) throws SQLException {
        this.log("setupConnection(" + bl + ")");
        this.attributes = this.setDefaultAttributes(bl, hashMap);
        this.connected = false;
        do {
            try {
                this.activeProtocolVersion = defaultDriverProtocollVersion;
                this.connectAndLogin(bl, this.exaServer, this.exaPort);
                this.connected = true;
            }
            catch (ConnectionLost connectionLost) {
                this.closeSocket();
                throw connectionLost;
            }
            catch (IOException iOException) {
                if (trace_exception) {
                    iOException.printStackTrace();
                }
                this.log("IOException for " + this.exaServer + ":" + this.exaPort + iOException.toString(), 0);
                if (iOException instanceof UnknownHostException) {
                    this.closeSocket();
                    throw new ConnectFailed(Translator.Unknown_host_name() + iOException.getMessage());
                }
                this.closeSocket();
                throw new ConnectFailed(iOException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.connected = false;
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(protocolException);
                }
                this.log("ProtocolException from " + this.exaServer + ":" + this.exaPort + " - " + protocolException.getMessage());
                if (0 == protocolException.getMessage().compareTo(Translator.To_create_an_encrypted_connection_the_server_must_be_at_least_5_0())) {
                    throw protocolException;
                }
                throw new ProtocolException(Translator.Connection_refused());
            }
            catch (SQLException sQLException) {
                if (trace_exception) {
                    sQLException.printStackTrace();
                }
                this.log("Exception for \" + exaServer + \":\" + exaPort" + sQLException.toString(), 0);
                if (this.csocket != null && (sQLException instanceof SQLInvalidAuthorizationSpecException || sQLException instanceof ConnectRefused || sQLException instanceof ConnectionLost || sQLException instanceof TimeoutException)) {
                    throw sQLException;
                }
                this.addWarning(sQLException);
                this.connected = true;
            }
        } while (!this.connected);
        if (!bl) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
            if (this.getActiveProtocolVersion() < 14) {
                try {
                    if (this.currentSchema != null && this.currentSchema.length() > 0) {
                        this.setSchema(this.currentSchema);
                    }
                }
                catch (SQLException sQLException) {
                    this.log("Error in EXAConnection - failed to open default schema, aborting. " + sQLException.toString(), 0);
                    this.close();
                    throw sQLException;
                }
            }
        }
    }

    private void addWarning(SQLException sQLException) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(sQLException.getMessage() + " (SessionID: " + this.getSessionID() + ")", sQLException.getSQLState());
        } else {
            this.warnings.setNextWarning(new SQLWarning(sQLException.getMessage(), sQLException.getSQLState()));
        }
    }

    protected int getDefaultFetchSize() {
        if (this.defaultFetchSize <= 0) {
            if (this.debug != null) {
                this.log("getDefaultFetchSize(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size will be set to connection default: " + 2000);
            }
            this.defaultFetchSize = 2000;
        }
        return this.defaultFetchSize;
    }

    protected String getParameter(String string) {
        Object object;
        String string2 = null;
        if (this.connectionParam != null && (object = this.connectionParam.get(string)) != null) {
            string2 = object.toString();
        }
        if (string2 != null && string2 != "") {
            this.log(" getParameter(" + string + "): " + string2);
        }
        return string2;
    }

    protected String getStringParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null || string3 == "") {
            return string2;
        }
        return string3;
    }

    private boolean getBooleanParameter(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        return !"0".equals(string2) && !"false".equalsIgnoreCase(string2);
    }

    private int getIntParameter(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + string + "\"");
            }
        }
        return n;
    }

    private long getLongParameter(String string, long l) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + string + "\"");
            }
        }
        return l;
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute) {
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute);
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute, Object object) {
        ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(protocolAttribute.id);
        protocolAttribute2.value = object;
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute2);
    }

    private final void putAttribute(HashMap hashMap, ProtocolAttribute protocolAttribute, Object object, int n) {
        ProtocolAttribute protocolAttribute2 = new ProtocolAttribute(protocolAttribute.id);
        protocolAttribute2.value = object;
        protocolAttribute2.binaryLength = n;
        hashMap.put(new Short(protocolAttribute.id), protocolAttribute2);
    }

    private HashMap setDefaultAttributes(boolean bl, HashMap hashMap) throws SQLException {
        Object object;
        HashMap<Short, ProtocolAttribute> hashMap2 = new HashMap<Short, ProtocolAttribute>();
        if (this.kerberosLogin) {
            object = new ProtocolAttribute(ProtocolAttribute.ATTR_KERBEROS_TICKET.id);
            ((ProtocolAttribute)object).value = null;
            ((ProtocolAttribute)object).binaryLength = 0;
            this.putAttribute(hashMap2, (ProtocolAttribute)object);
        } else {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_USERNAME, this.user);
        }
        if (this.getActiveProtocolVersion() >= 14 && null != this.currentSchema && !bl) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CURRENT_SCHEMA, this.currentSchema);
        }
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_DRIVERNAME, EXADriver.getEXADriverName());
        if (this.slaveToken != 0L) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_PARALLEL_TOKEN, this.slaveToken);
        }
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_LANGUAGE, Locale.getDefault().getLanguage());
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_RELEASE_VERSION, EXADriver.getVersionInfo());
        object = this.connectionParam.getProperty("clientname", CLIENT_NAME_DEFAULT);
        this.setClientInfoBase("clientname", (String)object, false);
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTNAME, this.getClientInfo("clientname"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTNAME, object);
        object = this.connectionParam.getProperty("clientversion", "unknown");
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTVERSION, object);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("os.name", "unknown os"));
        stringBuffer.append(" - ");
        stringBuffer.append(System.getProperty("os.version", "unknown version"));
        stringBuffer.append(" - ");
        stringBuffer.append(System.getProperty("os.arch", "unknown arch"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTOS, stringBuffer.toString());
        object = System.getProperty("user.name");
        if (object != null) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTOS_USERNAME, object);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(System.getProperty("java.vendor"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.version"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.vm.name"));
        stringBuffer2.append(" - ");
        stringBuffer2.append(System.getProperty("java.vm.info"));
        this.putAttribute(hashMap2, ProtocolAttribute.ATTR_CLIENTRUNTIME, stringBuffer2.toString());
        if (bl) {
            if (-1L == this.sessionID) {
                throw new SQLException(Translator.Connection_was_lost_and_reconnect_could_not_restore_the_session());
            }
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_SESSIONID, new Long(this.sessionID));
        } else {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
            protocolAttribute.value = new Boolean(this.getAutoCommit());
            hashMap2.put(new Short(protocolAttribute.id), protocolAttribute);
        }
        if (this.isSuperConnection()) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_SUPER_CONNECTION, new Boolean(true));
        }
        this.feedbackInterval = this.getIntParameter("feedbackinterval", -1);
        if (-1 != this.feedbackInterval) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_FEEDBACK_INTERVAL, new Integer(this.feedbackInterval));
        }
        this.queryTimeout = this.getIntParameter("querytimeout", -1);
        if (-1 != this.queryTimeout) {
            this.putAttribute(hashMap2, ProtocolAttribute.ATTR_QUERY_TIMEOUT, new Integer(this.queryTimeout));
        } else {
            this.queryTimeout = 0;
        }
        if (hashMap != null) {
            hashMap2.putAll(hashMap);
        }
        return hashMap2;
    }

    private void setClientInfoBase(String string, String string2, boolean bl) throws SQLClientInfoException {
        if (string.equals("clientname")) {
            this.clientInfo.setProperty(string, string2);
            if (bl) {
                try {
                    this.setClientName(string2);
                }
                catch (SQLException sQLException) {
                    SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
                    sQLClientInfoException.initCause(sQLException);
                    throw sQLClientInfoException;
                }
            }
        } else {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            hashMap.put(string, ClientInfoStatus.REASON_UNKNOWN);
            sQLClientInfoException.initCause(new SQLClientInfoException("Client info name not known: " + string + " ", hashMap));
            throw sQLClientInfoException;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.setClientInfoBase(string, string2, true);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setClientInfo(string, properties.getProperty(string));
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this.clientInfo.getProperty(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    public int[] GetSlavePorts() {
        String string = "";
        if (this.slavePorts != null) {
            for (int i = 0; i < this.slavePorts.length; ++i) {
                string = string + this.slavePorts[i] + (i == this.slavePorts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetSlavePorts() - " + string);
        return this.slavePorts;
    }

    public String[] GetSlaveHosts() {
        String string = "";
        if (this.slaveHosts != null) {
            for (int i = 0; i < this.slaveHosts.length; ++i) {
                string = string + this.slaveHosts[i] + (i == this.slaveHosts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetSlaveHosts() - " + string);
        return this.slaveHosts;
    }

    public long GetSlaveToken() {
        return this.slaveToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int EnterParallel(int n) throws SQLException {
        try {
            int n2;
            Object object;
            this.commandWasEnterParallel = true;
            int n3 = 0;
            ExecutionStatus executionStatus = new ExecutionStatus();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
            try {
                eXAOutputStream.writeInt(n);
                object = InetAddress.getByName(this.exaServer).getHostAddress();
                eXAOutputStream.writeInt(((String)object).getBytes(this.connection.getEncoding()).length);
                eXAOutputStream.write(((String)object).getBytes(this.connection.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new SQLException(iOException.getMessage());
            }
            object = byteArrayOutputStream.toByteArray();
            byte[] byArray = this.communication((byte[])object, object != null ? ((Object)object).length : 0, (byte)30, 0, executionStatus);
            EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
            try {
                n3 = eXAInputStream.readInt();
                this.slaveToken = eXAInputStream.readLong();
                this.slavePorts = new int[n3];
                this.slaveHosts = new String[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.slavePorts[n2] = eXAInputStream.readInt();
                    int n4 = eXAInputStream.readInt();
                    byte[] byArray2 = new byte[n4];
                    eXAInputStream.read(byArray2);
                    this.slaveHosts[n2] = new String(byArray2, "UTF-8");
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            n2 = n3;
            return n2;
        }
        finally {
            this.commandWasEnterParallel = false;
        }
    }

    public synchronized ResultSet DescribeResult(int n) throws SQLException {
        ExecutionStatus executionStatus = new ExecutionStatus();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, this.connection);
        try {
            eXAOutputStream.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException(iOException.getMessage());
        }
        EXAResult[] eXAResultArray = this.connection.communication_resultset(byteArrayOutputStream.toByteArray(), (byte)31, executionStatus);
        this.connection.metadataAcquired();
        if (eXAResultArray != null && eXAResultArray.length > 0) {
            if (eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)eXAResultArray[0];
        }
        return null;
    }

    protected abstract Socket createSocket(String var1, int var2, int var3) throws IOException;

    public String getKerberosUserName() {
        return this.kerberosUserName;
    }

    public String getKerberosTargetNameSSPI() {
        String string = null;
        string = this.kerberosTargetName != null ? this.kerberosTargetName : (this.kerberosHostName != null && this.kerberosRealm != null ? this.kerberosServiceName + "/" + this.kerberosHostName + "@" + this.kerberosRealm : (this.kerberosHostName == null && this.kerberosRealm == null ? this.kerberosServiceName : (this.kerberosHostName != null ? this.kerberosServiceName + "/" + this.kerberosHostName : this.kerberosServiceName + "/@" + this.kerberosRealm)));
        this.log("getKerberosTargetNameSSPI: " + string);
        return string;
    }

    public String getKerberosTargetNameGSS() {
        String string = null;
        string = this.kerberosTargetName != null ? this.kerberosTargetName : this.kerberosServiceName + "@" + this.kerberosHostName;
        this.log("getKerberosTargetNameGSS: " + string);
        return string;
    }

    private void connectAndLogin(boolean bl, String string, int n) throws IOException, SQLException {
        EXAResult[] eXAResultArray;
        Object object;
        Object object2;
        Object object3;
        int n2;
        Object object4;
        Object object5;
        Object object62;
        boolean bl2 = true;
        this.log("connectAndLogin(" + bl + ", " + string + ", " + n + ")");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
        eXAOutputStream.writeInt(this.getActiveProtocolVersion());
        SimpleDate simpleDate = new SimpleDate();
        simpleDate.fromCalendar(Calendar.getInstance());
        eXAOutputStream.writeInt(simpleDate.toInt());
        for (Object object62 : this.attributes.values()) {
            eXAOutputStream.writeAttribute((ProtocolAttribute)object62);
        }
        eXAOutputStream.flush();
        if (null == this.password && !this.kerberosLogin) {
            throw new IOException(Translator.Password_is_null_connect_aborted());
        }
        do {
            bl2 = true;
            try {
                this.csocket = this.createSocket(string, n, this.connectTimeout);
                this.csocket.setKeepAlive(true);
                this.csocket.setSoTimeout(10000);
            }
            catch (IOException iOException) {
                bl2 = false;
                throw iOException;
            }
        } while (!bl2);
        this.log("connectAndLogin - socket created");
        this.from_database = new EncryptedInputStream(new BufferedInputStream(this.csocket.getInputStream()));
        this.to_database = new EXAOutputStream(new EncryptedOutputStream(this.csocket.getOutputStream()), (EXAConnection)this);
        this.to_database.writeInt(0x1121201);
        this.to_database.writeInt(byteArrayOutputStream.size());
        this.to_database.write(byteArrayOutputStream.toByteArray());
        this.to_database.flush();
        this.log("connectAndLogin - create header");
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, this.responseTimeout));
        object62 = this.lastHeader.getAttributes();
        this.updateSessionAttributes((Vector)object62);
        if (this.encryptionEnabled && this.getActiveProtocolVersion() < 12) {
            throw new ProtocolException(Translator.To_create_an_encrypted_connection_the_server_must_be_at_least_5_0());
        }
        if (this.encryptionRequired) {
            this.encryptionEnabled = true;
        }
        if (this.lastHeader.getSize() > 0) {
            object5 = new byte[this.lastHeader.getSize()];
            this.from_database.read((byte[])object5);
            object4 = this.processMessageBody((byte[])object5);
            if (object4 != null) {
                for (n2 = 0; n2 < ((EXAResult[])object4).length; ++n2) {
                    if (!(object4[n2] instanceof EXASQLException)) continue;
                    throw ExceptionFactory.createSQLException((EXASQLException)object4[n2], (EXAConnection)this);
                }
            }
        }
        this.loginType = this.loginType == 0 && System.getProperty("os.name").startsWith("Windows") ? 1 : 2;
        if (this.kerberosLogin) {
            if (null != this.kerberosConfigFile) {
                System.setProperty("java.security.krb5.conf", this.kerberosConfigFile);
                this.log(" getProperty: kerberosConfigFile: " + System.getProperties().getProperty("java.security.krb5.conf"));
            }
            if (null != this.kerberosGssConfigFile) {
                System.setProperty("java.security.auth.login.config", this.kerberosGssConfigFile);
                this.log(" getProperty: kerberosGssConfigFile: " + System.getProperties().getProperty("java.security.auth.login.config"));
            }
            if (null != this.kerberosRealm) {
                System.setProperty("java.security.krb5.realm", this.kerberosRealm);
                this.log(" getProperty: kerberosRealm: " + System.getProperties().getProperty("java.security.krb5.realm"));
            }
            try {
                switch (this.loginType) {
                    case 2: {
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        if (null != this.kerberosUserName && null != this.kerberosRealm) {
                            System.setProperty("sun.security.krb5.principal", this.kerberosUserName + "@" + this.kerberosRealm);
                        }
                        GSSAuthentication.authenticate((EXAConnection)this, false);
                        break;
                    }
                    case 1: {
                        object5 = new SSPIClient((EXAConnection)this);
                        if (!((SSPIClient)object5).isSSPISupported()) {
                            GSSAuthentication.authenticate((EXAConnection)this, false);
                            break;
                        }
                        ((SSPIClient)object5).startSSPI();
                    }
                }
            }
            catch (Exception exception) {
                throw new SQLInvalidAuthorizationSpecException(exception.getMessage(), "28900");
            }
        }
        this.log("connectAndLogin - encrypt password");
        object5 = new RSA_encoder();
        ((RSA_encoder)object5).SetPublicKey(this.publicKey);
        object4 = null;
        if (this.slaveToken == 0L && !this.kerberosLogin) {
            n2 = this.randomPhrase.length - this.password.length() - 2;
            if (n2 > 0) {
                object3 = new ChaCha20_encoder();
                object2 = ((StreamEncoder)object3).getRandomKey("vui4sxz28dpg3da9s1hc7".getBytes(this.getEncoding()), n2);
                object = new ByteArrayOutputStream();
                ((OutputStream)object).write(this.password.getBytes(this.encoding));
                ((ByteArrayOutputStream)object).write(0);
                ((OutputStream)object).write((byte[])object2);
                eXAResultArray = (EXAResult[])((ByteArrayOutputStream)object).toByteArray();
                this.encodedPwd = ((RSA_encoder)object5).EncodePwd((byte[])eXAResultArray, this.randomPhrase);
            } else {
                object3 = this.password.getBytes(this.encoding);
                this.encodedPwd = ((RSA_encoder)object5).EncodePwd((byte[])object3, this.randomPhrase);
            }
            object4 = new ProtocolAttribute(ProtocolAttribute.ATTR_ENCODED_PASSWORD.id);
            object4.value = this.encodedPwd;
            object4.binaryLength = this.encodedPwd.length;
        }
        byte[] byArray = null;
        object3 = null;
        if (this.getActiveProtocolVersion() >= 12 && this.encryptionEnabled) {
            object2 = null;
            object = null;
            if (this.getActiveProtocolVersion() >= 14) {
                this.encryptor = new ChaCha20_encoder();
                object2 = this.encryptor.getRandomKey("xewd9j439cnr4urdu4ru3".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
                object = this.encryptor.getRandomKey("yrke9ek4yy9kd44dk88".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else {
                this.encryptor = new RC4_encoder();
                object2 = this.encryptor.getRandomKey("kmewd9j43239cnre3e324dkurdu4ru3".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
                object = this.encryptor.getRandomKey("ke32rke9ek4yy9kdxefwfef234d44dk88".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
            }
            this.encryptor.SetKeys((byte[])object2, (byte[])object);
            byArray = ((RSA_encoder)object5).EncodePwd((byte[])object2, this.randomPhrase);
            object3 = ((RSA_encoder)object5).EncodePwd((byte[])object, this.randomPhrase);
        }
        this.snapshotTransactions = this.getBooleanParameter("snapshottransactions", false);
        object2 = null;
        if (this.snapshotTransactions && this.getActiveProtocolVersion() >= 14) {
            object2 = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            object2.value = new Boolean(this.snapshotTransactions);
            object2.binaryLength = 1;
        }
        if (this.getActiveProtocolVersion() >= 12 && this.encryptionEnabled) {
            object = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_SEND_KEY.id);
            ((ProtocolAttribute)object).value = byArray;
            ((ProtocolAttribute)object).binaryLength = byArray.length;
            eXAResultArray = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_RECEIVE_KEY.id);
            eXAResultArray.value = object3;
            eXAResultArray.binaryLength = ((Object)object3).length;
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_KEYS_LEN.id);
            if (this.encryptor instanceof ChaCha20_encoder) {
                protocolAttribute.value = new Integer(ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else if (this.encryptor instanceof RC4_encoder) {
                protocolAttribute.value = new Integer(RC4_encoder.ENCRYPTION_KEY_LEN);
            } else {
                throw new IOException("Unknown encryption class");
            }
            Integer cfr_ignored_0 = (Integer)protocolAttribute.value;
            protocolAttribute.binaryLength = 32 / 8;
            this.to_database.writeInt(6 + (null != object4 ? object4.binaryLength + 6 : 0) + ((ProtocolAttribute)object).binaryLength + 6 + eXAResultArray.binaryLength + 2 + protocolAttribute.binaryLength + (null != object2 ? object2.binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(4 + (null != object2 ? 1 : 0));
            this.to_database.writeInt(6 + (null != object4 ? object4.binaryLength + 6 : 0) + ((ProtocolAttribute)object).binaryLength + 6 + eXAResultArray.binaryLength + 2 + protocolAttribute.binaryLength + (null != object2 ? object2.binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != object2) {
                this.to_database.writeAttribute((ProtocolAttribute)object2);
            }
            if (null != object4) {
                this.to_database.writeAttribute((ProtocolAttribute)object4);
            }
            this.to_database.writeAttribute((ProtocolAttribute)object);
            this.to_database.writeAttribute((ProtocolAttribute)eXAResultArray);
            this.to_database.writeAttribute(protocolAttribute);
        } else {
            this.to_database.writeInt((null != object4 ? object4.binaryLength + 6 : 0) + (null != object2 ? object2.binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(null != object4 ? 1 : 0 + (null != object2 ? 1 : 0));
            this.to_database.writeInt((null != object4 ? object4.binaryLength + 6 : 0) + (null != object2 ? object2.binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != object2) {
                this.to_database.writeAttribute((ProtocolAttribute)object2);
            }
            if (null != object4) {
                this.to_database.writeAttribute((ProtocolAttribute)object4);
            }
        }
        this.to_database.flush();
        this.log("connectAndLogin - read answer");
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, 0));
        if (!bl) {
            this.dateFormat = "YYYY-MM-DD";
            this.timestampFormat = "YYYY-MM-DD HH:MI:SS.FF3";
            this.numericCharacters = ".,";
        }
        object62 = this.lastHeader.getAttributes();
        this.updateSessionAttributes((Vector)object62);
        this.sysSchema = SYSSCHEMA_NEW;
        try {
            if (this.lastHeader.getSize() > 0) {
                object = new byte[this.lastHeader.getSize()];
                this.from_database.read((byte[])object);
                eXAResultArray = this.processMessageBody((byte[])object);
                if (eXAResultArray != null) {
                    for (int i = 0; i < eXAResultArray.length; ++i) {
                        if (!(eXAResultArray[i] instanceof EXASQLException)) continue;
                        throw ExceptionFactory.createSQLException((EXASQLException)eXAResultArray[i], (EXAConnection)this);
                    }
                }
            }
        }
        catch (RollbackException rollbackException) {
            if (this.getActiveProtocolVersion() >= 12) {
                if (this.encryptionEnabled) {
                    this.to_database.SetEncryptor(this.encryptor);
                    ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
                }
                this.getAttributes();
                this.updateSessionAttributes((Vector)object62);
            }
            throw rollbackException;
        }
        if (this.getActiveProtocolVersion() >= 12) {
            if (this.encryptionEnabled) {
                this.to_database.SetEncryptor(this.encryptor);
                ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
            }
            this.getAttributes();
            this.updateSessionAttributes((Vector)object62);
            if (this.snapshotTransactions && this.getActiveProtocolVersion() < 14) {
                this.SetSnapshotTransactions(this.snapshotTransactions);
            }
        }
    }

    private String toHexStr(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i]));
        }
        return stringBuilder.toString();
    }

    @Override
    public synchronized void setSchema(String string) throws SQLException {
        this.log("EXAConnection.setSchema(" + string + ") protocolVersion=" + this.getActiveProtocolVersion());
        if (this.getActiveProtocolVersion() < 14 || string == null) {
            String string2 = null;
            string2 = string == null ? "close schema" : "open schema " + string;
            EXAResult[] eXAResultArray = null;
            ExecutionStatus executionStatus = new ExecutionStatus();
            try {
                eXAResultArray = this.connection.communication_resultset(string2.getBytes(this.connection.getEncoding()), (byte)12, executionStatus);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
            if (eXAResultArray != null && eXAResultArray.length > 0 && eXAResultArray[0] instanceof EXASQLException) {
                throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
            }
        } else {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CURRENT_SCHEMA.id);
            protocolAttribute.value = string;
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            try {
                this.setAttributes(protocolAttributeArray);
            }
            catch (IOException iOException) {
                this.log("EXAConnection.setSchema(): caught IOException: " + iOException);
                throw new ConnectionLost(iOException.toString(), this.getSessionID());
            }
            catch (SQLException sQLException) {
                this.log("EXAConnection.setSchema(): caught SQLException: " + sQLException);
                throw sQLException;
            }
        }
        this.getSchema();
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        this.log("EXAConnection.getSchema()");
        try {
            this.getAttributes();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage(), "HY000");
        }
        this.log("EXAConnection.getSchema() returns " + this.getCurrentSchema());
        return this.getCurrentSchema();
    }

    protected int getNextSerialNumber() {
        return this.lastSerialNumber++;
    }

    public final synchronized byte[] communication(byte[] byArray, byte by, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        byte[] byArray2 = this.communication(byArray, byArray == null ? -1 : byArray.length, by, 0, executionStatus);
        if (executionStatus.cancelInitiated()) {
            byArray2 = this.communication(null, 0, (byte)37, 0, executionStatus);
        }
        return byArray2;
    }

    private final synchronized InMessage _communication(OutMessage outMessage) throws IOException, SQLException {
        outMessage.write_to_and_no_clean(this.to_database, (EXAConnection)this);
        return new InMessage(this.debug, this.from_database, (EXAConnection)this);
    }

    private final synchronized InMessage communication(OutMessage outMessage) throws IOException, SQLException {
        this.tmpOutMessage = outMessage;
        this.tmpOutMessage.flush();
        this.handle(new RecoverableOperation(){

            @Override
            public void op() throws IOException, SQLException {
                AbstractEXAConnection.this.tmpInMessage = AbstractEXAConnection.this._communication(AbstractEXAConnection.this.tmpOutMessage);
            }
        });
        return this.tmpInMessage;
    }

    protected final synchronized EXAResult[] communication_resultset(byte[] byArray, byte by, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        int n = null != byArray ? byArray.length : 0;
        try {
            this.log("start communication_resultset(nBytes: " + n + ", mode: " + by + ")");
            byte[] byArray2 = this.communication(byArray, byArray != null ? byArray.length : 0, by, 0, executionStatus);
            if (executionStatus.cancelInitiated()) {
                byArray2 = this.communication(null, 0, (byte)37, 0, executionStatus);
            }
            EXAResult[] eXAResultArray = this.readResults(byArray2, this.lastHeader.getNumberOfResults());
            return eXAResultArray;
        }
        catch (IOException iOException) {
            if (trace_exception) {
                iOException.printStackTrace();
            }
            this.log(iOException);
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
        finally {
            this.log("end communication_resultset(nBytes: " + n + ", mode: " + by + ")");
        }
    }

    private EXAResult[] processMessageBody(byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            return null;
        }
        EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
        int n = this.lastHeader.getNumberOfResults();
        EXAResult[] eXAResultArray = new EXAResult[n];
        block5: for (int i = 0; i < n; ++i) {
            byte by = eXAInputStream.readByte();
            switch (by) {
                case 0: {
                    eXAResultArray[i] = new EXARowCount(eXAInputStream, this.debug);
                    continue block5;
                }
                case 1: {
                    eXAResultArray[i] = this.dialectFactory.createResultSet(eXAInputStream, (EXAConnection)this, this.debug);
                    continue block5;
                }
                case -1: {
                    eXAResultArray[i] = new EXASQLException(eXAInputStream, this.debug);
                    continue block5;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return eXAResultArray;
    }

    public final synchronized EXAResult[] communication_vector(Vector vector, byte by, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        EXAResult[] eXAResultArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
            eXAOutputStream.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                eXAOutputStream.writeString((String)vector.elementAt(i));
            }
            eXAOutputStream.flush();
            eXAResultArray = vector.size() > 0 ? this.communication_resultset(byteArrayOutputStream.toByteArray(), by, executionStatus) : this.communication_resultset(null, by, executionStatus);
        }
        catch (IOException iOException) {
            if (trace_exception) {
                iOException.printStackTrace();
            }
            this.log(iOException);
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
        return eXAResultArray;
    }

    private EXAResult readSingleResult(EXAInputStream eXAInputStream) throws IOException, SQLException {
        EXAResult eXAResult = null;
        byte by = eXAInputStream.readByte();
        switch (by) {
            case 0: {
                eXAResult = new EXARowCount(eXAInputStream, this.debug);
                break;
            }
            case 1: {
                eXAResult = this.dialectFactory.createResultSet(eXAInputStream, (EXAConnection)this, this.debug);
                if (-4 != ((EXAResultSet)eXAResult).GetHandle()) break;
                eXAResult = new EXASQLException(new String("HY000"), new String(Translator.Query_did_not_return_a_result_set()), this.debug);
                break;
            }
            case -1: {
                eXAResult = new EXASQLException(eXAInputStream, this.debug);
                break;
            }
            case 2: {
                eXAResult = new EXAHandle(eXAInputStream, this.debug);
                break;
            }
            case 5: {
                eXAResult = new EXAStillExecuting(eXAInputStream, this.debug);
                break;
            }
            default: {
                throw new ProtocolException(Translator.Server_returned_unknow_type_of_result() + " (Type: " + by + ", SessionID: " + this.getSessionID() + ")");
            }
        }
        return eXAResult;
    }

    private EXAResult[] readResults(byte[] byArray, int n) throws IOException, SQLException, ProtocolException {
        if (byArray == null) {
            return null;
        }
        return this.readResults(new EXAInputStream(byArray, (EXAConnection)this), n);
    }

    private EXAResult[] readResults(EXAInputStream eXAInputStream, int n) throws IOException, SQLException, ProtocolException {
        EXAResult[] eXAResultArray = null;
        int n2 = n;
        this.log(n2 + " results in message");
        if (n2 > 0) {
            eXAResultArray = new EXAResult[n2];
            for (int i = 0; i < n2; ++i) {
                eXAResultArray[i] = this.readSingleResult(eXAInputStream);
            }
        }
        return eXAResultArray;
    }

    private void checkResults(InMessage inMessage) throws ProtocolException, IOException, SQLException {
        EXAResult[] eXAResultArray = this.readResults(inMessage.getStream(), inMessage.getHeader().getNumberOfResults());
        if (eXAResultArray != null) {
            for (int i = 0; i < eXAResultArray.length; ++i) {
                if (!(eXAResultArray[i] instanceof EXASQLException)) continue;
                throw ((EXASQLException)eXAResultArray[i]).getSQLExceptionIntern(this.connection);
            }
        }
    }

    protected synchronized byte[] communication(byte[] byArray, int n, byte by, int n2, ExecutionStatus executionStatus) throws SQLException {
        this.executionMode = by;
        try {
            CommOp commOp = new CommOp();
            commOp.execStatus = executionStatus;
            commOp.responseTimeout = n2;
            if (n >= 0) {
                commOp.header = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
                commOp.header.setSize(n);
                commOp.header.setMode(by);
                commOp.header.setNumberOfResults(0);
            }
            commOp.outBytes = byArray;
            this.handle(commOp);
            this.lastHeader = commOp.header;
            return commOp.inBytes;
        }
        catch (IOException iOException) {
            if (trace_exception) {
                iOException.printStackTrace();
            }
            this.log(iOException.toString());
            throw new ConnectionLost(iOException.toString(), this.getSessionID());
        }
    }

    private byte[] readMessageBody(Header header) throws ConnectionException, IOException, ConnectionLost {
        int n;
        int n2 = 0;
        byte[] byArray = null;
        if (n > 0) {
            int n3;
            byArray = new byte[header.getSize()];
            for (n = header.getSize(); n > 0; n -= n3) {
                n3 = 0;
                try {
                    n3 = this.from_database.read(byArray, n2, n);
                    if (n3 < 0) {
                        throw new ConnectionLost(Translator.Failed_to_read_from_server(), this.getSessionID());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    n3 = interruptedIOException.bytesTransferred;
                }
                n2 += n3;
            }
        }
        return byArray;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.log("rollback", 1);
        this.log("createStatement to execute rollback");
        Statement statement = this.createStatement();
        statement.executeUpdate("/*EXAConnection.rollback()*/ rollback;");
        statement.close();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.log("EXAConnection.setAutoCommit(" + bl + ")");
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
        protocolAttribute.value = new Boolean(bl);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
            this.connectionParam.put("autocommit", bl ? "1" : "0");
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setAutoCommit(): caught exception: " + iOException);
            throw new ConnectionLost(Translator.Failed_to_set_autocommit_mode_to() + iOException.toString(), this.getSessionID());
        }
    }

    public synchronized void setClientName(String string) throws SQLException {
        this.log("EXAConnection.setClientName(" + string + ")");
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENTNAME.id);
        protocolAttribute.value = new String(string);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setClientName(): caught exception: " + iOException);
            throw new ConnectionLost("Failed to set the client name in the server: " + iOException.toString(), this.getSessionID());
        }
    }

    public synchronized void SetSnapshotTransactions(boolean bl) throws SQLException {
        this.log("EXAConnection.useSnpashotTransaction(" + bl + ")");
        if (this.getActiveProtocolVersion() >= 12) {
            ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            protocolAttribute.value = new Boolean(bl);
            ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
            try {
                this.setAttributes(protocolAttributeArray);
            }
            catch (IOException iOException) {
                this.log("EXAConnection.useSnpashotTransaction(): caught exception: " + iOException);
                throw new ConnectionLost(Translator.Failed_to_set_use_snapshot_transactions_to() + iOException.toString(), this.getSessionID());
            }
        } else {
            this.log("Attribute ATTR_SNAPSHOT_TRANSACTIONS_ENABLED not implemented for protocol V" + this.getActiveProtocolVersion());
        }
    }

    public synchronized void setFeedbackInterval(int n) throws SQLException {
        this.log("EXAConnection.setFeedbackInterval(" + n + ")");
        if (this.getActiveProtocolVersion() < 9) {
            throw new SQLException(Translator.Failed_to_set_feedback_interval_to() + n + ". Active protocol version: " + this.getActiveProtocolVersion());
        }
        this.feedbackInterval = n;
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id);
        protocolAttribute.value = new Integer(n);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setFeedbackInterval(): caught exception: " + iOException);
            throw new ConnectionLost(Translator.Failed_to_set_feedback_interval_to() + n + ". " + iOException.toString(), this.getSessionID());
        }
    }

    public int getFeedbackInterval() {
        if (-1 == this.feedbackInterval) {
            return defaultFeedbackInterval;
        }
        return this.feedbackInterval;
    }

    public boolean getSnapshotTransactionsEnabled() {
        return this.snapshotTransactions;
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        this.log("setCatalog(" + string + ")", 1);
        if (!this.currentCatalog.equalsIgnoreCase(string)) {
            throw new SQLException(Translator.No_such_catalog() + string);
        }
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.log("setReadOnly(" + bl + ")", 0);
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.log("setTypeMap(" + map + ")", 0);
        this.typeMap = map;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.log("EXAConnection.setQueryTimeout(" + n + ")");
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_QUERY_TIMEOUT.id);
        protocolAttribute.value = new Integer(n);
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
        }
        catch (IOException iOException) {
            this.log("EXAConnection.setQueryTimeout(" + n + "): caught IOException: " + iOException.toString());
            throw new SQLException(iOException.toString());
        }
        catch (SQLException sQLException) {
            this.log("EXAConnection.setQueryTimeout(" + n + "): caught SQLException: " + sQLException.toString());
            throw sQLException;
        }
        this.queryTimeout = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public synchronized String[] getClusterNodes() throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EXAOutputStream eXAOutputStream = new EXAOutputStream(byteArrayOutputStream, (EXAConnection)this);
        String string = InetAddress.getByName(this.exaServer).getHostAddress();
        eXAOutputStream.writeString(string);
        eXAOutputStream.flush();
        this.log("getClusterNodes(), sending ip: " + string, 0);
        byte[] byArray = this.communication(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), (byte)16, 0, new ExecutionStatus());
        EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
        int n = eXAInputStream.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = eXAInputStream.readString();
            this.log("EXA reports ip " + i + " of " + n + ": " + stringArray[i]);
        }
        return stringArray;
    }

    public Vector getClusterNodesVector() {
        return this.clusterNodes;
    }

    protected void startParallel(int n) {
        try {
            Header header = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
            header.setMode((byte)30);
            header.setSize(4);
            header.write_to(this.to_database);
            this.to_database.writeInt(n);
            this.to_database.flush();
            byte[] byArray = this.communication(null, -1, header.getMode(), 0, new ExecutionStatus());
            EXAInputStream eXAInputStream = new EXAInputStream(byArray, (EXAConnection)this);
            long l = eXAInputStream.readLong();
            for (int i = header.getNumberOfResults(); i > 0; --i) {
                int n2 = eXAInputStream.readInt();
                String string = eXAInputStream.readString();
            }
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected DebugLog getDebug() {
        return this.debug;
    }

    protected int uploadJob(String string, byte by, Vector vector, Vector vector2, String string2) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    protected int uploadJob(String string, byte by, Vector vector, Vector vector2) throws SQLException, IOException {
        return this.uploadJob(string, by, vector, vector2, this.user);
    }

    protected void setQueuePolicy(int n) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    public synchronized void killSession(long l) throws SQLException, ConnectionException {
        this.log("killSession(" + l + ")", 0);
        if (l < 0L) {
            throw ExceptionFactory.createSQLException(Translator.Invalid_process_number(), "08003", (EXAConnection)this);
        }
        ExecutionStatus executionStatus = new ExecutionStatus();
        EXAResult[] eXAResultArray = null;
        byte[] byArray = null;
        if (this.getActiveProtocolVersion() >= 8) {
            byArray = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray[i] = (byte)(l >>> i * 8);
            }
        } else {
            byArray = new byte[4];
            for (int i = 0; i < 4; ++i) {
                byArray[i] = (byte)(l >>> i * 8);
            }
        }
        if ((eXAResultArray = this.connection.communication_resultset(byArray, (byte)27, executionStatus)) != null && eXAResultArray.length > 0 && eXAResultArray[0] instanceof EXASQLException) {
            throw ((EXASQLException)eXAResultArray[0]).getSQLExceptionIntern(this.connection);
        }
    }

    protected boolean isInVMUMode() {
        return this.vmuMode;
    }

    private String[] ColSplitter(String string) throws LoaderException {
        if (null == string || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 1;
        String[] stringArray = null;
        int n4 = 0;
        string = string + ",";
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '(': {
                    if (bl) continue block6;
                    ++n2;
                    continue block6;
                }
                case ')': {
                    if (bl) continue block6;
                    --n2;
                    continue block6;
                }
                case '\"': {
                    if (!bl) {
                        bl = true;
                        continue block6;
                    }
                    bl = false;
                    continue block6;
                }
                case ',': {
                    if (false != n2 || bl) continue block6;
                    if (i - n < 3) {
                        throw new LoaderException(Translator.Sytax_error_missing_column_description_for_col() + n3);
                    }
                    ++n3;
                    if (0 == n4) {
                        stringArray = new String[1];
                    } else {
                        String[] stringArray2 = new String[n4 + 1];
                        for (int j = 0; j < n4; ++j) {
                            stringArray2[j] = stringArray[j];
                        }
                        stringArray = stringArray2;
                    }
                    stringArray[n4] = new String(cArray, n, i - n);
                    n = i + 1;
                    ++n4;
                }
            }
        }
        if (0 == n4) {
            stringArray = new String[]{new String(cArray)};
        }
        return stringArray;
    }

    private void GetCollsAndTypes(String[] stringArray, String[] stringArray2, String[] stringArray3) throws LoaderException {
        for (int i = 0; i < stringArray3.length; ++i) {
            int n;
            char[] cArray = new char[stringArray3[i].length()];
            stringArray3[i].getChars(0, stringArray3[i].length(), cArray, 0);
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            boolean bl2 = false;
            block13: for (n = 0; n < cArray.length && null == stringArray[i]; ++n) {
                switch (cArray[n]) {
                    case '\"': {
                        if (!bl) {
                            bl = true;
                            continue block13;
                        }
                        bl = false;
                        continue block13;
                    }
                    case ' ': {
                        if (!bl && bl2) {
                            stringArray[i] = new String(cArray, n2, n - n2);
                            n2 = n + 1;
                            continue block13;
                        }
                        if (bl2) continue block13;
                        ++n2;
                        continue block13;
                    }
                    default: {
                        bl2 = true;
                    }
                }
            }
            if (null == stringArray[i]) {
                throw new LoaderException(Translator.No_column_name_found_for_column() + (i + 1));
            }
            bl2 = false;
            boolean bl3 = false;
            while (n < cArray.length && null == stringArray2[i]) {
                switch (cArray[n]) {
                    case '(': {
                        ++n3;
                        if (bl3) {
                            throw new LoaderException(Translator.To_many_parantheses_describing_datatype_for_col() + (i + 1));
                        }
                        bl3 = true;
                        break;
                    }
                    case ')': {
                        --n3;
                        break;
                    }
                    case ' ': {
                        if (0 == n3 && bl2) {
                            boolean bl4 = true;
                            if (!bl3) {
                                bl4 = false;
                                int n4 = 0;
                                while (n + n4 < cArray.length && cArray[n + n4] == ' ') {
                                    ++n4;
                                }
                                if (n + n4 == cArray.length) {
                                    bl4 = true;
                                } else if ('(' != cArray[n + n4]) {
                                    bl4 = true;
                                }
                            }
                            if (!bl4) break;
                            stringArray2[i] = new String(cArray, n2, n - n2);
                            break;
                        }
                        if (bl2) break;
                        ++n2;
                        break;
                    }
                    default: {
                        bl2 = true;
                    }
                }
                ++n;
            }
            if (0 != n3) {
                throw new LoaderException(Translator.Error_found_counting_parantheses_in_datatype_description_for_col() + (i + 1));
            }
            if (n2 + 1 < n && null == stringArray2[i]) {
                stringArray2[i] = new String(cArray, n2, n - n2);
            }
            if (null == stringArray2[i]) {
                throw new LoaderException(Translator.No_datataype_found_for_column() + (i + 1));
            }
            while (n < cArray.length) {
                switch (cArray[n]) {
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new LoaderException(i + 1 + Translator.Too_many_words_found());
                    }
                }
                ++n;
            }
        }
    }

    protected static String sqlQuote(String string, char c) {
        char[] cArray = new char[(string.length() << 1) + 2];
        int n = 0;
        cArray[n++] = c;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                cArray[n++] = c2;
            }
            cArray[n++] = c2;
        }
        cArray[n++] = c;
        return new String(cArray, 0, n);
    }

    protected int compiledDriverVersion() {
        return defaultDriverProtocollVersion;
    }

    public int getEXAPort() {
        return this.exaPort;
    }

    public String getEXAServer() {
        return this.exaServer;
    }

    protected String getUser() {
        if (this.kerberosLogin && this.kerberosUserName != null) {
            return this.kerberosUserName;
        }
        return this.user;
    }

    protected String getURL() {
        return this.connectionParam.getProperty("url");
    }

    protected static DriverPropertyInfo[] getDefaultProperties() {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[18];
        int n = 0;
        driverPropertyInfoArray[n] = new DriverPropertyInfo("autocommit", "1");
        driverPropertyInfoArray[n].description = Translator.Auto_commit_0_disabled_1_enabled();
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("debug", "0");
        driverPropertyInfoArray[n].description = Translator.Set_to_1_to_activate_logging();
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("clientname", "Generic client");
        driverPropertyInfoArray[n].description = "Name of the client application.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("connecttimeout", "0");
        driverPropertyInfoArray[n].description = "A timeout in seconds that specifies the maximum time interval the driver will try to establish a connection on each node given in the connection string.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("encryption", defaultEncryptionEnabled ? "1" : "0");
        driverPropertyInfoArray[n].description = "Encrypted client server communication.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("fetchsize", Integer.toString(2000));
        driverPropertyInfoArray[n].description = Translator.Default_fetch_size();
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("kerberosservicename", "exasol");
        driverPropertyInfoArray[n].description = "Kerberos service name.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("kerberoshostname", "");
        driverPropertyInfoArray[n].description = "Kerberos host name.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("kerberosusername", System.getProperty("user.name", ""));
        driverPropertyInfoArray[n].description = "Kerberos user name.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("kerberosrealm", "");
        driverPropertyInfoArray[n].description = "Kerberos REALM name.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("kerberosconfig", "");
        driverPropertyInfoArray[n].description = "Kerberos config file (krb5.conf).";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("kerberosgssconfig", "");
        driverPropertyInfoArray[n].description = "Kerberos config file (gss-jaas.conf).";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("schema", null);
        driverPropertyInfoArray[n].description = Translator.Name_of_initially_opened_schema();
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("snapshottransactions", "0");
        driverPropertyInfoArray[n].description = "Enables snapshot transactions in the current session.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("superconnection", "0");
        driverPropertyInfoArray[n].description = "Enables the SuperConnection mode.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("logdir", "");
        driverPropertyInfoArray[n].description = "Directory name where to save the logfiles to.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("logintimeout", "0");
        driverPropertyInfoArray[n].description = "A timeout in seconds that specifies how long the driver will wait for the server until the answer package for a connect request arrives. This timeout has effect only after a socket connection to the server was already established.";
        driverPropertyInfoArray[n].required = false;
        driverPropertyInfoArray[++n] = new DriverPropertyInfo("querytimeout", "0");
        driverPropertyInfoArray[n].description = "Query timeout, default is 0 (infinte).";
        driverPropertyInfoArray[n].required = false;
        if (18 != ++n) {
            return null;
        }
        return driverPropertyInfoArray;
    }

    protected synchronized void setAttributes(ProtocolAttribute[] protocolAttributeArray) throws IOException, SQLException {
        this.log("EXAConnection.setAttributes(), setting " + protocolAttributeArray.length + " attributes.");
        this.tmpOutMessage = new OutMessage(this.debug, (EXAConnection)this);
        this.tmpOutMessage.getHeader().setMode((byte)35);
        for (int i = 0; i < protocolAttributeArray.length; ++i) {
            this.tmpOutMessage.getHeader().addAttribute(protocolAttributeArray[i]);
        }
        this.tmpInMessage = this.communication(this.tmpOutMessage);
        this.checkResults(this.tmpInMessage);
    }

    protected synchronized void getAttributes() throws SQLException, IOException {
        this.log("EXAConnection.getAttributes()");
        byte[] byArray = this.communication(null, 0, (byte)34, 0, new ExecutionStatus());
        this.log("EXAConnection.getAttributes() numeric_characters=" + this.numericCharacters);
    }

    public synchronized byte[] exchangeTicket(byte[] byArray) throws SQLException {
        this.log("EXAConnection.exchangeTicket(nBytes=" + byArray.length + ")");
        ProtocolAttribute protocolAttribute = new ProtocolAttribute(ProtocolAttribute.ATTR_KERBEROS_TICKET.id);
        protocolAttribute.value = byArray;
        ProtocolAttribute[] protocolAttributeArray = new ProtocolAttribute[]{protocolAttribute};
        try {
            this.setAttributes(protocolAttributeArray);
            return this.kerberosToken;
        }
        catch (IOException iOException) {
            this.log("EXAConnection.exchangeTicket(): caught exception: " + iOException);
            throw new ConnectionLost(iOException.getMessage(), 0L);
        }
    }

    protected void reconnect() throws SQLException {
        if (this.wasDisconnected) {
            throw new SQLException(Translator.No_operations_allowed_on_this_connection_because_it_was_already_closed(), "JY000");
        }
        this.closeAbort(false);
        if (this.reconnectCount++ < 1) {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException interruptedException) {
                throw new SQLException(interruptedException.toString());
            }
            try {
                this.setupConnection(true, null);
            }
            catch (ConnectionException connectionException) {
                if (connectionException instanceof ConnectionLost) {
                    this.closeSocket();
                    throw connectionException;
                }
                this.closeSocket();
                throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
            }
        }
        this.closeSocket();
        throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
        this.reconnectCount = 0;
    }

    protected static int getProtocolVersion() {
        return defaultDriverProtocollVersion;
    }

    void updateSessionAttributes(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ProtocolAttribute protocolAttribute = (ProtocolAttribute)vector.elementAt(i);
            if (protocolAttribute.id == ProtocolAttribute.ATTR_SESSIONID.id) {
                this.sessionID = (Long)protocolAttribute.value;
                this.log("Session id received: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_CURRENT_SCHEMA.id) {
                if (protocolAttribute.value != null) {
                    this.changeCurrentSchema(protocolAttribute.value.toString());
                    this.log("Current schema: " + protocolAttribute.value.toString());
                    continue;
                }
                this.changeCurrentSchema(null);
                this.log("Current schema: <none>");
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_CURRENT_CATALOG.id) {
                if (protocolAttribute.value != null) {
                    this.currentCatalog = protocolAttribute.value.toString();
                    this.log("Current catalog: " + protocolAttribute.value);
                    continue;
                }
                this.currentCatalog = null;
                this.log("Current catalog: <none>");
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PROTOCOL_VERSION.id) {
                this.activeProtocolVersion = (Integer)protocolAttribute.value;
                this.log("Protocol version: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATA_MESSAGE_SIZE.id) {
                this.maxMessageSize = (Long)protocolAttribute.value;
                this.log("maxDataMessageSize: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATE_FORMAT.id) {
                this.dateFormat = protocolAttribute.value != null ? protocolAttribute.value.toString() : "YYYY-MM-DD";
                this.log("NLS date format: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATETIME_FORMAT.id) {
                this.timestampFormat = protocolAttribute.value != null ? protocolAttribute.value.toString() : "YYYY-MM-DD HH:MI:SS.FF3";
                this.log("NLS timestamp format: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DATE_LANGUAGE.id) {
                this.dateLanguage = protocolAttribute.value != null ? protocolAttribute.value.toString() : "german";
                this.log("NLS date language: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_NUMERIC_CHARACTERS.id) {
                this.numericCharacters = protocolAttribute.value != null ? protocolAttribute.value.toString() : ".,";
                this.log("Numeric characters: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PUBLIC_KEY.id) {
                this.publicKey = (byte[])protocolAttribute.value;
                this.log("Public Key: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_RANDOM_PHRASE.id) {
                this.randomPhrase = (byte[])protocolAttribute.value;
                this.log("Random phrase: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_DB_NAME.id) {
                this.databaseName = protocolAttribute.value.toString();
                this.log("Database Name: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_PRODUCT_NAME.id) {
                this.databaseProductName = protocolAttribute.value.toString();
                this.log("Database Product Name: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_RELEASE_VERSION.id) {
                this.databaseProductVersion = protocolAttribute.value.toString();
                this.log("Database Product Version: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_QUERY_CACHE_ACCESS.id) {
                this.log("Query cache access: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_ENCRYPTION_REQUIRED.id) {
                this.encryptionRequired = (Boolean)protocolAttribute.value;
                this.log("Encryption required: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id) {
                this.feedbackInterval = (Integer)protocolAttribute.value;
                this.log("Feedback interval: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id) {
                this.snapshotTransactions = (Boolean)protocolAttribute.value;
                this.log("Snapshot transactions enabled: " + protocolAttribute.value);
                continue;
            }
            if (protocolAttribute.id == ProtocolAttribute.ATTR_KERBEROS_TOKEN.id) {
                this.kerberosToken = (byte[])protocolAttribute.value;
                this.log("kerberosToken recieved, bytes: " + this.kerberosToken.length);
                continue;
            }
            if (protocolAttribute.id != ProtocolAttribute.ATTR_MAX_IDENTIFIER_LENGTH.id) continue;
            this.maxIdentifierLen = (Integer)protocolAttribute.value;
            this.log("Max identifier len: " + this.maxIdentifierLen);
        }
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public String getCurrentSchema() throws SQLException {
        return this.currentSchema;
    }

    protected void changeCurrentSchema(String string) {
        String string2 = this.currentSchema;
        this.currentSchema = string;
        this.fireSchemaChanged(string2, this.currentSchema);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getDateLanguage() {
        return this.dateLanguage;
    }

    public String getNumericCharacters() {
        return this.numericCharacters;
    }

    protected static int getDateFormatWidth(String string) {
        if (string == null) {
            return 10;
        }
        return string.length();
    }

    protected static int getTimestampFormatWidth(String string) {
        if (string == null) {
            return 23;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (n2 < 2) {
                if (cArray[i] == 'f' || cArray[i] == 'F') {
                    ++n2;
                    continue;
                }
                n2 = 0;
                continue;
            }
            if (cArray[i] >= '\u0000' || cArray[i] <= '\t') {
                int n3 = cArray[i] - 48;
                n = n - 3 + n3;
            }
            n2 = 0;
        }
        return n;
    }

    public String getSysSchema() {
        return this.sysSchema;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected String GetDatabaseName() {
        return this.databaseName;
    }

    protected String GetDatabaseProductName() {
        return this.databaseProductName;
    }

    protected String GetDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    private class CommOp
    implements RecoverableOperation {
        protected Header header = null;
        protected byte[] outBytes = null;
        protected byte[] inBytes = null;
        protected int responseTimeout = 0;
        ExecutionStatus execStatus = null;

        protected CommOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void op() throws IOException, SQLException {
            if (this.header != null) {
                this.header.write_to(AbstractEXAConnection.this.to_database);
            }
            if (this.outBytes != null) {
                AbstractEXAConnection.this.to_database.write(this.outBytes, 0, this.outBytes.length);
            }
            AbstractEXAConnection.this.to_database.flush();
            boolean bl = false;
            Header header = new Header(this.header);
            try {
                while (!bl) {
                    if (null != this.execStatus && this.execStatus.mustCancel()) {
                        this.inBytes = null;
                        return;
                    }
                    ((EncryptedInputStream)AbstractEXAConnection.this.from_database).SetMemoryStream(header.read_from(AbstractEXAConnection.this.from_database, this.responseTimeout));
                    AbstractEXAConnection.this.updateSessionAttributes(header.getAttributes());
                    this.inBytes = AbstractEXAConnection.this.readMessageBody(header);
                    if (AbstractEXAConnection.this.getActiveProtocolVersion() <= 8) {
                        bl = true;
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0] && !AbstractEXAConnection.this.commandWasEnterParallel) {
                        byte[] byArray = new byte[this.inBytes.length - 5];
                        System.arraycopy(this.inBytes, 5, byArray, 0, byArray.length);
                        String string = null;
                        try {
                            string = new String(byArray, "UTF-8");
                            if (string.toUpperCase(Locale.ENGLISH).contains("<status>EXECUTING</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "EXECUTING";
                            }
                            if (string.toUpperCase(Locale.ENGLISH).contains("<status>QUEUED</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "QUEUED";
                            }
                            if (!AbstractEXAConnection.this.connectionStatus.equals("QUEUED") || !this.execStatus.isCanceled()) continue;
                            this.inBytes = null;
                            AbstractEXAConnection.this.closeAbort(false);
                            return;
                        }
                        catch (Exception exception) {
                            string = "UNKNOWN";
                        }
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0] && !AbstractEXAConnection.this.commandWasEnterParallel) continue;
                    bl = true;
                }
            }
            finally {
                this.header.setSerialNumber(header.getSerialNumber());
            }
            this.header = header;
        }
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            AbstractEXAConnection.this.abort();
        }
    }

    private static final class ConnectionStatus {
        public static final String EXECUTING = "EXECUTING";
        public static final String QUEUED = "QUEUED";
        public static final String UNKNOWN = "UNKNOWN";

        private ConnectionStatus() {
        }
    }
}

