/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import com.jidesoft.thirdparty.prefuse.util.collections.AbstractTreeMap;
import com.jidesoft.thirdparty.prefuse.util.collections.FloatIntSortedMap;
import com.jidesoft.thirdparty.prefuse.util.collections.IntIterator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralComparator;
import com.jidesoft.thirdparty.prefuse.util.collections.LiteralIterator;

public class FloatIntTreeMap
extends AbstractTreeMap
implements FloatIntSortedMap {
    private B \u0102 = new B(Float.MIN_VALUE, Integer.MAX_VALUE, NIL, 0);

    public FloatIntTreeMap() {
        this(null, false);
    }

    public FloatIntTreeMap(boolean bl) {
        this(null, bl);
    }

    public FloatIntTreeMap(LiteralComparator literalComparator) {
        this(literalComparator, false);
    }

    public FloatIntTreeMap(LiteralComparator literalComparator, boolean bl) {
        super(literalComparator, bl);
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public boolean containsKey(float f2) {
        return this.\u0102(f2, 0) != NIL;
    }

    @Override
    public int get(float f2) {
        AbstractTreeMap.Entry entry = this.\u0102(f2, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.\u0106;
    }

    @Override
    public int put(float f2, int n2) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new B(f2, n2, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.\u0102.\u0107 = f2;
        this.\u0102.\u0101 = Integer.MAX_VALUE;
        while (true) {
            int n3;
            if ((n3 = this.compare(this.\u0102, entry)) == 0) {
                return entry.setValue(n2);
            }
            if (n3 < 0) {
                if (entry.\u0105 != NIL) {
                    entry = entry.\u0105;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.\u0105 = new B(f2, n2, entry, this.lastOrder);
                this.fixUpInsert(entry.\u0105);
                return Integer.MIN_VALUE;
            }
            if (entry.\u0103 == NIL) break;
            entry = entry.\u0103;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.\u0103 = new B(f2, n2, entry, this.lastOrder);
        this.fixUpInsert(entry.\u0103);
        return Integer.MIN_VALUE;
    }

    @Override
    public int remove(float f2) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.\u0101(f2, Integer.MAX_VALUE) : this.\u0102(f2, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n2 = entry.\u0106;
        this.remove(entry);
        return n2;
    }

    @Override
    public int remove(float f2, int n2) {
        AbstractTreeMap.Entry entry = this.\u0103(f2, 0);
        if (entry != NIL && entry.getFloatKey() != f2) {
            entry = this.successor(entry);
        }
        if (entry == NIL || entry.getFloatKey() != f2) {
            return Integer.MIN_VALUE;
        }
        while (entry.\u0106 != n2 && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n2;
    }

    @Override
    public float firstKey() {
        return this.minimum(this.root).getFloatKey();
    }

    @Override
    public float lastKey() {
        return this.maximum(this.root).getFloatKey();
    }

    @Override
    public LiteralIterator keyIterator() {
        return new A();
    }

    @Override
    public LiteralIterator keyRangeIterator(float f2, boolean bl, float f3, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        if (this.cmp.compare(f2, f3) <= 0) {
            entry2 = this.\u0103(f2, bl ? 0 : Integer.MAX_VALUE);
            entry = this.\u0103(f3, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.\u0103(f2, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.\u0103(f3, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new A(entry2, entry);
    }

    @Override
    public IntIterator valueRangeIterator(float f2, boolean bl, float f3, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(f2, bl, f3, bl2));
    }

    @Override
    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        int n2 = this.cmp.compare(entry.getFloatKey(), entry2.getFloatKey());
        if (this.allowDuplicates && n2 == 0) {
            n2 = entry.\u0101 < entry2.\u0101 ? -1 : (entry.\u0101 > entry2.\u0101 ? 1 : 0);
            this.lastOrder = 1 + (n2 < 0 ? entry.\u0101 : entry2.\u0101);
        }
        return n2;
    }

    private AbstractTreeMap.Entry \u0102(float f2, int n2) {
        this.\u0102.\u0107 = f2;
        this.\u0102.\u0101 = n2;
        AbstractTreeMap.Entry entry = this.find(this.\u0102);
        return entry;
    }

    private AbstractTreeMap.Entry \u0101(float f2, int n2) {
        this.\u0102.\u0107 = f2;
        this.\u0102.\u0101 = n2;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.\u0102);
        return entry;
    }

    private AbstractTreeMap.Entry \u0103(float f2, int n2) {
        this.\u0102.\u0107 = f2;
        this.\u0102.\u0101 = n2;
        AbstractTreeMap.Entry entry = this.findCeiling(this.\u0102);
        return entry;
    }

    private class A
    extends AbstractTreeMap.KeyIterator {
        public A() {
        }

        public A(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
            super(entry, entry2);
        }

        @Override
        public boolean isFloatSupported() {
            return true;
        }

        @Override
        public float nextFloat() {
            return this.\u0104().getFloatKey();
        }
    }

    static class B
    extends AbstractTreeMap.Entry {
        float \u0107;

        public B(float f2, int n2) {
            super(n2);
            this.\u0107 = f2;
        }

        public B(float f2, int n2, AbstractTreeMap.Entry entry, int n3) {
            super(n2, entry, n3);
            this.\u0107 = f2;
        }

        @Override
        public float getFloatKey() {
            return this.\u0107;
        }

        @Override
        public Object getKey() {
            return new Float(this.\u0107);
        }

        @Override
        public boolean keyEquals(AbstractTreeMap.Entry entry) {
            return entry instanceof B && this.\u0107 == ((B)entry).\u0107;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof B)) {
                return false;
            }
            B b2 = (B)object;
            return this.\u0107 == b2.\u0107 && this.\u0106 == b2.\u0106;
        }

        @Override
        public int hashCode() {
            int n2 = Float.floatToIntBits(this.\u0107);
            int n3 = this.\u0106;
            return n2 ^ n3 ^ this.\u0101;
        }

        @Override
        public String toString() {
            return this.\u0107 + "=" + this.\u0106;
        }

        @Override
        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.\u0107 = entry.getFloatKey();
        }
    }
}

