/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.stats.metrics;

import com.nuodb.impl.stats.metrics.MetricImpl;
import com.nuodb.impl.stats.metrics.MetricQueryImpl;
import com.nuodb.impl.stats.metrics.RangeImpl;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.stats.metrics.Metric;
import com.nuodb.stats.metrics.MetricQuery;
import com.nuodb.stats.metrics.MetricRequest;
import com.nuodb.stats.metrics.Range;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;

public class MetricRequestImpl
implements MetricRequest {
    private Range range;
    private Metric metric;
    private MetricQuery metricQuery;
    private String breakdown = null;
    private String aggrFunc = null;

    public MetricRequestImpl(Metric metric, Range range) {
        this.metric = metric;
        this.range = range;
        this.metricQuery = null;
    }

    public MetricRequestImpl(MetricQuery metric, Range range) {
        this.metricQuery = metric;
        this.metric = null;
        this.range = range;
    }

    public MetricRequestImpl(Tag tag) throws XmlException {
        Preconditions.checkArgument("MetricRequest".equals(tag.getName()), "not a MetricRequest tag: %s", tag);
        this.range = new RangeImpl(tag.getChild("Range"));
        this.breakdown = tag.getAttribute("breakdown", null);
        this.aggrFunc = tag.getAttribute("aggrFunc", "Sum");
        Tag child = tag.findChild("Metric");
        if (child != null) {
            this.metric = new MetricImpl(child);
            return;
        }
        child = tag.findChild("MetricQuery");
        if (child != null) {
            this.metricQuery = new MetricQueryImpl(child);
            return;
        }
        throw new IllegalArgumentException("Tag contains neiher MetricQuery nor Metric: " + tag);
    }

    @Override
    public MetricRequest encode(Tag tag) {
        if (this.metric != null) {
            tag.addChild(this.metric.toTag());
        }
        if (!StringUtils.isEmpty(this.breakdown)) {
            tag.setAttribute("breakdown", this.breakdown);
        }
        String funcVal = StringUtils.isEmpty(this.aggrFunc) ? "Sum" : this.aggrFunc;
        tag.setAttribute("aggrFunc", funcVal);
        if (this.metricQuery != null) {
            tag.addChild(this.metricQuery.toTag());
        }
        tag.addChild(this.range.toTag());
        return this;
    }

    @Override
    public Tag toTag() {
        Tag t = TagFactory.createTag("MetricRequest");
        this.encode(t);
        return t;
    }

    @Override
    public Metric getMetric() {
        return this.metric;
    }

    @Override
    public MetricRequest setMetric(Metric metric) {
        this.metric = metric;
        return this;
    }

    @Override
    public MetricQuery getMetricQuery() {
        return this.metricQuery;
    }

    @Override
    public MetricRequest setMetricQuery(MetricQuery metricQuery) {
        this.metricQuery = metricQuery;
        return this;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public MetricRequest setRange(Range range) {
        this.range = range;
        return this;
    }

    @Override
    public String getBreakdown() {
        return this.breakdown;
    }

    @Override
    public MetricRequest setBreakdown(String breakdown) {
        this.breakdown = breakdown;
        return this;
    }

    @Override
    public MetricRequest setAggrFunc(String aggrFunc) {
        this.aggrFunc = aggrFunc;
        if (aggrFunc != null) {
            Preconditions.checkArgument(aggrFunc.equals("Sum") || aggrFunc.equals("Average"), "invalid aggrFunc: " + aggrFunc);
        }
        return this;
    }

    @Override
    public String getAggrFunc() {
        return this.aggrFunc;
    }
}

