/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.RecoverableOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLWarning;

public abstract class ServerCommunication {
    public static final String AUTOCOMMIT = "autocommit";
    public static final String FETCHSIZE = "fetchsize";
    public static final String SCHEMA = "schema";
    public static final String CLIENT_NAME = "clientname";
    public static final String CLIENT_VERSION = "clientversion";
    public static final String LOGINTIMEOUT = "logintimeout";
    public static final String CONNECTTIMEOUT = "connecttimeout";
    public static final String ENCRYPTION = "encryption";
    public static final String QUERYTIMEOUT = "querytimeout";
    public static final String SUPERCONNECTION = "superconnection";
    public static final String FEEDBACKINTERVAL = "feedbackinterval";
    public static final String SNAPSHOTTRANSACTIONS = "snapshottransactions";
    public static final String DEFAULT_DATEFORMAT = "YYYY-MM-DD";
    public static final String DEFAULT_TIMESTAMPFORMAT = "YYYY-MM-DD HH:MI:SS.FF3";
    public static final String DEFAULT_NUMERIC_CHARACTERS = ".,";
    public static final String KERBEROS_SERVICE_NAME = "kerberosservicename";
    public static final String KERBEROS_HOST_NAME = "kerberoshostname";
    public static final String KERBEROS_REALM = "kerberosrealm";
    public static final String KERBEROS_USER_NAME = "kerberosusername";
    public static final String KERBEROS_CONFIG_FILE = "kerberosconfig";
    public static final String KERBEROS_GSS_CONFIG_FILE = "kerberosgssconfig";
    public static final String LOGIN_TYPE = "loginType";
    public static final String TESTCONNECTIONSTRINGONLY = "TestConnectionStringOnly";
    public static final String CONNECTION_POOL_SIZE = "connectionPoolSize";
    public static final String SLAVE = "slave";
    public static final String SLAVE_TOKEN = "slavetoken";
    public static final String USE_MICRO_CACHE = "metadataCache";
    public static final String METADATA_USE_SQL = "metadataSQL";
    public static final String DEBUG = "debug";
    public static final String USER_ID = "user";
    public static final String PASSWORD = "password";
    public static final String LOG_DIR = "logdir";
    protected ByteArrayOutputStream outData;
    protected EXAOutputStream outStream;
    protected byte[] tmpBytes;
    protected byte[] tmpBytes2;
    protected InMessage tmpInMessage;
    protected OutMessage tmpOutMessage;
    protected EXAResult[] tmpEXAResults;
    protected DebugLog debug;
    protected static boolean trace_exception = false;
    protected String className;
    protected EXAConnection connection;
    static int UNIQUE_ID = 0;
    int uid = ++UNIQUE_ID;
    private int reconnectWatcher = 0;

    protected int getObjectId() {
        return this.uid;
    }

    public ServerCommunication(DebugLog debugLog, String string, EXAConnection eXAConnection) {
        this.connection = eXAConnection;
        this.className = string;
        this.debug = debugLog;
        this.outData = new ByteArrayOutputStream();
        this.outStream = new EXAOutputStream(this.outData, this.connection);
        this.tmpBytes = null;
        this.tmpBytes2 = null;
        this.tmpInMessage = null;
        this.tmpOutMessage = null;
    }

    protected void logStackTrace(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(throwable.toString()).append("\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stringBuffer.append(stackTraceElement.toString() + "\n");
        }
        this.log(stringBuffer.toString());
    }

    public void clientLog(Object object) {
        this.log(object);
    }

    protected void log(Object object) {
        if (this.debug != null) {
            this.debug.log(this.getObjectId() + " " + this.className + ": " + object.toString());
        }
    }

    protected void log(Object object, int n) {
        this.log(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handle(RecoverableOperation recoverableOperation) throws IOException, SQLException {
        int n = 0;
        do {
            StringWriter stringWriter;
            ++n;
            try {
                recoverableOperation.op();
                return;
            }
            catch (IOException iOException) {
                stringWriter = new StringWriter();
                iOException.printStackTrace(new PrintWriter(stringWriter));
                this.log(" got IOException: " + iOException.getMessage() + "\n" + stringWriter.toString());
                this.connection.clearWarnings();
                try {
                    if (this.reconnectWatcher > 0) {
                        this.reconnectWatcher = 0;
                        throw new ConnectionException(iOException.toString() + " Reconnect not possible, check for previous errors.");
                    }
                    ++this.reconnectWatcher;
                    this.connection.reconnect();
                }
                finally {
                    --this.reconnectWatcher;
                }
            }
            catch (ConnectionException | SQLInvalidAuthorizationSpecException sQLException) {
                stringWriter = new StringWriter();
                sQLException.printStackTrace(new PrintWriter(stringWriter));
                this.log(" got ConnectionException: " + sQLException.getSQLState() + " " + sQLException.getMessage() + "\n" + stringWriter.toString());
                this.connection.clearWarnings();
                try {
                    if (this.reconnectWatcher > 0) {
                        this.reconnectWatcher = 0;
                        throw new ConnectionException(sQLException.toString() + " Reconnect not possible, check for previous errors.");
                    }
                    ++this.reconnectWatcher;
                    this.connection.reconnect();
                }
                finally {
                    --this.reconnectWatcher;
                }
            }
            SQLWarning sQLWarning = this.connection.getWarnings();
            if (sQLWarning == null) continue;
            this.connection.clearWarnings();
            throw sQLWarning;
        } while (n < 2);
    }
}

