/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.datawrapper;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.ErrorException;

public final class SqlDoubleDataWrapper
extends DefaultSqlDataWrapper {
    private double m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;
    private final int m_type;

    public SqlDoubleDataWrapper(int n) {
        assert (n == 8 || n == 6);
        this.m_type = n;
    }

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Data requested, but the data is null.");
        }
        return this.m_data;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public boolean isNull() {
        return this.m_isNull;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_isNull = false;
        this.m_data = bl ? 1.0 : 0.0;
    }

    @Override
    public void setDouble(double d) {
        this.setData(d);
    }

    @Override
    public void setInteger(long l) {
        this.setData(l);
    }

    @Override
    public void setReal(float f) {
        this.setData(f);
    }

    @Override
    public void setSmallInt(int n) {
        this.setData(n);
    }

    @Override
    public void setTinyInt(short s) {
        this.setData(s);
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    private void setData(double d) {
        this.m_isSet = true;
        this.m_data = d;
        this.m_isNull = false;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case 4: {
                        this.setInteger(dataWrapper.getInteger());
                        break;
                    }
                    case 5: {
                        this.setSmallInt(dataWrapper.getSmallInt());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    case 8: {
                        this.setDouble(dataWrapper.getDouble());
                        break;
                    }
                    case 6: {
                        this.setDouble(dataWrapper.getFloat());
                        break;
                    }
                    case 7: {
                        this.setReal(dataWrapper.getReal().floatValue());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(this.m_type);
            return;
        }
        switch (this.m_type) {
            case 8: {
                dataWrapper.setDouble(this.m_data);
                break;
            }
            case 6: {
                dataWrapper.setFloat(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException("Data must be SQL_DOUBLE or SQL_FLOAT.");
            }
        }
    }
}

