/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.aetree.AESortSpec;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AESort
extends AEUnaryRelationalExpr {
    private static final int NUM_CHILDREN = 1;
    private List<AESortSpec> m_sortSpecs;
    private int m_accessibleColCount;

    public AESort(AERelationalExpr aERelationalExpr, List<AESortSpec> list, int n) {
        super(aERelationalExpr);
        this.m_sortSpecs = new ArrayList<AESortSpec>(list);
        if (n < 0 || n > aERelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("Invalid restricted column count.");
        }
        this.m_accessibleColCount = n;
    }

    private AESort(AESort aESort) {
        super(aESort);
        this.m_sortSpecs = new ArrayList<AESortSpec>(aESort.m_sortSpecs);
        this.m_accessibleColCount = aESort.m_accessibleColCount;
    }

    public List<AESortSpec> getSortSpecs() {
        return Collections.unmodifiableList(this.m_sortSpecs);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (iAENode == this) {
            return true;
        }
        if (!(iAENode instanceof AESort)) {
            return false;
        }
        AESort aESort = (AESort)iAENode;
        return this.getOperand().isEquivalent(aESort.getOperand()) && this.m_sortSpecs.equals(aESort.m_sortSpecs);
    }

    @Override
    public AESort copy() {
        return new AESort(this);
    }

    @Override
    public int getColumnCount() {
        return this.m_accessibleColCount;
    }

    @Override
    public IColumn getColumn(int n) {
        if (0 > n || n >= this.m_accessibleColCount) {
            throw new IndexOutOfBoundsException();
        }
        return super.getColumn(n);
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
        for (AESortSpec aESortSpec : this.m_sortSpecs) {
            this.getOperand().setDataNeeded(this.getOperand(), aESortSpec.getColumnNumber());
        }
        this.getOperand().setDataNeededOnChild();
    }

    @Override
    protected IAENode getChild(int n) {
        if (0 != n) {
            throw new IndexOutOfBoundsException("There is no child at index: " + n);
        }
        return this.getOperand();
    }
}

