/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.SQLState;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;

public enum SQLStateException {
    SQL_SUCCESS("00"){

        @Override
        public SQLException create(String message, String state, int code) {
            return this.createDefault(message, state, code);
        }
    }
    ,
    SQL_WARNING("01"){

        @Override
        public SQLException create(String message, String state, int code) {
            return this.createDefault(message, state, code);
        }
    }
    ,
    SQL_CONNECTION_ERROR("08"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLTransientConnectionException(message, state, code);
        }
    }
    ,
    SQL_TRANSACTION_STATE_UNKNOWN("08007"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLRecoverableException(message, state, code);
        }
    }
    ,
    SQL_FEATURE_NOT_SUPPORTED("0A"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLFeatureNotSupportedException(message, state, code);
        }
    }
    ,
    SQL_DATA("22"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLDataException(message, state, code);
        }
    }
    ,
    SQL_INTEGRITY_CONSTRAINT_VALIDATION("23"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLIntegrityConstraintViolationException(message, state, code);
        }
    }
    ,
    SQL_INVALID_AUTHORIZATION("28"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLInvalidAuthorizationSpecException(message, state, code);
        }
    }
    ,
    SQL_TRANSIENT_ROLLBACK("40"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLTransactionRollbackException(message, state, code);
        }
    }
    ,
    SQL_SYNTAX_ERROR("42"){

        @Override
        public SQLException create(String message, String state, int code) {
            return new SQLSyntaxErrorException(message, state, code);
        }
    }
    ,
    SQL_SYSTEM_ERROR("58"){

        @Override
        public SQLException create(String message, String state, int code) {
            if (code == SQLState.LOCK_TIMEOUT.getCode()) {
                return new SQLTimeoutException(message, state, code);
            }
            return this.createDefault(message, state, code);
        }
    }
    ,
    SQL_ODBC_ERROR("HY"){

        @Override
        public SQLException create(String message, String state, int code) {
            if (code == SQLState.OPERATION_TIMEOUT.getCode()) {
                return new SQLTimeoutException(message, state, code);
            }
            return this.createDefault(message, state, code);
        }
    }
    ,
    SQL_UNKNOWN_EXCEPTION(""){

        @Override
        public SQLException create(String message, String state, int code) {
            return this.createDefault(message, state, code);
        }
    };

    private String fullState;
    private String stateClass;

    private SQLStateException(String state) {
        this.fullState = state;
        this.stateClass = this.fullState.length() >= 2 ? this.fullState.substring(0, 2) : this.fullState;
    }

    public String getStateClass() {
        return this.stateClass;
    }

    public String getFullState() {
        return this.fullState;
    }

    public static SQLStateException fromState(String state) {
        for (SQLStateException value : SQLStateException.values()) {
            if (!value.getFullState().equals(state)) continue;
            return value;
        }
        return SQLStateException.fromStateClass(state.substring(0, 2));
    }

    public static SQLStateException fromStateClass(String stateClass) {
        for (SQLStateException value : SQLStateException.values()) {
            if (!value.getStateClass().equals(stateClass)) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Unknown state class %s", stateClass));
    }

    public SQLException createDefault(String message, String state, int code) {
        return new SQLException(message, state, code);
    }

    public abstract SQLException create(String var1, String var2, int var3);

    public void raise(String message, String state, int code) throws SQLException {
        throw this.create(message, state, code);
    }
}

