/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.net;

import java.io.IOException;
import java.io.InputStream;

public class LengthUtil {
    public static int readLength(InputStream stream, byte[] lengthBuffer) throws IOException {
        int lengthRead;
        for (int remaining = 4; remaining > 0; remaining -= lengthRead) {
            lengthRead = stream.read(lengthBuffer, 4 - remaining, remaining);
            if (lengthRead != -1) continue;
            throw new IOException("End of stream reached");
        }
        return LengthUtil.getLength(lengthBuffer);
    }

    public static void writeLength(int messageLength, byte[] lengthBuffer) {
        int n = 3;
        int length = messageLength;
        while (n >= 0) {
            lengthBuffer[n] = (byte)length;
            --n;
            length >>= 8;
        }
    }

    public static int getLength(byte[] buf) {
        int len = 0;
        for (int n = 0; n < 4; ++n) {
            len = len << 8 | buf[n] & 0xFF;
        }
        return len;
    }
}

