/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.range.Range;
import com.jidesoft.range.StringRange;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class StringUtils {
    public static String toCamelCase(String string) {
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        return string2.toUpperCase() + string3.toLowerCase();
    }

    public static String stringList(String string, String string2, String string3, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuilder.append(objectArray[i2].toString());
            if (i2 >= objectArray.length - 1) continue;
            stringBuilder.append(string3);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String stringList(Object[] objectArray) {
        return StringUtils.stringList("[", "]", ",", objectArray);
    }

    public static String stringList(List<?> list) {
        if (list == null) {
            return "";
        }
        return StringUtils.stringList(list.toArray());
    }

    public static String min(List<String> list) {
        String string = null;
        for (String string2 : list) {
            if (string != null && string2.compareTo(string) >= 0) continue;
            string = string2;
        }
        return string;
    }

    public static String max(List<String> list) {
        String string = null;
        for (String string2 : list) {
            if (string != null && string2.compareTo(string) <= 0) continue;
            string = string2;
        }
        return string;
    }

    public static Range<String> range(List<String> list) {
        String string = null;
        String string2 = null;
        for (String string3 : list) {
            if (string2 == null || string3.compareTo(string2) > 0) {
                string2 = string3;
            }
            if (string != null && string3.compareTo(string) >= 0) continue;
            string = string3;
        }
        return new StringRange(string, string2);
    }

    public static String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringUtils.unescapeJava(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void unescapeJava(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string != null) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(4);
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (bl2) {
                    stringBuilder.append(c2);
                    if (stringBuilder.length() != 4) continue;
                    try {
                        int n3 = Integer.parseInt(stringBuilder.toString(), 16);
                        writer.write((char)n3);
                        stringBuilder.setLength(0);
                        bl2 = false;
                        bl = false;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RuntimeException("Unable to parse unicode value: " + stringBuilder, numberFormatException);
                    }
                }
                if (bl) {
                    bl = false;
                    switch (c2) {
                        case '\"': {
                            writer.write(34);
                            break;
                        }
                        case '\'': {
                            writer.write(39);
                            break;
                        }
                        case '\\': {
                            writer.write(92);
                            break;
                        }
                        case 'b': {
                            writer.write(8);
                            break;
                        }
                        case 'f': {
                            writer.write(12);
                            break;
                        }
                        case 'n': {
                            writer.write(10);
                            break;
                        }
                        case 'r': {
                            writer.write(13);
                            break;
                        }
                        case 't': {
                            writer.write(9);
                            break;
                        }
                        case 'u': {
                            bl2 = true;
                            break;
                        }
                        default: {
                            writer.write(c2);
                            break;
                        }
                    }
                    continue;
                }
                if (c2 == '\\') {
                    bl = true;
                    continue;
                }
                writer.write(c2);
            }
            if (bl) {
                writer.write(92);
            }
        }
    }
}

