/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.search;

import com.jidesoft.search.FindAndReplaceEvent;
import com.jidesoft.search.FindAndReplaceListener;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResult;
import com.jidesoft.search.FindResults;
import com.jidesoft.search.PromptDialog;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;

public class FindAndReplace {
    private static Logger \u010f;
    public static final int SCOPE_GLOBAL = 0;
    public static final int SCOPE_SELECTION = 1;
    public static final int ORIGIN_ENTIRE = 0;
    public static final int ORIGIN_FROM_CURSOR = 1;
    private List<FindAndReplaceTarget> \u010b;
    private FindAndReplaceTarget \u010a;
    private String \u0107;
    private String \u0115;
    private Vector<String> \u0118 = new Vector();
    private Vector<String> \u010c = new Vector();
    private boolean \u0116;
    private boolean \u0110 = true;
    private boolean \u010d = false;
    private boolean \u0103 = false;
    private boolean \u0114 = false;
    private int \u0113 = 0;
    private int \u0109 = 1;
    private Matcher \u0101;
    private boolean \u0117 = true;
    private boolean \u0106 = false;
    private boolean \u0108;
    private boolean \u0104 = true;
    private int \u0119 = 0;
    private StringBuilder \u0102 = null;
    private EventListenerList \u0111 = null;
    protected Pattern _pattern;
    private Rectangle \u010e;
    private boolean \u0105;
    private boolean \u0112 = false;
    public static FindResult EMPTY_RESULT;

    public FindAndReplaceTarget getTarget() {
        return this.\u010a == null && this.\u010b != null && this.\u010b.size() == 1 ? this.\u010b.get(0) : this.\u010a;
    }

    public void setTarget(FindAndReplaceTarget findAndReplaceTarget) {
        if (this.\u010a != findAndReplaceTarget) {
            this.\u010a = findAndReplaceTarget;
            this.\u0105 = true;
        }
    }

    public void addTarget(FindAndReplaceTarget findAndReplaceTarget) {
        if (this.\u010b == null) {
            this.\u010b = new ArrayList<FindAndReplaceTarget>();
        }
        this.\u010b.add(findAndReplaceTarget);
    }

    public void removeTarget(FindAndReplaceTarget findAndReplaceTarget) {
        this.\u010b.remove(findAndReplaceTarget);
    }

    public FindAndReplaceTarget[] getTargets() {
        return this.\u010b.toArray(new FindAndReplaceTarget[this.\u010b.size()]);
    }

    public String getFindText() {
        return this.\u0107;
    }

    public void setFindText(String string) {
        this.\u0107 = string;
    }

    public String getReplaceText() {
        return this.\u0115;
    }

    public void setReplaceText(String string) {
        this.\u0115 = string;
    }

    public Vector<String> getFindHistory() {
        return this.\u0118;
    }

    public void setFindHistory(Vector<String> vector) {
        this.\u0118 = vector;
    }

    public Vector<String> getReplaceHistory() {
        return this.\u010c;
    }

    public void setReplaceHistory(Vector<String> vector) {
        this.\u010c = vector;
    }

    public boolean isUseRegexOrWildcards() {
        return this.\u0116;
    }

    public void setUseRegexOrWildcards(boolean bl) {
        this.\u0116 = bl;
    }

    public boolean isUseWildcards() {
        return this.\u010d;
    }

    public void setUseWildcards(boolean bl) {
        this.\u010d = bl;
    }

    public boolean isUseRegex() {
        return this.\u0110;
    }

    public void setUseRegex(boolean bl) {
        this.\u0110 = bl;
    }

    public boolean isMatchWholeWord() {
        return this.\u0114;
    }

    public void setMatchWholeWord(boolean bl) {
        this.\u0114 = bl;
    }

    public boolean isMatchCase() {
        return this.\u0103;
    }

    public void setMatchCase(boolean bl) {
        this.\u0103 = bl;
    }

    public int getScope() {
        return this.\u0113;
    }

    public void setScope(int n2) {
        this.\u0113 = n2;
    }

    public int getOrigin() {
        return this.\u0109;
    }

    public void setOrigin(int n2) {
        this.\u0109 = n2;
    }

    public void searchAgain() {
        if (this.\u0101 != null) {
            this.initialCharSequence();
            this.search(this.\u0101);
        }
    }

    protected int getFlags() {
        int n2 = 0;
        if (!this.isMatchCase()) {
            n2 |= 2;
        }
        return n2 |= 8;
    }

    protected Matcher getMatcher() {
        String string = this.getFindText();
        if (this.isUseRegexOrWildcards()) {
            if (!this.isUseRegex() && this.isUseWildcards()) {
                DefaultWildcardSupport defaultWildcardSupport = new DefaultWildcardSupport();
                string = defaultWildcardSupport.convert(string);
                string = string.replaceAll("\\[\\!", "[^");
                string = string.replaceAll("#", "\\\\d");
                string = string.replaceAll("\\#", "#");
            }
        } else {
            string = string.replaceAll("([\\{\\}\\[\\]\\(\\)\\$\\^\\.\\*\\\\\\+\\?\\|])", "\\\\$1");
        }
        this._pattern = Pattern.compile(this.isMatchWholeWord() ? "\\b" + string + "\\b" : string, this.getFlags());
        this.initialCharSequence();
        return this._pattern.matcher(this.\u0102);
    }

    protected void initialCharSequence() {
        if (this.\u0102 == null || this.\u0105 || this.getTarget().isTargetChanged()) {
            this.\u0102 = new StringBuilder(this.getTarget().getCurrentText());
            this.\u0105 = false;
            int n2 = this.\u0119 = this.\u0102 != null ? this.\u0102.length() : 0;
            if (this.\u0101 != null) {
                this.\u0101 = this._pattern.matcher(this.\u0102);
            }
        }
    }

    public void search() {
        if (this.getFindText() == null || this.getFindText().length() == 0) {
            return;
        }
        this.fireFindAndReplaceEvent(0);
        this.setForward(!this.isReversed());
        this.\u0112 = this.getOrigin() == 0;
        Matcher matcher = null;
        try {
            matcher = this.getMatcher();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName());
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFound"), this.getFindText()));
            this.fireFindAndReplaceEvent(2);
            return;
        }
        this.getTarget().adjustCurrentPosition(this.getFindText(), this.isForward());
        this.search(matcher);
    }

    public FindResults searchAll() {
        if (this.getFindText() == null || this.getFindText().length() == 0) {
            return null;
        }
        this.setForward(true);
        int n2 = 0;
        this.fireFindAndReplaceEvent(0);
        FindResults findResults = new FindResults(this.getTarget().getResourceString("FindAndReplace.foundUsages"), this.getTarget().getIntepreter());
        FindResults findResults2 = new FindResults(this.getTarget().getCurrentName(), this.getTarget().getIntepreter());
        this.fireFindAndReplaceEvent(1, this.getTarget().getCurrentName());
        try {
            while (true) {
                Matcher matcher;
                this.\u0101 = matcher = this.getMatcher();
                FindResult findResult = this.findNext(matcher, n2);
                if (EMPTY_RESULT == findResult) {
                    findResults.addFindResults(findResults2);
                    this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName(), findResults2);
                    if (!this.getTarget().hasNext()) break;
                    this.getTarget().next();
                    findResults2 = new FindResults(this.getTarget().getCurrentName(), this.getTarget().getIntepreter());
                    n2 = 0;
                    this.textChanged();
                    this.fireFindAndReplaceEvent(1, this.getTarget().getCurrentName());
                    continue;
                }
                findResults2.addFindResult(findResult);
                n2 = findResult.getEnd();
                this.fireFindAndReplaceEvent(4, findResult);
            }
            this.fireFindAndReplaceEvent(2, findResults);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName());
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFound"), this.getFindText()));
            this.fireFindAndReplaceEvent(2);
        }
        return findResults;
    }

    public void search(Matcher matcher) {
        int n2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        block19: {
            block20: {
                int n3;
                bl3 = false;
                int n4 = this.\u0112 ? (this.isForward() ? 0 : this.\u0119) : (n3 = this.getTarget().getCurrentPosition(this.isForward()));
                if (this.\u0112) {
                    this.\u0112 = false;
                }
                bl2 = false;
                bl = false;
                n2 = 0;
                while (true) {
                    int n5;
                    ++n2;
                    FindResult findResult = this.findNext(matcher, n3);
                    if (findResult == EMPTY_RESULT) {
                        this.fireFindAndReplaceEvent(3, this.getTarget().getCurrentName());
                        if (this.getTarget().hasNext()) {
                            this.getTarget().next();
                            n3 = 0;
                            bl = false;
                            matcher = this.getMatcher();
                            this.fireFindAndReplaceEvent(1, this.getTarget().getCurrentName());
                            continue;
                        }
                        break block19;
                    }
                    if (!bl2 && !bl) {
                        this.getTarget().highlight(findResult.getStart(), findResult.getEnd());
                    }
                    this.fireFindAndReplaceEvent(4, findResult);
                    if (!this.isReplace()) break block20;
                    String string = this.getReplaceText();
                    if (this.isUseRegexOrWildcards() && this.isUseRegex()) {
                        try {
                            string = this.getTarget().getCurrentText().subSequence(findResult.getStart(), findResult.getEnd()).toString().replaceAll(this.getFindText(), StringUtils.unescapeJava(this.getReplaceText()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl2 || bl) {
                        n5 = this.replace(findResult, string);
                        this.\u0119 += n5;
                        int n6 = n3 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + n5 + 1;
                        if (this.getTarget().isTargetChanged()) {
                            this.textChanged();
                        } else {
                            this.\u0102.replace(findResult.getStart(), findResult.getEnd(), string);
                        }
                        matcher = this.getMatcher();
                        continue;
                    }
                    n5 = this.promptForReplace();
                    switch (n5) {
                        case 0: {
                            int n7 = this.replace(findResult, string);
                            n3 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + n7 + 1;
                            matcher = this.getMatcher();
                            break;
                        }
                        case 1: {
                            n3 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + 1;
                            break;
                        }
                        case 2: {
                            this.getTarget().replaceAllStarts();
                            n2 = 0;
                            int n7 = this.replace(findResult, string);
                            n3 = this.isReversed() ? findResult.getStart() - 1 : findResult.getStart() + n7 + 1;
                            this.textChanged();
                            matcher = this.getMatcher();
                            bl2 = true;
                            break;
                        }
                        case 3: {
                            this.getTarget().replaceAllStarts();
                            bl = true;
                            break;
                        }
                    }
                    if (n5 == -1) break;
                }
                bl3 = true;
                break block19;
            }
            bl3 = true;
        }
        if (!(bl2 || bl || bl3)) {
            this.searchFinished();
        }
        if (bl2 || bl) {
            this.getTarget().replaceAllEnds();
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.replacedAll"), n2));
        }
        this.\u0101 = matcher;
    }

    protected int promptForReplace() {
        Window window = this.getTarget().getPromptDialogParent();
        boolean bl = this.getTarget().hasNext();
        PromptDialog promptDialog = window instanceof Frame ? new PromptDialog((Frame)window, this.getTarget().getResourceString("FindAndReplace.replaceTitle"), MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.replaceMessage"), this.getReplaceText()), bl, this.getTarget()) : new PromptDialog((Dialog)window, this.getTarget().getResourceString("FindAndReplace.replaceTitle"), MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.replaceMessage"), this.getReplaceText()), bl, this.getTarget());
        promptDialog.pack();
        Point point = this.getTarget().getPromptDialogLocation(promptDialog.getBounds());
        if (point != null) {
            promptDialog.setLocation(point);
        } else {
            if (this.\u010e != null) {
                promptDialog.setBounds(this.\u010e);
            } else {
                promptDialog.setLocation(this.getTarget().getPromptDialogLocation());
            }
            this.getTarget().scrollToShowCaret(promptDialog.getBounds());
            promptDialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (componentEvent.getSource() instanceof PromptDialog) {
                        FindAndReplace.this.\u010e = ((PromptDialog)componentEvent.getSource()).getBounds();
                    }
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    if (componentEvent.getSource() instanceof PromptDialog) {
                        FindAndReplace.this.\u010e = ((PromptDialog)componentEvent.getSource()).getBounds();
                    }
                }
            });
        }
        promptDialog.setVisible(true);
        return promptDialog.getDialogResult();
    }

    protected FindResult findNext(Matcher matcher, int n2) {
        boolean bl = this.isForward();
        if (n2 >= this.\u0119 && bl) {
            return EMPTY_RESULT;
        }
        if (n2 <= 0 && !bl) {
            return EMPTY_RESULT;
        }
        if (bl) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (matcher.find(n2) && matcher.end() <= this.\u0119) {
                return new FindResult(matcher.start(), matcher.end(), this.getTarget().getIntepreter());
            }
            return EMPTY_RESULT;
        }
        int n3 = -1;
        matcher.reset();
        int n4 = -1;
        while (matcher.find() && matcher.end() <= n2) {
            n3 = matcher.start();
            n4 = matcher.end();
        }
        if (n3 < 0) {
            return EMPTY_RESULT;
        }
        return new FindResult(n3, n4, this.getTarget().getIntepreter());
    }

    public int replace(FindResult findResult, String string) {
        try {
            this.getTarget().replace(findResult.getStart(), findResult.getEnd() - findResult.getStart(), string);
            this.fireFindAndReplaceEvent(5, findResult, string);
            return string.length() - (findResult.getEnd() - findResult.getStart());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public void textChanged() {
        this.\u0102 = null;
        this.\u0119 = 0;
    }

    protected void searchFinished() {
        boolean bl;
        boolean bl2 = this.isForward();
        try {
            this.setForward(true);
            bl = this.findNext(this.getMatcher(), 0) != EMPTY_RESULT;
        }
        finally {
            this.setForward(bl2);
        }
        if (!bl) {
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFound"), this.getFindText()));
        } else if (this.isForward()) {
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFoundFromTop"), this.getFindText(), this.isReversed() ? this.getTarget().getResourceString("FindAndReplace.backwardSearchKeyStroke") : this.getTarget().getResourceString("FindAndReplace.forwardSearchKeyStroke")));
            this.\u0112 = true;
        } else {
            this.getTarget().showMessage(MessageFormat.format(this.getTarget().getResourceString("FindAndReplace.notFoundFromBottom"), this.getFindText(), this.isReversed() ? this.getTarget().getResourceString("FindAndReplace.forwardSearchKeyStroke") : this.getTarget().getResourceString("FindAndReplace.backwardSearchKeyStroke")));
            this.\u0112 = true;
        }
        this.fireFindAndReplaceEvent(2);
    }

    public boolean isForward() {
        return this.\u0117;
    }

    public void setForward(boolean bl) {
        boolean bl2 = this.\u0117;
        if (bl2 != bl) {
            this.\u0117 = bl;
        }
    }

    public boolean isReversed() {
        return this.\u0106;
    }

    public void setReversed(boolean bl) {
        boolean bl2 = this.\u0106;
        if (bl2 != bl) {
            this.\u0106 = bl;
        }
    }

    public boolean isReplace() {
        return this.\u0108;
    }

    public void setReplace(boolean bl) {
        this.\u0108 = bl;
    }

    public boolean isShowFindAll() {
        return this.\u0104;
    }

    public void setShowFindAll(boolean bl) {
        this.\u0104 = bl;
    }

    public synchronized void addFindAndReplaceListener(FindAndReplaceListener findAndReplaceListener) {
        if (this.\u0111 == null) {
            this.\u0111 = new EventListenerList();
        }
        this.\u0111.add(FindAndReplaceListener.class, findAndReplaceListener);
    }

    public synchronized void removeFindAndReplaceListener(FindAndReplaceListener findAndReplaceListener) {
        this.\u0111.remove(FindAndReplaceListener.class, findAndReplaceListener);
    }

    public FindAndReplaceListener[] getFindAndReplaceListeners() {
        return (FindAndReplaceListener[])this.\u0111.getListeners(FindAndReplaceListener.class);
    }

    protected void fireFindAndReplaceEvent(int n2) {
        if (\u010f.isLoggable(Level.FINE)) {
            \u010f.fine(new FindAndReplaceEvent(this, n2).toString());
        }
        if (this.\u0111 == null) {
            return;
        }
        Object[] objectArray = this.\u0111.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent(this, n2);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i2 + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n2, FindResults findResults) {
        if (\u010f.isLoggable(Level.FINE)) {
            \u010f.fine(new FindAndReplaceEvent((Object)this, n2, findResults).toString());
        }
        if (this.\u0111 == null) {
            return;
        }
        Object[] objectArray = this.\u0111.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n2, findResults);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i2 + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n2, FindResult findResult) {
        if (\u010f.isLoggable(Level.FINE)) {
            \u010f.fine(new FindAndReplaceEvent((Object)this, n2, findResult).toString());
        }
        if (this.\u0111 == null) {
            return;
        }
        Object[] objectArray = this.\u0111.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n2, findResult);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i2 + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n2, FindResult findResult, String string) {
        if (\u010f.isLoggable(Level.FINE)) {
            \u010f.fine(new FindAndReplaceEvent((Object)this, n2, findResult, string).toString());
        }
        if (this.\u0111 == null) {
            return;
        }
        Object[] objectArray = this.\u0111.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n2, findResult, string);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i2 + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n2, String string, FindResults findResults) {
        if (\u010f.isLoggable(Level.FINE)) {
            \u010f.fine(new FindAndReplaceEvent((Object)this, n2, string, findResults).toString());
        }
        if (this.\u0111 == null) {
            return;
        }
        Object[] objectArray = this.\u0111.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n2, string, findResults);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i2 + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    protected void fireFindAndReplaceEvent(int n2, String string) {
        if (\u010f.isLoggable(Level.FINE)) {
            \u010f.fine(new FindAndReplaceEvent((Object)this, n2, string).toString());
        }
        if (this.\u0111 == null) {
            return;
        }
        Object[] objectArray = this.\u0111.getListenerList();
        FindAndReplaceEvent findAndReplaceEvent = new FindAndReplaceEvent((Object)this, n2, string);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != FindAndReplaceListener.class) continue;
            ((FindAndReplaceListener)objectArray[i2 + 1]).statusChanged(findAndReplaceEvent);
        }
    }

    public boolean isTargetChanged() {
        return this.\u0105;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(128)) {
            Lm.showInvalidProductMessage(FindAndReplace.class.getName(), 128);
        }
        \u010f = Logger.getLogger(FindAndReplace.class.getName());
        EMPTY_RESULT = new FindResult(-1, -1, null);
    }
}

