/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.TableSelectionModel;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DefaultTableSelectionModel
implements ListSelectionListener,
TableSelectionModel {
    private static final int \u0109 = -1;
    private static final int \u010a = Integer.MAX_VALUE;
    private static final long \u0106 = -4170746759513164679L;
    protected EventListenerList listenerList = new EventListenerList();
    protected Vector<ListSelectionModel> _listSelectionModels = new Vector();
    protected boolean _withinOneSelection = false;
    protected int _anchorRowIndex = -1;
    protected int _anchorColumnIndex = -1;
    protected int _leadRowIndex = -1;
    protected int _leadColumnIndex = -1;
    protected int _minRowIndex = Integer.MAX_VALUE;
    protected int _minColumnIndex = Integer.MAX_VALUE;
    protected int _maxRowIndex = -1;
    protected int _maxColumnIndex = -1;
    protected boolean _isValueAdjusting = false;
    private int \u0101 = Integer.MAX_VALUE;
    private int \u0108 = Integer.MAX_VALUE;
    private int \u0102 = -1;
    private int \u0104 = -1;
    private int \u0107 = Integer.MAX_VALUE;
    private int \u0103 = -1;
    private int \u0105 = Integer.MAX_VALUE;
    private int \u010b = -1;

    @Override
    public boolean isValueAdjusting() {
        return this._isValueAdjusting;
    }

    @Override
    public void setValueAdjusting(boolean bl) {
        if (this._isValueAdjusting != bl) {
            this._isValueAdjusting = bl;
            this.fireValueChanged(this._isValueAdjusting);
        }
    }

    public void markAsDirty(int n2, int n3, int n4, int n5) {
        this.\u0101 = Math.min(this.\u0101, n2);
        this.\u0102 = Math.max(this.\u0102, n3);
        this.\u0108 = Math.min(this.\u0108, n4);
        this.\u0104 = Math.max(this.\u0104, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelection(int n2, int n3) {
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n3);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.addSelectionInterval(n2, n2);
                this.\u0101(listSelectionModel, n3);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
            this.markAsDirty(n2, n2, n3, n3);
            this.fireValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelection(int n2, int n3) {
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n3);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.removeSelectionInterval(n2, n2);
                this.\u0101(listSelectionModel, n3);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
            this.markAsDirty(n2, n2, n3, n3);
            this.fireValueChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelection(int n2, int n3) {
        this.clearSelection();
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n3);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.setSelectionInterval(n2, n2);
                this.\u0101(listSelectionModel, n3);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.markAsDirty(n2, n2, n3, n3);
        this.fireValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionInterval(int n2, int n3, int n4) {
        this.clearSelection();
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n4);
        if (listSelectionModel != null) {
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.setSelectionInterval(n2, n3);
                this.\u0101(listSelectionModel, n4);
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.markAsDirty(n2, n3, n4, n4);
        this.fireValueChanged();
    }

    @Override
    public void setAnchorSelection(int n2, int n3) {
        int n4 = this._anchorRowIndex;
        int n5 = this._anchorColumnIndex;
        this._anchorRowIndex = n2;
        this._anchorColumnIndex = n3;
        if (n4 != -1 && n5 != -1) {
            this.markAsDirty(Math.min(n4, this._anchorRowIndex), Math.max(n4, this._anchorRowIndex), Math.min(n5, this._anchorColumnIndex), Math.max(n5, this._anchorColumnIndex));
        }
        this._leadColumnIndex = -1;
        this._leadRowIndex = -1;
        this._withinOneSelection = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeadSelection(int n2, int n3) {
        ListSelectionModel listSelectionModel;
        int n4;
        int n5;
        int n6;
        if (this._leadRowIndex == n2 && this._leadColumnIndex == n3) {
            return;
        }
        int n7 = this._leadColumnIndex;
        if (!this._withinOneSelection) {
            this._withinOneSelection = true;
        } else if (this._leadColumnIndex != -1) {
            n6 = Math.min(this._leadColumnIndex, n3);
            n5 = Math.max(this._leadColumnIndex, n3);
            for (n4 = n6; n4 <= n5; ++n4) {
                listSelectionModel = this.getListSelectionModelAt(n4);
                if (listSelectionModel == null) continue;
                try {
                    listSelectionModel.setValueIsAdjusting(true);
                    listSelectionModel.removeSelectionInterval(this._anchorRowIndex, this._leadRowIndex);
                    this.\u0101(listSelectionModel, n4);
                    continue;
                }
                finally {
                    listSelectionModel.setValueIsAdjusting(false);
                }
            }
        }
        n6 = Math.min(this._anchorColumnIndex, n3);
        n5 = Math.max(this._anchorColumnIndex, n3);
        for (n4 = n6; n4 <= n5; ++n4) {
            listSelectionModel = this.getListSelectionModelAt(n4);
            if (listSelectionModel == null) continue;
            try {
                listSelectionModel.setValueIsAdjusting(true);
                if (this._leadRowIndex != -1) {
                    listSelectionModel.removeSelectionInterval(this._anchorRowIndex, this._leadRowIndex);
                }
                listSelectionModel.addSelectionInterval(this._anchorRowIndex, n2);
                this.\u0101(listSelectionModel, n4);
                continue;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this._leadRowIndex = n2;
        this._leadColumnIndex = n3;
        this.markAsDirty(Math.min(n7, Math.min(this._leadRowIndex, this._anchorRowIndex)), Math.max(n7, Math.max(this._leadRowIndex, this._anchorRowIndex)), Math.min(this._leadColumnIndex, this._anchorColumnIndex), Math.max(this._leadColumnIndex, this._anchorColumnIndex));
        this.fireValueChanged();
    }

    @Override
    public void moveLeadSelection(int n2, int n3) {
        if (this._leadRowIndex == n2 && this._leadColumnIndex == n3) {
            return;
        }
        this._leadRowIndex = n2;
        this._leadColumnIndex = n3;
        this.markAsDirty(Math.min(this._leadRowIndex, this._anchorRowIndex), Math.max(this._leadRowIndex, this._anchorRowIndex), Math.min(this._leadColumnIndex, this._anchorColumnIndex), Math.max(this._leadColumnIndex, this._anchorColumnIndex));
        this.fireValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        int n2 = this.getMaxSelectedRowIndex();
        int n3 = this.getMinSelectedRowIndex();
        int n4 = this.getMaxSelectedColumnIndex();
        int n5 = this.getMinSelectedColumnIndex();
        for (int i2 = 0; i2 < this._listSelectionModels.size(); ++i2) {
            ListSelectionModel listSelectionModel = this.getListSelectionModelAt(i2);
            if (listSelectionModel == null || listSelectionModel.isSelectionEmpty()) continue;
            try {
                listSelectionModel.setValueIsAdjusting(true);
                listSelectionModel.clearSelection();
                this.\u0101(listSelectionModel, i2);
                continue;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.\u0101();
        this.markAsDirty(n3, n2, n5, n4);
        this.fireValueChanged();
    }

    private void \u0101() {
        this._minRowIndex = Integer.MAX_VALUE;
        this._maxRowIndex = -1;
        this._minColumnIndex = Integer.MAX_VALUE;
        this._maxColumnIndex = -1;
    }

    private void \u0101(ListSelectionModel listSelectionModel, int n2) {
        if (!listSelectionModel.isSelectionEmpty()) {
            this._minRowIndex = Math.min(this._minRowIndex, listSelectionModel.getMinSelectionIndex());
            this._maxRowIndex = Math.max(this._maxRowIndex, listSelectionModel.getMaxSelectionIndex());
            this._minColumnIndex = Math.min(this._minColumnIndex, n2);
            this._maxColumnIndex = Math.max(this._maxColumnIndex, n2);
        } else {
            this.\u0101();
            for (int i2 = 0; i2 < this._listSelectionModels.size(); ++i2) {
                ListSelectionModel listSelectionModel2 = this.getListSelectionModelAt(i2);
                if (listSelectionModel2 == null || listSelectionModel2.isSelectionEmpty()) continue;
                this._minRowIndex = Math.min(this._minRowIndex, listSelectionModel2.getMinSelectionIndex());
                this._maxRowIndex = Math.max(this._maxRowIndex, listSelectionModel2.getMaxSelectionIndex());
                this._minColumnIndex = Math.min(this._minColumnIndex, i2);
                this._maxColumnIndex = Math.max(this._maxColumnIndex, i2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll(int n2, int n3) {
        this.\u0101(n3);
        for (int i2 = 0; i2 < this._listSelectionModels.size(); ++i2) {
            ListSelectionModel listSelectionModel = this._listSelectionModels.get(i2);
            listSelectionModel.setValueIsAdjusting(true);
            try {
                listSelectionModel.setSelectionInterval(0, n2 - 1);
                this.\u0101(listSelectionModel, i2);
                continue;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
            }
        }
        this.markAsDirty(0, n2 - 1, 0, n3 - 1);
        this.fireValueChanged();
    }

    private void \u0101(int n2) {
        if (n2 != this._listSelectionModels.size()) {
            int n3;
            for (n3 = this._listSelectionModels.size(); n3 > n2; --n3) {
                this.removeColumn();
            }
            while (n2 > n3) {
                this.addColumn();
                ++n3;
            }
        }
    }

    @Override
    public boolean isSelected(int n2, int n3) {
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n3);
        return listSelectionModel != null && listSelectionModel.isSelectedIndex(n2);
    }

    public ListSelectionModel getListSelectionModelAt(int n2) {
        if (n2 >= 0 && n2 < this._listSelectionModels.size()) {
            return this._listSelectionModels.elementAt(n2);
        }
        return null;
    }

    @Override
    public void setColumns(int n2) {
        this._listSelectionModels = new Vector();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addColumn();
        }
    }

    protected void addColumn() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this._listSelectionModels.add(defaultListSelectionModel);
        defaultListSelectionModel.addListSelectionListener(this);
    }

    protected void insertColumn(int n2) {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this._listSelectionModels.add(n2, defaultListSelectionModel);
        defaultListSelectionModel.addListSelectionListener(this);
    }

    protected void removeColumn() {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this._listSelectionModels.lastElement();
        defaultListSelectionModel.removeListSelectionListener(this);
        this._listSelectionModels.remove(defaultListSelectionModel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            TableModel tableModel = (TableModel)propertyChangeEvent.getNewValue();
            this.setColumns(tableModel.getColumnCount());
            TableModel tableModel2 = (TableModel)propertyChangeEvent.getOldValue();
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            tableModel.removeTableModelListener(this);
            tableModel.addTableModelListener(this);
        } else if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
            TableColumnModel tableColumnModel = (TableColumnModel)propertyChangeEvent.getNewValue();
            TableColumnModel tableColumnModel2 = (TableColumnModel)propertyChangeEvent.getOldValue();
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            tableColumnModel.removeColumnModelListener(this);
            tableColumnModel.addColumnModelListener(this);
        }
    }

    @Override
    public void addTableSelectionListener(TableSelectionListener tableSelectionListener) {
        this.listenerList.add(TableSelectionListener.class, tableSelectionListener);
    }

    @Override
    public void removeTableSelectionListener(TableSelectionListener tableSelectionListener) {
        this.listenerList.remove(TableSelectionListener.class, tableSelectionListener);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModel tableModel = (TableModel)tableModelEvent.getSource();
        this.\u0101(tableModel.getColumnCount());
        if (this._leadRowIndex >= tableModel.getRowCount()) {
            this._leadRowIndex = tableModel.getRowCount() - 1;
        }
        if (this._leadColumnIndex >= tableModel.getColumnCount()) {
            this._leadColumnIndex = tableModel.getColumnCount() - 1;
        }
        if (this._anchorRowIndex >= tableModel.getRowCount()) {
            this._anchorRowIndex = tableModel.getRowCount() - 1;
        }
        if (this._anchorColumnIndex >= tableModel.getColumnCount()) {
            this._anchorColumnIndex = tableModel.getColumnCount() - 1;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected void fireValueChanged(boolean bl) {
        if (this.\u0103 == -1 && this.\u010b == -1) {
            return;
        }
        int n2 = this.\u0107;
        int n3 = this.\u0103;
        int n4 = this.\u0105;
        int n5 = this.\u010b;
        this.\u0107 = Integer.MAX_VALUE;
        this.\u0103 = -1;
        this.\u0105 = Integer.MAX_VALUE;
        this.\u010b = -1;
        this.fireValueChanged(this, n2, n3, n4, n5, bl);
    }

    protected void fireValueChanged(Object object, int n2, int n3, int n4, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        TableSelectionEvent tableSelectionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableSelectionListener.class) continue;
            if (tableSelectionEvent == null) {
                tableSelectionEvent = new TableSelectionEvent(object, n2, n3, n4, n4, bl);
            }
            ((TableSelectionListener)objectArray[i2 + 1]).valueChanged(tableSelectionEvent);
        }
    }

    protected void fireValueChanged() {
        if (this.\u0102 == -1 && this.\u0104 == -1) {
            return;
        }
        this.\u0107 = Math.min(this.\u0107, this.\u0101);
        this.\u0103 = Math.max(this.\u0103, this.\u0102);
        this.\u0105 = Math.min(this.\u0105, this.\u0108);
        this.\u010b = Math.max(this.\u010b, this.\u0104);
        int n2 = this.\u0101;
        int n3 = this.\u0102;
        int n4 = this.\u0108;
        int n5 = this.\u0104;
        this.\u0101 = Integer.MAX_VALUE;
        this.\u0102 = -1;
        this.\u0108 = Integer.MAX_VALUE;
        this.\u0104 = -1;
        this.fireValueChanged(this, n2, n3, n4, n5, this.isValueAdjusting());
    }

    protected void fireValueChanged(Object object, int n2, int n3, int n4, int n5, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        TableSelectionEvent tableSelectionEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != TableSelectionListener.class) continue;
            if (tableSelectionEvent == null) {
                tableSelectionEvent = new TableSelectionEvent(object, n2, n3, n4, n5, bl);
            }
            ((TableSelectionListener)objectArray[i2 + 1]).valueChanged(tableSelectionEvent);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n");
        for (int i2 = 0; i2 < this._listSelectionModels.size(); ++i2) {
            stringBuffer.append("'").append(i2).append("'={");
            ListSelectionModel listSelectionModel = this.getListSelectionModelAt(i2);
            if (listSelectionModel == null) continue;
            int n2 = listSelectionModel.getMinSelectionIndex();
            int n3 = listSelectionModel.getMaxSelectionIndex();
            for (int i3 = n2; i3 < n3; ++i3) {
                if (!listSelectionModel.isSelectedIndex(i3)) continue;
                stringBuffer.append(i3).append(", ");
            }
            if (listSelectionModel.isSelectedIndex(n3)) {
                stringBuffer.append(n3);
            }
            stringBuffer.append("}\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public int getAnchorRowIndex() {
        return this._anchorRowIndex;
    }

    @Override
    public int getAnchorColumnIndex() {
        return this._anchorColumnIndex;
    }

    @Override
    public int getLeadRowIndex() {
        return this._leadRowIndex;
    }

    @Override
    public int getLeadColumnIndex() {
        return this._leadColumnIndex;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._minRowIndex > this._maxRowIndex || this._minColumnIndex > this._maxColumnIndex;
    }

    @Override
    public int[] getSelectedColumns() {
        if (!this.isSelectionEmpty()) {
            int n2 = this.getMinSelectedColumnIndex();
            int n3 = this.getMaxSelectedColumnIndex();
            if (n2 == -1 || n3 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n3 - n2)];
            int n4 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.isColumnSelected(i2)) continue;
                nArray[n4++] = i2;
            }
            int[] nArray2 = new int[n4];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        int n2 = this.getMinSelectedColumnIndex();
        int n3 = this.getMaxSelectedColumnIndex();
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.isColumnSelected(i2)) continue;
            ++n4;
        }
        return n4;
    }

    @Override
    public int[] getSelectedRows() {
        if (!this.isSelectionEmpty()) {
            int n2 = this.getMinSelectedRowIndex();
            int n3 = this.getMaxSelectedRowIndex();
            if (n2 == -1 || n3 == -1) {
                return new int[0];
            }
            int[] nArray = new int[1 + (n3 - n2)];
            int n4 = 0;
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.isRowSelected(i2)) continue;
                nArray[n4++] = i2;
            }
            int[] nArray2 = new int[n4];
            System.arraycopy(nArray, 0, nArray2, 0, n4);
            return nArray2;
        }
        return new int[0];
    }

    @Override
    public int getSelectedRowCount() {
        int n2 = this.getMinSelectedRowIndex();
        int n3 = this.getMaxSelectedRowIndex();
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.isRowSelected(i2)) continue;
            ++n4;
        }
        return n4;
    }

    @Override
    public boolean isRowSelected(int n2) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        for (int i2 = this._minColumnIndex; i2 <= this._maxColumnIndex; ++i2) {
            ListSelectionModel listSelectionModel = this.getListSelectionModelAt(i2);
            if (listSelectionModel == null || !listSelectionModel.isSelectedIndex(n2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int n2) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        ListSelectionModel listSelectionModel = this.getListSelectionModelAt(n2);
        return listSelectionModel != null && !listSelectionModel.isSelectionEmpty();
    }

    @Override
    public int getMinSelectedRowIndex() {
        return this.isSelectionEmpty() ? -1 : this._minRowIndex;
    }

    @Override
    public int getMaxSelectedRowIndex() {
        return this.isSelectionEmpty() ? -1 : this._maxRowIndex;
    }

    @Override
    public int getMinSelectedColumnIndex() {
        return this.isSelectionEmpty() ? -1 : this._minColumnIndex;
    }

    @Override
    public int getMaxSelectedColumnIndex() {
        return this.isSelectionEmpty() ? -1 : this._maxColumnIndex;
    }

    @Override
    public void columnAdded(int n2) {
        this._listSelectionModels.add(n2, new DefaultListSelectionModel());
    }

    @Override
    public void columnRemoved(int n2) {
        if (n2 >= 0 && n2 < this._listSelectionModels.size()) {
            this._listSelectionModels.remove(n2);
        }
    }

    @Override
    public void columnMoved(int n2, int n3) {
        if (n2 != n3) {
            ListSelectionModel listSelectionModel = this._listSelectionModels.remove(n2);
            this._listSelectionModels.add(n3, listSelectionModel);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.columnAdded(tableColumnModelEvent.getToIndex());
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.columnRemoved(tableColumnModelEvent.getFromIndex());
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.columnMoved(tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }
}

