/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.action;

import com.jidesoft.editor.AbstractCodeEditorIntelliHints;
import com.jidesoft.editor.CodeEditor;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public abstract class InputHandler
extends KeyAdapter {
    public static final Action BACKSPACE = new l();
    public static final Action BACKSPACE_WORD = new r();
    public static final Action DELETE = new k();
    public static final Action DELETE_WORD = new m();
    public static final Action DELETE_LINE = new J();
    public static final Action INSERT_BREAK = new N();
    public static final Action SPLIT_LINE = new U();
    public static final Action START_NEW_LINE = new P();
    public static final Action INDENT_SELECTION = new q();
    public static final Action UNINDENT_SELECTION = new p();
    public static final Action JOIN_LINES = new X();
    public static final Action END = new T(false);
    public static final Action DOCUMENT_END = new x(false);
    public static final Action SELECT_ALL = new S();
    public static final Action SELECT_END = new T(true);
    public static final Action SELECT_DOC_END = new x(true);
    public static final Action HOME = new K(false);
    public static final Action DOCUMENT_HOME = new H(false);
    public static final Action SELECT_HOME = new K(true);
    public static final Action SELECT_DOC_HOME = new H(true);
    public static final Action NEXT_CHAR = new h(false);
    public static final Action NEXT_LINE = new I(false);
    public static final Action NEXT_PAGE = new C(false);
    public static final Action NEXT_WORD = new i(false);
    public static final Action SELECT_NEXT_CHAR = new h(true);
    public static final Action SELECT_NEXT_LINE = new I(true);
    public static final Action SELECT_NEXT_PAGE = new C(true);
    public static final Action SELECT_NEXT_WORD = new i(true);
    public static final Action OVERWRITE = new o();
    public static final Action PREV_CHAR = new b(false);
    public static final Action PREV_LINE = new A(false);
    public static final Action PREV_PAGE = new s(false);
    public static final Action PREV_WORD = new c(false);
    public static final Action GOTO_LINE = new R();
    public static final Action FIND = new n();
    public static final Action FIND_NEXT = new f();
    public static final Action FIND_PREVIOUS = new G();
    public static final Action REPLACE = new _();
    public static final Action QUICK_SEARCH = new a();
    public static final Action SELECT_PREV_CHAR = new b(true);
    public static final Action SELECT_PREV_LINE = new A(true);
    public static final Action SELECT_PREV_PAGE = new s(true);
    public static final Action SELECT_PREV_WORD = new c(true);
    public static final Action SELECT_WORD = new y();
    public static final Action SELECT_TO_MATCHING_BRACKET = new D();
    public static final Action REPEAT = new d();
    public static final Action TOGGLE_RECT = new e();
    public static final Action DUPLICATE_SELECTION = new F();
    public static final Action LINE_COMMENTS = new u();
    public static final Action BLOCK_COMMENTS = new B();
    public static final Action CLIP_COPY = new g();
    public static final Action CLIP_PASTE = new E();
    public static final Action CLIP_PASTE_WITH_DIALOG = new O();
    public static final Action CLIP_CUT = new j();
    public static final Action UNDO = new Z();
    public static final Action REDO = new Q();
    public static final Action FOLD_SELECTION = new V();
    public static final Action EXPAND_FOLDING = new M();
    public static final Action COLLAPSE_FOLDING = new w();
    public static final Action EXPAND_ALL = new v();
    public static final Action COLLAPSE_ALL = new L();
    public static final Action INSERT_CHAR = new Y();
    public static final Action TOGGLE_CASE = new t();
    public static final Action ESCAPE = new W();
    protected static final Hashtable<String, Action> ACTIONS = new Hashtable();
    private Timer \u0101;
    protected Action _grabAction;
    protected boolean _repeat;
    protected int _repeatCount;
    protected MacroRecorder recorder;

    protected static void initDefaultActions() {
        ACTIONS.put("Backspace", BACKSPACE);
        ACTIONS.put("Delete to Word Start", BACKSPACE_WORD);
        ACTIONS.put("Delete", DELETE);
        ACTIONS.put("Delete to Word End", DELETE_WORD);
        ACTIONS.put("Delete Current Line", DELETE_LINE);
        ACTIONS.put("Insert Line Break", INSERT_BREAK);
        ACTIONS.put("Split Line", SPLIT_LINE);
        ACTIONS.put("Start New Line", START_NEW_LINE);
        ACTIONS.put("Indent Selection", INDENT_SELECTION);
        ACTIONS.put("Unindent Selection", UNINDENT_SELECTION);
        ACTIONS.put("Join Lines", JOIN_LINES);
        ACTIONS.put("Toggle Insert/Overwrite", OVERWRITE);
        ACTIONS.put("Toggle Rectangular Selection", TOGGLE_RECT);
        ACTIONS.put("Move Caret to Line Start", HOME);
        ACTIONS.put("Move Caret to Line End", END);
        ACTIONS.put("Select All", SELECT_ALL);
        ACTIONS.put("Select to Line Start", SELECT_HOME);
        ACTIONS.put("Select to Line End", SELECT_END);
        ACTIONS.put("Move Caret to Document Start", DOCUMENT_HOME);
        ACTIONS.put("Move Caret to Document End", DOCUMENT_END);
        ACTIONS.put("Select to Document Start", SELECT_DOC_HOME);
        ACTIONS.put("Select to Document End", SELECT_DOC_END);
        ACTIONS.put("Page Up", PREV_PAGE);
        ACTIONS.put("Page Down", NEXT_PAGE);
        ACTIONS.put("Select to Previous Page", SELECT_PREV_PAGE);
        ACTIONS.put("Select to Next Page", SELECT_NEXT_PAGE);
        ACTIONS.put("Move Caret to Previous Char", PREV_CHAR);
        ACTIONS.put("Select Previous Char", SELECT_PREV_CHAR);
        ACTIONS.put("Move Caret to Previous Word", PREV_WORD);
        ACTIONS.put("Select Previous Word", SELECT_PREV_WORD);
        ACTIONS.put("Move Caret to Next Char", NEXT_CHAR);
        ACTIONS.put("Select Next Char", SELECT_NEXT_CHAR);
        ACTIONS.put("Move Caret to Next Word", NEXT_WORD);
        ACTIONS.put("Select Next Word", SELECT_NEXT_WORD);
        ACTIONS.put("Move Caret to Previous Line", PREV_LINE);
        ACTIONS.put("Select Previous Line", SELECT_PREV_LINE);
        ACTIONS.put("Move Caret to Next Line", NEXT_LINE);
        ACTIONS.put("Select Next Line", SELECT_NEXT_LINE);
        ACTIONS.put("Goto Line", GOTO_LINE);
        ACTIONS.put("Select Word at Caret", SELECT_WORD);
        ACTIONS.put("Select to Matching Bracket", SELECT_TO_MATCHING_BRACKET);
        ACTIONS.put("Duplication Selection", DUPLICATE_SELECTION);
        ACTIONS.put("Line Comments", LINE_COMMENTS);
        ACTIONS.put("Block Comments", BLOCK_COMMENTS);
        ACTIONS.put("Undo", UNDO);
        ACTIONS.put("Redo", REDO);
        ACTIONS.put("Clipboard Copy", CLIP_COPY);
        ACTIONS.put("Clipboard Paste", CLIP_PASTE);
        ACTIONS.put("Clipboard Paste with Dialog", CLIP_PASTE_WITH_DIALOG);
        ACTIONS.put("Clipboard Cut", CLIP_CUT);
        ACTIONS.put("Find", FIND);
        ACTIONS.put("Find Next Occurrence", FIND_NEXT);
        ACTIONS.put("Find Previous Occurrence", FIND_PREVIOUS);
        ACTIONS.put("Replace", REPLACE);
        ACTIONS.put("Quick Search", QUICK_SEARCH);
        ACTIONS.put("Repeat", REPEAT);
        ACTIONS.put("Toggle Case", TOGGLE_CASE);
        ACTIONS.put("Fold Selection", FOLD_SELECTION);
        ACTIONS.put("Expand Folding", EXPAND_FOLDING);
        ACTIONS.put("Collapse Folding", COLLAPSE_FOLDING);
        ACTIONS.put("Expand All", EXPAND_ALL);
        ACTIONS.put("Collapse All", COLLAPSE_ALL);
        ACTIONS.put("Escape", ESCAPE);
    }

    public static void addAction(String string, Action action) {
        ACTIONS.put(string, action);
    }

    public static void addAction(Action action) {
        ACTIONS.put((String)action.getValue("Name"), action);
    }

    public static void removeAction(String string) {
        ACTIONS.remove(string);
    }

    public static Action getAction(String string) {
        return ACTIONS.get(string);
    }

    public static String getActionName(ActionListener actionListener) {
        Enumeration<String> enumeration = InputHandler.getActions();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (InputHandler.getAction(string) != actionListener) continue;
            return string;
        }
        return null;
    }

    public static Enumeration<String> getActions() {
        return ACTIONS.keys();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        int n3 = keyEvent.getModifiers();
        if (n2 == 17 || n2 == 16 || n2 == 18 || n2 == 157) {
            return;
        }
        if ((n3 & 0xFFFFFFFE) != 0 || keyEvent.isActionKey() || n2 == 8 || n2 == 127 || n2 == 10 || n2 == 9 || n2 == 27) {
            KeyStroke[] keyStrokeArray;
            Object object;
            if (this._grabAction != null && Character.isLetterOrDigit(keyEvent.getKeyChar())) {
                this.handleGrabAction(keyEvent);
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStroke(n2, n3);
            if (keyEvent.getSource() instanceof CodeEditor && (object = ((CodeEditor)keyEvent.getSource()).getClientProperty("INTELLI_HINTS")) instanceof AbstractCodeEditorIntelliHints && ((AbstractCodeEditorIntelliHints)object).isHintsPopupVisible()) {
                for (KeyStroke keyStroke2 : keyStrokeArray = ((AbstractCodeEditorIntelliHints)object).getDelegateKeyStrokes()) {
                    if (!keyStroke.equals(keyStroke2)) continue;
                    return;
                }
            }
            if ((object = this.findAction(keyStroke)) instanceof Action) {
                keyStrokeArray = keyEvent.getSource();
                this.\u0101(keyStrokeArray);
                if (this.executeAction((Action)object, keyStrokeArray, null)) {
                    keyEvent.consume();
                }
            }
        }
    }

    private void \u0101(Object object) {
        if (object instanceof CodeEditor && ((CodeEditor)object).isCaretBlinks()) {
            final CodeEditor codeEditor = (CodeEditor)object;
            if (this.\u0101 == null) {
                this.\u0101 = new Timer(200, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        codeEditor.blinkCaret();
                        InputHandler.this.\u0101.stop();
                    }
                });
            }
            if (!codeEditor.isBlink()) {
                codeEditor.pauseBlink();
            }
            if (this.\u0101.isRunning()) {
                this.\u0101.restart();
            } else {
                this.\u0101.start();
            }
        }
    }

    private static boolean \u0101(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        if (c2 < ' ' || c2 == '\u007f') {
            return false;
        }
        if (c2 == '\uffff') {
            return false;
        }
        int n2 = keyEvent.getModifiers();
        if (SystemInfo.isAnyMac()) {
            return !keyEvent.isMetaDown() && !keyEvent.isControlDown();
        }
        return (n2 & 8) == (n2 & 2);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n2 = keyEvent.getModifiers();
        int n3 = keyEvent.getKeyCode();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n3, n2);
        if (this.findAction(keyStroke) instanceof Action) {
            return;
        }
        if (InputHandler.\u0101(keyEvent)) {
            this.\u0101(keyEvent.getSource());
            char c2 = keyEvent.getKeyChar();
            if (this._grabAction != null) {
                this.handleGrabAction(keyEvent);
                return;
            }
            if (this._repeat && Character.isDigit(c2)) {
                this._repeatCount *= 10;
                this._repeatCount += c2 - 48;
                return;
            }
            this.executeAction(INSERT_CHAR, keyEvent.getSource(), String.valueOf(c2));
            keyEvent.consume();
            this._repeatCount = 0;
            this._repeat = false;
        }
    }

    public abstract Object findAction(KeyStroke var1);

    public void grabNextKeyStroke(Action action) {
        this._grabAction = action;
    }

    public boolean isRepeatEnabled() {
        return this._repeat;
    }

    public void setRepeatEnabled(boolean bl) {
        this._repeat = bl;
    }

    public int getRepeatCount() {
        return this._repeat ? Math.max(1, this._repeatCount) : 1;
    }

    public void setRepeatCount(int n2) {
        this._repeatCount = n2;
    }

    public MacroRecorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(MacroRecorder macroRecorder) {
        this.recorder = macroRecorder;
    }

    public boolean executeAction(Action action, Object object, String string) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, string);
        if (action instanceof Wrapper && action.isEnabled()) {
            action.actionPerformed(actionEvent);
            return true;
        }
        boolean bl = this._repeat;
        if (action.isEnabled()) {
            if (action instanceof NonRepeatable) {
                action.actionPerformed(actionEvent);
            } else {
                for (int i2 = 0; i2 < Math.max(1, this._repeatCount); ++i2) {
                    action.actionPerformed(actionEvent);
                }
            }
            if (this._grabAction == null) {
                if (this.recorder != null && !(action instanceof NonRecordable)) {
                    if (this._repeatCount != 1) {
                        this.recorder.actionPerformed(REPEAT, String.valueOf(this._repeatCount));
                    }
                    this.recorder.actionPerformed(action, string);
                }
                if (bl) {
                    this._repeat = false;
                    this._repeatCount = 0;
                }
            }
            return true;
        }
        return false;
    }

    public static CodeEditor getCodeEditor(EventObject eventObject) {
        Object object;
        if (eventObject != null && (object = eventObject.getSource()) instanceof Component) {
            Component component = (Component)object;
            while (true) {
                if (component instanceof CodeEditor) {
                    return (CodeEditor)component;
                }
                if (component == null) break;
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                    continue;
                }
                component = component.getParent();
            }
        }
        return null;
    }

    protected void handleGrabAction(KeyEvent keyEvent) {
        Action action = this._grabAction;
        this._grabAction = null;
        this.executeAction(action, keyEvent.getSource(), String.valueOf(keyEvent.getKeyChar()));
    }

    public String modifySelectionOnPaste(CodeEditor codeEditor, String string) {
        return string;
    }

    static {
        InputHandler.initDefaultActions();
    }

    private static class W
    extends AbstractAction {
        private static final long \u0101 = -3839572006439644976L;

        private W() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.escape();
        }
    }

    private static class t
    extends AbstractAction {
        private static final long \u0101 = -6537223538277293505L;

        private t() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.toggleCase();
        }
    }

    private static class j
    extends AbstractAction {
        private static final long \u0101 = 2066986637759826811L;

        private j() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.clipboardCut();
        }
    }

    private static class O
    extends AbstractAction {
        private static final long \u0101 = 7351098860475703330L;

        private O() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.pasteWithDialog();
        }
    }

    private static class E
    extends AbstractAction {
        private static final long \u0101 = -751945309305263439L;

        private E() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.clipboardPaste();
        }
    }

    private static class g
    extends AbstractAction {
        private static final long \u0101 = 3315719351834564639L;

        private g() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.clipboardCopy();
        }
    }

    private static class Y
    extends AbstractAction
    implements NonRepeatable {
        private static final long \u0101 = -4569943151991610879L;

        private Y() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.insertChar(actionEvent.getActionCommand());
        }
    }

    private static class e
    extends AbstractAction {
        private static final long \u0101 = -4097666487197541198L;

        private e() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.getSelectionModel().setColumnSelectionMode(!codeEditor.getSelectionModel().isColumnSelectionMode());
        }
    }

    private static class R
    extends AbstractAction {
        private static final long \u0101 = 3603408608295441876L;

        private R() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.promptGotoLine();
        }
    }

    private static class d
    extends AbstractAction
    implements NonRecordable {
        private static final long \u0101 = 8715415707313946726L;

        private d() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.getInputHandler().setRepeatEnabled(true);
            String string = actionEvent.getActionCommand();
            if (string != null) {
                codeEditor.getInputHandler().setRepeatCount(Integer.parseInt(string));
            }
        }
    }

    private static class c
    extends AbstractAction {
        private static final long \u0102 = -9184205017653379297L;
        private boolean \u0101;

        public c(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousWord(this.\u0101);
        }
    }

    private static class s
    extends AbstractAction {
        private static final long \u0102 = -1533953981392173385L;
        private boolean \u0101;

        public s(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousPage(this.\u0101);
        }
    }

    private static class A
    extends AbstractAction {
        private static final long \u0102 = 6816671179977654401L;
        private boolean \u0101;

        public A(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousLine(this.\u0101);
        }
    }

    private static class b
    extends AbstractAction {
        private static final long \u0102 = -4330484536395807904L;
        private boolean \u0101;

        public b(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToPreviousChar(this.\u0101);
        }
    }

    private static class o
    extends AbstractAction {
        private static final long \u0101 = 106897582803720514L;

        private o() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.toggleOverwrite();
        }
    }

    private static class i
    extends AbstractAction {
        private static final long \u0102 = -4198893112910778574L;
        private boolean \u0101;

        public i(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextWord(this.\u0101);
        }
    }

    private static class C
    extends AbstractAction {
        private static final long \u0102 = 3451566357915929033L;
        private boolean \u0101;

        public C(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextPage(this.\u0101);
        }
    }

    private static class I
    extends AbstractAction {
        private static final long \u0102 = 5906317859564151021L;
        private boolean \u0101;

        public I(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextLine(this.\u0101);
        }
    }

    private static class h
    extends AbstractAction {
        private static final long \u0102 = 13931417876929457L;
        private boolean \u0101;

        public h(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToNextChar(this.\u0101);
        }
    }

    private static class X
    extends AbstractAction {
        private static final long \u0101 = -4029121321542759272L;

        private X() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.joinLines();
        }
    }

    private static class p
    extends AbstractAction {
        private static final long \u0101 = 8672968964589483207L;

        private p() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.unindentSelection();
        }
    }

    private static class q
    extends AbstractAction {
        private static final long \u0101 = -3610821933550251237L;

        private q() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.indentSelection();
        }
    }

    private static class P
    extends AbstractAction {
        private static final long \u0101 = 3075515863437400165L;

        private P() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.startNewLine();
        }
    }

    private static class U
    extends AbstractAction {
        private static final long \u0101 = -7993210792538806158L;

        private U() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.splitLine();
        }
    }

    private static class N
    extends AbstractAction {
        private static final long \u0101 = 2659131234173420341L;

        private N() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.insertBreak();
        }
    }

    private static class H
    extends AbstractAction {
        private static final long \u0102 = -7726789645952689118L;
        private boolean \u0101;

        public H(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToDocumentStart(this.\u0101);
        }
    }

    private static class K
    extends AbstractAction {
        private static final long \u0102 = -5435672931188118039L;
        private boolean \u0101;

        public K(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToLineStart(this.\u0101);
        }
    }

    private static class x
    extends AbstractAction {
        private static final long \u0102 = -419496336497298905L;
        private boolean \u0101;

        public x(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToDocumentEnd(this.\u0101);
        }
    }

    private static class S
    extends AbstractAction {
        private static final long \u0101 = -2290680954398938706L;

        private S() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.selectAll();
        }
    }

    private static class T
    extends AbstractAction {
        private static final long \u0102 = -2618107777905306084L;
        private boolean \u0101;

        public T(boolean bl) {
            this.\u0101 = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.moveToLineEnd(this.\u0101);
        }
    }

    private static class J
    extends AbstractAction {
        private static final long \u0101 = 7380920441924080889L;

        private J() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.deleteLine();
        }
    }

    private static class m
    extends AbstractAction {
        private static final long \u0101 = -3073513876860168928L;

        private m() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.deleteWord();
        }
    }

    private static class k
    extends AbstractAction {
        private static final long \u0101 = -9128330564099572892L;

        private k() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.deleteChar();
        }
    }

    private static class r
    extends AbstractAction {
        private static final long \u0101 = -12801451070031414L;

        private r() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.backspaceWord();
        }
    }

    private static class l
    extends AbstractAction {
        private static final long \u0101 = 2195300881172488912L;

        private l() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.backspaceChar();
        }
    }

    private static class _
    extends AbstractAction {
        private static final long \u0101 = 216898672835723434L;

        private _() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.replace();
        }
    }

    private static class G
    extends AbstractAction {
        private static final long \u0101 = -4766805698324327183L;

        private G() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.findPrevious();
        }
    }

    private static class f
    extends AbstractAction {
        private static final long \u0101 = -7900051882199803626L;

        private f() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.findNext();
        }
    }

    private static class n
    extends AbstractAction {
        private static final long \u0101 = 1344247353550639817L;

        private n() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.find();
        }
    }

    private static class a
    extends AbstractAction {
        private static final long \u0101 = -6127293275004484560L;

        private a() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.quickSearch("");
        }
    }

    private static class L
    extends AbstractAction {
        private static final long \u0101 = 6191068347139580160L;

        private L() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.collapseAll();
        }
    }

    private static class v
    extends AbstractAction {
        private static final long \u0101 = 4395096353332537768L;

        private v() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.expandAll();
        }
    }

    private static class w
    extends AbstractAction {
        private static final long \u0101 = -4608093736925088489L;

        private w() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.collapseFolding();
        }
    }

    private static class M
    extends AbstractAction {
        private static final long \u0101 = 7577956763623513443L;

        private M() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.expandFolding();
        }
    }

    private static class V
    extends AbstractAction {
        private static final long \u0101 = -7372541634524818440L;

        private V() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.toggleFoldingSelection();
        }
    }

    private static class Q
    extends AbstractAction {
        private static final long \u0101 = -5288367014731605865L;

        private Q() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.redo();
        }
    }

    private static class Z
    extends AbstractAction {
        private static final long \u0101 = 437742589395720859L;

        private Z() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.undo();
        }
    }

    private static class D
    extends AbstractAction {
        private static final long \u0101 = 7865726044327253386L;

        private D() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.selectToMatchingBracket();
        }
    }

    private static class y
    extends AbstractAction {
        private static final long \u0101 = 1430066044262675939L;

        private y() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.selectWord();
        }
    }

    private static class B
    extends AbstractAction {
        private static final long \u0101 = -7165863513036379748L;

        private B() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.blockComments();
        }
    }

    private static class u
    extends AbstractAction {
        private static final long \u0101 = -2561877503395933792L;

        private u() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.lineComments();
        }
    }

    private static class F
    extends AbstractAction {
        private static final long \u0101 = 8566372647867701881L;

        private F() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CodeEditor codeEditor = InputHandler.getCodeEditor(actionEvent);
            codeEditor.duplicateSelection();
        }
    }

    public static interface MacroRecorder {
        public void actionPerformed(Action var1, String var2);
    }

    public static interface Wrapper {
    }

    public static interface NonRecordable {
    }

    public static interface NonRepeatable {
    }
}

