/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorFindAndReplaceTarget;
import com.jidesoft.editor.highlight.DefaultHighlighter;
import com.jidesoft.editor.highlight.Highlighter;
import com.jidesoft.editor.selection.DefaultSelectionModel;
import com.jidesoft.editor.selection.SelectionEvent;
import com.jidesoft.editor.selection.SelectionListener;
import com.jidesoft.editor.selection.SelectionModel;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;

public class CodeEditorSelectionFindAndReplaceTarget
extends CodeEditorFindAndReplaceTarget
implements SelectionListener,
PropertyChangeListener {
    static final Color \u0136 = new Color(204, 204, 255);
    private Color \u0137 = null;
    private Highlighter.HighlightPainter \u0133;
    private int \u0135 = 0;
    private Object \u0134 = null;

    public CodeEditorSelectionFindAndReplaceTarget(CodeEditor codeEditor) {
        super(codeEditor);
        codeEditor.getSelectionModel().addSelectionListener(this);
        codeEditor.addPropertyChangeListener("columnSelectionEnabled", this);
        this.setHighlightColor(\u0136);
    }

    public Color getHighlightColor() {
        if (this.\u0137 != null) {
            return this.\u0137;
        }
        return \u0136;
    }

    public void setHighlightColor(Color color) {
        this.\u0137 = color;
        this.\u0133 = new DefaultHighlighter.DefaultHighlightPainter(this.\u0137);
    }

    @Override
    public CharSequence getCurrentText() {
        this.setTargetChanged(false);
        SelectionModel selectionModel = this.getCodeEditor().getSelectionModel();
        return selectionModel.hasSelection() ? selectionModel.getSelectedText() : super.getCurrentText();
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new JLabel(this.getResourceString("FindAndReplace.selectedText"));
    }

    public boolean hasHighlight() {
        return this.\u0134 != null;
    }

    @Override
    public void replace(int n2, int n3, String string) throws BadLocationException {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            try {
                n2 = !this.getCodeEditor().getSelectionModel().isColumnSelectionMode() ? (n2 += this.getCodeEditor().getSelectionStart()) : this.getCodeEditor().getSelectionModel().offsetInSelectionToOffsetInDocument(n2);
                super.replace(n2, n3, string);
                if (!this.getCodeEditor().getSelectionModel().isColumnSelectionMode()) {
                    this.getCodeEditor().getSelectionModel().setSelection(this.getCodeEditor().getSelectionModel().getSelectionStart(), this.getCodeEditor().getSelectionModel().getSelectionEnd() + (string.length() - n3));
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            super.replace(n2, n3, string);
        }
    }

    @Override
    public void adjustCurrentPosition(String string, boolean bl) {
    }

    @Override
    public void highlight(int n2, int n3) {
        if (this.getCodeEditor().getSelectionModel().hasSelection()) {
            try {
                if (this.\u0134 != null) {
                    this.getCodeEditor().getHighlighter().removeHighlight(this.\u0134);
                }
                if (!this.getCodeEditor().getSelectionModel().isColumnSelectionMode()) {
                    int n4 = this.getCodeEditor().getSelectionStart();
                    this.\u0134 = this.getCodeEditor().getHighlighter().addHighlight(n2 + n4, n3 + n4, this.\u0133);
                    this.\u0135 = n3 - n2;
                    this.getCodeEditor().getCaretModel().setOffset(n3 + n4);
                } else if (this.getCodeEditor().getSelectionModel() instanceof DefaultSelectionModel) {
                    n2 = this.getCodeEditor().getSelectionModel().offsetInSelectionToOffsetInDocument(n2);
                    n3 = this.getCodeEditor().getSelectionModel().offsetInSelectionToOffsetInDocument(n3);
                    this.\u0134 = this.getCodeEditor().getHighlighter().addHighlight(n2, n3, this.\u0133);
                    this.\u0135 = n3 - n2;
                    this.getCodeEditor().getCaretModel().setOffset(n3);
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            super.highlight(n2, n3);
        }
    }

    @Override
    public int getCurrentPosition(boolean bl) {
        int n2;
        if (!this.getCodeEditor().getSelectionModel().hasSelection()) {
            return 0;
        }
        if (!this.hasHighlight()) {
            return bl ? 0 : this.getCodeEditor().getSelectionModel().getSelectedText().length();
        }
        int n3 = n2 = bl ? this.getCodeEditor().getCaretModel().getOffset() : this.getCodeEditor().getCaretModel().getOffset() - this.\u0135;
        if (this.getCodeEditor().getSelectionModel() instanceof DefaultSelectionModel) {
            return this.getCodeEditor().getSelectionModel().offsetInDocumentToOffsetInSelection(n2);
        }
        return n2 - this.getCodeEditor().getSelectionStart();
    }

    @Override
    public void selectionChanged(SelectionEvent selectionEvent) {
        this.setTargetChanged(true);
        if (this.\u0134 != null) {
            this.getCodeEditor().getHighlighter().removeHighlight(this.\u0134);
            this.\u0134 = null;
        }
        this.\u0135 = 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setTargetChanged(true);
        if (this.\u0134 != null) {
            this.getCodeEditor().getHighlighter().removeHighlight(this.\u0134);
            this.\u0134 = null;
        }
        this.\u0135 = 0;
    }

    Highlighter.HighlightPainter \u0104() {
        return this.\u0133;
    }

    @Override
    public void replaceAllEnds() {
        super.replaceAllEnds();
        if (this.getCodeEditor().getSelectionModel().isColumnSelectionMode()) {
            this.getCodeEditor().getSelectionModel().setSelection(this.getCodeEditor().getSelectionModel().getSelectionStartViewPosition(), this.getCodeEditor().getSelectionModel().getSelectionEndViewPosition());
        } else {
            this.getCodeEditor().getSelectionModel().setSelection(this.getCodeEditor().getSelectionModel().getSelectionStart(), this.getCodeEditor().getSelectionModel().getSelectionEnd());
        }
    }
}

