/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableChooserPanel
extends PopupPanel
implements ItemListener {
    private Border \u026b = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    protected JTable _table;
    private TableModel \u026a;
    protected Class<?> _class = String.class;
    private int \u0268;
    private JScrollPane \u0269;
    private AutoScroll \u026e;
    private int \u0267 = 0;
    private boolean \u026c = true;
    protected boolean hasEntered = false;
    private A \u026d;
    protected MouseMotionListener mouseMotionListener;
    protected MouseListener mouseListener;
    protected MouseListener tableMouseListener;
    protected MouseMotionListener tableMouseMotionListener;

    public TableChooserPanel() {
        this(new DefaultTableModel(), Object.class);
    }

    public TableChooserPanel(TableModel tableModel, Class<?> clazz) {
        this.\u026a = tableModel;
        this._class = clazz;
        this.initComponents();
    }

    protected void initComponents() {
        this.setStretchToFit(true);
        this.setLayout(new BorderLayout());
        this.setBorder(this.\u026b);
        this._table = this.createTable(this.\u026a);
        this._table.setName("ComboBox.table");
        this.setupTable(this._table);
        this.\u0269 = new JideScrollPane(this._table);
        ((JideScrollPane)this.\u0269).setVerticalScrollBarCoversWholeHeight(true);
        this.\u0269.setName("ComboBox.scrollPane");
        this.customzieScroller(this.\u0269);
        this.\u0269.setColumnHeaderView(this._table.getTableHeader());
        this.add((Component)this.\u0269, "Center");
        this._table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TableChooserPanel.this.setPreferredSize(null);
                TableChooserPanel.this.\u0131();
            }
        });
        this.\u0131();
        this.addItemListener(this);
        this.\u026e = new AutoScroll(this._table){

            @Override
            public void autoScrollingStarted(int n2) {
            }

            @Override
            public void autoScrolling(int n2) {
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                if (n2 == 0 || n2 == 2) {
                    int n3 = TableChooserPanel.this._table.getSelectedRow();
                    int n4 = TableChooserPanel.this._table.getSelectedColumn();
                    if (n3 > 0) {
                        TableChooserPanel.this._table.changeSelection(n3 - 1, n4, false, false);
                    }
                } else {
                    int n5 = TableChooserPanel.this._table.getSelectedRow();
                    int n6 = TableChooserPanel.this._table.getSelectedColumn();
                    if (n5 < TableChooserPanel.this._table.getRowCount() - 1) {
                        TableChooserPanel.this._table.changeSelection(n5 + 1, n6, false, false);
                    }
                }
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
            }

            @Override
            public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
                Point point = mouseEvent.getPoint();
                if (TableChooserPanel.this._table == null) {
                    return;
                }
                int n2 = TableChooserPanel.this._table.rowAtPoint(point);
                if (n2 == -1) {
                    n2 = point.y < 0 ? 0 : TableChooserPanel.this.\u026a.getRowCount() - 1;
                }
                if (TableChooserPanel.this._table.getSelectedRow() != n2) {
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                    TableChooserPanel.this._table.changeSelection(n2, TableChooserPanel.this.getDefaultColumnIndex(), false, false);
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                }
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!(SystemInfo.isJdk15Above() && this.isPreferredSizeSet() || this.\u0269.getColumnHeader() == null || this.\u0269.getColumnHeader().getView() == this._table.getTableHeader() || this._table.getTableHeader() == null)) {
            dimension.height += this._table.getTableHeader().getPreferredSize().height;
        }
        return dimension;
    }

    private void \u0131() {
        if (this.getMaximumRowCount() < this._table.getModel().getRowCount() || this._table.getModel().getRowCount() == 0) {
            Dimension dimension = this._table.getPreferredScrollableViewportSize();
            dimension.height = this._table.getRowHeight() * this.getMaximumRowCount();
            this._table.setPreferredScrollableViewportSize(dimension);
            this.\u0269.setVerticalScrollBarPolicy(22);
        } else {
            Dimension dimension = this._table.getPreferredScrollableViewportSize();
            dimension.height = this._table.getRowHeight() * this._table.getModel().getRowCount();
            this._table.setPreferredScrollableViewportSize(dimension);
            this.\u0269.setVerticalScrollBarPolicy(20);
        }
    }

    protected void customzieScroller(JScrollPane jScrollPane) {
        jScrollPane.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
    }

    protected JTable createTable(TableModel tableModel) {
        return new JTable(tableModel);
    }

    protected void setupTable(JTable jTable) {
        jTable.setSelectionMode(0);
        this.installListListeners();
        this.\u0101(jTable);
    }

    private void \u0101(JTable jTable) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableChooserPanel.this.setSelectedObject(TableChooserPanel.this.getValueAtRowIndex(TableChooserPanel.this._table.getSelectedRow()));
            }
        };
        jTable.registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(10, 0), 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public int getMaximumRowCount() {
        return this.\u0268;
    }

    public void setMaximumRowCount(int n2) {
        int n3 = this.\u0268;
        this.\u0268 = n2;
        this.\u0131();
        this.firePropertyChange("maximumRowCount", n3, this.\u0268);
    }

    public JTable getTable() {
        return this._table;
    }

    protected Object getValueAtRowIndex(int n2) {
        if (n2 < 0 || n2 >= this._table.getModel().getRowCount()) {
            return null;
        }
        return this._table.getModel().getValueAt(n2, this.getValueColumnIndex());
    }

    @Override
    public void setSelectedObject(Object object) {
        super.setSelectedObject(object);
        if (this._table != null) {
            if (object == null) {
                this._table.getSelectionModel().clearSelection();
            } else {
                for (int i2 = 0; i2 < this._table.getRowCount(); ++i2) {
                    Object object2 = this.getValueAtRowIndex(i2);
                    if (!object.equals(object2)) continue;
                    this._table.changeSelection(i2, 0, false, false);
                }
            }
        }
    }

    private void \u0101(int n2, Object object) {
        super.setSelectedObject(object);
        if (this._table != null) {
            if (object == null) {
                this._table.getSelectionModel().clearSelection();
            } else {
                this._table.changeSelection(n2, 0, false, false);
            }
        }
    }

    boolean \u0130() {
        return this.\u026c;
    }

    void \u0104(boolean bl) {
        this.\u026c = bl;
    }

    protected int getDefaultColumnIndex() {
        return 0;
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._table) {
            return mouseEvent;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._table);
        return new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected MouseListener createMouseListener() {
        return this.\u012e();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.\u012e();
    }

    protected MouseListener createTableMouseListener() {
        return this.\u012e();
    }

    protected MouseMotionListener createTableMouseMotionListener() {
        return this.\u012e();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.\u012e();
    }

    private A \u012e() {
        if (this.\u026d == null) {
            this.\u026d = new A();
        }
        return this.\u026d;
    }

    protected void installListListeners() {
        this.tableMouseListener = this.createTableMouseListener();
        if (this.tableMouseListener != null) {
            this._table.addMouseListener(this.tableMouseListener);
        }
        if ((this.tableMouseMotionListener = this.createTableMouseMotionListener()) != null) {
            this._table.addMouseMotionListener(this.tableMouseMotionListener);
        }
    }

    void \u012f() {
        if (this.tableMouseListener != null) {
            this._table.removeMouseListener(this.tableMouseListener);
            this.tableMouseListener = null;
        }
        if (this.tableMouseMotionListener != null) {
            this._table.removeMouseMotionListener(this.tableMouseMotionListener);
            this.tableMouseMotionListener = null;
        }
        this.\u026d = null;
    }

    public void setValueColumnIndex(int n2) {
        int n3 = this.\u0267;
        if (n3 != n2) {
            this.\u0267 = n2;
            this.firePropertyChange("valueColumnIndex", n3, this.\u0267);
        }
    }

    public int getValueColumnIndex() {
        return this.\u0267;
    }

    private class A
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    Serializable {
        private A() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n2 = TableChooserPanel.this._table.getSelectedRow();
            if (mouseEvent.getSource() == TableChooserPanel.this._table) {
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                TableChooserPanel.this.\u0101(n2, TableChooserPanel.this.getValueAtRowIndex(n2));
                TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = TableChooserPanel.this.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                TableChooserPanel.this._table.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", Boolean.TRUE);
                    TableChooserPanel.this.\u0101(n2, TableChooserPanel.this.getValueAtRowIndex(n2));
                    TableChooserPanel.this._table.putClientProperty("PopupPanel.selectedByMouseRollover", null);
                }
            }
            if (TableChooserPanel.this.\u0130()) {
                TableChooserPanel.this.\u026e.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (TableChooserPanel.this.\u0130()) {
                TableChooserPanel.this.\u026e.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (TableChooserPanel.this.\u0130()) {
                TableChooserPanel.this.\u026e.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ComponentOrientation componentOrientation;
            JTable jTable = (JTable)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("model".equals(string)) {
                TableModel tableModel = (TableModel)propertyChangeEvent.getNewValue();
                TableChooserPanel.this._table.setModel(tableModel);
                if (TableChooserPanel.this.isVisible()) {
                    TableChooserPanel.this.setVisible(false);
                }
            } else if ("componentOrientation".equals(string) && (componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue()) != TableChooserPanel.this.getComponentOrientation()) {
                TableChooserPanel.this.setComponentOrientation(componentOrientation);
            }
        }
    }
}

