/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SetRegistryValueAction
extends SystemInstallOrUninstallAction {
    private RegistryRoot registryRoot;
    private String keyName = "";
    private String valueName = "";
    private String value = "";
    private boolean createKey = true;
    private transient Object externalValue = null;

    public SetRegistryValueAction() {
    }

    public SetRegistryValueAction(RegistryRoot registryRoot, String keyName, String valueName, Object value, boolean createKey) {
        this.setRegistryRoot(registryRoot);
        this.setKeyName(keyName);
        this.setValueName(valueName);
        this.externalValue = value;
        if (this.externalValue == null) {
            this.setValue(null);
        }
        this.setCreateKey(createKey);
    }

    @Override
    public boolean execute(Context context) {
        Object value;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        PerformedAction performedAction = new PerformedAction();
        this.addRollbackAction(performedAction);
        if (this.isCreateKey() && !this.doCreateKey(performedAction)) {
            Logger.getInstance().error(this, "could not create key " + (Object)((Object)this.getRegistryRoot()) + " " + this.getKeyName());
            return false;
        }
        performedAction.oldValue = WinRegistry.getValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
        Object object = value = this.externalValue != null ? this.externalValue : this.getValue();
        if (value instanceof String && performedAction.oldValue instanceof WinRegistry.ExpandString) {
            value = new WinRegistry.ExpandString((String)value);
        }
        if (value == null) {
            performedAction.newValueSet = true;
            WinRegistry.deleteValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
        } else {
            performedAction.newValueSet = WinRegistry.setValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName(), value);
            if (!performedAction.newValueSet) {
                Logger.getInstance().error(this, "could not set value " + (Object)((Object)this.getRegistryRoot()) + " " + this.getKeyName() + " " + this.getValueName() + ": " + value);
            }
        }
        return performedAction.newValueSet;
    }

    private boolean doCreateKey(PerformedAction performedAction) {
        String usedKeyName = this.getKeyName();
        String curKeyName = null;
        StringTokenizer tokenizer = new StringTokenizer(usedKeyName, "\\");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            curKeyName = curKeyName == null ? "" : curKeyName + "\\";
            curKeyName = curKeyName + nextToken;
            if (WinRegistry.keyExists(this.getRegistryRoot(), curKeyName)) continue;
            if (!WinRegistry.createKey(this.getRegistryRoot(), curKeyName)) {
                return false;
            }
            performedAction.createdKeys.add(curKeyName);
        }
        return true;
    }

    public RegistryRoot getRegistryRoot() {
        return this.replaceWithTextOverride("registryRoot", this.registryRoot, RegistryRoot.class);
    }

    public void setRegistryRoot(RegistryRoot registryRoot) {
        this.registryRoot = registryRoot;
    }

    public String getKeyName() {
        return SetRegistryValueAction.replaceVariables(SetRegistryValueAction.replaceVariables(this.keyName));
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getValueName() {
        return SetRegistryValueAction.replaceVariables(SetRegistryValueAction.replaceVariables(this.valueName));
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public String getValue() {
        return SetRegistryValueAction.replaceVariables(SetRegistryValueAction.replaceVariables(this.value));
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isCreateKey() {
        return this.replaceWithTextOverride("createKey", this.createKey);
    }

    public void setCreateKey(boolean createKey) {
        this.createKey = createKey;
    }

    private class PerformedAction
    extends SetRegistryValueAction {
        List<String> createdKeys = new ArrayList<String>();
        boolean newValueSet = false;
        Object oldValue;

        PerformedAction() {
            this.setRegistryRoot(SetRegistryValueAction.this.getRegistryRoot());
            this.setKeyName(SetRegistryValueAction.this.getKeyName());
            this.setValueName(SetRegistryValueAction.this.getValueName());
        }

        @Override
        public boolean install(InstallerContext context) throws UserCanceledException {
            return false;
        }

        @Override
        public void rollback(InstallerContext context) {
            if (this.newValueSet) {
                if (this.oldValue == null) {
                    WinRegistry.deleteValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName());
                } else {
                    WinRegistry.setValue(this.getRegistryRoot(), this.getKeyName(), this.getValueName(), this.oldValue);
                }
            }
            for (int i = this.createdKeys.size() - 1; i >= 0; --i) {
                String keyName = this.createdKeys.get(i);
                WinRegistry.getSubKeyNames(this.getRegistryRoot(), keyName);
                WinRegistry.deleteKey(this.getRegistryRoot(), keyName, true);
            }
        }
    }
}

