/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d.font;

import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphics2d.font.Lookup;

public class FontEncoder {
    private FontEncoder() {
    }

    public static String getEncodedString(String string, String tableName) {
        CharTable charTable = Lookup.getInstance().getTable(tableName);
        return FontEncoder.getEncodedString(string, charTable);
    }

    public static String getEncodedString(String string, CharTable charTable) {
        if (charTable == null) {
            return string;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char enc = string.charAt(i);
            String name = FontEncoder.toName(charTable, enc);
            s.append(name != null ? charTable.toUnicode(name) : (char)enc);
        }
        return s.toString();
    }

    private static String toName(CharTable table, int enc) {
        try {
            return table.toName(enc);
        }
        catch (Exception e) {
            return null;
        }
    }
}

