/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.DefaultSelectable;
import com.jidesoft.swing.Selectable;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class CheckBoxListWithSelectable
extends JList
implements ItemSelectable {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean \u0101 = true;
    private boolean \u0102 = true;

    public CheckBoxListWithSelectable() {
        this.init();
    }

    public CheckBoxListWithSelectable(Vector<?> vector) {
        super(CheckBoxListWithSelectable.\u0101(vector));
        this.init();
    }

    public CheckBoxListWithSelectable(Object[] objectArray) {
        super(CheckBoxListWithSelectable.\u0101(objectArray));
        this.init();
    }

    public CheckBoxListWithSelectable(ListModel listModel) {
        super(CheckBoxListWithSelectable.\u0101(listModel));
        this.init();
    }

    protected void init() {
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        Handler handler = this.createHandler();
        this.addMouseListener(handler);
        this.addKeyListener(handler);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public void setSelectedObjects(Object[] objectArray) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object : objectArray) {
            hashMap.put(object, "");
        }
        this.\u0101(hashMap);
    }

    public void setSelectedObjects(Vector<?> vector) {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object obj : vector) {
            hashMap.put(obj, "");
        }
        this.\u0101(hashMap);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(super.getCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        if (this._listCellRenderer != null) {
            return this._listCellRenderer.getActualListRenderer();
        }
        return super.getCellRenderer();
    }

    private void \u0101(Map<Object, String> map) {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Object object = this.getModel().getElementAt(i2);
            if (!(object instanceof Selectable)) continue;
            Selectable selectable = (Selectable)object;
            if (selectable instanceof DefaultSelectable) {
                object = ((DefaultSelectable)selectable).getObject();
            }
            if (map.get(object) != null) {
                selectable.setSelected(true);
                this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
                map.remove(object);
                if (map.size() != 0) continue;
                break;
            }
            if (!selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    private static ListModel \u0101(ListModel listModel) {
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            if (listModel.getElementAt(i2) instanceof Selectable) continue;
            throw new IllegalArgumentException("The ListModel contains an element which is not an instance of Selectable at index " + i2 + ".");
        }
        return listModel;
    }

    private static Selectable[] \u0101(Object[] objectArray) {
        if (objectArray instanceof Selectable[]) {
            return (Selectable[])objectArray;
        }
        Selectable[] selectableArray = new Selectable[objectArray.length];
        for (int i2 = 0; i2 < selectableArray.length; ++i2) {
            selectableArray[i2] = new DefaultSelectable(objectArray[i2]);
        }
        return selectableArray;
    }

    private static Vector<?> \u0101(Vector<?> vector) {
        Vector<Selectable> vector2 = new Vector<Selectable>();
        for (Object obj : vector) {
            if (obj instanceof Selectable) {
                vector2.add((Selectable)obj);
                continue;
            }
            vector2.add(new DefaultSelectable(obj));
        }
        return vector2;
    }

    public boolean isClickInCheckBoxOnly() {
        return this.\u0102;
    }

    public void setClickInCheckBoxOnly(boolean bl) {
        if (bl != this.\u0102) {
            boolean bl2 = this.\u0102;
            this.\u0102 = bl;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, bl2, this.\u0102);
        }
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ItemListener.class) continue;
            if (itemEvent2 == null) {
                itemEvent2 = new ItemEvent(this, 701, itemEvent.getItem(), itemEvent.getStateChange());
            }
            ((ItemListener)objectArray[i2 + 1]).itemStateChanged(itemEvent2);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Vector<Object> vector = new Vector<Object>();
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Selectable selectable;
            Object e2 = this.getModel().getElementAt(i2);
            if (!(e2 instanceof Selectable) || !(selectable = (Selectable)e2).isSelected()) continue;
            if (selectable instanceof DefaultSelectable) {
                vector.add(((DefaultSelectable)selectable).getObject());
                continue;
            }
            vector.add(selectable);
        }
        return vector.toArray();
    }

    public void selectAll() {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Selectable selectable;
            Object e2 = this.getModel().getElementAt(i2);
            if (!(e2 instanceof Selectable) || !(selectable = (Selectable)e2).isEnabled() || selectable.isSelected()) continue;
            selectable.setSelected(true);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
        }
        this.repaint();
    }

    public void selectNone() {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Selectable selectable;
            Object e2 = this.getModel().getElementAt(i2);
            if (!(e2 instanceof Selectable) || !(selectable = (Selectable)e2).isEnabled() || !selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    public void setListData(Vector vector) {
        super.setListData(CheckBoxListWithSelectable.\u0101(vector));
    }

    public void setListData(Object[] objectArray) {
        super.setListData(CheckBoxListWithSelectable.\u0101(objectArray));
    }

    @Override
    public int getNextMatch(String string, int n2, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled() {
        return this.\u0101;
    }

    public boolean isCheckBoxVisible(int n2) {
        return true;
    }

    public void setCheckBoxEnabled(boolean bl) {
        if (bl != this.\u0101) {
            Boolean bl2 = this.\u0101 ? Boolean.TRUE : Boolean.FALSE;
            Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.\u0101 = bl;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, bl2, bl3);
            this.repaint();
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener {
        protected CheckBoxListWithSelectable _list;
        int \u0101;

        public Handler(CheckBoxListWithSelectable checkBoxListWithSelectable) {
            this.\u0101 = new JCheckBox().getPreferredSize().width;
            this._list = checkBoxListWithSelectable;
        }

        protected boolean clicksInCheckBox(MouseEvent mouseEvent) {
            int n2 = this._list.locationToIndex(mouseEvent.getPoint());
            Rectangle rectangle = this._list.getCellBounds(n2, n2);
            if (rectangle != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return mouseEvent.getX() < rectangle.x + this.\u0101;
                }
                return mouseEvent.getX() > rectangle.x + rectangle.width - this.\u0101;
            }
            return false;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
                return;
            }
            if (!this._list.isClickInCheckBoxOnly() || this.clicksInCheckBox(mouseEvent)) {
                int n2 = this._list.locationToIndex(mouseEvent.getPoint());
                this.toggleSelection(n2);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
                return;
            }
            if (keyEvent.getModifiers() == 0 && keyEvent.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        protected void toggleSelections() {
            int[] nArray = this._list.getSelectedIndices();
            ListModel listModel = this._list.getModel();
            for (int n2 : nArray) {
                Object e2 = listModel.getElementAt(n2);
                if (!(e2 instanceof Selectable) || !((Selectable)e2).isEnabled()) continue;
                ((Selectable)e2).invertSelected();
                boolean bl = ((Selectable)e2).isSelected();
                this._list.fireItemStateChanged(new ItemEvent(this._list, 701, e2, bl ? 1 : 2));
            }
            this._list.repaint();
        }

        protected void toggleSelection(int n2) {
            ListModel listModel = this._list.getModel();
            if (n2 >= 0) {
                Object e2 = listModel.getElementAt(n2);
                if (e2 instanceof Selectable && ((Selectable)e2).isEnabled()) {
                    ((Selectable)e2).invertSelected();
                    boolean bl = ((Selectable)e2).isSelected();
                    this._list.fireItemStateChanged(new ItemEvent(this._list, 701, e2, bl ? 1 : 2));
                }
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int n2 = this._list.getSelectedIndex();
            this.toggleSelection(n2);
        }
    }
}

